/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;

public class ClientRegistrationRsp
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP ClientRegistration";
    private byte result = 0;
    private byte reservedInBody = 0;

    public ClientRegistrationRsp() {
        this.setCommand(CMD_CLIENT_REGISTRATION);
        this.setDataType((byte)12);
        this.setAction((byte)1);
        this.setWrite();
    }

    @Override
    public void deserializeBody(byte[] body) {
        this.result = body[0];
        if (this.registerSuccess()) {
            this.setClientID(new byte[]{body[2], body[3]});
        }
    }

    @Override
    public byte[] serializeBody() {
        byte[] cid = this.getClientID();
        return new byte[]{this.result, this.reservedInBody, cid[0], cid[1]};
    }

    public void setRegisterSuccess() {
        this.result = 1;
    }

    public boolean registerSuccess() {
        return this.result == 1;
    }

    public void setRegisterFailed() {
        this.result = 0;
    }

    public boolean registerFailed() {
        return !this.registerSuccess();
    }

    public void setReservedInBody(byte b) {
        this.reservedInBody = b;
    }

    public byte getReservedInBody() {
        return this.reservedInBody;
    }

    @Override
    public String toString() {
        if (this.registerSuccess()) {
            return "RCP ClientRegistration: Succes, ClientID [ " + ClientRegistrationRsp.hexString(this.getClientID()) + "]";
        }
        return "RCP ClientRegistration: Failed";
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME;
    }

    @Override
    protected String getClassDebugInfo() {
        if (this.registerSuccess()) {
            return " Succes, ClientID [ " + ClientRegistrationRsp.hexString(this.getClientID()) + "]";
        }
        return "Failed";
    }
}

