/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;

public class ClientRegistrationReq
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP ClientRegistration";
    private String pass = "";

    public ClientRegistrationReq() {
        this.setCommand(CMD_CLIENT_REGISTRATION);
        this.setDataType((byte)12);
        this.setAction((byte)0);
        this.setWrite();
    }

    @Override
    protected void deserializeBody(byte[] data) {
        byte passlength = data[5];
        byte[] passBytes = new byte[passlength];
        int nbr = ClientRegistrationReq.bytesToInt(data, 6, 2);
        System.arraycopy(data, 8 + nbr * 2, passBytes, 0, passBytes.length);
        try {
            this.pass = new String(passBytes, "utf-8");
        }
        catch (Exception e) {
            this.logger.warn("Bad password encoding", (Throwable)e);
            this.pass = new String(passBytes);
        }
    }

    @Override
    public byte[] serializeBody() {
        byte[] passBytes = this.pass.getBytes();
        byte[] body = new byte[10 + passBytes.length];
        body[0] = 1;
        body[1] = 0;
        body[2] = 0;
        body[3] = 0;
        body[4] = 0;
        body[5] = (byte)passBytes.length;
        body[6] = 0;
        body[7] = 1;
        body[8] = -1;
        body[9] = -1;
        System.arraycopy(passBytes, 0, body, 10, passBytes.length);
        return body;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String str) {
        this.pass = str;
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME;
    }

    @Override
    protected String getClassDebugInfo() {
        return "Password [" + this.pass + "]";
    }
}

