/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import de.seetec.v5.shared.Basic;

public class CapabilityListRsp
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP CapabilityList";
    private boolean h264Supported = false;

    public CapabilityListRsp() {
        this.setCommand(CMD_CAPABILITY_LIST);
        this.setDataType((byte)12);
    }

    public boolean isH264Supported() {
        return this.h264Supported;
    }

    @Override
    protected void deserializeBody(byte[] data) {
        if (data != null && data.length > 0) {
            int offset = 6;
            int numberOfSections = Basic.byteArrayToInt4((byte[])new byte[]{data[4], data[5]});
            for (int i = 0; i < numberOfSections; ++i) {
                int lengthOfSection = Basic.byteArrayToInt4((byte[])new byte[]{data[offset + 2], data[offset + 3]});
                if (data[offset] == 0 && data[offset + 1] == 1) {
                    int numberOfElements = Basic.byteArrayToInt4((byte[])new byte[]{data[offset + 4], data[offset + 5]});
                    for (int j = 0; j < numberOfElements; ++j) {
                        if (data[offset + 6 + (j * 10 + 4)] != 0 || (data[offset + 6 + (j * 10 + 5)] & 4) != 4) continue;
                        this.h264Supported = true;
                    }
                }
                offset += lengthOfSection;
            }
        }
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME + (this.getRead() ? "Read" : "Write");
    }

    @Override
    protected String getClassDebugInfo() {
        return "n/a";
    }
}

