/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.AlarmEntry;
import de.seetec.v5.shared.Basic;
import java.util.ArrayList;
import java.util.List;

public class AlarmOverview
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP AlarmOverview";
    private int flags;
    private List<AlarmEntry> alarmEntries;

    public int getFlags() {
        return this.flags;
    }

    public AlarmOverview() {
        this.setCommand(CMD_ALARM_OVERVIEW);
        this.setDataType((byte)12);
        this.setRead();
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME + (this.getRead() ? "Read" : "Write");
    }

    @Override
    protected String getClassDebugInfo() {
        return "n/a";
    }

    public List<AlarmEntry> getAlarmEntries() {
        return this.alarmEntries;
    }

    @Override
    protected void deserializeBody(byte[] resultData) {
        this.flags = (int)Basic.byteArrayToInt8((byte[])resultData, (int)0, (int)2);
        byte[] alarmEntryData = new byte[resultData.length - 4];
        System.arraycopy(resultData, 4, alarmEntryData, 0, alarmEntryData.length);
        this.alarmEntries = this.getAlarmEntries(alarmEntryData);
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder(super.toString());
        if (this.alarmEntries.size() > 0) {
            res.append("\r\nAlarm Entries: ");
            for (AlarmEntry alarmEntry : this.alarmEntries) {
                res.append("\r\n Name: ");
                res.append(alarmEntry.getAlarmName());
                res.append(" Type: ");
                res.append((Object)alarmEntry.getAlarmType());
                res.append(" Source: ");
                res.append((Object)alarmEntry.getAlarmSource());
            }
        }
        return super.toString() + "\r\n" + res.toString();
    }

    private List<AlarmEntry> getAlarmEntries(byte[] alarmEntryData) {
        AlarmEntry alarmEntry;
        ArrayList<AlarmEntry> res = new ArrayList<AlarmEntry>();
        for (int offset = 0; offset < alarmEntryData.length; offset += alarmEntry.getEntryLength()) {
            alarmEntry = new AlarmEntry(alarmEntryData, offset);
            res.add(alarmEntry);
        }
        return res;
    }
}

