/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.jpeg;

import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.net.RCPNetworkCallback;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.bosch.BoschCameraSrv;
import de.seetec.v5.re.cm.device.video.bosch.BoschHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.bosch.BoschMotionDetectionHandler;
import de.seetec.v5.re.cm.device.video.bosch.TpktStreamReader;
import de.seetec.v5.re.cm.device.video.bosch.TpktStreamWriter;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationReq;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationRsp;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientUnregister;
import de.seetec.v5.re.cm.device.video.bosch.rcp.HardwareVersion;
import de.seetec.v5.re.cm.device.video.bosch.rcp.MotionAlarmState;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import de.seetec.v5.re.cm.device.video.bosch.rcp.TimeoutWarning;
import de.seetec.v5.re.cm.device.video.bosch.rcp.VideoAlarmState;
import de.seetec.v5.shared.OPCLowerNodeIDType;
import de.seetec.v5.shared.util.ConfigurationException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class BoschJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements RCPNetworkCallback {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.jpeg.BoschJPEGVideoSourceClient";
    private String passphrase = null;
    private Socket socket = null;
    private TpktStreamReader rcpReader = null;
    private TpktStreamWriter rcpWriter = null;
    private int rcpPort = 1756;
    private boolean registered = false;
    private byte[] clientID;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        OutputStream outStream;
        InputStream inStream;
        this.registered = false;
        this.clientID = new byte[]{0, 0};
        int errorCode = super.init();
        if (errorCode != 0) {
            return errorCode;
        }
        try {
            this.socket = new Socket(this.host, this.rcpPort);
            this.socket.setSoTimeout(10000);
            inStream = this.socket.getInputStream();
            outStream = this.socket.getOutputStream();
        }
        catch (Exception e) {
            this.logger.error("Cannot connect to " + this.host + ":" + this.rcpPort + " for " + this.getVideoSrv());
            return -21603;
        }
        this.rcpReader = new TpktStreamReader();
        this.rcpReader.init(inStream, this);
        this.rcpWriter = new TpktStreamWriter(outStream, this);
        ClientRegistrationReq req = new ClientRegistrationReq();
        this.passphrase = BoschCameraSrv.createPassphrase(this.networkParameter);
        req.setPass(this.passphrase);
        this.sendRCPDataPacket(req);
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        block6: {
            if (this.startShutdown(CLASS_NAME)) {
                return 0;
            }
            ClientUnregister unReq = new ClientUnregister();
            unReq.setActionRequest();
            unReq.setClientID(this.clientID);
            this.sendRCPDataPacket(unReq);
            if (this.rcpReader != null) {
                this.rcpReader.shutdown();
            }
            this.rcpReader = null;
            if (this.rcpWriter != null) {
                this.rcpWriter.shutdown();
            }
            this.rcpWriter = null;
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) break block6;
                    this.logger.debug("Error while closing socket: " + e.getMessage());
                }
            }
        }
        this.socket = null;
        this.passphrase = null;
        super.shutdown();
        this.logger.info("shutdown done for " + this.getVideoSrv());
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    private void sendRCPDataPacket(Packet p) {
        if (this.rcpWriter != null) {
            this.rcpWriter.send(p.serialize());
        } else {
            this.logger.warn("rcpWriter is null for " + this.getVideoSrv());
            this.listener.sendStatusService(-21603);
            this.shutdown();
        }
    }

    @Override
    public void onRCPDataPacket(byte[] data) {
        block25: {
            Packet p = Packet.deserialize(data);
            if (this.isShutdown()) {
                return;
            }
            if (p == null) {
                return;
            }
            if (!this.registered) {
                if (p instanceof ClientRegistrationRsp) {
                    ClientRegistrationRsp rsp = (ClientRegistrationRsp)p;
                    if (rsp.registerFailed()) {
                        this.logger.warn("Register failed for " + this.getVideoSrv());
                        this.listener.sendStatusService(-21657);
                        this.shutdown();
                    } else {
                        this.clientID = rsp.getClientID();
                        this.logger.info("Register success, clientID is [ " + Packet.hexString(this.clientID) + "] for " + this.getVideoSrv());
                        this.registered = true;
                    }
                }
            } else if (p instanceof ClientUnregister) {
                ClientUnregister rsp = (ClientUnregister)p;
                if (rsp.getStatus() != 1) {
                    this.logger.warn("ClientUnregister failed for " + this.getVideoSrv());
                }
                this.logger.warn("shutting down, unregistered from server [" + rsp + "]");
                this.listener.sendStatusService(-21603);
                this.shutdown();
            } else if (p instanceof VideoAlarmState) {
                VideoAlarmState rsp = (VideoAlarmState)p;
                if (rsp.getNumericDescriptorAsInt() == this.videoSourceNr) {
                    try {
                        if (!this.listener.getVideoSourceParameter().isEnableVideoloss()) break block25;
                        if (rsp.getState()) {
                            if (this.listener.hasHardwareMotionDetection()) {
                                ((LiveCameraSrv)this.getVideoSrv()).evaluateVideoLoss();
                                if (System.currentTimeMillis() > this.lastVideoLossEventSent + 5000L) {
                                    this.lastVideoLossEventSent = System.currentTimeMillis();
                                    this.getVideoSrv().getCore().sendVideoLossEvent(this.getVideoSrv());
                                }
                            }
                            break block25;
                        }
                        this.getCore().sendOPCEvent("false", OPCLowerNodeIDType.CAMERA_VIDEOLOSS_STATUS, this.getVideoSrv().getEntityID());
                    }
                    catch (ConfigurationException ex) {
                        this.logger.error("Error evaluating videoLoss flag for " + this);
                    }
                }
            } else if (p instanceof MotionAlarmState) {
                MotionAlarmState rsp = (MotionAlarmState)p;
                if (rsp.getState()) {
                    try {
                        if (this.getVideoSrv() != null && this.getVideoSrv().getVideoSourceCnf() != null && this.getVideoSrv().getHardwareMotionDetection() != null && rsp.getNumericDescriptorAsInt() == this.getVideoSrv().getVideoSourceCnf().getServerEntryNo()) {
                            ((BoschMotionDetectionHandler)((Object)((BoschHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processMotionDetection();
                        }
                    }
                    catch (Exception i) {
                        this.logger.error("Error forwarding of motion detection for " + this.getVideoSrv(), (Throwable)i);
                    }
                }
            } else if (p instanceof TimeoutWarning) {
                HardwareVersion req = new HardwareVersion();
                req.setClientID(this.clientID);
                this.sendRCPDataPacket(req);
            }
        }
    }

    protected String getResolutionString(int width) {
        String resolutionString = width == 704 ? "XL" : (width == 352 ? "M" : "S");
        return resolutionString;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            StringBuilder sb = new StringBuilder(256);
            sb.append("/snap.jpg?JpegCam=");
            sb.append(this.videoSourceNr);
            sb.append("&JpegSize=");
            sb.append(this.getResolutionString(this.width));
            this.quality /= 1000;
            this.quality /= 3;
            sb.append("&JpegQuality=");
            sb.append(this.quality);
            super.readSingleImages(sb.toString());
            if (!this.isShutdown()) {
                this.sendStatusService(-21651);
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.sendStatusService(-21651);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }
}

