/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.bicomoverrcp;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.bicomoverrcp.PayloadFlag;
import de.seetec.v5.re.cm.device.video.bosch.bicomoverrcp.PayloadOperation;
import de.seetec.v5.re.cm.device.video.bosch.bicomoverrcp.PayloadPTZObjectId;
import de.seetec.v5.re.cm.device.video.bosch.bicomoverrcp.PayloadServerType;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.BicomCommandXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BicomOverRCPQuery {
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private BicomCommandXML packet;
    private final PayloadFlag flag;
    private final PayloadServerType serverType;
    private final String objectId;
    private final PayloadOperation operation;
    private final String hexValue;

    private BicomOverRCPQuery(PayloadFlag flag, PayloadServerType serverType, String objectId, PayloadOperation operation, String hexValue) {
        this.flag = flag;
        this.serverType = serverType;
        this.objectId = objectId;
        this.operation = operation;
        this.hexValue = hexValue;
        this.packet = this.createBicomPacket();
    }

    public static BicomOverRCPQuery getZoom() {
        return new BicomOverRCPQuery(PayloadFlag.RETURN_PAYLOAD_EXPECTED, PayloadServerType.PTZ, PayloadPTZObjectId.ZOOM.hex(), PayloadOperation.GET, "");
    }

    public static BicomOverRCPQuery setZoom(int zoom) {
        return new BicomOverRCPQuery(PayloadFlag.BASE, PayloadServerType.PTZ, PayloadPTZObjectId.ZOOM.hex(), PayloadOperation.SET, String.format("%04X", zoom));
    }

    public static BicomOverRCPQuery getMaxZoom() {
        return new BicomOverRCPQuery(PayloadFlag.RETURN_PAYLOAD_EXPECTED, PayloadServerType.PTZ, PayloadPTZObjectId.ZOOM.hex(), PayloadOperation.GET_MAX, "");
    }

    public static BicomOverRCPQuery getPan() {
        return new BicomOverRCPQuery(PayloadFlag.RETURN_PAYLOAD_EXPECTED, PayloadServerType.PTZ, PayloadPTZObjectId.PAN.hex(), PayloadOperation.GET, "");
    }

    public static BicomOverRCPQuery getMaxPan() {
        return new BicomOverRCPQuery(PayloadFlag.RETURN_PAYLOAD_EXPECTED, PayloadServerType.PTZ, PayloadPTZObjectId.PAN.hex(), PayloadOperation.GET_MAX, "");
    }

    public static BicomOverRCPQuery getTilt() {
        return new BicomOverRCPQuery(PayloadFlag.RETURN_PAYLOAD_EXPECTED, PayloadServerType.PTZ, PayloadPTZObjectId.TILT.hex(), PayloadOperation.GET, "");
    }

    public static BicomOverRCPQuery getMaxTilt() {
        return new BicomOverRCPQuery(PayloadFlag.RETURN_PAYLOAD_EXPECTED, PayloadServerType.PTZ, PayloadPTZObjectId.TILT.hex(), PayloadOperation.GET_MAX, "");
    }

    public void send(BoschDevice device) {
        try {
            this.getBicomPacket().send(device, Direction.WRITE);
        }
        catch (Exception ex) {
            this.logger.error("BicomOverRCPQuery: error when sending packet " + ex.getMessage(), (Throwable)ex);
        }
    }

    private BicomCommandXML createBicomPacket() {
        BicomCommandXML bicomCommand = new BicomCommandXML();
        bicomCommand.setNum(1);
        bicomCommand.setPayload(this.getPayloadHex());
        return bicomCommand;
    }

    public BicomCommandXML getBicomPacket() {
        return this.packet;
    }

    public String getPayloadHex() {
        StringBuilder sb = new StringBuilder("0x");
        sb.append(this.flag.hex());
        sb.append(this.serverType.hex());
        sb.append(this.objectId);
        sb.append(this.operation.hex());
        sb.append(this.hexValue);
        return sb.toString();
    }

    public String getResultAsString() {
        String result = this.packet.getResultAsString().toUpperCase(Locale.GERMANY);
        result = result.replaceAll(" ", "");
        result = result.replaceAll(this.getPayloadHex().substring(2), "");
        return result;
    }

    public PayloadFlag getFlag() {
        return this.flag;
    }

    public PayloadServerType getServerType() {
        return this.serverType;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public PayloadOperation getOperation() {
        return this.operation;
    }

    public String getHexValue() {
        return this.hexValue;
    }
}

