/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.device.shared.net.RCPNetworkCallback;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TpktStreamWriter {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.TpktStreamWriter";
    private final Logger logger = LogManager.getLogger((String)"de.seetec.v5.re.cm.device.video.bosch.TpktStreamWriter");
    private final RCPNetworkCallback callback;
    private final OutputStream stream;
    private boolean shutdown = false;

    public TpktStreamWriter(OutputStream outStream, RCPNetworkCallback cb) {
        this.callback = cb;
        this.stream = outStream;
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        try {
            this.stream.close();
        }
        catch (Exception e) {
            this.logger.error("Exception closing stream", (Throwable)e);
        }
    }

    public void send(Packet p) {
        this.send(p.serialize());
    }

    public synchronized void send(byte[] data) {
        if (this.shutdown) {
            this.logger.info("Shutdown in progress");
            return;
        }
        byte[] bodyLength = Packet.intTo2Bytes(data.length + 4);
        byte[] tpktHeader = new byte[]{3, 0, bodyLength[0], bodyLength[1]};
        try {
            this.stream.write(tpktHeader);
            this.stream.write(data);
            this.stream.flush();
        }
        catch (Exception e) {
            if (this.shutdown) {
                return;
            }
            this.logger.error("Exception writing to network", (Throwable)e);
            this.callback.onNetworkError(-21603);
        }
    }
}

