/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.device.shared.net.RCPNetworkCallback;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TpktStreamReader
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.TpktStreamReader";
    private final Logger logger = LogManager.getLogger((String)"de.seetec.v5.re.cm.device.video.bosch.TpktStreamReader");
    private RCPNetworkCallback callback = null;
    private boolean shutdown;
    private InputStream stream = null;
    private boolean reportTimeOut = false;

    public int init(InputStream inStream, RCPNetworkCallback cb, boolean reportTimeOut) {
        this.shutdown = false;
        this.stream = inStream;
        if (this.stream == null) {
            this.logger.error("InputStream null. No further info available.");
            return -21601;
        }
        this.callback = cb;
        if (this.callback == null) {
            this.logger.error("Callback null for " + this.stream);
            return -21601;
        }
        this.reportTimeOut = reportTimeOut;
        new Thread((Runnable)this, this.toString()).start();
        return 0;
    }

    public int init(InputStream inStream, RCPNetworkCallback cb) {
        return this.init(inStream, cb, false);
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        try {
            this.stream.close();
        }
        catch (Exception e) {
            this.logger.error("Exception closing stream", (Throwable)e);
        }
        this.stream = null;
    }

    @Override
    public void run() {
        block13: {
            try {
                while (!this.shutdown) {
                    int read;
                    byte[] tpktHeader = new byte[4];
                    int headerRead = 0;
                    while (!this.shutdown && headerRead != 4) {
                        try {
                            read = this.stream.read(tpktHeader, headerRead, 4 - headerRead);
                            if (read == -1) {
                                this.logger.warn("End Read Thread. Outer.");
                                this.callback.onNetworkError(-21603);
                                break block13;
                            }
                            headerRead += read;
                        }
                        catch (SocketTimeoutException ste) {
                            if (!this.reportTimeOut) continue;
                            this.callback.onNetworkError(-21603);
                            break block13;
                        }
                        catch (Exception e) {
                            if (!this.shutdown) {
                                this.logger.error("Exception reading tpk header", (Throwable)e);
                                this.callback.onNetworkError(-21603);
                            }
                            break block13;
                        }
                    }
                    if (tpktHeader.length < 4) continue;
                    if (tpktHeader[0] != 3) {
                        this.logger.error("Wrong TPKT version, expected 3, is " + tpktHeader[0]);
                        this.callback.onNetworkError(-21603);
                        break;
                    }
                    int bodySize = Packet.bytesToInt(tpktHeader, 2, 2) - 4;
                    byte[] body = new byte[bodySize];
                    for (int bodyRead = 0; !this.shutdown && bodyRead != bodySize; bodyRead += read) {
                        try {
                            read = this.stream.read(body, bodyRead, bodySize - bodyRead);
                            continue;
                        }
                        catch (Exception e) {
                            if (this.shutdown) break;
                            this.logger.error("Exception reading tpk body", (Throwable)e);
                            this.callback.onNetworkError(-21603);
                            break;
                        }
                    }
                    if (this.shutdown) continue;
                    byte[] bodyCopy = new byte[body.length];
                    System.arraycopy(body, 0, bodyCopy, 0, body.length);
                    this.callback.onRCPDataPacket(bodyCopy);
                }
            }
            catch (Throwable t) {
                this.logger.error("Exception while reading strom for " + this.callback);
                this.logger.error((Object)t, t);
                this.shutdown();
            }
        }
        this.shutdown();
    }

    public String toString() {
        return "de.seetec.v5.re.cm.device.video.bosch.TpktStreamReader[callback=" + this.callback.toString() + "]";
    }
}

