/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.device.video.bosch.rcpXml.H264EncBaseOperationModeCapsXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.OperationMode;

public enum ResolutionMappingMP {
    BOSCH_720P(1280, 720, 4),
    BOSCH_720P_FULL_FRAMERATE(1280, 720, 5),
    BOSCH_1080P(1920, 1080, 6),
    BOSCH_720P_SKIP3(1280, 720, 7),
    BOSCH_720P_SKIP4(1280, 720, 8),
    BOSCH_1080P_SKIP7(1920, 1080, 9),
    BOSCH_SD_ROI_PTZ(0, 0, 10),
    BOSCH_2592x1944(2592, 1944, 11),
    BOSCH_400x720(400, 720, 12),
    BOSCH_4CIF(704, 576, 13),
    BOSCH_DUAL_STREAM_INDEPENDENT_ROI_PTZ(0, 0, 14),
    BOSCH_1280x960_4_3_CROPPED(1280, 960, 15),
    BOSCH_1440x1080(1440, 1080, 16),
    BOSCH_1280x1024(1280, 1024, 17),
    BOSCH_576x1024_UPRIGHT(576, 1024, 18),
    BOSCH_720p_CROPPED(1280, 720, 19),
    BOSCH_2704x2032(2704, 2032, 20),
    BOSCH_2992x1680(2992, 1680, 21),
    BOSCH_3840x2160(3840, 2160, 22),
    BOSCH_4000x3000(4000, 3000, 23),
    BOSCH_3584x2016(3584, 2016, 24),
    BOSCH_800x600(800, 600, 25),
    BOSCH_1024x768(1024, 768, 26),
    BOSCH_1280x960(1280, 960, 27),
    BOSCH_1600x1200(1600, 1200, 28),
    BOSCH_3648x2160(3648, 2160, 29),
    BOSCH_2640x2640(2640, 2640, 30),
    BOSCH_1792x1792(1792, 1792, 31),
    BOSCH_1024x1024(1024, 1024, 32),
    BOSCH_800x800(800, 800, 33),
    BOSCH_1536x864(1536, 864, 34),
    BOSCH_2560x1440(2560, 1440, 35),
    BOSCH_2560x960(2560, 960, 36),
    BOSCH_FEDC_MODE(3648, 1080, 37),
    BOSCH_1824x1080_ROI_PTZ(1824, 1080, 38),
    BOSCH_1824x540(1824, 540, 39),
    BOSCH_1280x480(1280, 480, 40),
    BOSCH_1536x1536(1536, 1536, 41),
    BOSCH_800x800_ROI_PTZ(800, 800, 42),
    BOSCH_768x768(768, 768, 43),
    BOSCH_768x288(768, 288, 44),
    BOSCH_2048x1152(2048, 1152, 45),
    BOSCH_2688x800(2688, 800, 46),
    BOSCH_672x200(672, 200, 47),
    BOSCH_608x360(608, 360, 48),
    BOSCH_640x240(640, 240, 49),
    BOSCH_768x576(768, 576, 50),
    BOSCH_3584x504(3584, 504, 51),
    BOSCH_VGA_CROPPED(640, 480, 52),
    BOSCH_2992x1680_SKIP_3(2992, 1680, 53),
    BOSCH_2704x2032_SKIP_3(2704, 2032, 54),
    BOSCH_2640x2640_SKIP_6(2640, 2640, 55),
    BOSCH_1792x1792_SKIP_2(1792, 1792, 56),
    BOSCH_1824x1080(1824, 1080, 57),
    BOSCH_1216x720(1216, 720, 58),
    BOSCH_1280x1024_CROPPED(1280, 1024, 59),
    BOSCH_2048x1536(2048, 1536, 60),
    BOSCH_1920x1080_SKIP_2(1920, 1080, 61),
    BOSCH_1920x1080_cropped(1920, 1080, 62),
    BOSCH_3072x1728(3072, 1728, 63),
    BOSCH_3072x1728_SKIP_3(3072, 1728, 64),
    BOSCH_2688x1512(2688, 1512, 65),
    BOSCH_2304x1296(2304, 1296, 66),
    BOSCH_2688x1512_SKIP_2(2688, 1512, 67),
    BOSCH_2304x1296_SKIP_2(2304, 1296, 68),
    BOSCH_3264x1840(3264, 1840, 70),
    BOSCH_3264x1840_SKIP_3(3264, 1840, 71),
    BOSCH_3840x2160_SKIP6(3840, 2160, 75),
    BOSCH_3840x2160_SKIP3(3840, 2160, 76),
    BOSCH_3584x2016_SKIP8(3584, 2016, 77),
    BOSCH_3264_1840_SKIP3(3264, 1840, 78),
    BOSCH_3072_1728_SKIP2(3072, 1728, 79),
    BOSCH_3584x2016_SKIP6(3584, 2016, 80),
    BOSCH_3584x2016_SKIP2(3584, 2016, 81),
    BOSCH_1920x1440_CROP(1920, 1440, 82),
    BOSCH_2720x1530(2720, 1530, 83),
    BOSCH_2720x1530_SKIP2(2720, 1530, 84),
    BOSCH_1440x1440(1440, 1440, 85);

    private final int width;
    private final int height;
    private final int resolutionTag;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getResolutionTag() {
        return this.resolutionTag;
    }

    private ResolutionMappingMP(int width, int height, int resolutionTag) {
        this.width = width;
        this.height = height;
        this.resolutionTag = resolutionTag;
    }

    public static ResolutionMappingMP valueOf(H264EncBaseOperationModeCapsXML h264EncBaseOperationModeCaps, int width, int height) {
        ResolutionMappingMP mapping = null;
        for (ResolutionMappingMP t : ResolutionMappingMP.values()) {
            if (width != t.getWidth() || height != t.getHeight()) continue;
            for (OperationMode operationModeComb : h264EncBaseOperationModeCaps.getOperationModes()) {
                if ((operationModeComb.getResolution(1) == null || operationModeComb.getResolution(1).getNumber() != t.getResolutionTag()) && (operationModeComb.getResolution(2) == null || operationModeComb.getResolution(2).getNumber() != t.getResolutionTag())) continue;
                mapping = t;
                return mapping;
            }
        }
        return mapping;
    }

    public static ResolutionMappingMP valueOf(int resolutionTag) {
        ResolutionMappingMP mapping = null;
        for (ResolutionMappingMP t : ResolutionMappingMP.values()) {
            if (resolutionTag != t.getResolutionTag()) continue;
            mapping = t;
            break;
        }
        return mapping;
    }
}

