/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.device.shared.Resolution;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.bosch.BoschCameraSrv;
import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.ResolutionMappingMP;
import de.seetec.v5.re.cm.device.video.bosch.ResolutionMappingSD_JPG;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Mpeg4GopStructure;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.BaseFramerateXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.BicomCommandXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.BoschResolution;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.CamNameLinesXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.ConfAudioXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.ConfEncProfileParamsXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.ConfEncStampingProperties;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.ConfVideoCurrentParamsCodnbrXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.EncodeCurrentResolutionXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.H264EncBaseOperationModeCapsXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.H264EncBaseOperationModeXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.H264EncoderConfigXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.JpegStreamSetupOptionsVerboseXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.JpegStreamSetupXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Mpeg4AvcBitrateOptimization;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Mpeg4BandwidthXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Mpeg4CurrentParamsXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Mpeg4FrameSkipRatioXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Mpeg4GopStructureXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Mpeg4IFrameDistanceXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Mpeg4NameXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Mpeg4ResolutionXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.NameStampValXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.OperationMode;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.RTSPPort;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.SoftwareVersionXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Stamping;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.TimeStampValXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.VideoInputFormatExVerboseXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.VideoInputFormatExXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.VideoOperationModeXML;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;

public class BoschVideoSourceClientRTSP
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.mpeg.BoschVideoSourceClientRTSP";
    private int res = -1;
    private int streamNumber = 1;
    private int profile = -1;
    private int maxBaseFramerate;
    private BoschCameraSrv boschCameraSrv;

    private void setH26xResolutionIndependentStreams() {
        Mpeg4ResolutionXML mpeg4ResolutionXml = new Mpeg4ResolutionXML();
        mpeg4ResolutionXml.setHeight(this.height);
        mpeg4ResolutionXml.setWidth(this.width);
        try {
            mpeg4ResolutionXml.setNum(this.profile);
            mpeg4ResolutionXml.send(this.getBoschDevice(), Direction.WRITE);
        }
        catch (Exception ex) {
            this.logger.warn("Exception while setting resolution for " + this + " : " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setH26xResolutions(BoschDevice device) {
        block54: {
            try {
                this.boschCameraSrv.setBlockResolutionSetting();
            }
            catch (InterruptedException ex) {
                this.logger.info("Exception while getting semaphore for setting resolutions for " + this);
            }
            try {
                boolean setSDResolution;
                boolean setMPResolution;
                H264EncBaseOperationModeCapsXML h264EncBaseOperationModeCaps = new H264EncBaseOperationModeCapsXML();
                try {
                    h264EncBaseOperationModeCaps.send(device, Direction.READ);
                }
                catch (Exception ex) {
                    this.logger.warn("H264EncBaseOperationModeCapsXML not supported for " + this);
                }
                ResolutionMappingMP resolutionMappingMP = ResolutionMappingMP.valueOf(h264EncBaseOperationModeCaps, this.width, this.height);
                if (resolutionMappingMP == null) {
                    setMPResolution = false;
                    setSDResolution = true;
                } else {
                    setMPResolution = true;
                    setSDResolution = false;
                }
                if (setMPResolution) {
                    if (resolutionMappingMP == null) {
                        this.logger.warn("ResolutionMappingMP is null. Cannot set resolutions");
                    } else {
                        this.logger.info("Setting Resolution: " + this.width + "x" + this.height + " Tag: " + resolutionMappingMP.getResolutionTag() + " Name: " + resolutionMappingMP.name());
                        this.res = resolutionMappingMP.getResolutionTag();
                    }
                    H264EncBaseOperationModeXML h264EncBaseOperationMode = new H264EncBaseOperationModeXML();
                    h264EncBaseOperationMode.setNum(this.videoSourceNr);
                    try {
                        h264EncBaseOperationMode.send(device, Direction.READ);
                        int resolutionStream1 = h264EncBaseOperationMode.getResolutionStream1();
                        int resolutionStream2 = h264EncBaseOperationMode.getResolutionStream2();
                        boolean resolutionChanged = false;
                        if (this.streamNumber == 1 && this.res != resolutionStream1) {
                            resolutionStream1 = this.res;
                            resolutionChanged = true;
                        }
                        if (this.streamNumber == 2 && this.res != resolutionStream2) {
                            resolutionStream2 = this.res;
                            resolutionChanged = true;
                        }
                        if (resolutionChanged) {
                            int res1 = resolutionStream1;
                            int res2 = resolutionStream2;
                            boolean foundCombination = false;
                            List<OperationMode> operationModes = h264EncBaseOperationModeCaps.getOperationModes();
                            for (OperationMode operationMode : operationModes) {
                                if (resolutionStream1 != operationMode.getResolution(1).getNumber() || resolutionStream2 != operationMode.getResolution(2).getNumber()) continue;
                                foundCombination = true;
                                break;
                            }
                            if (!foundCombination) {
                                for (OperationMode operationMode : operationModes) {
                                    if (this.streamNumber == 1) {
                                        if (operationMode.getResolution(1).getNumber() != resolutionStream1 || operationMode.getResolution(2) != BoschResolution.SD) continue;
                                        res1 = resolutionStream1;
                                        res2 = BoschResolution.SD.getNumber();
                                        foundCombination = true;
                                        break;
                                    }
                                    if (operationMode.getResolution(2).getNumber() != resolutionStream2 || operationMode.getResolution(1) != BoschResolution.SD) continue;
                                    res1 = resolutionStream1;
                                    res2 = BoschResolution.SD.getNumber();
                                    foundCombination = true;
                                    break;
                                }
                            }
                            if (!foundCombination && this.streamNumber == 1) {
                                for (OperationMode operationMode : operationModes) {
                                    if (operationMode.getResolution(1).getNumber() != resolutionStream1 || operationMode.getResolution(2) != BoschResolution.copy_other_stream) continue;
                                    res1 = resolutionStream1;
                                    res2 = BoschResolution.copy_other_stream.getNumber();
                                    foundCombination = true;
                                    break;
                                }
                            }
                            if (!foundCombination && this.streamNumber == 2) {
                                for (OperationMode operationMode : operationModes) {
                                    if (operationMode.getResolution(1).getNumber() != resolutionStream2 || operationMode.getResolution(2) != BoschResolution.copy_other_stream) continue;
                                    res1 = resolutionStream2;
                                    res2 = BoschResolution.copy_other_stream.getNumber();
                                    foundCombination = true;
                                    break;
                                }
                            }
                            if (!foundCombination) {
                                for (OperationMode operationMode : operationModes) {
                                    if (this.streamNumber == 1) {
                                        if (operationMode.getResolution(1).getNumber() != resolutionStream1) continue;
                                        res1 = resolutionStream1;
                                        res2 = operationMode.getResolution(2).getNumber();
                                        foundCombination = true;
                                        break;
                                    }
                                    if (operationMode.getResolution(1).getNumber() != resolutionStream1) continue;
                                    res1 = resolutionStream1;
                                    res2 = operationMode.getResolution(2).getNumber();
                                    foundCombination = true;
                                    break;
                                }
                            }
                            if (!foundCombination) {
                                for (OperationMode operationMode : operationModes) {
                                    if (operationMode.getResolution(1).getNumber() != BoschResolution.SD.getNumber() || operationMode.getResolution(2) != BoschResolution.copy_other_stream) continue;
                                    res1 = BoschResolution.SD.getNumber();
                                    res2 = BoschResolution.copy_other_stream.getNumber();
                                    foundCombination = true;
                                    break;
                                }
                            }
                            if (this.rotationAngle == 90 || this.rotationAngle == 270) {
                                h264EncBaseOperationMode.setInverted(true);
                            } else {
                                h264EncBaseOperationMode.setInverted(false);
                            }
                            h264EncBaseOperationMode.setResolutionStream1(res1);
                            h264EncBaseOperationMode.setResolutionStream2(res2);
                            h264EncBaseOperationMode.send(device, Direction.WRITE);
                            if (h264EncBaseOperationMode.getResolutionStream1() != res1 || h264EncBaseOperationMode.getResolutionStream2() != res2) {
                                setSDResolution = true;
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.logger.warn("Could not set resolutions as MP Resolution. Trying to set SD Resolution instead. Error: " + ex.getMessage());
                        setSDResolution = true;
                    }
                }
                if (!setSDResolution) break block54;
                ResolutionMappingSD_JPG resolutionMappingSD_JPG = ResolutionMappingSD_JPG.valueOf(this.width, this.height);
                if (resolutionMappingSD_JPG != null) {
                    this.logger.info("Setting Resolution: " + this.width + "x" + this.height + " Tag: " + resolutionMappingSD_JPG.getResolutionTag() + " Name: " + resolutionMappingSD_JPG.name());
                    H264EncBaseOperationModeXML h264EncBaseOperationMode = new H264EncBaseOperationModeXML();
                    h264EncBaseOperationMode.setNum(this.videoSourceNr);
                    try {
                        boolean foundCombination;
                        h264EncBaseOperationMode.send(device, Direction.READ);
                        int resolutionStream1 = h264EncBaseOperationMode.getResolutionStream1();
                        int resolutionStream2 = h264EncBaseOperationMode.getResolutionStream2();
                        List<OperationMode> operationModes = h264EncBaseOperationModeCaps.getOperationModes();
                        if (this.streamNumber == 1) {
                            foundCombination = false;
                            resolutionStream1 = BoschResolution.SD.getNumber();
                            for (OperationMode operationMode : operationModes) {
                                if (operationMode.getResolution(1).getNumber() != resolutionStream1 || operationMode.getResolution(2).getNumber() != resolutionStream2) continue;
                                foundCombination = true;
                                break;
                            }
                            if (!foundCombination) {
                                for (OperationMode operationMode : operationModes) {
                                    if (operationMode.getResolution(1).getNumber() != resolutionStream1 || operationMode.getResolution(2).getNumber() != BoschResolution.SD.getNumber()) continue;
                                    resolutionStream2 = BoschResolution.SD.getNumber();
                                    foundCombination = true;
                                    break;
                                }
                            }
                            if (!foundCombination) {
                                for (OperationMode operationMode : operationModes) {
                                    if (operationMode.getResolution(1).getNumber() != resolutionStream1 || operationMode.getResolution(2).getNumber() != BoschResolution.copy_other_stream.getNumber()) continue;
                                    resolutionStream2 = BoschResolution.copy_other_stream.getNumber();
                                    foundCombination = true;
                                    break;
                                }
                            }
                        } else if (this.streamNumber == 2) {
                            foundCombination = false;
                            resolutionStream2 = BoschResolution.SD.getNumber();
                            for (OperationMode operationMode : operationModes) {
                                if (operationMode.getResolution(2).getNumber() != resolutionStream2 || operationMode.getResolution(1).getNumber() != resolutionStream1) continue;
                                foundCombination = true;
                                break;
                            }
                            if (!foundCombination) {
                                for (OperationMode operationMode : operationModes) {
                                    if (operationMode.getResolution(2).getNumber() != resolutionStream2 || operationMode.getResolution(1).getNumber() != BoschResolution.SD.getNumber()) continue;
                                    resolutionStream1 = BoschResolution.SD.getNumber();
                                    foundCombination = true;
                                    break;
                                }
                            }
                            if (!foundCombination) {
                                for (OperationMode operationMode : operationModes) {
                                    if (operationMode.getResolution(2).getNumber() != resolutionStream2 || operationMode.getResolution(1).getNumber() != BoschResolution.copy_other_stream.getNumber()) continue;
                                    resolutionStream1 = BoschResolution.copy_other_stream.getNumber();
                                    break;
                                }
                            }
                        }
                        if (this.rotationAngle == 90 || this.rotationAngle == 270) {
                            h264EncBaseOperationMode.setInverted(true);
                        } else {
                            h264EncBaseOperationMode.setInverted(false);
                        }
                        h264EncBaseOperationMode.setResolutionStream1(resolutionStream1);
                        h264EncBaseOperationMode.setResolutionStream2(resolutionStream2);
                        h264EncBaseOperationMode.send(device, Direction.WRITE);
                    }
                    catch (Exception ex) {
                        this.logger.warn("Could not set SD Resolution for stream " + this.streamNumber);
                    }
                    this.res = resolutionMappingSD_JPG.getResolutionTag();
                    Mpeg4ResolutionXML reqRes = new Mpeg4ResolutionXML();
                    reqRes.setNum(this.profile);
                    reqRes.setResolution(this.res);
                    try {
                        reqRes.send(device, Direction.WRITE);
                    }
                    catch (Exception ex) {
                        this.logger.error("Exception while setting Resolution for " + this + " : " + ex.getMessage());
                    }
                    if (reqRes.getResolution() != this.res) {
                        this.logger.error("Could not set resolution: Resolutio tag in Seetec: " + this.res + ", Resolution tag on Decive: " + reqRes.getResolution());
                    }
                    break block54;
                }
                this.logger.info("Resolution unknown. Resolution will not be set for " + this.getVideoSrv().getDevice());
            }
            finally {
                this.boschCameraSrv.releaseBlockResolutionSetting();
            }
        }
    }

    private void configureJpegExtendedCapabilities() {
        try {
            int coderNumber = this.boschCameraSrv.getCoderNumber(this.streamNumber);
            VideoOperationModeXML reqViMode = new VideoOperationModeXML();
            reqViMode.setNum(coderNumber);
            reqViMode.setMode(0);
            reqViMode.send(this.getBoschDevice(), Direction.WRITE);
        }
        catch (Exception ex) {
            this.logger.warn("Exception while setting codec MJPEG for " + this + " : " + ex.getMessage());
        }
        BaseFramerateXML baseFramerate = new BaseFramerateXML();
        int basefps = 0;
        try {
            baseFramerate.send(this.getBoschDevice(), Direction.READ);
            basefps = Math.round((float)baseFramerate.getFramerate() / 1000.0f);
        }
        catch (Exception ex) {
            this.logger.error("Exception while getting base framerate and skip ratio for " + this + ": " + ex.getMessage());
        }
        ConfEncProfileParamsXML confEncProfileParamsXml = new ConfEncProfileParamsXML();
        confEncProfileParamsXml.setHeight(this.height);
        confEncProfileParamsXml.setWidth(this.width);
        confEncProfileParamsXml.setBasefps(basefps);
        confEncProfileParamsXml.setFps((int)this.fps / 1000);
        confEncProfileParamsXml.setQuality(this.isConstantBitrateUsed ? this.quality / 1000 : 0);
        try {
            confEncProfileParamsXml.setNum(this.profile);
            confEncProfileParamsXml.send(this.getBoschDevice(), Direction.WRITE);
        }
        catch (Exception ex) {
            this.logger.warn("Exception while setting JPEG Parameters for " + this + " : " + ex.getMessage());
        }
    }

    private BoschDevice getBoschDevice() {
        return (BoschDevice)this.videoSrv.getDevice();
    }

    private int getMaxTitleLength() throws Exception {
        ConfEncStampingProperties confEncStampingProperties = new ConfEncStampingProperties();
        confEncStampingProperties.send(this.getBoschDevice(), Direction.READ);
        return confEncStampingProperties.getCamNameLines() * confEncStampingProperties.getCharsPerLine();
    }

    @Override
    public int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        int legacyTimeout = this.getBoschDevice().getBoschLegacyTimeout();
        this.networkParameter.checkAndSetTimeout(legacyTimeout);
        this.boschCameraSrv = (BoschCameraSrv)this.videoSrv;
        SoftwareVersionXML softwareVersionXml = new SoftwareVersionXML();
        try {
            softwareVersionXml.send(this.getBoschDevice(), Direction.READ);
            if (!this.getBoschDevice().isFirmwareVersionEqualOrHigher(softwareVersionXml, 6, 30, 0)) {
                this.logger.error("Firmware insufficient for Generic Driver. Please install Firmware 6.30 or higher for " + this);
                return -21668;
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading firmware for " + this + ": " + ex.getMessage());
        }
        this.maxBaseFramerate = (int)this.fps;
        try {
            String streamName = this.listener.getVideoSourceParameter().getStreamName();
            this.streamNumber = streamName.equals("H.264 (2)") || streamName.equals("H.265 (2)") || streamName.equals("MJPEG (2)") ? 2 : (streamName.equals("H.264 (3)") || streamName.equals("H.265 (3)") || streamName.equals("MJPEG (3)") ? 3 : (streamName.equals("H.264 (4)") || streamName.equals("H.265 (4)") || streamName.equals("MJPEG (4)") ? 4 : 1));
            this.logger.info("Current stream Name: " + streamName + ", Stream number on camera: " + this.streamNumber);
        }
        catch (Exception ex) {
            this.logger.error("Configuration Exception for " + this + " : " + ex.getMessage());
        }
        try {
            if (this.supportsVideoInputFormatRotation()) {
                this.rotateImageWithRCP(this.rotationAngle);
            } else if (this.getBoschDevice().supportsBicomImageRotation()) {
                this.rotateImageWithBicom(this.rotationAngle);
            }
        }
        catch (Exception ex) {
            this.logger.info("Could not rotate image for " + this + " : " + ex.getMessage());
        }
        try {
            this.setStamp(this.getBoschDevice(), new TimeStampValXML(), this.useDateTime);
        }
        catch (Exception ex) {
            this.logger.warn("Could not set Timestamp for " + this + " : " + ex.getMessage());
        }
        try {
            boolean enableTitle = this.getBoschDevice().getNumberOfCameras() > 1 ? true : this.useTitle;
            this.setStamp(this.getBoschDevice(), new NameStampValXML(), enableTitle);
            CamNameLinesXML camNameLinesXml = new CamNameLinesXML();
            camNameLinesXml.setNum(this.videoSourceNr);
            int maxTitleLength = this.getMaxTitleLength();
            camNameLinesXml.setMaxTitleLength(maxTitleLength);
            if (this.useTitle) {
                if (this.title.length() > maxTitleLength) {
                    this.title = this.title.substring(0, maxTitleLength);
                }
                camNameLinesXml.setNameStamp(this.title);
            }
            if (this.useTitle || this.getBoschDevice().getNumberOfCameras() > 1) {
                camNameLinesXml.send(this.getBoschDevice(), Direction.WRITE);
            }
        }
        catch (Exception ex) {
            this.logger.warn("Could not set Namestamp for " + this + " : " + ex.getMessage());
        }
        this.bandwidth /= 1024;
        this.profile = (this.videoSourceNr - 1) * 2 + this.streamNumber;
        if (this.getBoschDevice().isSupportingIndividualStreamCapabilities().booleanValue()) {
            try {
                this.profile = this.boschCameraSrv.getProfilePreset(this.streamNumber);
            }
            catch (Exception ex) {
                this.logger.warn("Exception while getting profile preset number for " + this + ". Assuming it is " + this.profile);
            }
        }
        if (this.videoCodec == Codec.MJPEG) {
            block108: {
                boolean configureJpeg = this.getBoschDevice().canConfigureJpeg();
                if (configureJpeg) {
                    if (this.getBoschDevice().isSupportingIndividualStreamCapabilities().booleanValue()) {
                        this.configureJpegExtendedCapabilities();
                    } else {
                        this.quality /= 1000;
                        this.quality = this.quality <= 0 ? 1 : this.quality;
                        ResolutionMappingSD_JPG resolutionMapping = ResolutionMappingSD_JPG.valueOf(this.width, this.height);
                        if (resolutionMapping != null) {
                            this.res = resolutionMapping.getResolutionTag();
                        }
                        if (this.res == -1) {
                            JpegStreamSetupOptionsVerboseXML options = new JpegStreamSetupOptionsVerboseXML();
                            try {
                                options.send(this.getBoschDevice(), Direction.READ);
                                List<Resolution> resolutions = options.getResolutions();
                                for (Resolution jpegResolution : resolutions) {
                                    if (jpegResolution.getWidth() != this.width || jpegResolution.getHeight() != this.height) continue;
                                    this.res = jpegResolution.getId();
                                }
                            }
                            catch (Exception ex) {
                                this.logger.error("Could not read available resolutions. Using default values instead. Error: " + ex.getMessage());
                            }
                        }
                        if (this.res == -1) {
                            this.logger.error("Could not find resolutions. JPEG parameters wont be set for " + this);
                        } else {
                            JpegStreamSetupXML jpegStreamSetupRequest = new JpegStreamSetupXML();
                            jpegStreamSetupRequest.setNum(1);
                            if (this.rotationAngle == 90 || this.rotationAngle == 270) {
                                jpegStreamSetupRequest.setInverted(true);
                            } else {
                                jpegStreamSetupRequest.setInverted(false);
                            }
                            jpegStreamSetupRequest.setResolution(this.res);
                            this.fps = this.fps > (long)this.maxBaseFramerate ? (long)this.maxBaseFramerate : this.fps;
                            jpegStreamSetupRequest.setFPS((int)this.fps);
                            jpegStreamSetupRequest.setQuality(this.quality);
                            try {
                                jpegStreamSetupRequest.send(this.getBoschDevice(), Direction.WRITE);
                            }
                            catch (Exception ex) {
                                this.logger.error("Exception while setting JPEG parameters for " + this + " : " + ex.getMessage());
                                if (!(ex instanceof SeeTecException)) break block108;
                                SeeTecException ste = (SeeTecException)((Object)ex);
                                return ste.getErrorCode();
                            }
                        }
                    }
                }
            }
            this.rtspUrl = "rtsp://" + this.networkParameter.getHost() + ":554/?h26x=0&line=" + this.videoSourceNr;
            if (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST) {
                this.rtspUrl = "rtsp://" + this.networkParameter.getHost() + "/rtsp_tunnel?h26x=0&line=" + this.videoSourceNr;
                this.networkParameter.setHttpPort(80);
            }
            if (this.isMulticastEnabled) {
                this.rtspUrl = this.rtspUrl + "&multicast=1";
            }
            if (this.getBoschDevice().isSupportingIndividualStreamCapabilities().booleanValue()) {
                this.rtspUrl = this.rtspUrl + "&inst=" + this.streamNumber;
            }
            this.rtspSettings = new RTSPStreamSettings();
            try {
                this.rtspSettings.setCheckResolution(true, this.resolution);
                this.rtspSettings.init(this, null, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), false, 2, this.rtspUrl, true);
                if (this.rotationAngle == 90 || this.rotationAngle == 270) {
                    this.logger.info("Switching resolution. Previous resolution: " + this.width + "x" + this.height);
                    int temp = this.width;
                    this.width = this.height;
                    this.height = temp;
                    this.logger.info("\t\t\tNew resolution: " + this.width + "x" + this.height);
                }
            }
            catch (ConfigurationException ex) {
                this.logger.warn("Could not initialize rtspSettings for " + this);
                this.logger.warn((Object)ex);
            }
        } else {
            if (!this.getBoschDevice().isSupportingIndividualStreamCapabilities().booleanValue()) {
                Mpeg4NameXML mpeg4Name = new Mpeg4NameXML();
                mpeg4Name.setName("VMS_Channel_" + this.videoSourceNr + "_Stream_" + this.streamNumber);
                mpeg4Name.setNum(this.profile);
                try {
                    mpeg4Name.send(this.getBoschDevice(), Direction.WRITE);
                }
                catch (Exception ex) {
                    this.logger.error("Exception while setting profile name for " + this + " : " + ex.getMessage());
                }
            }
            this.iFrameDist = (int)(this.fps * (long)this.iFrameDistMS) / 1000000;
            this.iFrameDist = this.iFrameDist < 3L ? 3L : this.iFrameDist;
            long l = this.iFrameDist = this.iFrameDist > 60L ? 60L : this.iFrameDist;
            if (this.isAudioEnabled) {
                try {
                    ConfAudioXML confAudioXml = new ConfAudioXML();
                    confAudioXml.setAudioEnabled(true);
                    confAudioXml.send(this.getBoschDevice(), Direction.WRITE);
                    this.logger.info("Audio enabled for " + this.getVideoSrv());
                    try {
                        this.logger.info("Audio Parameter: " + this.audioCodec + " with " + this.audioBitrate + "bit for " + this.getVideoSrv().getDevice());
                    }
                    catch (Exception e) {
                        this.logger.error("Reading audio configuration from " + this.getVideoSrv().getDevice() + " failed ", (Throwable)e);
                        return -21601;
                    }
                }
                catch (Exception ex) {
                    this.logger.error("Exception while enabling Audio for " + this + " : " + ex.getMessage());
                }
            }
            this.quality /= 1000;
            this.quality = this.quality <= 0 ? 1 : this.quality;
            Mpeg4IFrameDistanceXML reqIFrame = new Mpeg4IFrameDistanceXML();
            reqIFrame.setNum(this.profile);
            reqIFrame.setDistance((int)this.iFrameDist);
            try {
                reqIFrame.send(this.getBoschDevice(), Direction.WRITE);
            }
            catch (Exception ex) {
                this.logger.error("Exception while setting I-Frame distance for " + this + " : " + ex.getMessage());
            }
            Mpeg4GopStructureXML reqGop = new Mpeg4GopStructureXML();
            reqGop.setNum(this.profile);
            reqGop.setValue(Mpeg4GopStructure.GOP_VALUES.IP.getValue());
            try {
                reqGop.send(this.getBoschDevice(), Direction.WRITE);
            }
            catch (Exception ex) {
                this.logger.warn("Exception while GOP-Structure for " + this + " : " + ex.getMessage());
            }
            if (this.isConstantBitrateUsed) {
                Mpeg4AvcBitrateOptimization mpeg4AvcBitrateOptimization = new Mpeg4AvcBitrateOptimization();
                mpeg4AvcBitrateOptimization.setQuality(0);
                mpeg4AvcBitrateOptimization.setNum(this.profile);
                try {
                    mpeg4AvcBitrateOptimization.send(this.getBoschDevice(), Direction.WRITE);
                }
                catch (Exception ex) {
                    this.logger.error("Exception while shutting down quality settings for " + this + " : " + ex.getMessage());
                }
                Mpeg4BandwidthXML reqBandS = new Mpeg4BandwidthXML();
                reqBandS.setNum(this.profile);
                reqBandS.setBandwidth(this.bandwidth);
                try {
                    reqBandS.send(this.getBoschDevice(), Direction.WRITE);
                }
                catch (Exception ex) {
                    this.logger.error("Exception while setting Bandwidth for " + this + " : " + ex.getMessage());
                }
            } else {
                int avcQuality = (100 - this.quality) / 20 + 1;
                Mpeg4AvcBitrateOptimization mpeg4AvcBitrateOptimization = new Mpeg4AvcBitrateOptimization();
                mpeg4AvcBitrateOptimization.setQuality(avcQuality);
                mpeg4AvcBitrateOptimization.setNum(this.profile);
                try {
                    mpeg4AvcBitrateOptimization.send(this.getBoschDevice(), Direction.WRITE);
                }
                catch (Exception ex) {
                    this.logger.error("Exception while setting Quality for " + this + " : " + ex.getMessage());
                }
            }
            if (this.getBoschDevice().isSupportingIndividualStreamCapabilities().booleanValue()) {
                this.setH26xResolutionIndependentStreams();
            } else {
                this.setH26xResolutions(this.getBoschDevice());
            }
            BaseFramerateXML baseFramerate = new BaseFramerateXML();
            try {
                baseFramerate.send(this.getBoschDevice(), Direction.READ);
                int basefpsThousands = Math.round((float)baseFramerate.getFramerate() / 1000.0f);
                int baseFps = basefpsThousands * 1000;
                long skipRatio = (long)baseFps / this.fps;
                Mpeg4FrameSkipRatioXML reqSkip = new Mpeg4FrameSkipRatioXML();
                reqSkip.setNum(this.profile);
                reqSkip.setSkipRatio((int)skipRatio);
                reqSkip.send(this.getBoschDevice(), Direction.WRITE);
            }
            catch (Exception ex) {
                this.logger.error("Exception while setting base framerate and skip ratio for " + this + ": " + ex.getMessage());
            }
            int coderNumber = 0;
            if (this.getBoschDevice().isSupportingIndividualStreamCapabilities().booleanValue()) {
                try {
                    coderNumber = this.boschCameraSrv.getCoderNumber(this.streamNumber);
                }
                catch (Exception ex) {
                    this.logger.warn("Exception while getting coder number for " + this + ": " + ex.getMessage());
                }
            }
            VideoOperationModeXML reqViMode = new VideoOperationModeXML();
            reqViMode.setNum(coderNumber);
            if (this.videoCodec == Codec.H264 || this.videoCodec == Codec.H265) {
                if (this.videoCodec == Codec.H264) {
                    reqViMode.setMode(2);
                } else if (this.videoCodec == Codec.H265) {
                    reqViMode.setMode(3);
                }
                try {
                    reqViMode.send(this.getBoschDevice(), Direction.WRITE);
                }
                catch (Exception ex) {
                    this.logger.warn("Exception while trying to send Packet for " + this);
                }
            } else if (this.videoCodec == Codec.RTSP) {
                try {
                    VideoOperationModeXML videoOperationModeXml = new VideoOperationModeXML();
                    videoOperationModeXml.send(this.getBoschDevice(), Direction.READ);
                    int mode = videoOperationModeXml.getMode();
                    if (mode == 2) {
                        this.videoCodec = Codec.H264;
                    } else if (mode == 3) {
                        this.videoCodec = Codec.H265;
                    }
                }
                catch (Exception ex) {
                    return -20100;
                }
            }
            int encoderNumber = 2 * (this.videoSourceNr - 1) + this.streamNumber;
            Mpeg4CurrentParamsXML mpeg4CurrentParamsXML = new Mpeg4CurrentParamsXML();
            mpeg4CurrentParamsXML.setValue(encoderNumber);
            mpeg4CurrentParamsXML.setNum(encoderNumber);
            try {
                mpeg4CurrentParamsXML.send(this.getBoschDevice(), Direction.WRITE);
            }
            catch (Exception ex) {
                this.logger.error("Exception while setting encoder number " + encoderNumber + " for " + this + ": " + ex.getMessage());
            }
            this.rtspUrl = "rtsp://" + this.networkParameter.getHost() + ":554/&h26x=4&line=" + this.videoSourceNr + "&inst=" + this.streamNumber;
            if (this.videoCodec == Codec.H265) {
                this.rtspUrl = this.rtspUrl.replace("h26x=4", "h26x=5");
            }
            if (this.isAudioEnabled) {
                this.rtspUrl = this.rtspUrl + "&enableaudio=1&audio_line=1";
                if (this.audioCodec == Codec.G711U) {
                    this.rtspUrl = this.rtspUrl + "&audio_mode=1";
                }
            }
            if (this.isMulticastEnabled) {
                this.rtspUrl = this.rtspUrl + "&multicast=1";
            }
            this.rtspSettings = new RTSPStreamSettings();
            try {
                if (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST) {
                    this.rtspUrl = "rtsp://" + this.networkParameter.getHost() + "/rtsp_tunnel?h26x=" + (this.videoCodec == Codec.H264 ? "4" : "5") + "&line=" + this.videoSourceNr + "&inst=" + this.streamNumber;
                    if (this.isAudioEnabled) {
                        this.rtspUrl = this.rtspUrl + "&enableaudio=1&audio_line=1";
                        if (this.audioCodec == Codec.G711U) {
                            this.rtspUrl = this.rtspUrl + "&audio_mode=1";
                        }
                    }
                    this.networkParameter.setHttpPort(80);
                }
                this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 2, this.rtspUrl, true);
            }
            catch (ConfigurationException ex) {
                this.logger.warn("Could not initialize rtspSettings for " + this);
                this.logger.warn((Object)ex);
            }
        }
        if (this.getBoschDevice().isSupportingIndividualStreamCapabilities().booleanValue()) {
            int coderNumber = (this.videoSourceNr - 1) * 8 + this.streamNumber;
            ConfVideoCurrentParamsCodnbrXML confVideoCurrentParamsCodnbrXml = new ConfVideoCurrentParamsCodnbrXML();
            confVideoCurrentParamsCodnbrXml.setProfile(this.streamNumber);
            confVideoCurrentParamsCodnbrXml.setCoder(coderNumber);
            try {
                confVideoCurrentParamsCodnbrXml.send(this.getBoschDevice(), Direction.WRITE);
            }
            catch (Exception ex) {
                this.logger.warn("Exception while assigning profile to a stream for " + this + " : " + ex.getMessage());
            }
        } else {
            try {
                int profileStream1 = (this.videoSourceNr - 1) * 2 + 1;
                int profileStream2 = (this.videoSourceNr - 1) * 2 + 2;
                H264EncoderConfigXML h264EncoderConfig = new H264EncoderConfigXML();
                h264EncoderConfig.setNum(this.videoSourceNr);
                h264EncoderConfig.setProfileStream1(profileStream1);
                h264EncoderConfig.setProfileStream2(profileStream2);
                h264EncoderConfig.send(this.getBoschDevice(), Direction.WRITE);
            }
            catch (Exception ex) {
                this.logger.error("Exception while setting profile for stream. Profile: " + this.profile + ", Stream: " + this.streamNumber + " Error Message: " + ex.getMessage());
            }
        }
        if (this.transmissionID != TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST) {
            try {
                int port = this.listener.getVideoSourceParameter().getRtspPort();
                if (port != 554 && (port < 1024 || port > 65535)) {
                    this.logger.error("RTSP Port should be either 554 or between 1024 and 65535");
                } else {
                    RTSPPort rtspPort = new RTSPPort();
                    rtspPort.setRtspPort(port);
                    rtspPort.send(this.getBoschDevice(), Direction.WRITE);
                }
            }
            catch (Exception ex) {
                this.logger.error("Exception while setting RTSP Port for " + this + ": " + ex.getMessage());
            }
        }
        this.rtspSettings.setKeepAliveInterval(10000);
        this.rtspSettings.disableBasicAuthentication();
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.logger.info("Starting RTSP Stream with url: " + this.rtspUrl);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while initializing RTSP Handler for " + this.getVideoSrv() + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        this.errorCode = this.rtspHandler.start();
        if (this.errorCode != 0) {
            this.logger.error("Start of RTSPHandler failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    private void setStamp(BoschDevice device, Stamping stamping, boolean useStamping) throws Exception {
        if (useStamping) {
            stamping.send(device, Direction.READ);
            if (stamping.getStamp() == StampingPosition.EMPTY.getApiValue()) {
                stamping.setStamp(StampingPosition.TOP.getApiValue());
            }
        } else {
            stamping.setStamp(StampingPosition.EMPTY.getApiValue());
        }
        stamping.send(device, Direction.WRITE);
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.rtspHandler != null) {
            this.rtspHandler.shutdown();
            this.rtspHandler = null;
        }
        super.shutdown();
        this.logger.info("shutdown done for " + this.getVideoSrv());
        return 0;
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }

    private void rotateImageWithRCP(int rotationAngle) {
        BoschDevice device = (BoschDevice)this.videoSrv.getDevice();
        VideoInputFormatExXML videoInputFormatExXml = new VideoInputFormatExXML();
        videoInputFormatExXml.setVideoSource(this.videoSourceNr);
        try {
            videoInputFormatExXml.send(device, Direction.READ);
            int rotation = 0;
            switch (this.rotationAngle) {
                case 90: {
                    rotation = 2;
                    break;
                }
                case 180: {
                    rotation = 4;
                    break;
                }
                case 270: {
                    rotation = 6;
                    break;
                }
            }
            if (videoInputFormatExXml.getImageRotation() != rotation) {
                if (rotationAngle == 90 || rotationAngle == 270) {
                    VideoInputFormatExVerboseXML videoInputFormatExVerboseXML = new VideoInputFormatExVerboseXML();
                    videoInputFormatExVerboseXML.send(device, Direction.READ);
                    EncodeCurrentResolutionXML encodeCurrentResolutionXML = new EncodeCurrentResolutionXML();
                    encodeCurrentResolutionXML.setVideoSource((byte)this.videoSourceNr);
                    encodeCurrentResolutionXML.setStreamNumber((byte)this.streamNumber);
                    encodeCurrentResolutionXML.send(device, Direction.READ);
                    int framerateCorridorMode = videoInputFormatExVerboseXML.getFramerateCorridorMode(encodeCurrentResolutionXML.getWidth(), encodeCurrentResolutionXML.getHeight());
                    int idCorridorMode = videoInputFormatExVerboseXML.getIdCorridorMode(encodeCurrentResolutionXML.getWidth(), encodeCurrentResolutionXML.getHeight());
                    if (this.fps > (long)framerateCorridorMode) {
                        this.maxBaseFramerate = framerateCorridorMode;
                        videoInputFormatExXml.setVideoFormatID(idCorridorMode);
                    }
                }
                videoInputFormatExXml.setImageRotation(rotation);
                videoInputFormatExXml.send(device, Direction.WRITE);
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception while rotating image with RCP+ for " + this + " : " + ex.getMessage());
        }
    }

    private void rotateImageWithBicom(int rotationAngle) {
        String payload = "0x850006011A03";
        payload = rotationAngle == 180 ? payload + "0001" : payload + "0000";
        BoschDevice device = (BoschDevice)this.videoSrv.getDevice();
        BicomCommandXML bicomCommandXML = new BicomCommandXML();
        bicomCommandXML.setPayload(payload);
        try {
            bicomCommandXML.send(device, Direction.WRITE);
        }
        catch (Exception ex) {
            this.logger.error("Exception while setting image rotation with BICOM command: " + ex.getMessage());
        }
    }

    private boolean supportsVideoInputFormatRotation() {
        boolean canRotate;
        VideoInputFormatExVerboseXML videoInputFormatExVerboseXML = new VideoInputFormatExVerboseXML();
        BoschDevice device = (BoschDevice)this.videoSrv.getDevice();
        try {
            videoInputFormatExVerboseXML.send(device, Direction.READ);
            canRotate = videoInputFormatExVerboseXML.isRotation90() || videoInputFormatExVerboseXML.isRotation180() || videoInputFormatExVerboseXML.isRotation270();
        }
        catch (Exception ex) {
            return false;
        }
        return canRotate;
    }

    private static enum StampingPosition {
        EMPTY(0),
        BOTTOM(1),
        TOP(2),
        CUSTOM(3);

        private final int apiValue;

        private StampingPosition(int apiValue) {
            this.apiValue = apiValue;
        }

        public int getApiValue() {
            return this.apiValue;
        }
    }
}

