/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.device.shared.net.RCPNetworkCallback;
import de.seetec.v5.re.cm.device.video.bosch.TpktStreamReader;
import de.seetec.v5.re.cm.device.video.bosch.TpktStreamWriter;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import de.seetec.v5.shared.net.NetworkParameter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Arrays;

public class BoschSyncRCPCall
implements RCPNetworkCallback {
    private static final int DELAY = 5000;
    private Socket socket = null;
    private TpktStreamReader rcpReader = null;
    private TpktStreamWriter rcpWriter = null;
    private Packet answer = null;
    private byte[] expectedReqTag = new byte[2];

    public int init(NetworkParameter networkParameter) {
        int errorCode = 0;
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            this.socket = new Socket(networkParameter.getHost(), networkParameter.getHTTPport());
            this.socket.setSoTimeout(5000);
            inStream = this.socket.getInputStream();
            outStream = this.socket.getOutputStream();
        }
        catch (ConnectException e) {
            errorCode = -21699;
        }
        catch (Exception e) {
            errorCode = -21700;
        }
        this.rcpReader = new TpktStreamReader();
        this.rcpReader.init(inStream, this, true);
        this.rcpWriter = new TpktStreamWriter(outStream, this);
        return errorCode;
    }

    public synchronized int shutdown() {
        if (this.rcpReader != null) {
            this.rcpReader.shutdown();
        }
        this.rcpReader = null;
        if (this.rcpWriter != null) {
            this.rcpWriter.shutdown();
        }
        this.rcpWriter = null;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        this.shutdown();
    }

    public synchronized Packet sendRCPDataPacket(Packet p) {
        this.answer = null;
        this.expectedReqTag = p.getCommand();
        if (this.rcpWriter != null) {
            this.rcpWriter.send(p.serialize());
        }
        long time = System.currentTimeMillis();
        while (time + 5000L > System.currentTimeMillis()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.answer;
    }

    @Override
    public void onRCPDataPacket(byte[] data) {
        if (Arrays.equals(this.expectedReqTag, new byte[]{data[0], data[1]})) {
            this.answer = Packet.deserialize(data);
        }
    }
}

