/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.ReadCameraRecordingInfos;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.cm.shared.timerange.TimeRange;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class BoschPlaybackVideoSourceClient
extends PlaybackVideoSourceClient {
    public static final int BOSCH_SLICE_COMPLETE = -2147483647;
    protected int randomNumber;
    protected String rtspSessionId;
    private BoschDevice device;

    @Override
    public final int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.device = (BoschDevice)this.getVideoSrv().getDevice();
        this.setExecuteOperationAfterSetupFlag(true);
        this.setExecuteOperationAfterPlayFlag(true);
        return 0;
    }

    protected long getSearchStartTime() throws SeeTecException {
        return this.getRecordingInfoSearchTime("00000000", this.videoPlaybackStartingTime);
    }

    protected long getSearchEndtime() throws SeeTecException {
        return this.getRecordingInfoSearchTime("FFFFFFFF", this.endTimeStamp);
    }

    private long getRecordingInfoSearchTime(String maxBoschValue, long targetValue) throws SeeTecException {
        long start;
        if (this.getRangesToFill() == null) {
            start = this.convertBoschHexValueToDate(maxBoschValue, 0L);
        } else {
            start = targetValue;
            if (TimeZone.getDefault().inDaylightTime(new Date())) {
                start += TimeUnit.HOURS.toMillis(1L);
            }
        }
        return start;
    }

    protected void readRTSPsessionId() throws SeeTecException {
        try {
            Document response = ((BoschDevice)this.getVideoSrv().getDevice()).getHttpResponseAsXml("/rcp.xml?command=0x0ae8&type=T_DWORD&direction=READ&protocol=TCP&num=" + this.randomNumber);
            Element root = response.getRootElement();
            this.rtspSessionId = root.getChild("result").getChild("dec").getText();
            this.rtspSessionId = this.rtspSessionId.trim();
        }
        catch (Throwable throwable) {
            throw new SeeTecException(-21600, "Problems while getting sessionID: " + throwable.getMessage());
        }
    }

    protected Element readAvailableRecordingInfos(long fromTime, long toTime) throws Exception {
        ReadCameraRecordingInfos req = new ReadCameraRecordingInfos(fromTime, toTime, 0, this.rtspSessionId);
        req.send((BoschDevice)this.getVideoSrv().getDevice(), Direction.READ);
        return req.getResult().getRootElement().getChild("result");
    }

    protected void processAvailableRecordingInfos(Element result) throws SeeTecException {
        String len = result.getChild("len").getText();
        String str = result.getChild("str").getText();
        if (this.hasAtLeastOneSlice(len)) {
            List<TimeRange> timeRanges = this.parseAvailableRecordingInfos(str);
            if (this.getRangesToFill() == null) {
                this.setRangesToFill(timeRanges);
                throw new SeeTecException(-2147483647, "Slices complete");
            }
        } else {
            this.logger.info("No slices available");
        }
    }

    protected List<TimeRange> parseAvailableRecordingInfos(String slices) throws SeeTecException {
        ArrayList<TimeRange> result = new ArrayList<TimeRange>();
        String sliceAsHexString = slices.replace(" ", "").trim().replace("\n", "").replace("\r", "");
        for (int i = 0; i < sliceAsHexString.length(); i += 32) {
            String temp = sliceAsHexString.substring(i, i + 32);
            long startDate = this.convertBoschHexValueToDate(temp.substring(0, 8), this.getTimeDifference());
            long endDate = this.convertBoschHexValueToDate(temp.substring(8, 16), this.getTimeDifference());
            if (TimeZone.getDefault().inDaylightTime(new Date())) {
                startDate -= TimeUnit.HOURS.toMillis(1L);
                endDate -= TimeUnit.HOURS.toMillis(1L);
            }
            result.add(new TimeRange(startDate, endDate));
        }
        return result;
    }

    private boolean hasAtLeastOneSlice(String sliceAmmount) {
        return Long.parseLong(sliceAmmount) >= 16L;
    }

    @Override
    public final void executeOperationAfterSetup() throws SeeTecException {
        this.readRTSPsessionId();
        long start = this.getSearchStartTime();
        long end = this.getSearchEndtime();
        try {
            this.logger.info("TimeDifference: " + this.getTimeDifference() + " for " + this);
            Element result = this.readAvailableRecordingInfos(start, end);
            this.processAvailableRecordingInfos(result);
        }
        catch (SeeTecException se) {
            if (se.getErrorCode() == -2147483647) {
                throw se;
            }
            this.logger.error((Object)se, (Throwable)se);
            throw new SeeTecException(se.getErrorCode(), se.getMessage());
        }
        catch (Throwable throwable) {
            this.logger.error((Object)throwable, throwable);
            throw new SeeTecException(-21600, "Problems while trying to get the recording information from Bosch device" + throwable);
        }
    }

    @Override
    public final void executeOperationAfterPlay() throws SeeTecException {
        try {
            String cameraName = ((BoschDevice)this.getVideoSrv().getDevice()).getDeviceEntity().getEntityName();
            Document currentResponseAsDocument = ((BoschDevice)this.getVideoSrv().getDevice()).getHttpResponseAsXml("/rcp.xml?command=0x0902&type=T_INT&direction=WRITE&num=1&sessionid=" + this.rtspSessionId + "&payload=0x00000000");
            this.logger.info("RTSP Stream for camera '" + cameraName + "' paused. Current playback speed: " + this.getPlaybackSpeed(currentResponseAsDocument));
            long replayTime = this.videoPlaybackStartingTime;
            this.setVideoPlaybackEndTime(this.endTimeStamp);
            long difference = this.getTimeDifference();
            if (TimeZone.getDefault().inDaylightTime(new Date())) {
                difference += TimeUnit.HOURS.toMillis(1L);
            }
            String startTimeAsHex = this.convertDateToBoschHexValue(replayTime, difference);
            long startTimeAsLong = this.convertBoschHexValueToDate(startTimeAsHex, 0L);
            ((BoschDevice)this.getVideoSrv().getDevice()).getHttpResponseAsXml("/rcp.xml?command=0x0905&type=P_OCTET&direction=WRITE&num=1&sessionid=" + this.rtspSessionId + "&payload=0x" + startTimeAsHex);
            this.logger.info("Start RTSP Stream from camera time: " + new Date(startTimeAsLong) + " [" + startTimeAsHex + "] with time difference of " + TimeUnit.MILLISECONDS.toSeconds(this.getTimeDifference()) + "s.");
            currentResponseAsDocument = ((BoschDevice)this.getVideoSrv().getDevice()).getHttpResponseAsXml("/rcp.xml?command=0x0902&type=T_INT&direction=WRITE&num=1&sessionid=" + this.rtspSessionId + "&payload=" + 100L * (long)this.listener.getVideoSourceParameter().getEdgeStorageParameter().getPlaybackSpeed());
            this.logger.info("RTSP Stream for camera '" + cameraName + "' resumed. Current playback speed: " + this.getPlaybackSpeed(currentResponseAsDocument));
            this.setLocalStorageReady(true);
        }
        catch (Exception throwable) {
            this.logger.error((Object)throwable, (Throwable)throwable);
            throw new SeeTecException(-21600, "Problems while trying to set replay time");
        }
    }

    private String getPlaybackSpeed(Document currentResponseAsDocument) {
        return currentResponseAsDocument.getRootElement().getChild("result").getChild("dec").getText();
    }

    public final long convertBoschHexValueToDate(String hexValue, long timeDifference) throws SeeTecException {
        if (hexValue == null || hexValue.length() != 8) {
            throw new SeeTecException(-21600, "Error while converting HEX value to date because value is zero or != 8");
        }
        long milliSecondsFromYear2k = Long.decode("0x" + hexValue) * 1000L;
        return Tools.getMilliSecondsSinceYear(2000) + milliSecondsFromYear2k - timeDifference;
    }

    public final String convertDateToBoschHexValue(long timeInMilliSeconds, long timeDifference) throws SeeTecException {
        String hexValue;
        if (timeInMilliSeconds < 0L) {
            throw new SeeTecException(-21600, "Error while converting date to HEX value because value is less than 0");
        }
        long time = timeInMilliSeconds;
        time += timeDifference;
        time -= Tools.getMilliSecondsSinceYear(2000);
        time /= 1000L;
        if ((hexValue = Long.toHexString(++time)).length() > 8) {
            hexValue = hexValue.substring(hexValue.length() - 8);
        } else if (hexValue.length() < 8) {
            while (hexValue.length() < 8) {
                hexValue = "0" + hexValue;
            }
        }
        return hexValue;
    }

    @Override
    public final List<TimeRange> getRecordingInfosFromDevice(long startTimestamp, long endTimestamp) {
        return this.device.getRecordingInfosFromDevice(startTimestamp, endTimestamp, this.videoSourceNr, this);
    }

    @Override
    protected Long getTimeDifferenceFromDevice() throws SeeTecException, JDOMException, Exception {
        Document currentResponseAsDocument = ((BoschDevice)this.getVideoSrv().getDevice()).getHttpResponseAsXml("/rcp.xml?command=0x0a0f&type=P_OCTET&direction=READ");
        Element root = currentResponseAsDocument.getRootElement();
        String len = root.getChild("result").getChild("len").getText();
        int length = Integer.parseInt(len);
        if (length == 8) {
            String str = root.getChild("result").getChild("str").getText();
            str = str.replace(" ", "");
            byte[] dateAsByteArray = Basic.hexStringToByteArray((String)str);
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, Basic.byteArrayToInt4((byte[])dateAsByteArray, (int)0, (int)2));
            calendar.set(2, dateAsByteArray[2] - 1);
            calendar.set(5, dateAsByteArray[3]);
            calendar.set(11, dateAsByteArray[4]);
            calendar.set(12, dateAsByteArray[5]);
            calendar.set(13, dateAsByteArray[6]);
            calendar.set(14, 0);
            long deviceTimeInMilliSeconds = calendar.getTimeInMillis();
            long localTime = System.currentTimeMillis();
            this.logger.info("DeviceTime: " + deviceTimeInMilliSeconds + " " + new Date(deviceTimeInMilliSeconds));
            this.logger.info("LocalTime: " + localTime + " " + new Date(localTime));
            this.logger.info("=> TimeDifference (DeviceTime - LocalTime): " + (deviceTimeInMilliSeconds - localTime));
            return deviceTimeInMilliSeconds - localTime;
        }
        throw new SeeTecException(-21600, "Error while calculating time difference between device and server");
    }

    @Override
    protected final double getMaxPlaybackSpeed() {
        return 20.0;
    }

    @Override
    protected final String getRtspUrl(long startTimestamp, long endTimestamp, String nameOfRecording) throws ConfigurationException {
        int videoChannel = this.listener.getVideoSourceParameter().getServerEntryNo();
        boolean stream = true;
        boolean replayMode = true;
        this.randomNumber = (int)(Math.random() * 899.0 + 100.0);
        String tempRtspUrl = "rtsp://" + this.getHost() + "/?rtsp_tunnel?line=" + videoChannel + "&inst=" + 1 + "&rec=" + 1 + "&rnd=" + this.randomNumber;
        this.logger.info("RTSP URL: " + tempRtspUrl + " for " + this);
        return tempRtspUrl;
    }

    @Override
    protected String getTimeRange(long startTimestamp, long endTimestamp, String timeRangeName) {
        return "";
    }

    public int startStreaming() {
        return this.startRtspStreaming(0L, 0L, null);
    }

    public void endStreaming() {
        this.stopRtspStreaming();
    }

    @Override
    protected String getRequireField() {
        return "";
    }
}

