/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.net.RCPNetworkCallback;
import de.seetec.v5.re.cm.device.video.bosch.TpktStreamReader;
import de.seetec.v5.re.cm.device.video.bosch.TpktStreamWriter;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationReq;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationRsp;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientUnregister;
import de.seetec.v5.re.cm.device.video.bosch.rcp.HardwareVersion;
import de.seetec.v5.re.cm.device.video.bosch.rcp.InputPinState;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import de.seetec.v5.re.cm.device.video.bosch.rcp.RelayOutputState;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Retrigger;
import de.seetec.v5.re.cm.device.video.bosch.rcp.TimeoutWarning;
import de.seetec.v5.shared.proxy.ent.Entity;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class BoschIOHandler
extends IOHandler
implements RCPNetworkCallback {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.BoschIOHandler";
    private static final int DELAY = 10000;
    private String passphrase = null;
    private Socket socket = null;
    private TpktStreamReader rcpReader = null;
    private TpktStreamWriter rcpWriter = null;
    private static final int RCP_PORT = 1756;
    private boolean registered = false;
    private boolean registerAnswered = false;
    private byte[] clientID;
    private byte[] sessionID;

    @Override
    public int init(Core core, Device device, Entity[] srvEnities) {
        this.registered = false;
        this.clientID = new byte[]{0, 0};
        int errorCode = super.init(core, device, srvEnities, false, true);
        if (errorCode != 0) {
            return errorCode;
        }
        if (this.hasActiveInputs() || this.hasActiveOutputs()) {
            OutputStream outStream;
            InputStream inStream;
            try {
                this.socket = new Socket(this.host, 1756);
                this.socket.setSoTimeout(15000);
                inStream = this.socket.getInputStream();
                outStream = this.socket.getOutputStream();
            }
            catch (Exception e) {
                this.logger.error("Cannot connect to " + this.host + ":" + 1756 + " for " + device);
                return -21603;
            }
            this.rcpReader = new TpktStreamReader();
            this.rcpReader.init(inStream, this, true);
            this.rcpWriter = new TpktStreamWriter(outStream, this);
            ClientRegistrationReq req = new ClientRegistrationReq();
            this.passphrase = "+" + this.usr + ":" + this.pwd + "+";
            req.setPass(this.passphrase);
            this.sendRCPDataPacket(req);
            long time = System.currentTimeMillis();
            while (time + 10000L > System.currentTimeMillis() && !this.registerAnswered) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.registerAnswered) {
                this.logger.info("No reply to registration for 10000[ms] on " + device);
                this.shutdown();
                return -21603;
            }
            if (!this.registered) {
                this.logger.info("Register failed for " + device);
                return -21657;
            }
        } else {
            this.logger.info("Don't start IOHandlerThread cause no inputs active.");
        }
        this.logger.info("init done for" + device);
        return 0;
    }

    @Override
    public void run() {
        long keepAliveInterval = 10000L;
        long time = System.currentTimeMillis();
        while (!this.isShutdown()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                this.logger.fatal("Error while sleep. " + e.getMessage());
            }
            if (!this.hasActiveInputs() && !this.hasActiveOutputs() || System.currentTimeMillis() <= time + keepAliveInterval) continue;
            Retrigger rtReq = new Retrigger();
            rtReq.setActionRequest();
            rtReq.setClientID(this.clientID);
            rtReq.setSessionID(this.sessionID);
            this.sendRCPDataPacket(rtReq);
            time = System.currentTimeMillis();
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.registered) {
            ClientUnregister unReq = new ClientUnregister();
            unReq.setActionRequest();
            unReq.setClientID(this.clientID);
            this.sendRCPDataPacket(unReq);
        }
        if (this.rcpReader != null) {
            this.rcpReader.shutdown();
        }
        this.rcpReader = null;
        if (this.rcpWriter != null) {
            this.rcpWriter.shutdown();
        }
        this.rcpWriter = null;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                this.logger.warn("Exception while trying to close socket for " + this);
            }
        }
        this.socket = null;
        this.passphrase = null;
        super.shutdown();
        this.logger.info("shutdown done for " + this.device);
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.shutdown();
    }

    public void sendRCPDataPacket(Packet p) {
        if (this.rcpWriter != null) {
            this.rcpWriter.send(p.serialize());
        } else if (this.hasActiveInputs() || this.hasActiveOutputs()) {
            this.logger.warn("rcpWriter is null for " + this.device);
            this.shutdown();
        }
    }

    @Override
    public void onRCPDataPacket(byte[] data) {
        Packet p = Packet.deserialize(data);
        if (this.isShutdown()) {
            return;
        }
        if (p == null) {
            return;
        }
        if (!this.registered) {
            if (p instanceof ClientRegistrationRsp) {
                ClientRegistrationRsp rsp = (ClientRegistrationRsp)p;
                if (!rsp.registerFailed()) {
                    this.clientID = rsp.getClientID();
                    this.sessionID = rsp.getSessionID();
                    this.logger.info("Register success, clientID is [ " + Packet.hexString(this.clientID) + "] for " + this.device);
                    this.registered = true;
                }
                this.registerAnswered = true;
            }
        } else if (p instanceof ClientUnregister) {
            ClientUnregister rsp = (ClientUnregister)p;
            if (rsp.getStatus() != 1) {
                this.logger.warn("ClientUnregister failed for " + this.device);
            }
            this.logger.warn("shutting down, unregistered from server [" + rsp + "]");
            this.shutdown();
        } else if (p instanceof InputPinState) {
            InputPinState rsp = (InputPinState)p;
            if (rsp.isActionError()) {
                this.logger.warn("Error when retrieving inputState: " + rsp.toString() + " for " + this.device);
                this.shutdown();
                return;
            }
            int state = rsp.getState() ? 1 : 0;
            this.readDigitalInputs(rsp.getNumericDescriptorAsInt(), state);
        } else if (p instanceof RelayOutputState) {
            RelayOutputState rsp = (RelayOutputState)p;
            if (rsp.isActionError()) {
                this.logger.warn("Error when setting relay state: " + rsp.toString() + " for " + this.device);
                this.shutdown();
            }
        } else if (p instanceof TimeoutWarning) {
            HardwareVersion req = new HardwareVersion();
            req.setClientID(this.clientID);
            this.sendRCPDataPacket(req);
        }
    }

    public final void readDigitalInputs(int input, int state) {
        DigitalInputSrv[] iServices;
        for (DigitalInputSrv iService : iServices = super.getDigitalInputSrv()) {
            int inputNumber = iService.getInputNumber();
            if (inputNumber != input) continue;
            iService.checkInput(state);
        }
    }

    @Override
    public int writeDigitalOutput(int number, int value, long holdTime) {
        IOHandler.HoldTimer holdTimer;
        int errorCode;
        RelayOutputState req = new RelayOutputState();
        req.setClientID(this.clientID);
        req.setActionRequest();
        req.setWrite();
        req.setNumericDescriptorAsInt(number);
        boolean state = value != 0;
        req.setState(state);
        this.sendRCPDataPacket(req);
        if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(number, value > 0 ? 0 : 1, holdTime)) != 0) {
            holdTimer.shutdown();
            this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] on " + this.device.toString());
        }
        return 0;
    }
}

