/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.configuration.definition.camera.FeaturesType;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecsType;
import de.seetec.v5.re.cm.configuration.definition.device.AvailableIOsType;
import de.seetec.v5.re.cm.configuration.definition.device.BitrateSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.CameraResolutionType;
import de.seetec.v5.re.cm.configuration.definition.device.CaptureModeDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.CodecType;
import de.seetec.v5.re.cm.configuration.definition.device.CommentsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceGroupMembershipsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceNetworkDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.EdgeStoragePlaybackSpeedType;
import de.seetec.v5.re.cm.configuration.definition.device.GenericEventDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.ImageRotationCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MiscVideoServerCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MultiStreamingDefinitionsType;
import de.seetec.v5.re.cm.configuration.definition.device.RtspSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.StreamDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedApiVersionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCameraResolutionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCaptureModesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedEdgeStoragePlaybackSpeedsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedFrameRatesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedRotationAnglesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedTransmissionTypeIDsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedVideoSourceEntityTypesType;
import de.seetec.v5.re.cm.device.shared.Resolution;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministration;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.bosch.BoschCameraAdministration;
import de.seetec.v5.re.cm.device.video.bosch.BoschCameraSrv;
import de.seetec.v5.re.cm.device.video.bosch.BoschIOHandler;
import de.seetec.v5.re.cm.device.video.bosch.BoschPlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.video.bosch.BoschSyncRCPCall;
import de.seetec.v5.re.cm.device.video.bosch.BoschUser;
import de.seetec.v5.re.cm.device.video.bosch.ResolutionMappingSD_JPG;
import de.seetec.v5.re.cm.device.video.bosch.bicomoverrcp.BicomOverRCPQuery;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationReq;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationRsp;
import de.seetec.v5.re.cm.device.video.bosch.rcp.CoderList;
import de.seetec.v5.re.cm.device.video.bosch.rcp.CoderListRsp;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.AlarmEntry;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.AlarmOverviewXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.BaseFramerateXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.BicomCommandXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.BoschResolution;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.CapabilityListXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.CoderVideoOperationModeOptions;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.CommercialTypeNumberXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.ConfEncProfileResolutionOptionsXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.ConfMpeg4AvcBitrateOptimizationOptionsXml;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.DeviceCapabilitiesXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.DeviceCapabilityEntry;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.DptzStaticCapsXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.H264EncBaseOperationModeCapsXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.JpegStreamSetupOptionsVerboseXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.JpegStreamSetupXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.OperationMode;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.ProductNameXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PtzControlerAvailableXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.SoftwareVersionXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.VariantIdXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.VideoInputFormatExVerboseXML;
import de.seetec.v5.re.cm.shared.timerange.TimeRange;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaID;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkHelperAdapter;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import de.seetec.v5.shared.net.SeetecHttpClient;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class BoschDevice
extends VideoServer {
    private static volatile CameraAdministration CAMERA_ADMINISTRATION = null;
    private final int boschLegacyTimeout = (int)TimeUnit.SECONDS.toMillis(10L);
    private HttpHandlerImpl httpHandler;
    private Boolean isEncoder;
    private Boolean supportsIndividualStreamCapabilities;
    private DeviceCapabilitiesXML deviceCapabilities;
    private Integer numberOfCameras;

    public Boolean getIsEncoder() throws Exception {
        if (this.isEncoder == null) {
            DeviceCapabilitiesXML deviceCapabilitiesXml = this.getDeviceCapabilities();
            DeviceCapabilityEntry entry = deviceCapabilitiesXml.getEntryByTagName("DEVICE_TYPE");
            this.isEncoder = entry != null && entry.getValueInteger() == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this.isEncoder;
    }

    public Boolean isSupportingIndividualStreamCapabilities() {
        if (this.supportsIndividualStreamCapabilities == null) {
            try {
                DeviceCapabilitiesXML deviceCapablities = this.getDeviceCapabilities();
                DeviceCapabilityEntry entry = deviceCapablities.getEntryByTagName("INDIVIDUAL_ENCODER_OPERATION_MODE_CONFIG");
                this.supportsIndividualStreamCapabilities = entry != null && entry.getValueBoolean() != false;
            }
            catch (Exception ex) {
                this.supportsIndividualStreamCapabilities = false;
            }
        }
        return this.supportsIndividualStreamCapabilities;
    }

    protected Integer getNumberOfCameras() {
        if (this.numberOfCameras == null) {
            try {
                this.numberOfCameras = this.getDeviceCapabilities().getEntryByNumber(5).getValueInteger();
            }
            catch (Exception ex) {
                this.logger.warn("Exception while reading number of video sources. Assuming 1 for " + this);
            }
            if (this.numberOfCameras == null || this.numberOfCameras < 1) {
                this.numberOfCameras = 1;
            }
        }
        return this.numberOfCameras;
    }

    public final boolean useSingleJpegImages() {
        long deviceType = this.getDeviceType();
        return deviceType == 201700L || deviceType == 201709L || deviceType == 201710L || deviceType == 201712L || deviceType == 201711L || deviceType == 201701L || deviceType == 201702L || deviceType == 201703L || deviceType == 201713L || deviceType == 201704L || deviceType == 201705L || deviceType == 201706L || deviceType == 201707L || deviceType == 201708L || deviceType == 201714L;
    }

    public Document getHttpResponseAsXml(String httpCommand) throws SeeTecException, JDOMException, Exception {
        Element err;
        Element res;
        String xmlString;
        ByteArrayInputStream bais;
        Document xmlDoc;
        Element root;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Send command: " + httpCommand);
        }
        if ((root = (xmlDoc = new SAXBuilder().build((InputStream)(bais = new ByteArrayInputStream((xmlString = this.getHttpHandler().readGetRequest(httpCommand)).getBytes())))).getRootElement()) != null && (res = root.getChild("result")) != null && (err = res.getChild("err")) != null) {
            throw new Exception("Result of XML contains error: " + err.getText());
        }
        return xmlDoc;
    }

    public static final int checkDeviceInfos(long type, String host, int port, boolean useAuthorization, String user, String pass, int timeout) {
        String[] stringArray;
        int errorCode = 0;
        if (useAuthorization) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = user;
            stringArray = stringArray2;
            stringArray2[1] = pass;
        } else {
            stringArray = null;
        }
        NetworkParameter networkParameter = NetworkParameterFactory.createNetworkParameter((String)host, (int)1756, (boolean)false, (int)-1, (int)timeout, stringArray);
        BoschSyncRCPCall boschSyncRCPCall = new BoschSyncRCPCall();
        errorCode = boschSyncRCPCall.init(networkParameter);
        if (errorCode != 0) {
            errorCode = errorCode == -21699 ? -21697 : errorCode;
            return errorCode;
        }
        CoderList reqCoder = new CoderList();
        reqCoder.setRead();
        reqCoder.setNumericDescriptorAsInt(1);
        reqCoder.setActionRequest();
        CoderListRsp rspCoder = null;
        Packet packet = boschSyncRCPCall.sendRCPDataPacket(reqCoder);
        if (packet instanceof CoderListRsp) {
            rspCoder = (CoderListRsp)packet;
        }
        if (rspCoder == null) {
            return -21699;
        }
        if (networkParameter.getUserPWD() != null && !BoschUser.isUserExisting(networkParameter.getUserPWD()[0])) {
            return -21701;
        }
        ClientRegistrationReq reqReg = new ClientRegistrationReq();
        reqReg.setPass(BoschCameraSrv.createPassphrase(networkParameter));
        reqReg.setNumericDescriptorAsInt(1);
        ClientRegistrationRsp rsp = null;
        Packet response = boschSyncRCPCall.sendRCPDataPacket(reqReg);
        if (response instanceof ClientRegistrationRsp) {
            rsp = (ClientRegistrationRsp)response;
        }
        if (rsp == null) {
            errorCode = -21697;
        } else if (rsp.registerFailed()) {
            errorCode = -21701;
        }
        return errorCode;
    }

    @Override
    public String getFirmwareVersion() {
        SoftwareVersionXML softwareVersionXml = new SoftwareVersionXML();
        try {
            softwareVersionXml.send(this, Direction.READ);
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading Firmware version");
            return "<unknown>";
        }
        return softwareVersionXml.getFirmware();
    }

    @Override
    protected IOHandler createIOHandler() {
        return new BoschIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        DeviceDefinition deviceDefinition = new DeviceDefinition();
        try {
            CommercialTypeNumberXML commercialTypeNumberXml = new CommercialTypeNumberXML();
            commercialTypeNumberXml.send(this, Direction.READ);
            ProductNameXML productNameXml = new ProductNameXML();
            productNameXml.send(this, Direction.READ);
            VariantIdXML variantIdXml = new VariantIdXML();
            variantIdXml.send(this, Direction.READ);
            PtzControlerAvailableXML ptzControlerAvailable = new PtzControlerAvailableXML();
            ptzControlerAvailable.send(this, Direction.READ);
            DptzStaticCapsXML dptzStaticCaps = new DptzStaticCapsXML();
            dptzStaticCaps.send(this, Direction.READ);
            boolean bicomAvailable = dptzStaticCaps.supportsBicom(1);
            String currentSignature = this.getFirmwareVersion();
            String currentManufacturer = "Bosch Smart Driver (Firmware 6.30 or higher)";
            String currentName = productNameXml.getProductName() + " " + commercialTypeNumberXml.getCommercialTypeNumber();
            String currentComments = "RE_APP_VERSION::7.1.1_23";
            if (!(signature != null && signature.equals(currentSignature) && manufacturer != null && manufacturer.equals("Bosch Smart Driver (Firmware 6.30 or higher)") && name != null && name.equals(currentName) && comments != null && comments.equals("RE_APP_VERSION::7.1.1_23") && Integer.toString(variantIdXml.getVariantId()).equals(this.getCurrentCaptureModeFromDefinition()))) {
                int[] speeds;
                List<OperationMode> operationModes;
                int totalNumberOfStreams;
                CapabilityListXML capabilityList = new CapabilityListXML();
                capabilityList.send(this, Direction.READ);
                deviceDefinition.setName(currentName);
                deviceDefinition.setAudioCapabilities(this.getAudioCapabilitiesType(capabilityList));
                deviceDefinition.setSupportedGenericEvents(this.getGenericEventTrigger());
                deviceDefinition.setAvailableIOs(this.getAvailableIOsType(capabilityList));
                deviceDefinition.setCountFirstChannelOnly(true);
                deviceDefinition.setDefaultApiVersion("RCP+ (Rev. 6.3)");
                deviceDefinition.setDefaultCaptureModeIndex(0);
                deviceDefinition.setDefaultMediaID(MediaID.VIDEO_SERVER_DIGITAL.getType());
                DeviceGroupMembershipsType deviceGroupMembershipsType = new DeviceGroupMembershipsType();
                if (bicomAvailable) {
                    deviceGroupMembershipsType.getDeviceGroups().add("OpticalZoomAreaSupported");
                }
                deviceGroupMembershipsType.getDeviceGroups().add("EdgeStorage");
                deviceGroupMembershipsType.getDeviceGroups().add("EdgeStorageVideoImport");
                deviceGroupMembershipsType.getDeviceGroups().add("GenericDriver");
                deviceGroupMembershipsType.getDeviceGroups().add("GenericEventTrigger");
                deviceGroupMembershipsType.getDeviceGroups().add("MotionDetectionInStream");
                deviceGroupMembershipsType.getDeviceGroups().add("MultistreamResolutionCombinationWarning");
                deviceGroupMembershipsType.getDeviceGroups().add("PresetsImportable");
                deviceGroupMembershipsType.getDeviceGroups().add("CameraAdministrationModifyPassword");
                deviceGroupMembershipsType.getDeviceGroups().add("CameraAdministrationUpgradeFirmware");
                deviceGroupMembershipsType.getDeviceGroups().add("ConfigurableVideoStreamNetworkTimeout");
                deviceDefinition.setDeviceGroupMemberships(deviceGroupMembershipsType);
                CommentsType commentsType = new CommentsType();
                commentsType.getString().add("RE_APP_VERSION::7.1.1_23");
                deviceDefinition.setComments(commentsType);
                deviceDefinition.setDeviceNetworkDefinition(this.getDeviceNetworkDefinition());
                deviceDefinition.setImageRotationCapabilities(this.getimageRotationCapabilities(bicomAvailable));
                if (this.getDeviceType() == 200657L) {
                    deviceDefinition.setManufacturer("Sony Smart Driver (Generation X)");
                } else {
                    deviceDefinition.setManufacturer("Bosch Smart Driver (Firmware 6.30 or higher)");
                }
                MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = new MiscVideoServerCapabilitiesType();
                miscVideoServerCapabilitiesType.setCanPTZ(true);
                miscVideoServerCapabilitiesType.setCanTimeDate(this.getNumberOfCameras() == 1);
                miscVideoServerCapabilitiesType.setCanTitle(true);
                miscVideoServerCapabilitiesType.setCanTimeshift(false);
                miscVideoServerCapabilitiesType.setNoOfRS232S(capabilityList.getNumberOfRS232());
                miscVideoServerCapabilitiesType.setPTZSpeedMultiplier(100);
                deviceDefinition.setMiscVideoServerCapabilities(miscVideoServerCapabilitiesType);
                deviceDefinition.setNoOfCams(this.getNumberOfCameras());
                SupportedVideoSourceEntityTypesType supportedVideoSourceEntityTypesType = new SupportedVideoSourceEntityTypesType();
                supportedVideoSourceEntityTypesType.getLong().add(211735L);
                deviceDefinition.setSupportedVideoSourceEntityTypes(supportedVideoSourceEntityTypesType);
                deviceDefinition.setSignature(this.getFirmwareVersion());
                SupportedApiVersionsType supportedApiVersionsType = new SupportedApiVersionsType();
                supportedApiVersionsType.getString().add("6.30");
                deviceDefinition.setSupportedApiVersions(supportedApiVersionsType);
                H264EncBaseOperationModeCapsXML h264EncBaseOperationModeCaps = new H264EncBaseOperationModeCapsXML();
                try {
                    h264EncBaseOperationModeCaps.send(this, Direction.READ);
                }
                catch (Exception ex) {
                    this.logger.warn("H264EncBaseOperationModeCapsXML not supported for " + this);
                }
                int numberOfH264Streams = 0;
                int numberOfH265Streams = 0;
                int numberOfMjpegStreams = 0;
                if (this.isSupportingIndividualStreamCapabilities().booleanValue()) {
                    OperationMode operationMode = h264EncBaseOperationModeCaps.getOperationModes().get(0);
                    totalNumberOfStreams = operationMode.getNumberOfStreams();
                    for (int i = 1; i <= totalNumberOfStreams; ++i) {
                        CoderVideoOperationModeOptions coderVideoOperationModeOptions = new CoderVideoOperationModeOptions();
                        coderVideoOperationModeOptions.setStreamNumber(i);
                        coderVideoOperationModeOptions.send(this, Direction.READ);
                        List<Codec> codecList = coderVideoOperationModeOptions.getCodecList();
                        if (codecList.contains(Codec.H264)) {
                            ++numberOfH264Streams;
                        }
                        if (codecList.contains(Codec.H265)) {
                            ++numberOfH265Streams;
                        }
                        if (!codecList.contains(Codec.MJPEG)) continue;
                        ++numberOfMjpegStreams;
                    }
                } else {
                    if (capabilityList.isH264Supported()) {
                        numberOfH264Streams = 2;
                    }
                    if (capabilityList.isH265Supported()) {
                        numberOfH265Streams = 2;
                    }
                    numberOfMjpegStreams = 1;
                    totalNumberOfStreams = Math.max(numberOfH264Streams, numberOfH265Streams) + numberOfMjpegStreams;
                }
                if ((operationModes = h264EncBaseOperationModeCaps.getOperationModes()).size() == 1 && operationModes.get(0).getResolution(2) != null && operationModes.get(0).getResolution(2).getName().equals("copy other stream")) {
                    numberOfH264Streams = 1;
                    numberOfH265Streams = numberOfH265Streams == 0 ? 0 : 1;
                }
                SupportedCaptureModesType supportedCaptureModesType = new SupportedCaptureModesType();
                CaptureModeDefinitionType captureModeDefinitionType = new CaptureModeDefinitionType();
                captureModeDefinitionType.setDefaultStreamDefinitionIndex(0);
                captureModeDefinitionType.setMaxTotalNumberOfStreams(totalNumberOfStreams);
                captureModeDefinitionType.setModeSuffix(Integer.toString(variantIdXml.getVariantId()));
                if (this.isSupportingIndividualStreamCapabilities().booleanValue()) {
                    captureModeDefinitionType.setMultiStreamingDefinitions(this.getMultiStreamingDefinitionsTypeIndividualCodecs(totalNumberOfStreams));
                } else {
                    captureModeDefinitionType.setMultiStreamingDefinitions(this.getMultiStreamingDefinitionsTypeGlobalCodec(h264EncBaseOperationModeCaps, capabilityList, numberOfH264Streams, numberOfH265Streams));
                }
                supportedCaptureModesType.getCaptureModeDefinition().add(captureModeDefinitionType);
                deviceDefinition.setSupportedCaptureModes(supportedCaptureModesType);
                deviceDefinition.setEntityType(201748L);
                SupportedEdgeStoragePlaybackSpeedsType supportedEdgeStoragePlaybackSpeedsType = new SupportedEdgeStoragePlaybackSpeedsType();
                for (int speed : speeds = new int[]{1, 2, 4, 8, 16, 20}) {
                    EdgeStoragePlaybackSpeedType edgeStoragePlaybackSpeedType = new EdgeStoragePlaybackSpeedType();
                    edgeStoragePlaybackSpeedType.setSpeedValue(speed);
                    edgeStoragePlaybackSpeedType.setSpeedName(speed + "x");
                    supportedEdgeStoragePlaybackSpeedsType.getEdgeStoragePlaybackSpeed().add(0, edgeStoragePlaybackSpeedType);
                }
                deviceDefinition.setSupportedEdgeStoragePlaybackSpeeds(supportedEdgeStoragePlaybackSpeedsType);
                return deviceDefinition;
            }
            return null;
        }
        catch (SeeTecException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading device capabilities: " + ex.getMessage());
            return null;
        }
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        try {
            PtzControlerAvailableXML ptzControlerAvailable = new PtzControlerAvailableXML();
            ptzControlerAvailable.send(this, Direction.READ);
            DptzStaticCapsXML dptzStaticCaps = new DptzStaticCapsXML();
            dptzStaticCaps.send(this, Direction.READ);
            boolean bicomAvailable = dptzStaticCaps.supportsBicom(1);
            VideoCameraDefinition videoCameraDefinition = new VideoCameraDefinition();
            videoCameraDefinition.setManufacturer("Bosch");
            videoCameraDefinition.setComment("");
            videoCameraDefinition.setDefaultMediaID(MediaID.VIDEO_SOURCE_PTZ.getType());
            videoCameraDefinition.setName("");
            videoCameraDefinition.setEntityType(211735L);
            videoCameraDefinition.setPreferAbsolutePTZ(false);
            DeviceCapabilitiesXML deviceCapabilitiesXml = new DeviceCapabilitiesXML();
            deviceCapabilitiesXml.send(this, Direction.READ);
            DeviceCapabilityEntry isPTZsupported = deviceCapabilitiesXml.getEntryByNumber(2);
            FeaturesType featuresType = new FeaturesType();
            if (isPTZsupported.getValueBoolean().booleanValue()) {
                featuresType.setCanAbsolutePan(false);
                featuresType.setCanAbsoluteTilt(false);
                featuresType.setCanAbsoluteZoom(true);
                featuresType.setCanContinuousPan(true);
                featuresType.setCanContinuousTilt(true);
                featuresType.setCanContinuousZoom(true);
                featuresType.setCanRelativePan(false);
                featuresType.setCanRelativeTilt(false);
                featuresType.setCanRelativeZoom(false);
                featuresType.setCanFocus(true);
                featuresType.setCanAutoFocus(true);
                featuresType.setCanIris(true);
                featuresType.setCanAutoIris(true);
                featuresType.setCanNullLux(true);
                featuresType.setCanAutoNullLux(false);
                featuresType.setCanPreset(true);
                featuresType.setMinPan(-180000);
                featuresType.setMaxPan(180000);
                featuresType.setMinTilt(0);
                featuresType.setMaxTilt(90000);
                featuresType.setMinAbsoluteZoom(0);
                int zoom = 0;
                if (bicomAvailable) {
                    BicomOverRCPQuery zoomQuery = BicomOverRCPQuery.getMaxZoom();
                    zoomQuery.send(this);
                    String zoomString = zoomQuery.getResultAsString();
                    zoom = zoomString.isEmpty() ? 8191 : Integer.parseInt(zoomString, 16);
                } else {
                    zoom = 8191;
                }
                featuresType.setMaxAbsoluteZoom(zoom);
                featuresType.setMinZoom(0);
                featuresType.setMaxZoom(100000);
                featuresType.setMinSpeed(0);
                featuresType.setMaxSpeed(100000);
                featuresType.setPTZMinContinuousLevel(10000);
                featuresType.setPTZMaxContinuousLevel(100000);
                featuresType.setPTZContinuousSpeedFactor(1000);
                featuresType.setCanCenterPT(bicomAvailable);
            }
            videoCameraDefinition.setFeatures(featuresType);
            return videoCameraDefinition;
        }
        catch (Exception exception) {
            this.logger.warn("Error while reading information from " + this);
            throw new SeeTecException(-21600, exception.getMessage());
        }
    }

    protected String getCurrentCaptureModeFromDefinition() {
        String foundDisplayResolutionInDefinition = null;
        try {
            List<CaptureModeDefinitionType> list = this.getDeviceDefinitionFromConfiguration().getSupportedCaptureModes().getCaptureModeDefinition();
            if (!list.isEmpty()) {
                foundDisplayResolutionInDefinition = list.get(0).getModeSuffix();
            }
        }
        catch (Exception e) {
            this.logger.warn("Could not find out currently set capture mode.");
            foundDisplayResolutionInDefinition = null;
        }
        return foundDisplayResolutionInDefinition;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() {
        DeviceCapabilitiesXML deviceCapabilitiesXml = new DeviceCapabilitiesXML();
        try {
            deviceCapabilitiesXml.send(this, Direction.READ);
        }
        catch (Exception ex) {
            return null;
        }
        SupportedGenericEventsType supportedGenericEventsType = new SupportedGenericEventsType();
        for (int i = 1; i <= this.getNumberOfCameras(); ++i) {
            AlarmOverviewXML alarmOverviewXML = new AlarmOverviewXML();
            alarmOverviewXML.setNum(i);
            try {
                alarmOverviewXML.send(this, Direction.READ);
            }
            catch (Exception ex) {
                this.logger.error("Exception while reading event triggers for " + this + ": " + ex.getMessage());
                return null;
            }
            List<AlarmEntry> alarmEntries = alarmOverviewXML.getAlarmEntries();
            for (AlarmEntry alarmEntry : alarmEntries) {
                GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
                genericEventDefinitionType.setEventType(alarmEntry.getAlarmName());
                if (this.isDeviceBasedAlarm(alarmEntry.getAlarmSource().getAlarmSourceNumber())) {
                    if (this.containsAlarm(supportedGenericEventsType.getGenericEventDefinition(), alarmEntry)) continue;
                    genericEventDefinitionType.setSourceNumber(0);
                    supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
                    continue;
                }
                genericEventDefinitionType.setSourceNumber(i);
                supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
            }
        }
        return supportedGenericEventsType;
    }

    protected boolean supportsBicomImageRotation() {
        String payload = "0x850006011A01";
        BicomCommandXML bicomCommandXML = new BicomCommandXML();
        bicomCommandXML.setPayload(payload);
        try {
            bicomCommandXML.send(this, Direction.WRITE);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    protected boolean canConfigureJpeg() {
        if (this.isSupportingIndividualStreamCapabilities().booleanValue()) {
            return true;
        }
        JpegStreamSetupXML jpegStreamSetup = new JpegStreamSetupXML();
        jpegStreamSetup.setNum(1);
        try {
            jpegStreamSetup.send(this, Direction.READ);
            String payload = jpegStreamSetup.getResultAsString().replace(" ", "");
            int resolutionOnDevice = jpegStreamSetup.getResolution();
            JpegStreamSetupOptionsVerboseXML jpegStreamSetupOptionsVerboseXML = new JpegStreamSetupOptionsVerboseXML();
            jpegStreamSetupOptionsVerboseXML.send(this, Direction.READ);
            List<Resolution> possibleResolutions = jpegStreamSetupOptionsVerboseXML.getResolutions();
            jpegStreamSetup.setPayload(payload);
            if (!BoschDevice.listContainsResolution(possibleResolutions, resolutionOnDevice) && possibleResolutions.size() > 0) {
                jpegStreamSetup.setResolution(possibleResolutions.get(0).getId());
            }
            jpegStreamSetup.send(this, Direction.WRITE);
            jpegStreamSetup.getResultAsByteArray();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean isFirmwareVersionEqualOrHigher(SoftwareVersionXML softwareVersionXml, int major, int minor, int build) {
        try {
            if (major > Integer.parseInt(softwareVersionXml.getMajor())) {
                return false;
            }
            if (major < Integer.parseInt(softwareVersionXml.getMajor())) {
                return true;
            }
            if (minor > Integer.parseInt(softwareVersionXml.getMinor())) {
                return false;
            }
            if (minor < Integer.parseInt(softwareVersionXml.getMinor())) {
                return true;
            }
            return build <= Integer.parseInt(softwareVersionXml.getBuild());
        }
        catch (Exception ex) {
            this.logger.error("Exception while evaluating Firmware version: " + ex.getMessage());
            return false;
        }
    }

    public AudioCapabilitiesType getAudioCapabilitiesType(CapabilityListXML capabilityList) {
        AudioCapabilitiesType audioCapabilitiesType = new AudioCapabilitiesType();
        AudioCodecsType audioCodecsType = new AudioCodecsType();
        List<Codec> audioCodecList = capabilityList.getAudioCodecList();
        for (int i = 0; i < audioCodecList.size(); ++i) {
            Codec c = audioCodecList.get(i);
            AudioCodecDefinitionType audioCodecDefinitionType = new AudioCodecDefinitionType();
            CodecType codecType = new CodecType();
            codecType.setValue(c.getType());
            audioCodecDefinitionType.setAudioCodec(codecType);
            audioCodecDefinitionType.setBitrate(64000);
            audioCodecsType.getAudioCodecDefinition().add(audioCodecDefinitionType);
            if (!capabilityList.isSupportsAudioOut()) continue;
            audioCapabilitiesType.setCanAudioOut(true);
        }
        if (audioCodecsType.getAudioCodecDefinition().isEmpty()) {
            audioCapabilitiesType.setAudioCodecs(null);
            audioCapabilitiesType.setCanAudio(false);
            audioCapabilitiesType.setNumberOfPossibleAudioStreams(0);
        } else {
            audioCapabilitiesType.setAudioCodecs(audioCodecsType);
            audioCapabilitiesType.setCanAudio(true);
            audioCapabilitiesType.setDefaultAudioCodecIndex(0);
            audioCapabilitiesType.setNumberOfPossibleAudioStreams(1);
        }
        return audioCapabilitiesType;
    }

    public AvailableIOsType getAvailableIOsType(CapabilityListXML capabilityList) {
        int i;
        AvailableIOsType availableIOsType = new AvailableIOsType();
        for (i = 0; i < capabilityList.getNumberOfInputs(); ++i) {
            availableIOsType.getInputOutputCapabilities().add(0);
        }
        for (i = 0; i < capabilityList.getNumberOfOutputs(); ++i) {
            availableIOsType.getInputOutputCapabilities().add(1);
        }
        return availableIOsType;
    }

    public int getBoschLegacyTimeout() {
        return this.boschLegacyTimeout;
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Mentionned hard-coded password is just Bosch default pass which is a proper default setting in this case.")
    private DeviceNetworkDefinitionType getDeviceNetworkDefinition() {
        DeviceNetworkDefinitionType deviceNetworkDefinition = new DeviceNetworkDefinitionType();
        deviceNetworkDefinition.setCanChangeHttpPort(true);
        deviceNetworkDefinition.setCanHttps(true);
        deviceNetworkDefinition.setCanChangeHttpsPort(true);
        deviceNetworkDefinition.setDefaultHttpPort(80);
        deviceNetworkDefinition.setDefaultHttpsPort(443);
        deviceNetworkDefinition.setDefaultPassword("");
        deviceNetworkDefinition.setDefaultUserName("service");
        deviceNetworkDefinition.setUseAuthentication(true);
        deviceNetworkDefinition.setMinVideoStreamNetworkTimeout(5000L);
        deviceNetworkDefinition.setMaxVideoStreamNetworkTimeout(20000L);
        deviceNetworkDefinition.setDefaultVideoStreamNetworkTimeout(10000L);
        return deviceNetworkDefinition;
    }

    private ImageRotationCapabilitiesType getimageRotationCapabilities(boolean bicomAvailable) {
        VideoInputFormatExVerboseXML videoInputFormatExVerboseXML = new VideoInputFormatExVerboseXML();
        boolean canRotate = false;
        ImageRotationCapabilitiesType imageRotationCapabilitiesType = new ImageRotationCapabilitiesType();
        try {
            videoInputFormatExVerboseXML.send(this, Direction.READ);
            boolean bl = canRotate = videoInputFormatExVerboseXML.isRotation90() || videoInputFormatExVerboseXML.isRotation180() || videoInputFormatExVerboseXML.isRotation270();
            if (canRotate) {
                imageRotationCapabilitiesType.setCanRotateJPEGImage(canRotate);
                imageRotationCapabilitiesType.setCanRotateMPEGImage(canRotate);
                SupportedRotationAnglesType supportedRotationAnglesType = new SupportedRotationAnglesType();
                supportedRotationAnglesType.getInt().add(0);
                if (videoInputFormatExVerboseXML.isRotation90()) {
                    supportedRotationAnglesType.getInt().add(90000);
                }
                if (videoInputFormatExVerboseXML.isRotation180()) {
                    supportedRotationAnglesType.getInt().add(180000);
                }
                if (videoInputFormatExVerboseXML.isRotation270()) {
                    supportedRotationAnglesType.getInt().add(270000);
                }
                imageRotationCapabilitiesType.setSupportedRotationAngles(supportedRotationAnglesType);
                return imageRotationCapabilitiesType;
            }
        }
        catch (Exception ex) {
            this.logger.error("Command for reading video input not supported ");
        }
        if (!canRotate && bicomAvailable && this.supportsBicomImageRotation()) {
            imageRotationCapabilitiesType.setCanRotateJPEGImage(true);
            imageRotationCapabilitiesType.setCanRotateMPEGImage(true);
        } else {
            imageRotationCapabilitiesType.setCanRotateJPEGImage(false);
            imageRotationCapabilitiesType.setCanRotateMPEGImage(false);
        }
        SupportedRotationAnglesType supportedRotationAnglesType = new SupportedRotationAnglesType();
        supportedRotationAnglesType.getInt().add(0);
        supportedRotationAnglesType.getInt().add(180000);
        imageRotationCapabilitiesType.setSupportedRotationAngles(supportedRotationAnglesType);
        return imageRotationCapabilitiesType;
    }

    private MultiStreamingDefinitionsType getMultiStreamingDefinitionsTypeIndividualCodecs(int totalNumberOfStreams) throws Exception {
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = new MultiStreamingDefinitionsType();
        ConfMpeg4AvcBitrateOptimizationOptionsXml confMpeg4AvcBitrateOptimizationOptionsXml = new ConfMpeg4AvcBitrateOptimizationOptionsXml();
        confMpeg4AvcBitrateOptimizationOptionsXml.send(this, Direction.READ);
        boolean isBitrateOptimizationSupported = confMpeg4AvcBitrateOptimizationOptionsXml.getBitrateOptimizationOptions();
        BitrateSettingsType bitrateSettingsType = new BitrateSettingsType();
        bitrateSettingsType.setCanCBR(true);
        bitrateSettingsType.setCanCBRQuality(false);
        bitrateSettingsType.setCanVBR(true);
        bitrateSettingsType.setCanVBRQuality(isBitrateOptimizationSupported);
        bitrateSettingsType.setMaxBandwidth(51200000);
        bitrateSettingsType.setMinBandwidth(1024);
        bitrateSettingsType.setSupportedBitrates(null);
        RtspSettingsType rtspSettingsType = new RtspSettingsType();
        rtspSettingsType.setCanChangeRtspPort(true);
        rtspSettingsType.setCanMultipleRtspPorts(false);
        rtspSettingsType.setDefaultRtspPort(554);
        SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_MULTICAST.getType());
        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST.getType());
        BaseFramerateXML baseFramerate = new BaseFramerateXML();
        baseFramerate.send(this, Direction.READ);
        int basefpsThousands = Math.round((float)baseFramerate.getFramerate() / 1000.0f);
        int basefps = basefpsThousands * 1000;
        if (basefps == 0) {
            basefps = 25000;
            this.logger.warn("Could not read base framerate. Using 25fps for " + this);
        }
        for (int i = 1; i <= totalNumberOfStreams; ++i) {
            CoderVideoOperationModeOptions coderVideoOperationModeOptions = new CoderVideoOperationModeOptions();
            coderVideoOperationModeOptions.setStreamNumber(i);
            coderVideoOperationModeOptions.send(this, Direction.READ);
            List<Codec> codecList = coderVideoOperationModeOptions.getCodecList();
            for (Codec codec : codecList) {
                StreamDefinitionType streamDefinitionType = new StreamDefinitionType();
                SupportedCameraResolutionsType supportedCameraResolutionsType = new SupportedCameraResolutionsType();
                ConfEncProfileResolutionOptionsXML confEncProfileResolutionOptionsXml = new ConfEncProfileResolutionOptionsXML();
                confEncProfileResolutionOptionsXml.send(this, Direction.READ);
                List<Resolution> resolutions = confEncProfileResolutionOptionsXml.getResolutionList(i);
                for (Resolution resolution : resolutions) {
                    CameraResolutionType cameraResolutionType = new CameraResolutionType();
                    cameraResolutionType.setDisplayResolution(resolution.getResolutionName());
                    cameraResolutionType.setHeight(resolution.getHeight());
                    cameraResolutionType.setWidth(resolution.getWidth());
                    cameraResolutionType.setMaxMilliFPS(basefps);
                    cameraResolutionType.setMinMilliFPS(1000);
                    supportedCameraResolutionsType.getCameraResolution().add(cameraResolutionType);
                }
                streamDefinitionType.setSupportedCameraResolutions(supportedCameraResolutionsType);
                streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                streamDefinitionType.setDefaultCameraResolutionIndex(0);
                streamDefinitionType.setDefaultMilliFPS(5000);
                streamDefinitionType.setDefaultTransmissionTypeIndex(0);
                streamDefinitionType.setHideBandwithField(false);
                streamDefinitionType.setHideFPSField(false);
                streamDefinitionType.setRtspSettings(rtspSettingsType);
                streamDefinitionType.setMaxNumberOfStreams(1);
                streamDefinitionType.setNoOfHWMDInputs(1);
                if (codec.equals((Object)Codec.H264)) {
                    streamDefinitionType.setName("H.264 (" + i + ")");
                    streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                    streamDefinitionType.setMinIFrameDistance(100);
                    streamDefinitionType.setMaxIFrameDistance(100000);
                    streamDefinitionType.setHideIFrameField(false);
                    streamDefinitionType.setHideKompressionField(false);
                    streamDefinitionType.setEncodingIntervalMin(3);
                    streamDefinitionType.setEncodingIntervalMax(60);
                    CodecType videoCodecTypeH264 = new CodecType();
                    videoCodecTypeH264.setValue(Codec.H264.getType());
                    streamDefinitionType.setStreamingMode(videoCodecTypeH264);
                } else if (codec.equals((Object)Codec.H265)) {
                    streamDefinitionType.setName("H.265 (" + i + ")");
                    streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                    streamDefinitionType.setMinIFrameDistance(100);
                    streamDefinitionType.setMaxIFrameDistance(100000);
                    streamDefinitionType.setHideIFrameField(false);
                    streamDefinitionType.setHideKompressionField(false);
                    streamDefinitionType.setEncodingIntervalMin(3);
                    streamDefinitionType.setEncodingIntervalMax(60);
                    CodecType videoCodecTypeH265 = new CodecType();
                    videoCodecTypeH265.setValue(Codec.H265.getType());
                    streamDefinitionType.setStreamingMode(videoCodecTypeH265);
                } else if (codec.equals((Object)Codec.MJPEG)) {
                    try {
                        streamDefinitionType.setName("MJPEG (" + i + ")");
                        CodecType codecType = new CodecType();
                        codecType.setValue(Codec.MJPEG.getType());
                        streamDefinitionType.setStreamingMode(codecType);
                        bitrateSettingsType = new BitrateSettingsType();
                        bitrateSettingsType.setCanCBR(true);
                        bitrateSettingsType.setCanCBRQuality(false);
                        bitrateSettingsType.setCanVBR(false);
                        bitrateSettingsType.setCanVBRQuality(false);
                        bitrateSettingsType.setMaxBandwidth(51200000);
                        bitrateSettingsType.setMinBandwidth(1024);
                        bitrateSettingsType.setSupportedBitrates(null);
                        streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                        streamDefinitionType.setHideIFrameField(true);
                        streamDefinitionType.setHideKompressionField(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionType);
            }
        }
        return multiStreamingDefinitionsType;
    }

    private MultiStreamingDefinitionsType getMultiStreamingDefinitionsTypeGlobalCodec(H264EncBaseOperationModeCapsXML h264EncBaseOperationModeCaps, CapabilityListXML capabilityList, int numberOfH264Streams, int numberOfH265Streams) throws Exception {
        List<CameraResolutionType> cameraResolutions;
        CameraResolutionType cameraResolutionType;
        Enum resolution;
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = new MultiStreamingDefinitionsType();
        ConfMpeg4AvcBitrateOptimizationOptionsXml confMpeg4AvcBitrateOptimizationOptionsXml = new ConfMpeg4AvcBitrateOptimizationOptionsXml();
        confMpeg4AvcBitrateOptimizationOptionsXml.send(this, Direction.READ);
        boolean isBitrateOptimizationSupported = confMpeg4AvcBitrateOptimizationOptionsXml.getBitrateOptimizationOptions();
        StreamDefinitionType streamDefinitionTypeStream1 = new StreamDefinitionType();
        BitrateSettingsType bitrateSettingsType = new BitrateSettingsType();
        bitrateSettingsType.setCanCBR(true);
        bitrateSettingsType.setCanCBRQuality(false);
        bitrateSettingsType.setCanVBR(true);
        bitrateSettingsType.setCanVBRQuality(isBitrateOptimizationSupported);
        bitrateSettingsType.setMaxBandwidth(51200000);
        bitrateSettingsType.setMinBandwidth(1024);
        bitrateSettingsType.setSupportedBitrates(null);
        RtspSettingsType rtspSettingsType = new RtspSettingsType();
        rtspSettingsType.setCanChangeRtspPort(true);
        rtspSettingsType.setCanMultipleRtspPorts(false);
        rtspSettingsType.setDefaultRtspPort(554);
        CodecType videoCodecTypeH264 = new CodecType();
        videoCodecTypeH264.setValue(Codec.H264.getType());
        CodecType videoCodecTypeH265 = new CodecType();
        videoCodecTypeH265.setValue(Codec.H265.getType());
        SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_MULTICAST.getType());
        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST.getType());
        BaseFramerateXML baseFramerate = new BaseFramerateXML();
        baseFramerate.send(this, Direction.READ);
        int basefpsThousands = Math.round((float)baseFramerate.getFramerate() / 1000.0f);
        int basefps = basefpsThousands * 1000;
        if (basefps == 0) {
            basefps = 25000;
            this.logger.warn("Could not read base framerate. Using 25fps for " + this);
        }
        if (numberOfH264Streams > 0) {
            List<CameraResolutionType> cameraResolutions2;
            CameraResolutionType cameraResolutionType2;
            Enum resolution2;
            int i;
            streamDefinitionTypeStream1.setName("H.264 (1)");
            streamDefinitionTypeStream1.setBitrateSettings(bitrateSettingsType);
            streamDefinitionTypeStream1.setDefaultCameraResolutionIndex(0);
            streamDefinitionTypeStream1.setDefaultMilliFPS(5000);
            streamDefinitionTypeStream1.setDefaultTransmissionTypeIndex(0);
            streamDefinitionTypeStream1.setMinIFrameDistance(100);
            streamDefinitionTypeStream1.setMaxIFrameDistance(100000);
            streamDefinitionTypeStream1.setHideBandwithField(false);
            streamDefinitionTypeStream1.setHideFPSField(false);
            streamDefinitionTypeStream1.setHideIFrameField(false);
            streamDefinitionTypeStream1.setHideKompressionField(false);
            streamDefinitionTypeStream1.setMaxNumberOfStreams(1);
            streamDefinitionTypeStream1.setNoOfHWMDInputs(1);
            streamDefinitionTypeStream1.setEncodingIntervalMin(3);
            streamDefinitionTypeStream1.setEncodingIntervalMax(60);
            streamDefinitionTypeStream1.setRtspSettings(rtspSettingsType);
            streamDefinitionTypeStream1.setStreamingMode(videoCodecTypeH264);
            SupportedCameraResolutionsType supportedCameraResolutionsTypeStream1 = new SupportedCameraResolutionsType();
            for (i = 0; i < h264EncBaseOperationModeCaps.getResolutions(1).size(); ++i) {
                resolution2 = h264EncBaseOperationModeCaps.getResolutions(1).get(i);
                if (resolution2 == null || ((BoschResolution)resolution2).getWidth() <= 0 || ((BoschResolution)resolution2).getHeight() <= 0) continue;
                cameraResolutionType2 = new CameraResolutionType();
                cameraResolutionType2.setDisplayResolution(((BoschResolution)resolution2).getName());
                cameraResolutionType2.setHeight(((BoschResolution)resolution2).getHeight());
                cameraResolutionType2.setWidth(((BoschResolution)resolution2).getWidth());
                cameraResolutionType2.setMaxMilliFPS(basefps);
                cameraResolutionType2.setMinMilliFPS(1);
                cameraResolutions2 = supportedCameraResolutionsTypeStream1.getCameraResolution();
                if (PacketXML.containsResolution(cameraResolutions2, cameraResolutionType2)) continue;
                supportedCameraResolutionsTypeStream1.getCameraResolution().add(cameraResolutionType2);
            }
            if (h264EncBaseOperationModeCaps.getResolutions(1).isEmpty() || BoschDevice.containsSDResolution(h264EncBaseOperationModeCaps.getResolutions(1))) {
                for (i = 0; i < capabilityList.getResolutionList().size(); ++i) {
                    resolution2 = capabilityList.getResolutionList().get(i);
                    if (resolution2 == null || ((ResolutionMappingSD_JPG)resolution2).getWidth() <= 0 || ((ResolutionMappingSD_JPG)resolution2).getHeight() <= 0) continue;
                    cameraResolutionType2 = new CameraResolutionType();
                    cameraResolutionType2.setDisplayResolution(((ResolutionMappingSD_JPG)resolution2).getName());
                    cameraResolutionType2.setHeight(((ResolutionMappingSD_JPG)resolution2).getHeight());
                    cameraResolutionType2.setWidth(((ResolutionMappingSD_JPG)resolution2).getWidth());
                    cameraResolutionType2.setMaxMilliFPS(basefps);
                    cameraResolutionType2.setMinMilliFPS(1);
                    cameraResolutions2 = supportedCameraResolutionsTypeStream1.getCameraResolution();
                    if (PacketXML.containsResolution(cameraResolutions2, cameraResolutionType2)) continue;
                    supportedCameraResolutionsTypeStream1.getCameraResolution().add(cameraResolutionType2);
                }
            }
            streamDefinitionTypeStream1.setSupportedCameraResolutions(supportedCameraResolutionsTypeStream1);
            streamDefinitionTypeStream1.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
            multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionTypeStream1);
        }
        if (numberOfH264Streams == 2) {
            int i;
            StreamDefinitionType streamDefinitionTypeStream2 = new StreamDefinitionType();
            streamDefinitionTypeStream2.setName("H.264 (2)");
            streamDefinitionTypeStream2.setBitrateSettings(bitrateSettingsType);
            streamDefinitionTypeStream2.setDefaultCameraResolutionIndex(0);
            streamDefinitionTypeStream2.setDefaultMilliFPS(5000);
            streamDefinitionTypeStream2.setMinIFrameDistance(100);
            streamDefinitionTypeStream2.setMaxIFrameDistance(100000);
            streamDefinitionTypeStream2.setDefaultTransmissionTypeIndex(0);
            streamDefinitionTypeStream2.setEncodingIntervalMax(60);
            streamDefinitionTypeStream2.setEncodingIntervalMin(3);
            streamDefinitionTypeStream2.setHideBandwithField(false);
            streamDefinitionTypeStream2.setHideFPSField(false);
            streamDefinitionTypeStream2.setHideIFrameField(false);
            streamDefinitionTypeStream2.setHideKompressionField(false);
            streamDefinitionTypeStream2.setMaxNumberOfStreams(1);
            streamDefinitionTypeStream2.setNoOfHWMDInputs(1);
            streamDefinitionTypeStream2.setRtspSettings(rtspSettingsType);
            streamDefinitionTypeStream2.setStreamingMode(videoCodecTypeH264);
            SupportedCameraResolutionsType supportedCameraResolutionsTypeStream2 = new SupportedCameraResolutionsType();
            for (i = 0; i < h264EncBaseOperationModeCaps.getResolutions(2).size(); ++i) {
                resolution = h264EncBaseOperationModeCaps.getResolutions(2).get(i);
                if (resolution == null || ((BoschResolution)resolution).getWidth() <= 0 || ((BoschResolution)resolution).getHeight() <= 0) continue;
                cameraResolutionType = new CameraResolutionType();
                cameraResolutionType.setDisplayResolution(((BoschResolution)resolution).getName());
                cameraResolutionType.setHeight(((BoschResolution)resolution).getHeight());
                cameraResolutionType.setWidth(((BoschResolution)resolution).getWidth());
                cameraResolutionType.setMaxMilliFPS(basefps);
                cameraResolutionType.setMinMilliFPS(1);
                cameraResolutions = supportedCameraResolutionsTypeStream2.getCameraResolution();
                if (PacketXML.containsResolution(cameraResolutions, cameraResolutionType)) continue;
                supportedCameraResolutionsTypeStream2.getCameraResolution().add(cameraResolutionType);
            }
            if (h264EncBaseOperationModeCaps.getResolutions(2).isEmpty() || BoschDevice.containsSDResolution(h264EncBaseOperationModeCaps.getResolutions(2))) {
                for (i = 0; i < capabilityList.getResolutionList().size(); ++i) {
                    resolution = capabilityList.getResolutionList().get(i);
                    if (resolution == null || ((ResolutionMappingSD_JPG)resolution).getWidth() <= 0 || ((ResolutionMappingSD_JPG)resolution).getHeight() <= 0) continue;
                    cameraResolutionType = new CameraResolutionType();
                    cameraResolutionType.setDisplayResolution(((ResolutionMappingSD_JPG)resolution).getName());
                    cameraResolutionType.setHeight(((ResolutionMappingSD_JPG)resolution).getHeight());
                    cameraResolutionType.setWidth(((ResolutionMappingSD_JPG)resolution).getWidth());
                    cameraResolutionType.setMaxMilliFPS(basefps);
                    cameraResolutionType.setMinMilliFPS(1);
                    cameraResolutions = supportedCameraResolutionsTypeStream2.getCameraResolution();
                    if (PacketXML.containsResolution(cameraResolutions, cameraResolutionType)) continue;
                    supportedCameraResolutionsTypeStream2.getCameraResolution().add(cameraResolutionType);
                }
            }
            streamDefinitionTypeStream2.setSupportedCameraResolutions(supportedCameraResolutionsTypeStream2);
            streamDefinitionTypeStream2.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
            multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionTypeStream2);
        }
        if (numberOfH265Streams > 0) {
            int i;
            StreamDefinitionType streamDefinitionTypeStream3 = new StreamDefinitionType();
            streamDefinitionTypeStream3.setName("H.265 (1)");
            streamDefinitionTypeStream3.setBitrateSettings(bitrateSettingsType);
            streamDefinitionTypeStream3.setDefaultCameraResolutionIndex(0);
            streamDefinitionTypeStream3.setDefaultMilliFPS(5000);
            streamDefinitionTypeStream3.setDefaultTransmissionTypeIndex(0);
            streamDefinitionTypeStream3.setMinIFrameDistance(100);
            streamDefinitionTypeStream3.setMaxIFrameDistance(100000);
            streamDefinitionTypeStream3.setHideBandwithField(false);
            streamDefinitionTypeStream3.setHideFPSField(false);
            streamDefinitionTypeStream3.setHideIFrameField(false);
            streamDefinitionTypeStream3.setHideKompressionField(false);
            streamDefinitionTypeStream3.setMaxNumberOfStreams(1);
            streamDefinitionTypeStream3.setNoOfHWMDInputs(1);
            streamDefinitionTypeStream3.setEncodingIntervalMin(3);
            streamDefinitionTypeStream3.setEncodingIntervalMax(60);
            streamDefinitionTypeStream3.setRtspSettings(rtspSettingsType);
            streamDefinitionTypeStream3.setStreamingMode(videoCodecTypeH265);
            SupportedCameraResolutionsType supportedCameraResolutionsTypeStream3 = new SupportedCameraResolutionsType();
            for (i = 0; i < h264EncBaseOperationModeCaps.getResolutions(1).size(); ++i) {
                resolution = h264EncBaseOperationModeCaps.getResolutions(1).get(i);
                if (resolution == null || ((BoschResolution)resolution).getWidth() <= 0 || ((BoschResolution)resolution).getHeight() <= 0) continue;
                cameraResolutionType = new CameraResolutionType();
                cameraResolutionType.setDisplayResolution(((BoschResolution)resolution).getName());
                cameraResolutionType.setHeight(((BoschResolution)resolution).getHeight());
                cameraResolutionType.setWidth(((BoschResolution)resolution).getWidth());
                cameraResolutionType.setMaxMilliFPS(basefps);
                cameraResolutionType.setMinMilliFPS(1);
                cameraResolutions = supportedCameraResolutionsTypeStream3.getCameraResolution();
                if (PacketXML.containsResolution(cameraResolutions, cameraResolutionType)) continue;
                supportedCameraResolutionsTypeStream3.getCameraResolution().add(cameraResolutionType);
            }
            if (h264EncBaseOperationModeCaps.getResolutions(1).isEmpty() || BoschDevice.containsSDResolution(h264EncBaseOperationModeCaps.getResolutions(1))) {
                for (i = 0; i < capabilityList.getResolutionList().size(); ++i) {
                    resolution = capabilityList.getResolutionList().get(i);
                    if (resolution == null || ((ResolutionMappingSD_JPG)resolution).getWidth() <= 0 || ((ResolutionMappingSD_JPG)resolution).getHeight() <= 0) continue;
                    cameraResolutionType = new CameraResolutionType();
                    cameraResolutionType.setDisplayResolution(((ResolutionMappingSD_JPG)resolution).getName());
                    cameraResolutionType.setHeight(((ResolutionMappingSD_JPG)resolution).getHeight());
                    cameraResolutionType.setWidth(((ResolutionMappingSD_JPG)resolution).getWidth());
                    cameraResolutionType.setMaxMilliFPS(basefps);
                    cameraResolutionType.setMinMilliFPS(1);
                    cameraResolutions = supportedCameraResolutionsTypeStream3.getCameraResolution();
                    if (PacketXML.containsResolution(cameraResolutions, cameraResolutionType)) continue;
                    supportedCameraResolutionsTypeStream3.getCameraResolution().add(cameraResolutionType);
                }
            }
            streamDefinitionTypeStream3.setSupportedCameraResolutions(supportedCameraResolutionsTypeStream3);
            streamDefinitionTypeStream3.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
            multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionTypeStream3);
        }
        if (numberOfH265Streams == 2) {
            int i;
            StreamDefinitionType streamDefinitionTypeStream4 = new StreamDefinitionType();
            streamDefinitionTypeStream4.setName("H.265 (2)");
            streamDefinitionTypeStream4.setBitrateSettings(bitrateSettingsType);
            streamDefinitionTypeStream4.setDefaultCameraResolutionIndex(0);
            streamDefinitionTypeStream4.setDefaultMilliFPS(5000);
            streamDefinitionTypeStream4.setMinIFrameDistance(100);
            streamDefinitionTypeStream4.setMaxIFrameDistance(100000);
            streamDefinitionTypeStream4.setDefaultTransmissionTypeIndex(0);
            streamDefinitionTypeStream4.setEncodingIntervalMax(60);
            streamDefinitionTypeStream4.setEncodingIntervalMin(3);
            streamDefinitionTypeStream4.setHideBandwithField(false);
            streamDefinitionTypeStream4.setHideFPSField(false);
            streamDefinitionTypeStream4.setHideIFrameField(false);
            streamDefinitionTypeStream4.setHideKompressionField(false);
            streamDefinitionTypeStream4.setMaxNumberOfStreams(1);
            streamDefinitionTypeStream4.setNoOfHWMDInputs(1);
            streamDefinitionTypeStream4.setRtspSettings(rtspSettingsType);
            streamDefinitionTypeStream4.setStreamingMode(videoCodecTypeH265);
            SupportedCameraResolutionsType supportedCameraResolutionsTypeStream4 = new SupportedCameraResolutionsType();
            for (i = 0; i < h264EncBaseOperationModeCaps.getResolutions(2).size(); ++i) {
                resolution = h264EncBaseOperationModeCaps.getResolutions(2).get(i);
                if (resolution == null || ((BoschResolution)resolution).getWidth() <= 0 || ((BoschResolution)resolution).getHeight() <= 0) continue;
                cameraResolutionType = new CameraResolutionType();
                cameraResolutionType.setDisplayResolution(((BoschResolution)resolution).getName());
                cameraResolutionType.setHeight(((BoschResolution)resolution).getHeight());
                cameraResolutionType.setWidth(((BoschResolution)resolution).getWidth());
                cameraResolutionType.setMaxMilliFPS(basefps);
                cameraResolutionType.setMinMilliFPS(1);
                cameraResolutions = supportedCameraResolutionsTypeStream4.getCameraResolution();
                if (PacketXML.containsResolution(cameraResolutions, cameraResolutionType)) continue;
                supportedCameraResolutionsTypeStream4.getCameraResolution().add(cameraResolutionType);
            }
            if (h264EncBaseOperationModeCaps.getResolutions(2).isEmpty() || BoschDevice.containsSDResolution(h264EncBaseOperationModeCaps.getResolutions(2))) {
                for (i = 0; i < capabilityList.getResolutionList().size(); ++i) {
                    resolution = capabilityList.getResolutionList().get(i);
                    if (resolution == null || ((ResolutionMappingSD_JPG)resolution).getWidth() <= 0 || ((ResolutionMappingSD_JPG)resolution).getHeight() <= 0) continue;
                    cameraResolutionType = new CameraResolutionType();
                    cameraResolutionType.setDisplayResolution(((ResolutionMappingSD_JPG)resolution).getName());
                    cameraResolutionType.setHeight(((ResolutionMappingSD_JPG)resolution).getHeight());
                    cameraResolutionType.setWidth(((ResolutionMappingSD_JPG)resolution).getWidth());
                    cameraResolutionType.setMaxMilliFPS(basefps);
                    cameraResolutionType.setMinMilliFPS(1);
                    cameraResolutions = supportedCameraResolutionsTypeStream4.getCameraResolution();
                    if (PacketXML.containsResolution(cameraResolutions, cameraResolutionType)) continue;
                    supportedCameraResolutionsTypeStream4.getCameraResolution().add(cameraResolutionType);
                }
            }
            streamDefinitionTypeStream4.setSupportedCameraResolutions(supportedCameraResolutionsTypeStream4);
            streamDefinitionTypeStream4.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
            multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionTypeStream4);
        }
        try {
            JpegStreamSetupOptionsVerboseXML jpegStreamSetupOptionsVerbose = new JpegStreamSetupOptionsVerboseXML();
            jpegStreamSetupOptionsVerbose.send(this, Direction.READ);
            boolean canConfigureJpeg = this.canConfigureJpeg();
            StreamDefinitionType streamDefinitionTypeStream3 = new StreamDefinitionType();
            streamDefinitionTypeStream3.setName("MJPEG");
            streamDefinitionTypeStream3.setDefaultCameraResolutionIndex(0);
            streamDefinitionTypeStream3.setDefaultMilliFPS(5000);
            streamDefinitionTypeStream3.setDefaultTransmissionTypeIndex(0);
            streamDefinitionTypeStream3.setMaxNumberOfStreams(1);
            streamDefinitionTypeStream3.setNoOfHWMDInputs(1);
            streamDefinitionTypeStream3.setRtspSettings(rtspSettingsType);
            videoCodecTypeH264 = new CodecType();
            videoCodecTypeH264.setValue(Codec.MJPEG.getType());
            streamDefinitionTypeStream3.setStreamingMode(videoCodecTypeH264);
            streamDefinitionTypeStream3.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
            if (!canConfigureJpeg) {
                streamDefinitionTypeStream3.setHideBandwithField(true);
                streamDefinitionTypeStream3.setHideFPSField(true);
                streamDefinitionTypeStream3.setHideIFrameField(true);
                streamDefinitionTypeStream3.setHideKompressionField(true);
            } else {
                streamDefinitionTypeStream3.setHideBandwithField(true);
                streamDefinitionTypeStream3.setHideFPSField(false);
                streamDefinitionTypeStream3.setHideIFrameField(true);
                streamDefinitionTypeStream3.setHideKompressionField(false);
                SupportedCameraResolutionsType supportedCameraResolutionsTypeStream3 = new SupportedCameraResolutionsType();
                SupportedFrameRatesType supportedFrameRatesType = new SupportedFrameRatesType();
                int[] availableFramerates = new int[]{5000, 10000, 15000, 20000, 25000, 30000, 50000};
                if (basefps == 60000) {
                    availableFramerates[6] = 60000;
                }
                for (int fps : availableFramerates) {
                    if (fps > basefps) continue;
                    supportedFrameRatesType.getInt().add(fps);
                }
                Object object = jpegStreamSetupOptionsVerbose.getResolutions().iterator();
                while (object.hasNext()) {
                    Resolution resolution3 = (Resolution)object.next();
                    if (resolution3.getWidth() <= 0 || resolution3.getHeight() <= 0) continue;
                    CameraResolutionType cameraResolutionType3 = new CameraResolutionType();
                    cameraResolutionType3.setDisplayResolution(resolution3.getResolutionName());
                    cameraResolutionType3.setWidth(resolution3.getWidth());
                    cameraResolutionType3.setHeight(resolution3.getHeight());
                    cameraResolutionType3.setSupportedFrameRates(supportedFrameRatesType);
                    List<CameraResolutionType> cameraResolutions3 = supportedCameraResolutionsTypeStream3.getCameraResolution();
                    if (PacketXML.containsResolution(cameraResolutions3, cameraResolutionType3)) continue;
                    supportedCameraResolutionsTypeStream3.getCameraResolution().add(cameraResolutionType3);
                }
                streamDefinitionTypeStream3.setSupportedCameraResolutions(supportedCameraResolutionsTypeStream3);
            }
            multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionTypeStream3);
        }
        catch (Exception ex) {
            this.logger.warn("Exception while reading MJPEG capabilities for " + this + " : " + ex.getMessage());
        }
        return multiStreamingDefinitionsType;
    }

    private static boolean listContainsResolution(List<Resolution> possibleResolutions, int resolution) {
        for (Resolution jpegResolution : possibleResolutions) {
            if (jpegResolution.getId() != resolution) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSDResolution(List<BoschResolution> resolutions) {
        for (BoschResolution resolution : resolutions) {
            if (!resolution.equals((Object)BoschResolution.SD)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAlarm(List<GenericEventDefinitionType> genericEventDefinitions, AlarmEntry alarmEntry) {
        for (GenericEventDefinitionType genericEventDefinition : genericEventDefinitions) {
            if (!genericEventDefinition.getEventType().equals(alarmEntry.getAlarmName())) continue;
            return true;
        }
        return false;
    }

    public List<TimeRange> getRecordingInfosFromDevice(long startTimestamp, long endTimestamp, int videoSourceNr, BoschPlaybackVideoSourceClient client) {
        List<Object> timeRanges = new ArrayList();
        client.setRangesToFill(null);
        try {
            client.setTimeDifference(client.getTimeDifferenceFromDevice());
            int errorCode = client.startStreaming();
            if (errorCode == -2147483647) {
                timeRanges = client.getRangesToFill();
                client.endStreaming();
            }
        }
        catch (SeeTecException se) {
            if (se.getErrorCode() == -2147483647) {
                timeRanges = client.getRangesToFill();
                client.endStreaming();
            } else {
                this.logger.error("Exception while getting recording infos: " + se.getMessage());
                client.endStreaming();
            }
        }
        catch (Throwable throwable) {
            this.logger.info("Error while getting recording infos from device " + throwable.getMessage());
            client.endStreaming();
        }
        return timeRanges;
    }

    String checkEdgeStorageReady(int serverEntryNo, BoschPlaybackVideoSourceClient client) {
        List<TimeRange> lastRecordings = this.getRecordingInfosFromDevice(0L, 0L, 0, client);
        ArrayList<String> multiLineLog = new ArrayList<String>();
        multiLineLog.add("Edge Storage Information for " + this);
        multiLineLog.add("Channel: 0");
        if (lastRecordings.isEmpty() || !this.containsRecording(lastRecordings, 60000L)) {
            multiLineLog.add("Edge Storage is not ready, because there are no recordings available from the last 60 seconds");
        } else {
            multiLineLog.add("Edge Storage is ready on the camera.");
            multiLineLog.add("Could not gather additional edge storage information from camera.");
        }
        String edgeStorageStatus = Basic.generateIndentedMultiLineLog(multiLineLog);
        this.logger.info(Basic.generateIndentedMultiLineLog((String)edgeStorageStatus));
        return edgeStorageStatus;
    }

    protected boolean containsRecording(List<TimeRange> lastRecordings, long elapsedTime) {
        long currentTime = System.currentTimeMillis();
        TimeRange lastXmilisTimeRange = new TimeRange(currentTime - elapsedTime, currentTime);
        for (int i = lastRecordings.size() - 1; i >= 0; --i) {
            TimeRange timeRange = lastRecordings.get(i);
            if (!lastXmilisTimeRange.isPartOf(timeRange)) continue;
            return true;
        }
        return false;
    }

    protected HttpHandlerImpl getHttpHandler() throws Exception {
        if (this.httpHandler == null) {
            NetworkParameter networkParameter = this.getDeviceCnf().getNetworkParameter();
            networkParameter.checkAndSetTimeout(this.boschLegacyTimeout);
            this.httpHandler = new HttpHandlerImpl(networkParameter);
        }
        return this.httpHandler;
    }

    public static CameraAdministration getCameraAdministration() throws SeeTecException {
        if (CAMERA_ADMINISTRATION == null) {
            CAMERA_ADMINISTRATION = new BoschCameraAdministration((SeetecHttpClient)new NetworkHelperAdapter());
        }
        return CAMERA_ADMINISTRATION;
    }

    protected synchronized DeviceCapabilitiesXML getDeviceCapabilities() throws Exception {
        if (this.deviceCapabilities == null) {
            this.deviceCapabilities = new DeviceCapabilitiesXML();
            this.deviceCapabilities.send(this, Direction.READ);
        }
        return this.deviceCapabilities;
    }

    private boolean isDeviceBasedAlarm(int alarmSourceNumber) {
        return alarmSourceNumber <= 5 || alarmSourceNumber > 11;
    }
}

