/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClientFactory;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.bosch.BoschAudioOutServer;
import de.seetec.v5.re.cm.device.video.bosch.BoschCameraControl;
import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.BoschPlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.video.bosch.BoschTriggerHandler;
import de.seetec.v5.re.cm.device.video.bosch.BoschVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.bosch.EncoderOperationMode;
import de.seetec.v5.re.cm.device.video.bosch.jpeg.BoschJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.bosch.mpeg.BoschMPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.bosch.rcp.H264EncBaseOperationModeCaps;
import de.seetec.v5.re.cm.device.video.bosch.rcp.OperationModeCombination;
import de.seetec.v5.re.cm.device.video.bosch.rcp.VariantIDDescription;
import de.seetec.v5.re.cm.device.video.bosch.rcp.VariantIDOptionsRsp;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.ConfRcpCoderListXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.DptzStaticCapsXML;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.EdgeStorageParameter;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jdom.Document;
import org.jdom.Element;

public class BoschCameraSrv
extends LiveCameraSrv {
    protected Semaphore semaphore = new Semaphore(1);
    protected long semaphoreWaitingTimeSeconds = 10L;
    private BoschCameraControl boschCameraControl = null;
    private Long entityType = null;
    private boolean watchDogAlreadyStarted = false;
    private int streamID = 2;
    private Map<String, Integer> dynToStream = new HashMap<String, Integer>();
    private boolean isCaptureModeSet;
    private final Semaphore resolutionCurrentlySet = new Semaphore(1);
    private Map<Integer, Integer> coders = null;

    @Override
    public int init(Vector<PresetCnf> presetList) throws ConfigurationException {
        int errorCode = super.init(presetList);
        EdgeStorageParameter edgeStorageParameter = this.getVideoSourceCnf().getEdgeStorageParameter();
        if (edgeStorageParameter != null && edgeStorageParameter.isEnabled()) {
            try {
                PlaybackVideoSourceClient tempPlaybackClient = PlaybackVideoSourceClientFactory.createPlaybackVideoSourceClient(this.getEntityType(), edgeStorageParameter, this.getCore(), this, this.getVideoProfileHandler(null), true);
                ((BoschDevice)this.getDevice()).checkEdgeStorageReady(this.getVideoSourceCnf().getServerEntryNo(), (BoschPlaybackVideoSourceClient)tempPlaybackClient);
                tempPlaybackClient.shutdown();
            }
            catch (SeeTecException ex) {
                this.logger.error("Failed to check edgestorage status!");
            }
        }
        return errorCode;
    }

    public void setBlockResolutionSetting() throws InterruptedException {
        this.resolutionCurrentlySet.acquire();
    }

    public void releaseBlockResolutionSetting() {
        this.resolutionCurrentlySet.release();
    }

    int getProfilePreset(int streamNumber) throws ConfigurationException, Exception {
        return (this.getCoderNumber(streamNumber) << 8) + streamNumber;
    }

    int getCoderNumber(int streamNumber) throws ConfigurationException, Exception {
        if (this.coders == null) {
            ConfRcpCoderListXML confRcpCoderListXml = new ConfRcpCoderListXML();
            confRcpCoderListXml.setNum(this.getVideoSourceCnf().getServerEntryNo());
            confRcpCoderListXml.send((BoschDevice)this.getDevice(), Direction.READ);
            this.coders = confRcpCoderListXml.getCoders();
        }
        return this.coders.get(streamNumber - 1);
    }

    @Override
    public CameraControl createCameraControl(Long entityType) {
        if (entityType != null) {
            block10: {
                if (entityType == 211701L || entityType == 211708L || entityType == 211720L || entityType == 211713L || entityType == 211712L || entityType == 211717L || entityType == 211714L || entityType == 211733L || entityType == 211734L || entityType == 211739L || entityType == 211740L) {
                    this.logger.info("BiCom protocol will be used for: " + this);
                    this.boschCameraControl = new BoschCameraControl(3);
                } else if (entityType == 211709L) {
                    this.logger.info("AutoDome protocol will be used for: " + this);
                    this.boschCameraControl = new BoschCameraControl(1);
                } else if (entityType == 211735L || entityType == 210555L) {
                    DptzStaticCapsXML dptzStaticCaps = new DptzStaticCapsXML();
                    try {
                        dptzStaticCaps.send((BoschDevice)this.device, Direction.READ);
                        boolean bicomAvailable = dptzStaticCaps.supportsBicom(this.getVideoSourceCnf().getServerEntryNo());
                        if (bicomAvailable) {
                            this.logger.info("BiCom protocol will be used for: " + this);
                            this.boschCameraControl = new BoschCameraControl(3);
                            break block10;
                        }
                        this.logger.info("Pelco-D protocol will be used for: " + this);
                        this.boschCameraControl = new BoschCameraControl(2);
                    }
                    catch (Exception ex) {
                        this.logger.warn("Exception while reading Bicom-Capability for : " + this + " : " + ex.getMessage());
                        this.logger.info("PELCO-D protocol will be used for : " + this);
                        this.boschCameraControl = new BoschCameraControl(2);
                    }
                } else {
                    this.logger.info("Pelco-D protocol will be used for: " + this);
                    this.boschCameraControl = new BoschCameraControl(2);
                }
            }
            this.boschCameraControl.init(this.getCore(), this.getDevice(), this, this.presetList);
            new ControlWatchDog().init();
            return this.boschCameraControl;
        }
        return null;
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        VideoSourceClient videoSourceClient = null;
        ArrayList<String> requestedDisplayResolution = null;
        OperationModeCombination combinationToSet = null;
        try {
            long deviceType = this.getDevice().getDeviceType();
            if (deviceType == 201748L || deviceType == 200657L) {
                videoSourceClient = new BoschVideoSourceClientRTSP();
            } else {
                Element root;
                Document currentResponseAsDocument;
                try {
                    currentResponseAsDocument = ((BoschDevice)this.getDevice()).getHttpResponseAsXml("/rcp.xml?command=0x0bb6&type=P_OCTET&direction=READ&protocol=TCP&num=" + listener.getVideoSourceParameter().getServerEntryNo());
                    root = currentResponseAsDocument.getRootElement();
                    if (root.getChild("result").getChild("err") != null) {
                        this.logger.warn("Error while requesting variantID: " + root.getChild("result").getChild("err").getText());
                    } else if (root.getChild("result").getChild("str") != null) {
                        String variantAsString = root.getChild("result").getChild("str").getText().trim();
                        variantAsString = variantAsString.replaceAll("\\s", "");
                        VariantIDOptionsRsp variantIDOptionsRsp = new VariantIDOptionsRsp();
                        variantIDOptionsRsp.deserializeBody(Basic.hexStringToByteArray((String)variantAsString));
                        List<VariantIDDescription> variants = variantIDOptionsRsp.getVariants();
                        if (!variants.isEmpty()) {
                            this.logger.info("Found variants: " + variants);
                            currentResponseAsDocument = ((BoschDevice)this.getDevice()).getHttpResponseAsXml("/rcp.xml?command=0x0bb2&type=T_DWORD&direction=READ&protocol=TCP&num=" + listener.getVideoSourceParameter().getServerEntryNo());
                            root = currentResponseAsDocument.getRootElement();
                            if (root.getChild("result").getChild("err") != null) {
                                this.logger.warn("Error while requesting variantID: " + root.getChild("result").getChild("err").getText());
                            } else if (root.getChild("result").getChild("dec") != null) {
                                VariantIDDescription currentSetVariant = variantIDOptionsRsp.getVariant(Long.parseLong(root.getChild("result").getChild("dec").getTextTrim()));
                                this.logger.info("Currently set Variant '" + currentSetVariant + "' for " + this);
                                if (this.getDevice().getDeviceCnf().getCaptureMode().getResolution().equals(currentSetVariant.getVariantIDDescription())) {
                                    this.logger.info("Correct VariantID already set for " + this);
                                } else {
                                    VariantIDDescription newVariant = variantIDOptionsRsp.getVariant(this.getDevice().getDeviceCnf().getCaptureMode().getResolution());
                                    if (newVariant == null) {
                                        this.logger.error("Requested Variant '" + this.getDevice().getDeviceCnf().getCaptureMode().getResolution() + "' not available on device. Available Variants: " + variantIDOptionsRsp.getVariants() + " for " + this);
                                    } else {
                                        StringBuilder info = new StringBuilder("\r\n");
                                        info.append("=============================================");
                                        info.append("\r\n");
                                        info.append("VariantID '");
                                        info.append(newVariant);
                                        info.append("' will be set for ");
                                        info.append(this);
                                        info.append("\r\n");
                                        info.append("THIS WILL CAUSE A REBOOT INITIALIZED BY THE DEVICE!");
                                        info.append("\r\n");
                                        info.append("=============================================");
                                        this.logger.info((CharSequence)info);
                                        currentResponseAsDocument = ((BoschDevice)this.getDevice()).getHttpResponseAsXml("/rcp.xml?command=0x0bb2&type=T_DWORD&direction=WRITE&payload=" + newVariant.getVariantID() + "&protocol=TCP&num=" + listener.getVideoSourceParameter().getServerEntryNo());
                                        root = currentResponseAsDocument.getRootElement();
                                        if (root.getChild("result").getChild("err") != null) {
                                            this.logger.warn("Error while setting variantID: " + root.getChild("result").getChild("err").getText());
                                        }
                                    }
                                }
                            }
                        } else {
                            this.logger.info("Device doesn't support variants for " + this);
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.info("VariantID command not applied successfull. Maybe unknown on older products.");
                }
                if (listener.getVideoSourceParameter().getMediaCodec() == Codec.MPEG4 || listener.getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                    videoSourceClient = new BoschMPEGVideoSourceClient();
                    try {
                        currentResponseAsDocument = ((BoschDevice)this.getDevice()).getHttpResponseAsXml("/rcp.xml?command=0x0af9&type=P_OCTET&direction=READ&protocol=TCP&num=" + listener.getVideoSourceParameter().getServerEntryNo());
                        root = currentResponseAsDocument.getRootElement();
                        String caps = root.getChild("result").getChild("str").getText().trim();
                        caps = caps.replaceAll("\\s", "");
                        byte[] capsAsBytes = Basic.hexStringToByteArray((String)caps);
                        H264EncBaseOperationModeCaps rsp = new H264EncBaseOperationModeCaps();
                        rsp.deserializeBody(capsAsBytes);
                        if (this.logger.isDebugEnabled()) {
                            rsp.printCapabilities();
                        }
                        requestedDisplayResolution = new ArrayList<String>();
                        if (this.getBasicVideoProfileHandler().getVideoSourceParameter().getMediaCodec() == Codec.MPEG4 || this.getBasicVideoProfileHandler().getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                            requestedDisplayResolution.add(this.getBasicVideoProfileHandler().getVideoSourceParameter().getDisplayResolution());
                        }
                        for (VideoProfileHandler add : this.getAdditionalVideoProfileHandler()) {
                            if (add.getVideoSourceParameter().getMediaCodec() != Codec.MPEG4 && add.getVideoSourceParameter().getMediaCodec() != Codec.H264) continue;
                            requestedDisplayResolution.add(add.getVideoSourceParameter().getDisplayResolution());
                        }
                        this.logger.info("Streaming combination should be found for: " + requestedDisplayResolution + " for " + this);
                        String[] requestedDisplayResolutionArray = requestedDisplayResolution.toArray(new String[requestedDisplayResolution.size()]);
                        ArrayList<EncoderOperationMode[]> operationModePermutations = new ArrayList<EncoderOperationMode[]>();
                        List<EncoderOperationMode> firstList = this.findOperationMode(requestedDisplayResolutionArray[0]);
                        if (requestedDisplayResolutionArray.length > 1) {
                            List<EncoderOperationMode> secondList = this.findOperationMode(requestedDisplayResolutionArray[1]);
                            for (EncoderOperationMode firstListMode : firstList) {
                                Iterator<Object> iterator = secondList.iterator();
                                while (iterator.hasNext()) {
                                    EncoderOperationMode secondListMode = (EncoderOperationMode)((Object)iterator.next());
                                    operationModePermutations.add(new EncoderOperationMode[]{firstListMode, secondListMode});
                                }
                            }
                            if (this.logger.isDebugEnabled()) {
                                for (EncoderOperationMode[] permutation : operationModePermutations) {
                                    this.logger.info("Permutation: " + (Object)((Object)permutation[0]) + "   -   " + (Object)((Object)permutation[1]));
                                }
                            }
                        } else {
                            for (EncoderOperationMode firstListMode : firstList) {
                                operationModePermutations.add(new EncoderOperationMode[]{firstListMode});
                            }
                        }
                        block12: while (combinationToSet == null && operationModePermutations.size() > 0) {
                            Object combination_1_2;
                            EncoderOperationMode[] requestedOperationMode = (EncoderOperationMode[])operationModePermutations.remove(0);
                            if (requestedOperationMode.length == 2) {
                                combination_1_2 = new byte[8];
                                System.arraycopy(Basic.int4ToByteArray((int)requestedOperationMode[0].getOperationTag()), 0, combination_1_2, 0, 4);
                                System.arraycopy(Basic.int4ToByteArray((int)requestedOperationMode[1].getOperationTag()), 0, combination_1_2, 4, 4);
                                byte[] combination_2_1 = new byte[8];
                                System.arraycopy(Basic.int4ToByteArray((int)requestedOperationMode[1].getOperationTag()), 0, combination_2_1, 0, 4);
                                System.arraycopy(Basic.int4ToByteArray((int)requestedOperationMode[0].getOperationTag()), 0, combination_2_1, 4, 4);
                                for (OperationModeCombination combination : rsp.getCapabilities()) {
                                    if (!Arrays.equals(combination.getCombinationAsByteArray(), (byte[])combination_1_2)) continue;
                                    this.logger.info("Found possible multistreaming " + combination);
                                    combinationToSet = combination;
                                    break;
                                }
                                if (combinationToSet != null) continue;
                                for (OperationModeCombination combination : rsp.getCapabilities()) {
                                    if (!Arrays.equals(combination.getCombinationAsByteArray(), combination_2_1)) continue;
                                    this.logger.info("Found possible multistreaming " + combination);
                                    combinationToSet = combination;
                                    continue block12;
                                }
                                continue;
                            }
                            if (requestedOperationMode.length != 1) continue;
                            combination_1_2 = rsp.getCapabilities().iterator();
                            while (combination_1_2.hasNext()) {
                                OperationModeCombination combination = (OperationModeCombination)combination_1_2.next();
                                if (combination.getCombination()[0] != requestedOperationMode[0]) continue;
                                this.logger.info("Found possible singleStreaming " + combination);
                                combinationToSet = combination;
                                break;
                            }
                            if (combinationToSet != null) continue;
                            for (OperationModeCombination combination : rsp.getCapabilities()) {
                                if (combination.getCombination()[1] != requestedOperationMode[0]) continue;
                                this.logger.info("Found possible singleStreaming " + combination);
                                combinationToSet = combination;
                                continue block12;
                            }
                        }
                        if (combinationToSet == null) {
                            this.logger.error("NO MATCHING stream combination found for " + this);
                            this.logger.error("Go on without changing stream settings.");
                        } else {
                            currentResponseAsDocument = ((BoschDevice)this.getDevice()).getHttpResponseAsXml("/rcp.xml?command=0x0ad3&type=P_OCTET&direction=READ&protocol=TCP&num=" + listener.getVideoSourceParameter().getServerEntryNo());
                            root = currentResponseAsDocument.getRootElement();
                            String currentlySetMode = root.getChild("result").getChild("str").getText().trim();
                            byte[] currentlySetModeAsBytes = Basic.hexStringToByteArray((String)(currentlySetMode = currentlySetMode.replaceAll("\\s", "")));
                            if (Arrays.equals(currentlySetModeAsBytes, combinationToSet.getCombinationAsByteArray())) {
                                this.logger.info("Requested encoder combination already set. Don't set again for " + this);
                            } else {
                                this.logger.info("Combination to set: " + combinationToSet);
                                this.logger.info("/rcp.xml?command=0x0ad3&type=P_OCTET&direction=WRITE&protocol=TCP&num=" + listener.getVideoSourceParameter().getServerEntryNo() + "&payload=0x" + Basic.byteArrayToHexString((byte[])combinationToSet.getCombinationAsByteArray()));
                                ((BoschDevice)this.getDevice()).getHttpResponseAsXml("/rcp.xml?command=0x0ad3&type=P_OCTET&direction=WRITE&protocol=TCP&num=" + listener.getVideoSourceParameter().getServerEntryNo() + "&payload=0x" + Basic.byteArrayToHexString((byte[])combinationToSet.getCombinationAsByteArray()));
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn("Command for reading out H.264 capabilities seems to be unknown on this device. Go on without.");
                    }
                    ((BoschMPEGVideoSourceClient)videoSourceClient).setStreamID(this.streamAssignment(listener.getDynamicVideoProfileID(), listener.getVideoSourceParameter().getDisplayResolution(), requestedDisplayResolution, combinationToSet));
                } else {
                    BoschDevice boschDevice = (BoschDevice)this.getDevice();
                    videoSourceClient = boschDevice.useSingleJpegImages() ? new BoschJPEGVideoSourceClient() : new BoschMPEGVideoSourceClient();
                }
            }
            int errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    public static String createPassphrase(NetworkParameter networkParameter) {
        String passphrase = "+service:+";
        if (networkParameter != null && networkParameter.getUserPWD() != null && networkParameter.getUserPWD().length == 2) {
            passphrase = "+" + (networkParameter.getUserPWD()[0] == null ? "" : networkParameter.getUserPWD()[0]) + ":" + (networkParameter.getUserPWD()[1] == null ? "" : networkParameter.getUserPWD()[1]) + "+";
        }
        return passphrase;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    public boolean isCaptureModeSet() {
        return this.isCaptureModeSet;
    }

    public void setCaptureModeSet(boolean isSet) {
        this.isCaptureModeSet = isSet;
    }

    protected List<EncoderOperationMode> findOperationMode(String displayResolution) {
        ArrayList<EncoderOperationMode> result;
        block7: {
            result = new ArrayList<EncoderOperationMode>();
            try {
                if (displayResolution.contains("720p") || displayResolution.contains("1280x720")) {
                    result.addAll(EncoderOperationMode.getListOfMatchingModes("720P"));
                    return result;
                }
                if (displayResolution.contains("1080p") || displayResolution.contains("1920x1080")) {
                    result.addAll(EncoderOperationMode.getListOfMatchingModes("1080P"));
                    return result;
                }
                if (displayResolution.contains("5MP")) {
                    result.add(EncoderOperationMode.BOSCH_OPERATION_MODE_H264_MP_HD_5MP);
                    return result;
                }
                if (displayResolution.matches("\\d{3}x\\d{4}") || displayResolution.matches("\\d{4}x\\d{3}") || displayResolution.matches("\\d{4}x\\d{4}")) {
                    String displayResolutionAdapted = displayResolution.replace("x", "_");
                    result.addAll(EncoderOperationMode.getListOfMatchingModes(displayResolutionAdapted));
                    break block7;
                }
                if (displayResolution.matches("\\d{3}x\\d{3}")) {
                    String displayResolutionAdapted = displayResolution.replace("x", "_");
                    result.addAll(EncoderOperationMode.getListOfMatchingModes(displayResolutionAdapted));
                    result.add(EncoderOperationMode.BOSCH_OPERATION_MODE_H264_MP_SD);
                    break block7;
                }
                result.add(EncoderOperationMode.BOSCH_OPERATION_MODE_H264_MP_SD);
                return result;
            }
            catch (Exception e) {
                this.logger.warn("Could not read display resolution for " + this);
            }
        }
        return result;
    }

    protected boolean isHigherResolutionRequested(String displayResolution, List<String> requestedDisplayResolution) {
        ArrayList<String> requestedDisplayResolutionClone = new ArrayList<String>();
        if (requestedDisplayResolution != null) {
            requestedDisplayResolutionClone.addAll(requestedDisplayResolution);
        }
        requestedDisplayResolutionClone.remove(displayResolution);
        if (displayResolution != null) {
            int sortingOrder = 0;
            for (EncoderOperationMode encoderMode : EncoderOperationMode.values()) {
                if (encoderMode.getResolution().isEmpty() || !displayResolution.contains(encoderMode.getResolution())) continue;
                sortingOrder = encoderMode.getSortingOrder();
            }
            int maxRequestedSortingOrder = 0;
            for (String requested : requestedDisplayResolutionClone) {
                for (EncoderOperationMode encoderMode : EncoderOperationMode.values()) {
                    if (!requested.contains(encoderMode.getResolution()) || encoderMode.getSortingOrder() <= maxRequestedSortingOrder) continue;
                    maxRequestedSortingOrder = encoderMode.getSortingOrder();
                }
            }
            return sortingOrder < maxRequestedSortingOrder;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int streamAssignment(int dynamicVideoProfileID, String displayResolution, List<String> requestedDisplayResolution, OperationModeCombination combinationToSet) throws NullPointerException, InterruptedException, SeeTecException {
        if (!this.semaphore.tryAcquire(this.semaphoreWaitingTimeSeconds, TimeUnit.SECONDS)) {
            this.logger.warn("Cannot aquire [semaphore] for " + this);
            throw new SeeTecException(-20001, "Initializing [VideoSourceClient] for " + this + " failed with cause impossible to acquire semaphore.");
        }
        try {
            block13: {
                block16: {
                    block14: {
                        block15: {
                            this.dynToStream.remove("" + dynamicVideoProfileID);
                            if (displayResolution.contains("720p") || displayResolution.contains("720P")) {
                                displayResolution = EncoderOperationMode.BOSCH_OPERATION_MODE_H264_MP_FIXED_720P.getResolution();
                            }
                            if (displayResolution.contains("1080p") || displayResolution.contains("1080P")) {
                                displayResolution = EncoderOperationMode.BOSCH_OPERATION_MODE_H264_MP_FIXED_1080P.getResolution();
                            }
                            boolean setNewStyle = false;
                            if (combinationToSet != null) {
                                if (combinationToSet.getCombination()[0].getResolution().equalsIgnoreCase(displayResolution) && !this.dynToStream.containsValue(1)) {
                                    this.dynToStream.put("" + dynamicVideoProfileID, 1);
                                    setNewStyle = true;
                                }
                                if (combinationToSet.getCombination()[1].getResolution().equalsIgnoreCase(displayResolution) && !setNewStyle) {
                                    this.dynToStream.put("" + dynamicVideoProfileID, 2);
                                    setNewStyle = true;
                                }
                            }
                            if (setNewStyle) break block13;
                            if (!this.dynToStream.isEmpty()) break block14;
                            if (!displayResolution.matches(".*\\d{4}x\\d{3,4}.*")) break block15;
                            if (this.isHigherResolutionRequested(displayResolution, requestedDisplayResolution)) {
                                this.logger.info("Set HD stream 2 cause another HD stream has higher resolution.");
                                this.streamID = 2;
                            } else {
                                this.streamID = 1;
                            }
                            break block16;
                        }
                        this.streamID = 2;
                        if (this.getDeviceType() != 201739L) break block16;
                        this.streamID = 1;
                        break block16;
                    }
                    if (this.dynToStream.size() == 1) {
                        this.streamID = 2;
                        for (Integer value : this.dynToStream.values()) {
                            if (value != 2) continue;
                            this.streamID = 1;
                        }
                    }
                }
                this.dynToStream.put("" + dynamicVideoProfileID, this.streamID);
            }
            int n = this.dynToStream.get("" + dynamicVideoProfileID);
            return n;
        }
        finally {
            this.semaphore.release();
        }
    }

    protected long getDeviceType() {
        return this.device.getDeviceType();
    }

    @Override
    protected GenericEventTriggerHandler createNewGenericEventTriggerHandler() {
        return new BoschTriggerHandler(this);
    }

    @Override
    protected BoschAudioOutServer createAudioOutServer() {
        try {
            BoschAudioOutServer boschAudioOutServer = new BoschAudioOutServer(this.device.getDeviceCnf().getNetworkParameter(), (BoschDevice)this.device);
            boschAudioOutServer.init();
            return boschAudioOutServer;
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Exception whilte starting Bosch Audio Out Server for " + this);
            return null;
        }
    }

    private class ControlWatchDog
    implements Runnable {
        private ControlWatchDog() {
        }

        public void init() {
            if (!BoschCameraSrv.this.watchDogAlreadyStarted) {
                BoschCameraSrv.this.watchDogAlreadyStarted = true;
                new Thread((Runnable)this, this.toString()).start();
            }
        }

        @Override
        public void run() {
            while (!BoschCameraSrv.this.isShutdown()) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!BoschCameraSrv.this.boschCameraControl.isShutdown()) continue;
                BoschCameraSrv.this.entityType = BoschCameraSrv.this.getEntityType();
                BoschCameraSrv.this.cameraControl = BoschCameraSrv.this.createCameraControl(BoschCameraSrv.this.entityType);
            }
        }
    }
}

