/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministration;
import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministrationBase;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HTTPBody;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.HttpHandler;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.SeetecHttpClient;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.http.ContentType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class BoschCameraAdministration
extends CameraAdministrationBase
implements CameraAdministration {
    public BoschCameraAdministration(SeetecHttpClient httpClient) throws SeeTecException {
        super(httpClient);
    }

    public HttpHandler getHttpHandler(NetworkParameter networkParameter) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        return new HttpHandlerImpl(networkParameter);
    }

    @Override
    protected void modifyPasswordOnDevice(String passwordToSet, NetworkParameter networkParameter) throws SeeTecException {
        try {
            String userName = networkParameter.getUserPWD()[0];
            int userNameLength = userName.length() + 4;
            int passwordLength = passwordToSet.length() + 4;
            int overallLength = userNameLength + passwordLength + 4;
            String payload = "0x" + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)overallLength, (int)2)) + "0000" + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)userNameLength, (int)2)) + "0001" + this.convertStringToHexString(userName) + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)passwordLength, (int)2)) + "0004" + this.convertStringToHexString(passwordToSet);
            String url = "/rcp.xml?command=" + Command.CMD_CONF_ADV_USER_SETTINGS.getCommand() + "&type=" + Type.TYPE_P_OCTET.getType() + "&direction=" + (Object)((Object)Direction.WRITE) + "&payload=" + payload;
            this.sendRcpCommand(networkParameter, url);
        }
        catch (SeeTecException seeTecException) {
            throw new SeeTecException(seeTecException.getErrorCode(), "Error while setting password. Status: " + seeTecException.getNetworkStatus() + ". Message: " + seeTecException.getMessage());
        }
    }

    private void sendRcpCommand(NetworkParameter networkParameter, String url) throws SeeTecException {
        try {
            Element err;
            Element res;
            HTTPBody httpBody;
            String responseString;
            ByteArrayInputStream bais;
            Document xmlDoc;
            Element root;
            byte[] response = this.getHttpClient().readGetRequest(networkParameter, url, Integer.MAX_VALUE);
            HTTPResponse httpResponse = new HTTPResponse(response);
            if (httpResponse.hasBody() && (root = (xmlDoc = new SAXBuilder().build((InputStream)(bais = new ByteArrayInputStream((responseString = (httpBody = httpResponse.getHttpBody()).getData()).getBytes())))).getRootElement()) != null && (res = root.getChild("result")) != null && (err = res.getChild("err")) != null) {
                throw new SeeTecException(-20001, "Result of XML contains error: " + err.getText());
            }
        }
        catch (JDOMException ex) {
            throw new SeeTecException(-20053, "Error while parsing XML response after password setting for " + this + ": " + ex.getMessage());
        }
    }

    private String convertStringToHexString(String input) {
        Charset charset = Charset.forName("ASCII");
        byte[] inputAsByteArray = input.getBytes(charset);
        return Basic.byteArrayToHexString((byte[])inputAsByteArray);
    }

    @Override
    protected void upgradeFirmwareOnDevice(byte[] firmwareData, NetworkParameter networkParameter) throws SeeTecException {
        networkParameter.setSoTimeout((int)TimeUnit.MINUTES.toMillis(15L));
        try {
            HttpHandler httpHandler = this.getHttpHandler(networkParameter);
            String checkUrl = "/rcp.xml?message=" + Command.CMD_CONF_UPLOAD_PROGRESS.getCommand() + "&collectms=2000";
            String status = httpHandler.readGetRequest(checkUrl);
            this.checkResponseBodyForAlreadyInProgress(status);
            String result = httpHandler.readPostRequestMultipart("/upload.htm", "bosch.fw", firmwareData, ContentType.APPLICATION_OCTET_STREAM, "bosch.fw");
            status = httpHandler.readGetRequest(checkUrl);
            this.checkResponseForError(result);
            this.checkResponseForError(status);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException exception) {
            throw new SeeTecException(-20001, "Error while upgrading firmware on device. Message: " + exception.getMessage());
        }
        catch (SeeTecException seeTecException) {
            throw new SeeTecException(seeTecException.getErrorCode(), "Error while upgrading firmware on device. Status: " + seeTecException.getNetworkStatus() + ". Message: " + seeTecException.getMessage());
        }
    }

    private void checkResponseForError(String responseBody) throws SeeTecException {
        if (responseBody.toLowerCase().contains("err")) {
            throw new SeeTecException(-20002, responseBody);
        }
    }

    private void checkResponseBodyForAlreadyInProgress(String responseBody) throws SeeTecException {
        String response = responseBody.trim().replace("\n", "").replace("\r", "");
        if (!response.contains("<message_list></message_list>")) {
            throw new SeeTecException(-20002, responseBody);
        }
    }
}

