/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.device.shared.AudioOutServer;
import de.seetec.v5.re.cm.device.shared.net.RCPNetworkCallback;
import de.seetec.v5.re.cm.device.video.bosch.BoschCameraSrv;
import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.TpktStreamReader;
import de.seetec.v5.re.cm.device.video.bosch.TpktStreamWriter;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationReq;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationRsp;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientUnregister;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Connect;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Disconnect;
import de.seetec.v5.re.cm.device.video.bosch.rcp.MediaDescriptor;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Retrigger;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkParameter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BoschAudioOutServer
extends AudioOutServer
implements Runnable,
RCPNetworkCallback {
    private final NetworkParameter networkParameter;
    private final Logger logger;
    private boolean isShutdown = false;
    private Thread thread;
    private TpktStreamWriter rcpWriter = null;
    private Socket socket = null;
    private DatagramSocket udpSocket = null;
    private volatile boolean registered;
    private byte[] clientID;
    private volatile boolean registerAnswered = false;
    private TpktStreamReader rcpReader = null;
    private byte[] sessionID;
    private volatile boolean connected = false;
    private volatile boolean streamRunning = false;
    private int counter = 0;
    private static final int RCP_PORT = 1756;
    private volatile int mtaPort;
    private final Semaphore semaphore = new Semaphore(1);
    private volatile boolean expectUnregister = false;

    public BoschAudioOutServer(NetworkParameter networkParameter, BoschDevice boschDevice) {
        if (networkParameter == null) {
            throw new IllegalArgumentException("NetworkParameter is null for Bosch AudioOutServer");
        }
        this.networkParameter = networkParameter;
        this.logger = LogManager.getLogger(this.getClass());
    }

    public int init() {
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.thread.start();
        this.logger.info(this + " initialized");
        return 0;
    }

    @Override
    public void onRCPDataPacket(byte[] data) {
        Packet p = Packet.deserialize(data);
        if (this.isShutdown()) {
            return;
        }
        if (p == null) {
            return;
        }
        if (!this.registered) {
            if (p instanceof ClientRegistrationRsp) {
                ClientRegistrationRsp rsp = (ClientRegistrationRsp)p;
                if (!rsp.registerFailed()) {
                    this.clientID = rsp.getClientID();
                    this.registered = true;
                }
                this.registerAnswered = true;
            }
        } else {
            Packet rsp;
            if (p instanceof Connect) {
                this.connected = true;
                rsp = (Connect)p;
                this.sessionID = rsp.getSessionID();
                if (((Connect)rsp).getDescriptors().size() > 0) {
                    this.mtaPort = ((Connect)rsp).getDescriptors().get(0).getMTAPort();
                } else {
                    this.logger.warn("Could not read descriptors. New MTA Port not available for " + this);
                    this.logger.warn("Last MTA Port was " + this.mtaPort);
                }
            }
            if (p instanceof ClientUnregister) {
                rsp = (ClientUnregister)p;
                if (((ClientUnregister)rsp).getStatus() != 1) {
                    this.logger.warn("ClientUnregister failed for ");
                }
                if (!this.expectUnregister) {
                    this.logger.warn("Closing connection, because camera sent an Unregistered command [" + rsp + "]");
                    this.closeConnection();
                } else {
                    this.expectUnregister = false;
                }
            } else if (p instanceof Disconnect) {
                this.logger.info(Basic.byteArrayToHexString((byte[])data));
                this.sendRCPDataPacket(p);
                this.closeConnection();
            }
        }
    }

    @Override
    public void onNetworkError(int error) {
        this.logger.warn("Network error for " + this);
        this.closeConnection();
    }

    private void sendAudio(byte[] audioData) throws IOException {
        byte[] rcpHeader = new byte[12];
        byte[] countingBytes = Basic.int4ToByteArray((int)this.counter++);
        rcpHeader[0] = -128;
        rcpHeader[8] = -1;
        rcpHeader[9] = -1;
        rcpHeader[10] = -1;
        rcpHeader[11] = -1;
        System.arraycopy(countingBytes, 2, rcpHeader, 2, 2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(rcpHeader);
        baos.write(audioData);
        DatagramPacket datagramPacket = new DatagramPacket(baos.toByteArray(), baos.size(), InetAddress.getByName(this.networkParameter.getHost()), this.mtaPort);
        this.udpSocket.send(datagramPacket);
    }

    @Override
    public void run() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        int length = 640;
        int interval = 80;
        int keepAliveInterval = 3000;
        long time = Long.MIN_VALUE;
        long timeForKeepAlive = System.currentTimeMillis();
        boolean keepAliveCounter = false;
        while (!this.isShutdown) {
            try {
                MediaFrame mediaFrameToSend = this.take();
                if (!this.streamRunning) {
                    this.establishStream();
                }
                if (System.currentTimeMillis() - timeForKeepAlive > (long)keepAliveInterval) {
                    Retrigger retrigger = new Retrigger();
                    retrigger.setSessionID(this.sessionID);
                    retrigger.setReserved((byte)(keepAliveCounter ? 1 : 0));
                    retrigger.setDataType((byte)8);
                    retrigger.setClientID(this.clientID);
                    this.sendRCPDataPacket(retrigger);
                    timeForKeepAlive = System.currentTimeMillis();
                }
                for (byte[] singlePayLoad : mediaFrameToSend.getPayload()) {
                    baos.write(singlePayLoad);
                    if (baos.size() < length) continue;
                    byte[] buffer = baos.toByteArray();
                    byte[] payload = new byte[length];
                    System.arraycopy(buffer, 0, payload, 0, length);
                    baos.reset();
                    baos.write(buffer, length, buffer.length - length);
                    if (time != Long.MIN_VALUE && System.currentTimeMillis() - time < (long)interval) {
                        Thread.sleep((long)interval - (System.currentTimeMillis() - time));
                    }
                    time = System.currentTimeMillis();
                    this.sendAudio(payload);
                }
            }
            catch (Exception exception) {
                this.logger.info("Exception while sending audio for " + this + " : " + exception.getMessage());
                this.closeConnection();
            }
        }
        this.logger.info("Shutting down " + this);
    }

    public String toString() {
        String toString = "Audio out server [Host=[" + this.networkParameter.getHost() + "], " + (!this.networkParameter.useHTTPS() ? "HTTP port=[" + this.networkParameter.getHTTPport() : "HTTPS port=[" + this.networkParameter.getSSLport()) + "]]";
        return toString;
    }

    public int closeConnection() {
        this.streamRunning = false;
        if (this.clientID != null && this.sessionID != null) {
            ClientUnregister clientUnregister = new ClientUnregister();
            clientUnregister.setClientID(this.clientID);
            clientUnregister.setSessionID(this.sessionID);
            this.sendRCPDataPacket(clientUnregister);
            this.expectUnregister = true;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ioe) {
                this.logger.warn("Error closing socket for " + this + " : " + ioe.getMessage());
            }
            this.socket = null;
        }
        if (this.udpSocket != null) {
            try {
                this.udpSocket.close();
            }
            catch (Exception ioe) {
                this.logger.warn("Error closing UDP Socket for " + this + " : " + ioe.getMessage());
            }
            this.udpSocket = null;
        }
        if (this.rcpReader != null) {
            this.rcpReader.shutdown();
            this.rcpReader = null;
        }
        if (this.rcpWriter != null) {
            this.rcpWriter.shutdown();
            this.rcpWriter = null;
        }
        return 0;
    }

    @Override
    public int shutdown() {
        this.isShutdown = true;
        this.closeConnection();
        this.thread.interrupt();
        return super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishStream() {
        if (!this.semaphore.tryAcquire()) {
            this.logger.info("Cannot aquire [semaphore] for " + this);
            return;
        }
        try {
            InputStream inStream = null;
            OutputStream outStream = null;
            this.registered = false;
            try {
                this.socket = new Socket(this.networkParameter.getHost(), 1756);
                this.socket.setSoTimeout(10000);
                inStream = this.socket.getInputStream();
                outStream = this.socket.getOutputStream();
            }
            catch (Exception e) {
                this.logger.error("Cannot connect to " + this.networkParameter.getHost() + ":" + 1756);
            }
            this.rcpReader = new TpktStreamReader();
            this.rcpReader.init(inStream, this);
            this.rcpWriter = new TpktStreamWriter(outStream, this);
            ClientRegistrationReq req = new ClientRegistrationReq();
            String passphrase = BoschCameraSrv.createPassphrase(this.networkParameter);
            req.setPass(passphrase);
            req.setNumericDescriptorAsInt(1);
            this.registerAnswered = false;
            this.sendRCPDataPacket(req);
            while (!this.registerAnswered) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    this.logger.warn("Exception while waiting for RCP answer for " + this + ex.getMessage());
                }
            }
            Connect connect = new Connect();
            connect.setClientID(this.clientID);
            MediaDescriptor desc = new MediaDescriptor();
            desc.setMethodPut();
            desc.setMediaAudio();
            desc.setMEP((byte)1);
            desc.setCoder((byte)0);
            desc.setLine((byte)1);
            desc.setCoding(new byte[]{0, 1});
            connect.addDescriptor(desc);
            this.connected = false;
            this.sendRCPDataPacket(connect);
            while (!this.connected) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    this.logger.warn("Exception while waiting for RCP answer for " + this + ex.getMessage());
                }
            }
            try {
                this.udpSocket = new DatagramSocket();
                this.udpSocket.setSoTimeout(10000);
            }
            catch (Exception e) {
                this.logger.error("Cannot connect to " + this.networkParameter.getHost() + ":" + 1756);
            }
            this.streamRunning = true;
        }
        catch (Exception ex) {
            this.logger.warn("Exception while starting Audio Out Server for " + this + ": " + ex.getMessage());
        }
        finally {
            this.semaphore.release();
        }
    }

    public void sendRCPDataPacket(Packet p) {
        if (this.rcpWriter != null) {
            this.rcpWriter.send(p.serialize());
        } else {
            this.streamRunning = false;
        }
    }

    private boolean isShutdown() {
        return this.isShutdown;
    }
}

