/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.basler.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.video.basler.BaslerDevice;
import de.seetec.v5.re.cm.device.video.basler.BaslerHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.basler.BaslerMotionDetectionHandler;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Map;

public class BaslerJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.basler.jpeg.BaslerJPEGVideoSourceClient";
    private HttpServerPushHandler httpServerPushHandler = null;
    private long streamID = 1L;
    private long fps = Long.MIN_VALUE;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        Hashtable<String, String> htParameters = new Hashtable<String, String>();
        String outputScale = null;
        int errorCode = 0;
        this.logger.info("init started for" + this.getVideoSrv());
        errorCode = super.init(false);
        if (errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
            return errorCode;
        }
        this.quality /= 1000;
        this.quality = this.quality <= 0 ? 1 : this.quality;
        this.fps = this.highestFramerate / 1000L;
        if (this.resolutionTag == null) {
            this.logger.info("ResolutionTag not set in configuration for " + this);
            this.logger.info("OutputScale 1:1 will be used for " + this);
            outputScale = "Scale_1_1";
        } else if (this.resolutionTag.length() == 0) {
            this.logger.info("ResolutionTag not set in configuration for " + this);
            this.logger.info("OutputScale 1:1 will be used for " + this);
            outputScale = "Scale_1_1";
        } else if ("1:1".equalsIgnoreCase(this.resolutionTag)) {
            outputScale = "Scale_1_1";
        } else if ("1:2".equalsIgnoreCase(this.resolutionTag)) {
            outputScale = "Scale_1_2";
        } else if ("1:4".equalsIgnoreCase(this.resolutionTag)) {
            outputScale = "Scale_1_4";
        } else if ("1:8".equalsIgnoreCase(this.resolutionTag)) {
            outputScale = "Scale_1_8";
        } else {
            this.logger.warn("Unknwon resolutionTag '" + this.resolutionTag + "' given  for " + this);
            outputScale = "Scale_1_1";
        }
        this.logger.info("Stream: " + this.streamID + ": Image parameter: Q=" + this.quality + ", fps=" + this.fps + ", res=" + outputScale);
        htParameters.put("_1", "JPEG");
        htParameters.put("_2", "" + this.quality);
        htParameters.put("_3", "VBR");
        try {
            if (this.getVideoSrv().getVideoSourceCnf().isTimeDateEnabled()) {
                htParameters.put("_4", URLEncoder.encode("$date$", "UTF-8"));
            } else {
                htParameters.put("_4", "\n");
            }
        }
        catch (Exception e) {
            this.logger.error("Error while filling htParameters for " + this.getVideoSrv(), (Throwable)e);
            return -21651;
        }
        htParameters.put("_5", outputScale);
        htParameters.put("_6", "ROT_" + this.rotationAngle);
        int numberOfCorrectSetting = 0;
        try {
            String requestUrl = "/cgi-bin/param_if.cgi?NumActions=7&Action_0=Stream.StreamSelector.SetValue&Parameter_0_0=" + this.streamID + "&Action_1=Stream.EncoderType.GetValue&Action_2=Stream.Quality.GetValue&Action_3=Stream.EncoderMode.GetValue&Action_4=Stream.OverlayText.GetValue&Action_5=Stream.OutputScaling.GetValue&Action_6=Sensor.ImageRotation.GetValue";
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)requestUrl, (int)Integer.MAX_VALUE);
            String resultAsString = new String(result);
            for (Map.Entry entry : htParameters.entrySet()) {
                String searchString = "Return" + (String)entry.getKey() + "=" + (String)entry.getValue();
                searchString = searchString.endsWith("\n") ? searchString : searchString + "\n";
                if (!resultAsString.contains(searchString)) continue;
                ++numberOfCorrectSetting;
            }
        }
        catch (Exception e) {
            this.logger.error("Error while reading parameters for " + this.getVideoSrv(), (Throwable)e);
            return -21651;
        }
        if (numberOfCorrectSetting == 6) {
            this.logger.info("All parameteres already set up for " + this.getVideoSrv());
        } else {
            StringBuilder parameterUrl = new StringBuilder("/cgi-bin/param_if.cgi?NumActions=7");
            parameterUrl.append("&Action_0=Stream.StreamSelector.SetValue&Parameter_0_0=");
            parameterUrl.append(this.streamID);
            parameterUrl.append("&Action_1=Stream.EncoderType.SetValue&Parameter_1_0=");
            parameterUrl.append((String)htParameters.get("_1"));
            parameterUrl.append("&Action_2=Stream.Quality.SetValue&Parameter_2_0=");
            parameterUrl.append((String)htParameters.get("_2"));
            parameterUrl.append("&Action_3=Stream.EncoderMode.SetValue&Parameter_3_0=");
            parameterUrl.append((String)htParameters.get("_3"));
            try {
                if (this.getVideoSrv().getVideoSourceCnf().isTimeDateEnabled()) {
                    htParameters.put("_4", URLEncoder.encode("$date$", "UTF-8"));
                } else {
                    htParameters.put("_4", "");
                }
            }
            catch (Exception e) {
                this.logger.error("Error while filling htParameters for " + this.getVideoSrv(), (Throwable)e);
            }
            parameterUrl.append("&Action_4=Stream.OverlayText.SetValue&Parameter_4_0=");
            parameterUrl.append((String)htParameters.get("_4"));
            parameterUrl.append("&Action_5=Stream.OutputScaling.SetValue&Parameter_5_0=");
            parameterUrl.append((String)htParameters.get("_5"));
            parameterUrl.append("&Action_6=Sensor.ImageRotation.SetValue&Parameter_6_0=");
            parameterUrl.append((String)htParameters.get("_6"));
            if (this.getVideoSrv() != null && this.getVideoSrv().getDevice() != null && (errorCode = ((BaslerDevice)this.getVideoSrv().getDevice()).setParameter(parameterUrl.toString())) != 0) {
                this.logger.error("Error '" + errorCode + "' setting parameters for " + this);
                return -20000;
            }
        }
        try {
            Thread.sleep(800L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return errorCode;
    }

    @Override
    public void run() {
        int errorCode = 0;
        super.setRunFinished(CLASS_NAME, false);
        try {
            BaslerJPEGVideoSourceClient listener = this;
            this.networkParameter.setSoTimeout(5000);
            boolean bAsynchronous = false;
            this.httpServerPushHandler = new HttpServerPushHandler();
            StringBuilder url = new StringBuilder("/cgi-bin/mjpeg?stream=");
            url.append(this.streamID);
            url.append("&mode=live");
            url.append("&fps=");
            url.append(this.fps);
            url.append("&prio=high");
            errorCode = this.httpServerPushHandler.init(listener, this.networkParameter, url.toString());
            if (errorCode != 0) {
                this.logger.error("Error [" + errorCode + "]with " + this.httpServerPushHandler);
            } else {
                errorCode = this.httpServerPushHandler.startServerPush(bAsynchronous);
                if (errorCode != 0) {
                    this.logger.warn("ServerPush of " + this.httpServerPushHandler + " terminated with error [" + errorCode + "]");
                }
            }
            this.httpServerPushHandler.shutdown();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            errorCode = -21651;
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public void setStreamID(long streamID) {
        this.streamID = streamID;
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.listener.notifyForNetworkProblems();
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        byte[] contentData = httpServerPushContent.getContentBody();
        if (contentData != null) {
            byte[] FFE1Header = new byte[]{-1, -31};
            byte[] MOTIONTAG = new byte[]{77, 111, 116, 105, 111, 110, 61};
            int index = -1;
            index = Basic.indexOfByteArray((byte[])contentData, (byte[])FFE1Header, (int)0, (int)300);
            if (index != -1 && (index = Basic.indexOfByteArray((byte[])contentData, (byte[])MOTIONTAG, (int)index, (int)(contentData.length - index))) != -1 && Basic.indexOfByteArray((byte[])contentData, (byte[])new byte[]{10}, (int)index, (int)(contentData.length - index)) != -1) {
                byte[] motionData = new byte[5];
                System.arraycopy(contentData, index, motionData, 0, 5);
                if (this.listener.hasHardwareMotionDetection() && this.getVideoSrv().getHardwareMotionDetection() != null) {
                    ((BaslerMotionDetectionHandler)((Object)((BaslerHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processMotionDetection(motionData);
                }
            }
            MediaFrame mediaFrame = null;
            try {
                mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MJPEG, contentData, false);
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while creating video frame for " + this + " : " + ex.getMessage());
            }
            if (mediaFrame != null) {
                this.deliverFrameCreateServerTimestamp(0, mediaFrame);
            }
        }
    }
}

