/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.videosource;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperMpeg4;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisAPIVersion;
import de.seetec.v5.re.cm.device.video.axis.videosource.AxisAudioSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.util.Arrays;

public class AxisMPEGVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.axis.mpeg.AxisMPEGVideoSourceClient";

    @Override
    public int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        try {
            this.networkParameter = this.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Failed to get AxisDeviceNetworkParameter for " + this, (Throwable)ex);
            return -20000;
        }
        AxisDevice axisDevice = (AxisDevice)this.getVideoSrv().getDevice();
        this.fps = this.fps < 1000L ? 1000L : this.fps;
        this.iFrameDist = this.fps * (long)this.iFrameDistMS / 1000000L;
        this.iFrameDist = this.iFrameDist < 1L ? 1L : this.iFrameDist;
        this.compression /= 1000;
        this.fps /= 1000L;
        this.bandwidth /= 1024;
        if (this.isAudioEnabled) {
            StringBuilder url = AxisAudioSourceClient.generateAudioParameterURL(this.isAudioEnabled, this.audioCodec, this.audioBitrate, this.videoSourceNr, (AxisDevice)this.getVideoSrv().getDevice());
            try {
                String audioURL = url.toString().replace(" ", "%20");
                axisDevice.getHttpHandler().readGetRequest(audioURL);
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while setting Audio association for " + this.getVideoSrv(), (Throwable)ex);
                return ex.getErrorCode();
            }
            catch (Exception ex) {
                this.logger.error("Exception while setting Audio association for " + this.getVideoSrv(), (Throwable)ex);
                return -20001;
            }
        }
        try {
            this.errorCode = axisDevice.setRTSPPort(this.listener.getVideoSourceParameter().getRtspPort());
            if (this.errorCode != 0) {
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("RTSP port could not be read", (Throwable)ex);
        }
        String PARAMETERMIDDLEPART = "&root.Image.I";
        StringBuilder url = axisDevice.getAxisAPIVersion() == AxisAPIVersion.VERSION_2 ? new StringBuilder("/axis-cgi/admin/param.cgi?action=update&root.Image.I") : new StringBuilder("/axis-cgi/param.cgi?action=update&root.Image.I");
        url.append(this.videoSourceNr - 1);
        url.append(".MPEG.ConfigHeaderInterval=1");
        url.append("&root.Image.I");
        url.append(this.videoSourceNr - 1);
        if (this.resolutionTag != null && this.resolutionTag.trim().length() > 0) {
            url.append(".Appearance.Resolution=");
            url.append(this.resolutionTag.trim());
        } else {
            url.append(".Appearance.Resolution=");
            url.append(this.width);
            url.append("x");
            url.append(this.height);
        }
        url.append("&root.Image.I");
        url.append(this.videoSourceNr - 1);
        url.append(".Appearance.Compression=");
        url.append(this.compression);
        url.append("&root.Image.I");
        url.append(this.videoSourceNr - 1);
        url.append(".MPEG.ICount=1");
        url.append("&root.Image.I");
        url.append(this.videoSourceNr - 1);
        url.append(".MPEG.PCount=");
        url.append(this.iFrameDist);
        url.append("&root.Image.I");
        url.append(this.videoSourceNr - 1);
        if (this.isConstantBitrateUsed) {
            url.append(".RateControl.Mode=cbr");
            url.append("&root.Image.I");
            url.append(this.videoSourceNr - 1);
            url.append(".RateControl.MaxBitrate=");
            url.append(this.bandwidth);
        } else {
            url.append(".RateControl.Mode=vbr");
        }
        url.append("&root.Image.I");
        url.append(this.videoSourceNr - 1);
        url.append(".Stream.FPS=");
        url.append(this.fps);
        url.append("&root.Network.RTSP.Timeout=60");
        url.append("&root.Image.I");
        url.append(this.videoSourceNr - 1);
        url.append(".text.DateEnabled=");
        url.append(this.useDateTime ? "yes" : "no");
        url.append("&root.Image.I");
        url.append(this.videoSourceNr - 1);
        url.append(".text.ClockEnabled=");
        url.append(this.useDateTime ? "yes" : "no");
        url.append("&root.Image.I");
        url.append(this.videoSourceNr - 1);
        url.append(".Appearance.Rotation=");
        url.append(this.rotationAngle);
        url.append("&root.Image.I");
        url.append(this.videoSourceNr - 1);
        url.append(".text.TextEnabled=");
        url.append(this.useTitle ? "1" : "0");
        if (this.title != null && this.title.trim().length() > 0) {
            url.append("&root.Image.I");
            url.append(this.videoSourceNr - 1);
            url.append(".text.String=");
            url.append(this.title);
            url.append("&root.Image.I");
            url.append(this.videoSourceNr - 1);
            url.append(".text.Color=white");
            url.append("&root.Image.I");
            url.append(this.videoSourceNr - 1);
            url.append(".text.BGColor=black");
        }
        try {
            axisDevice.getHttpHandler().readGetRequest(url.toString());
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting initial parameters for " + this.getVideoSrv(), (Throwable)e);
            return e.getErrorCode();
        }
        catch (Exception e) {
            this.logger.error("Exception while setting initial parameters for " + this.getVideoSrv(), (Throwable)e);
            return -20001;
        }
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.rtspUrl = "rtsp://" + this.getHost() + (this.videoSourceNr == Integer.MIN_VALUE ? "/mpeg4/media.amp" : "/mpeg4/" + this.videoSourceNr + "/media.amp");
        this.rtspSettings = new RTSPStreamSettings();
        boolean useNewHttp = ((AxisDevice)this.videoSrv.getDevice()).useNewHttp;
        try {
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, "*", useNewHttp);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this, (Throwable)ex);
        }
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("RTSPHandler start failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while starting RTSP Handling for " + this.getVideoSrv() + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public synchronized void processData(byte[] data) {
        block17: {
            if (this.isShutdown()) {
                return;
            }
            if (data == null) {
                this.logger.error("Incoming data is null for " + this.getVideoSrv());
                return;
            }
            try {
                MediaFrame mediaFrame;
                try {
                    if (data.length >= 2 && data[0] == -128 && data[1] == -56) {
                        return;
                    }
                    this.checkForPacketLoss(data);
                    this.completeFrame.write(data, 12, data.length - 12);
                    this.completeFrame.flush();
                }
                catch (IOException e) {
                    this.logger.error("Error cummulating data for a frame.", (Throwable)e);
                }
                if (StreamingHelper.isFollowUp(data)) break block17;
                byte[] completeFrameAsByteArray = this.completeFrame.toByteArray();
                this.completeFrame.reset();
                int mediaType = StreamingHelperMpeg4.checkForMPEG4Part2MediaType(completeFrameAsByteArray);
                if (mediaType < 0) break block17;
                if (mediaType == 36) {
                    this.logger.info("!End of stream signal received! for " + this.getVideoSrv());
                    if (!this.isShutdown()) {
                        this.logger.info("End of Stream signal reached, but no shutdown,so retry.");
                        if (this.rtspHandler != null) {
                            this.rtspHandler.shutdown();
                        }
                        this.rtspHandler = null;
                        this.init();
                        this.enforceIFrame();
                    }
                    break block17;
                }
                if (mediaType == 33) {
                    int[] resolutionCheck = StreamingHelperMpeg4.extractMPEG4Part2Resolution(completeFrameAsByteArray);
                    if (resolutionCheck != null) {
                        this.width = resolutionCheck[0];
                        this.height = resolutionCheck[1];
                    }
                    int lengthOfConfigHeader = Integer.MIN_VALUE;
                    try {
                        for (int i = 0; i <= 64; ++i) {
                            if (completeFrameAsByteArray[i] != 0 || completeFrameAsByteArray[i + 1] != 0 || completeFrameAsByteArray[i + 2] != 1 || completeFrameAsByteArray[i + 3] != -77) continue;
                            lengthOfConfigHeader = i;
                            break;
                        }
                        if (lengthOfConfigHeader == Integer.MIN_VALUE) {
                            this.logger.warn("No start of I-Frame in an C/I-Frame found. Strange.");
                            this.logger.warn("Discard frame.");
                            return;
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn("Strange I-FRAME, shorter than 67 bytes.");
                        this.logger.warn("Discard frame.");
                        return;
                    }
                    this.configHeader = Arrays.copyOf(completeFrameAsByteArray, lengthOfConfigHeader);
                    mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MPEG4, this.width, this.height, completeFrameAsByteArray, this.configHeader);
                } else {
                    mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MPEG4, this.width, this.height, completeFrameAsByteArray);
                }
                long timestamp = this.calculateTimestampFromRTP(data, mediaType);
                this.deliverFrame(mediaType, mediaFrame, timestamp);
            }
            catch (Throwable t) {
                this.logger.error("Ignoring packet due to unexpected error: " + t.getMessage(), t);
            }
        }
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    private int enforceIFrame() {
        String enforceIFrameURL = "/axis-cgi/mpeg4/restart_stream.cgi?camera=" + this.videoSourceNr;
        try {
            ((AxisDevice)this.getVideoSrv().getDevice()).getHttpHandler().readGetRequest(enforceIFrameURL);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while restarting stream [" + this.errorCode + "] for " + this.getVideoSrv());
            return ex.getErrorCode();
        }
        catch (Exception ex) {
            this.logger.error("Exception while restarting stream [" + this.errorCode + "] for " + this.getVideoSrv());
            return -20001;
        }
        return 0;
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }
}

