/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.videosource;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.axis.AxisCameraSrv;
import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.re.cm.device.video.axis.videosource.AxisAudioSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.util.SeeTecException;

public class AxisH264VideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.axis.mpeg.AxisH264VideoSourceClient";
    private static final String BASE_URL = "/axis-media/media.amp";
    private static final String AXIS_H264_NO_PROFILE = "?videocodec=h264";
    private static final String AXIS_H264_MAIN_PROFILE = "?videocodec=h264&h264profile=main";
    private static final String AXIS_H264_HIGH_PROFILE = "?videocodec=h264&h264profile=high";
    private String baseParameter = null;
    private StringBuilder parameterStringBuilder = new StringBuilder();
    private AxisDevice axisDevice = null;
    private AxisCameraSrv axisCameraSrv = null;

    @Override
    public int init() {
        try {
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing [" + this.errorCode + "] for " + this);
                return this.errorCode;
            }
            this.networkParameter = this.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
            this.axisCameraSrv = (AxisCameraSrv)this.getVideoSrv();
            this.axisDevice = (AxisDevice)this.getVideoSrv().getDevice();
            try {
                this.axisCameraSrv.setChannelParameters(this.useTitle, this.title, this.useDateTime, this.rotationAngle);
            }
            catch (Exception ex) {
                this.logger.info("Could net set title and date/time over API. Will set them over RTSP command for " + this);
            }
            this.fps = this.fps < 1000L ? 1000L : this.fps;
            this.iFrameDist = this.fps * (long)this.iFrameDistMS / 1000000L;
            this.iFrameDist = this.iFrameDist < 1L ? 1L : this.iFrameDist;
            this.networkParameter.setSoTimeout(Math.max(this.networkParameter.getSoTimeout(), this.iFrameDistMS * 3));
            this.compression /= 1000;
            this.fps /= 1000L;
            this.bandwidth /= 1024;
            if (!this.isConstantBitrateUsed) {
                this.bandwidth = 0;
            } else if (this.bandwidth < 5) {
                this.bandwidth = 5;
            }
            if (!this.isHTTPTunneling && (this.errorCode = this.axisDevice.setRTSPPort(this.listener.getVideoSourceParameter().getRtspPort())) != 0) {
                return this.errorCode;
            }
            try {
                this.errorCode = this.axisCameraSrv.setViewAreas(this.listener);
                if (this.errorCode != 0) {
                    return this.errorCode;
                }
            }
            catch (Exception e) {
                this.logger.error("Exception while setting view area for " + this.axisCameraSrv, (Throwable)e);
                return -20001;
            }
            if (AxisDevice.isFisheyeCamera(this.axisDevice.getDeviceType())) {
                this.resolutionTag = this.axisCameraSrv.getNearestResolution(this.videoSourceNr, this.width, this.height);
            }
            if (this.resolutionTag != null && this.resolutionTag.trim().length() > 0) {
                this.parameterStringBuilder.append("&resolution=").append(this.resolutionTag.trim());
            } else {
                this.parameterStringBuilder.append("&resolution=").append(this.width).append("x").append(this.height);
            }
            this.parameterStringBuilder.append("&fps=").append(this.fps);
            this.parameterStringBuilder.append("&compression=").append(this.compression);
            this.parameterStringBuilder.append("&videokeyframeinterval=").append(this.iFrameDist);
            this.parameterStringBuilder.append("&videobitrate=").append(this.bandwidth);
            this.parameterStringBuilder.append("&camera=");
            if (((AxisDevice)this.getVideoSrv().getDevice()).getAxisDeviceParameters().isDewarpEnabled()) {
                this.parameterStringBuilder.append(this.videoSourceNr);
            } else if (this.videoSourceNr == 5 && !AxisDevice.isFisheyeCamera(this.axisDevice.getDeviceType())) {
                if (this.axisDevice.getDeviceCnf().getVirtualCameras().isEnabled()) {
                    this.parameterStringBuilder.append(this.videoSourceNr);
                } else {
                    this.parameterStringBuilder.append(this.axisDevice.getVideoSourceSpecifier(this.axisDevice.getAxisDeviceParameters(), this.videoSourceNr));
                }
            } else {
                this.parameterStringBuilder.append(this.videoSourceNr);
            }
            this.parameterStringBuilder.append("&clock=").append(this.useDateTime ? "1" : "0");
            this.parameterStringBuilder.append("&date=").append(this.useDateTime ? "1" : "0");
            this.parameterStringBuilder.append("&text=").append(this.useTitle ? "1" : "0");
            if (this.useTitle && this.title != null && this.title.trim().length() > 0) {
                this.parameterStringBuilder.append("&textstring=").append(this.title);
            }
            if (!((AxisDevice)this.getVideoSrv().getDevice()).getAxisDeviceParameters().canSourceImageRotation(this.videoSourceNr - 1)) {
                this.parameterStringBuilder.append("&rotation=").append(this.rotationAngle);
            }
            StringBuilder url = AxisAudioSourceClient.generateAudioParameterURL(this.isAudioEnabled, this.audioCodec, this.audioBitrate, this.videoSourceNr, (AxisDevice)this.getVideoSrv().getDevice());
            try {
                this.axisDevice.getHttpHandler().readGetRequest(url.toString());
            }
            catch (SeeTecException e) {
                this.logger.error("Exception [" + e.getErrorCode() + "|" + e.getMessage() + "] while setting Audio association for " + this.getVideoSrv(), (Throwable)e);
                return e.getErrorCode();
            }
            url = AxisAudioSourceClient.generateAudioSourceParameterURL(this.isAudioEnabled, this.videoSourceNr, (AxisDevice)this.getVideoSrv().getDevice());
            try {
                if (url.length() > 0) {
                    this.axisDevice.getHttpHandler().readGetRequest(url.toString());
                }
            }
            catch (SeeTecException e) {
                this.logger.error("Exception [" + e.getErrorCode() + "|" + e.getMessage() + "] while enabling/disabling Audio source. Will continue to start the stream anyway for " + this.getVideoSrv(), (Throwable)e);
            }
            if (this.videoCodec == Codec.H264) {
                try {
                    String result = this.axisDevice.getHttpHandler().readGetRequest("/axis-cgi/param.cgi?action=list&group=Properties.Image.H264.Profiles");
                    String h264ProfilesResult = result != null ? result.toLowerCase() : "";
                    this.baseParameter = !AxisDevice.isGenericDriver(this.videoSrv.getEntityType()) ? this.createProfilePartForStaticDrivers(h264ProfilesResult) : this.createProfilePartForSmartDriver(h264ProfilesResult, this.listener.getVideoSourceParameter().getMpegProfile());
                    try {
                        result = this.axisDevice.getHttpHandler().readGetRequest("/axis-cgi/view/param.cgi?action=update&root.Image.I0.MPEG.H264.PSEnabled=yes");
                        if (result != null && !result.toLowerCase().contains("ok")) {
                            this.logger.warn("Can't set flag PSEnabled to 'yes' to receive SPS data in the stream, for " + this);
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn("Setting flag PSEnabled failed: " + e.getMessage());
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Exception [" + e.getMessage() + "] while requesting coding capabilities for " + this);
                }
            } else {
                this.baseParameter = "?videocodec=h265";
            }
            this.respectEveryParameterSet = true;
            this.rtspUrl = "rtsp://" + this.getHost() + BASE_URL + this.baseParameter + this.parameterStringBuilder;
            this.rtspSettings = new RTSPStreamSettings();
            boolean useNewHttp = ((AxisDevice)this.videoSrv.getDevice()).useNewHttp;
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, "*", useNewHttp, true);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspSettings.disableBasicAuthentication();
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            if (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST) {
                this.rtspHandler.setAuthenticationMethod(101);
                this.rtspSettings.setReceiverReportsEnabled(false);
            }
            if ((this.errorCode = this.rtspHandler.start()) != 0) {
                this.logger.error("Starting RTSP Handler failed [" + this.errorCode + "] for " + this.getVideoSrv());
                return this.errorCode;
            }
            return 0;
        }
        catch (SeeTecException exception) {
            return exception.getErrorCode();
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    protected String createProfilePartForStaticDrivers(String h264ProfilesResult) {
        if (h264ProfilesResult != null && h264ProfilesResult.contains("main")) {
            return AXIS_H264_MAIN_PROFILE;
        }
        return AXIS_H264_NO_PROFILE;
    }

    protected String createProfilePartForSmartDriver(String h264ProfilesResult, MpegProfile configuredProfile) {
        if (configuredProfile == null || h264ProfilesResult == null) {
            return AXIS_H264_NO_PROFILE;
        }
        if (configuredProfile == MpegProfile.MAIN && h264ProfilesResult.contains("main")) {
            return AXIS_H264_MAIN_PROFILE;
        }
        if (configuredProfile == MpegProfile.HIGH && h264ProfilesResult.contains("high")) {
            return AXIS_H264_HIGH_PROFILE;
        }
        if (configuredProfile == MpegProfile.BASELINE && h264ProfilesResult.contains("baseline")) {
            return AXIS_H264_NO_PROFILE;
        }
        return AXIS_H264_NO_PROFILE;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        try {
            if (!this.isShutdown()) {
                this.logger.warn("Shutting down [" + error + "] for " + this);
                this.listener.sendStatusService(error);
                this.shutdown();
            }
        }
        catch (Throwable e) {
            this.logger.error("Exception [" + e.getMessage() + "] in onNetworkError for " + this, e);
        }
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.logger.error("Network problem from HTTPStreamHandler signalied. Shutting down.");
        this.shutdown();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        if (this.listener != null) {
            this.listener.sendStatusService(nStatusCode);
        } else {
            this.logger.error("Listener null for " + this);
        }
    }

    @Override
    public void processData(byte[] data) {
        ((AxisCameraSrv)this.getVideoSrv()).checkForSEIUserData(this.listener, data, true);
        this.processRtpData(data);
    }
}

