/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.utils;

import de.seetec.v5.re.cm.device.video.axis.utils.AxisQuery;
import de.seetec.v5.re.cm.device.video.axis.utils.Query;

public class AxisPtzControlQuery
extends AxisQuery {
    protected static final String PTZ_CONTROL = "/axis-cgi/com/ptz.cgi";
    protected static final String QUERY = "query";
    protected static final String QUERY_POSITION_VAL = "position";
    protected static final String QUERY_GET_ALL_PRESETS_VAL = "presetposall";
    protected static final String IR_CUT_FILTER = "ircutfilter";
    protected static final String IR_CUT_FILTER_AUTO_VAL = "auto";
    protected static final String SET_SERVER_PRESET_NAME = "setserverpresetname";
    protected static final String REMOVE_SERVER_PRESET_NAME = "removeserverpresetname";
    protected static final String GOTO_SERVER_PRESET_NAME = "gotoserverpresetname";
    protected static final String PTZ_ABSOLUTE_TILT = "tilt";
    protected static final String PTZ_ABSOLUTE_PAN = "pan";
    protected static final String PTZ_ABSOLUTE_ZOOM = "zoom";
    protected static final String PTZ_ABSOLUTE_SPEED = "speed";
    protected static final String PTZ_ABSOLUTE_FOCUS = "focus";
    protected static final String PTZ_RELATIVE_FOCUS = "rfocus";
    protected static final String PTZ_CONTINUOUS_FOCUS = "continuousfocusmove";
    protected static final String PTZ_AUTO_FOCUS = "autofocus";
    protected static final String PTZ_CONTINUOUS_PANTILT = "continuouspantiltmove";
    protected static final String PTZ_CONTINUOUS_ZOOM = "continuouszoommove";
    protected static final String PTZ_MOVE = "move";
    protected static final String PTZ_MOVE_HOME_VAL = "home";
    protected static final String PTZ_IMAGE_ROTATION = "imagerotation";
    protected static final String PTZ_CENTER = "center";
    protected static final String PTZ_IMAGE_WIDTH = "imagewidth";
    protected static final String PTZ_IMAGE_HEIGHT = "imageheight";
    protected static final String PTZ_AREA_ZOOM = "areazoom";
    protected static final String PTZ_IRIS = "iris";
    protected static final String PTZ_RELATIVE_IRIS = "riris";
    protected static final String PTZ_CONTINUOUS_IRIS = "continuousirismove";
    protected static final String PTZ_AUTO_IRIS = "autoiris";
    protected static final Integer DIVISOR_FOR_REDUCING_IRIS_VALUES_TO_500 = 10;

    AxisPtzControlQuery() {
        super(PTZ_CONTROL);
    }

    public AxisPtzControlQuery sid() {
        String seeTecID = Long.toHexString(System.currentTimeMillis() & 0xFFFFFFFFL);
        return this.sid(seeTecID);
    }

    public AxisPtzControlQuery sid(String sid) {
        return this.newParam("sid", sid);
    }

    public AxisPtzControlQuery camera(Integer cameraNumber) {
        if (cameraNumber == null) {
            return this.doNothing();
        }
        return this.newParam("camera", cameraNumber);
    }

    public AxisPtzControlQuery query(String queryValue) {
        return this.newParam(QUERY, queryValue);
    }

    public AxisPtzControlQuery queryPosition() {
        return this.newParam(QUERY, QUERY_POSITION_VAL);
    }

    public AxisPtzControlQuery queryGetAllPresets() {
        return this.newParam(QUERY, QUERY_GET_ALL_PRESETS_VAL);
    }

    public AxisPtzControlQuery irCutFilter(String value) {
        return this.newParam(IR_CUT_FILTER, value);
    }

    public AxisPtzControlQuery irCutFilterAuto() {
        return this.newParam(IR_CUT_FILTER, IR_CUT_FILTER_AUTO_VAL);
    }

    public AxisPtzControlQuery tilt(Integer tiltVal) {
        if (tiltVal == null) {
            return this;
        }
        return this.newParam(PTZ_ABSOLUTE_TILT, (double)tiltVal.intValue() / MILI_MULTIPLIER);
    }

    public AxisPtzControlQuery pan(Integer panVal) {
        if (panVal == null) {
            return this;
        }
        return this.newParam(PTZ_ABSOLUTE_PAN, (double)panVal.intValue() / MILI_MULTIPLIER);
    }

    public AxisPtzControlQuery zoom(Integer zoomVal) {
        if (zoomVal == null) {
            return this;
        }
        return this.newParam(PTZ_ABSOLUTE_ZOOM, zoomVal);
    }

    public AxisPtzControlQuery speed(Integer speedVal) {
        if (speedVal == null) {
            return this;
        }
        return this.newParam(PTZ_ABSOLUTE_SPEED, speedVal);
    }

    public AxisPtzControlQuery speedMax() {
        return this.newParam(PTZ_ABSOLUTE_SPEED, "100");
    }

    public AxisPtzControlQuery focus(Integer value) {
        return this.newParam(PTZ_ABSOLUTE_FOCUS, value / MILI_MULTIPLIER_INT);
    }

    public AxisPtzControlQuery relativeFocus(Integer value) {
        return this.newParam(PTZ_RELATIVE_FOCUS, value / MILI_MULTIPLIER_INT);
    }

    public AxisPtzControlQuery continuousFocus(Integer value) {
        value = value != null ? value : 0;
        return this.newParam(PTZ_CONTINUOUS_FOCUS, value / MILI_MULTIPLIER_INT);
    }

    public AxisPtzControlQuery autoFocus(String value) {
        return this.newParam(PTZ_AUTO_FOCUS, value);
    }

    public AxisPtzControlQuery continuousPanTilt(Integer panSpeedValue, Integer tiltSpeedValue) {
        panSpeedValue = panSpeedValue != null ? panSpeedValue : 0;
        tiltSpeedValue = tiltSpeedValue != null ? tiltSpeedValue : 0;
        return this.newParam(PTZ_CONTINUOUS_PANTILT, panSpeedValue / MILI_MULTIPLIER_INT + "," + tiltSpeedValue / MILI_MULTIPLIER_INT);
    }

    public AxisPtzControlQuery continuousZoom(Integer zoomSpeedValue) {
        zoomSpeedValue = zoomSpeedValue != null ? zoomSpeedValue : 0;
        return this.newParam(PTZ_CONTINUOUS_ZOOM, zoomSpeedValue / MILI_MULTIPLIER_INT);
    }

    public AxisPtzControlQuery move(String value) {
        return this.newParam(PTZ_MOVE, value);
    }

    public AxisPtzControlQuery moveHome() {
        return this.newParam(PTZ_MOVE, PTZ_MOVE_HOME_VAL);
    }

    public AxisPtzControlQuery center(Integer absolutX, Integer absolutY) {
        return this.newParam(PTZ_CENTER, absolutX + "," + absolutY);
    }

    public AxisPtzControlQuery imageRotation(Integer imageRotation) {
        return this.newParam(PTZ_IMAGE_ROTATION, imageRotation / MILI_MULTIPLIER_INT);
    }

    public AxisPtzControlQuery imageWidth(Integer imageWidth) {
        return this.newParam(PTZ_IMAGE_WIDTH, imageWidth);
    }

    public AxisPtzControlQuery imageHeight(Integer imageHeight) {
        return this.newParam(PTZ_IMAGE_HEIGHT, imageHeight);
    }

    public AxisPtzControlQuery areaZoom(Integer absolutX, Integer absolutY, Integer zoomFactor) {
        return this.newParam(PTZ_AREA_ZOOM, absolutX + "," + absolutY + "," + zoomFactor);
    }

    public AxisPtzControlQuery iris(Integer value) {
        return this.newParam(PTZ_IRIS, value / MILI_MULTIPLIER_INT);
    }

    public AxisPtzControlQuery relativeIris(Integer value) {
        return this.newParam(PTZ_RELATIVE_IRIS, value / DIVISOR_FOR_REDUCING_IRIS_VALUES_TO_500);
    }

    public AxisPtzControlQuery continuousIris(Integer value) {
        value = value != null ? value : 0;
        return this.newParam(PTZ_CONTINUOUS_IRIS, value / MILI_MULTIPLIER_INT);
    }

    public AxisPtzControlQuery autoIris(String value) {
        return this.newParam(PTZ_AUTO_IRIS, value);
    }

    public AxisPtzControlQuery setServerPresetName(String encodedPresetName) {
        return this.newParam(SET_SERVER_PRESET_NAME, encodedPresetName);
    }

    public AxisPtzControlQuery removeServerPresetName(String presetName) {
        return this.newParam(REMOVE_SERVER_PRESET_NAME, presetName);
    }

    public AxisPtzControlQuery gotoServerPresetName(String presetName) {
        return this.newParam(GOTO_SERVER_PRESET_NAME, presetName);
    }

    private AxisPtzControlQuery newParam(String name, Object value) {
        this.addParam(new Query.Parameter(name, String.valueOf(value)));
        return this;
    }

    private AxisPtzControlQuery doNothing() {
        return this;
    }
}

