/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.utils;

import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisSeries;
import de.seetec.v5.shared.util.SeeTecException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AxisFirmwareVersion {
    private static final Logger LOGGER = LogManager.getLogger(AxisFirmwareVersion.class);
    private final AxisDevice device;

    public AxisFirmwareVersion(AxisDevice axisDevice) throws SeeTecException {
        if (axisDevice == null) {
            throw new SeeTecException(-20002, "Parameter axisDevice is null");
        }
        this.device = axisDevice;
    }

    public String getFirmwareVersion() {
        try {
            String fw = this.device.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.Firmware.Version");
            if (fw != null) {
                return fw;
            }
        }
        catch (SeeTecException ex) {
            LOGGER.error("Exception [" + ex.getMessage() + "] for " + this.device);
        }
        return "<unknown>";
    }

    public Float getShortFirmwareVersion() {
        try {
            String fw = this.getFirmwareVersion();
            int indexOf = fw.indexOf("_");
            if (indexOf != -1) {
                fw = fw.substring(0, indexOf);
            }
            if ((indexOf = fw.indexOf("CVP-")) != -1) {
                fw = fw.substring(indexOf + 4);
            }
            while (fw.length() - fw.replaceAll("\\.", "").length() > 1) {
                fw = fw.substring(0, fw.lastIndexOf(46));
            }
            return Float.valueOf(Float.parseFloat(fw));
        }
        catch (NumberFormatException ex) {
            LOGGER.warn("Unable to read firmware version for " + this.device + " [ " + ex.getMessage() + "]");
            return null;
        }
    }

    public boolean isEventDataStreamSupported() {
        try {
            String metaDataAvailable = this.device.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.API.Metadata.Metadata");
            String metaDataVersion = this.device.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.API.Metadata.Version");
            float metaVersion = Float.parseFloat(metaDataVersion);
            Float fw = this.getShortFirmwareVersion();
            AxisSeries axisSeries = new AxisSeries(this.device.getAxisDeviceParameters().getDeviceParameterValue("root.Brand.ProdNbr"));
            if ((fw != null && (double)fw.floatValue() >= 5.5 || axisSeries.isASeries() || axisSeries.isCSeries()) && metaDataAvailable != null && metaDataAvailable.contains("yes") && (double)metaVersion >= 1.0) {
                return true;
            }
        }
        catch (SeeTecException ex) {
            LOGGER.error("Could not get parameters from the camera because of [" + ex.getErrorCode() + "|" + ex.getMessage() + "] for " + this.device);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Could not parse metaDataVersion as number because of " + ex.getMessage() + " for " + this.device);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage() + " for " + this.device);
        }
        return false;
    }

    public void checkFirmwareForGenericDriver() throws SeeTecException {
        String firmwareVersion = this.getFirmwareVersion();
        Float shortFirmwareVersion = this.getShortFirmwareVersion();
        boolean deviceIsAlright = false;
        try {
            AxisSeries axisSeries = new AxisSeries(this.device.getAxisDeviceParameters().getDeviceParameterValue("root.Brand.ProdNbr"));
            if (axisSeries.isASeries() || axisSeries.isCSeries()) {
                deviceIsAlright = true;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to get the series of device" + this.device + " [" + ex.getMessage() + "]");
        }
        if (firmwareVersion.contains("lfp") || shortFirmwareVersion != null && (double)shortFirmwareVersion.floatValue() >= 5.0) {
            deviceIsAlright = true;
        }
        if (!deviceIsAlright) {
            LOGGER.warn("Axis Smart Driver requires a newer Device Firmware Version for" + this.device);
            throw new SeeTecException(-21693, "Axis Smart Driver requires a newer Device Firmware Version.");
        }
    }

    public static boolean isFirmwareGreater(String firmwareA, String firmwareB) {
        String[] firmwareASeparated = firmwareA.split("\\.");
        String[] firmwareBSeparated = firmwareB.split("\\.");
        for (int i = 0; i < Math.min(firmwareASeparated.length, firmwareBSeparated.length); ++i) {
            try {
                int partFirmwareA = Integer.parseInt(firmwareASeparated[i]);
                int partFirmwareB = Integer.parseInt(firmwareBSeparated[i]);
                if (partFirmwareA <= partFirmwareB) continue;
                return true;
            }
            catch (NumberFormatException ex) {
                break;
            }
        }
        return false;
    }
}

