/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.utils;

import de.seetec.v5.re.cm.device.video.axis.utils.AxisDisk;
import de.seetec.v5.re.shared.ConfigurationElement;
import de.seetec.v5.re.shared.ConfigurationManager;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AxisDisksPropertiesCnfMgr
extends ConfigurationManager {
    private static final String DISKS_TAGNAME = "disks";
    private static final String DISK_TAGNAME = "disk";
    private final Logger logger = LogManager.getLogger((String)((Object)((Object)this)).getClass().getName());

    public int init(byte[] cnf) {
        if (cnf == null) {
            return -20000;
        }
        if (super.init(cnf) != 0) {
            this.logger.info("Could not use the given xml conf: " + Arrays.toString(cnf));
            return -20000;
        }
        return 0;
    }

    public int getNumberOfDisks() {
        return Integer.parseInt(this.getRootElement().getChild(DISKS_TAGNAME).getAttributeValue("numberofdisks"));
    }

    public AxisDisk getDisk(int index) throws SeeTecException {
        List disks = this.getRootElement().getChildren(DISKS_TAGNAME, DISK_TAGNAME);
        return new AxisDisk((ConfigurationElement)disks.get(index));
    }

    public AxisDisk getDisk(String diskId) throws SeeTecException {
        List disks = this.getRootElement().getChildren(DISKS_TAGNAME, DISK_TAGNAME);
        for (ConfigurationElement disk : disks) {
            if (!disk.getAttributeValue("diskid").equalsIgnoreCase(diskId)) continue;
            return new AxisDisk(disk);
        }
        return null;
    }
}

