/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.utils;

import de.seetec.v5.re.shared.ConfigurationElement;
import de.seetec.v5.shared.util.SeeTecException;

public class AxisDisk {
    private ConfigurationElement root;
    private static final String NAME_ATTR = "name";
    private static final String STATUS_ATTR = "status";
    private static final String TOTAL_SIZE_ATTR = "totalsize";
    private static final String FREE_SIZE_ATTR = "freesize";

    AxisDisk(ConfigurationElement disk) throws SeeTecException {
        if (disk == null) {
            throw new SeeTecException(-20002, "AxisDisk cannot accept null values.");
        }
        this.root = disk;
    }

    public String getName() {
        return this.root.getAttributeValue(NAME_ATTR);
    }

    public String getStatus() {
        return this.root.getAttributeValue(STATUS_ATTR);
    }

    public Long getTotalSize() {
        String attributeValue = this.root.getAttributeValue(TOTAL_SIZE_ATTR);
        if (attributeValue == null) {
            return 0L;
        }
        return Long.parseLong(attributeValue);
    }

    public Long getFreeSize() {
        String attributeValue = this.root.getAttributeValue(FREE_SIZE_ATTR);
        if (attributeValue == null) {
            return 0L;
        }
        return Long.parseLong(attributeValue);
    }

    public String toString() {
        return "AxisDisk\n\t{\n\tname = " + this.getName() + "\n\t" + TOTAL_SIZE_ATTR + " = " + this.getTotalSize() + "\n\t" + FREE_SIZE_ATTR + " = " + this.getFreeSize() + "\n\t" + STATUS_ATTR + " = " + this.getStatus() + "\n\t}";
    }
}

