/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.utils;

import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AxisDeviceParameters {
    private static final Logger LOGGER = LogManager.getLogger(AxisDeviceParameters.class);
    private static final String ENABLED = "yes";
    private final AxisDevice device;
    protected final Map<String, String> deviceParameters = new HashMap<String, String>();

    public AxisDeviceParameters(AxisDevice axisDevice) {
        this.device = axisDevice;
    }

    public String getDeviceParameterValue(String key) throws SeeTecException {
        return this.getDeviceParameterValue(key, false);
    }

    public String getDeviceParameterValue(String key, boolean fromDevice) throws SeeTecException {
        if (key == null) {
            throw new SeeTecException(-20002, "Paramter key is null for " + this.device);
        }
        if (fromDevice || this.getDeviceParameters().get(key) == null) {
            String[] keyHierarchy = key.split("\\.");
            String group = keyHierarchy.length >= 2 && keyHierarchy[0].equals("root") ? keyHierarchy[1] : "root";
            this.fillDeviceParametersFromDevice(group);
        }
        return this.getDeviceParameters().get(key);
    }

    public Map<String, String> getDeviceParameters() throws SeeTecException {
        return this.getDeviceParameters(false);
    }

    public Map<String, String> getDeviceParameters(boolean fromDevice) throws SeeTecException {
        if (fromDevice) {
            this.fillDeviceParametersFromDevice("root");
        }
        return this.deviceParameters;
    }

    protected void fillDeviceParametersFromDevice(String group) throws SeeTecException {
        String[] lines;
        long time = System.currentTimeMillis();
        String result = this.readDeviceParametersFromDevice(group);
        for (String line : lines = result.split("\n")) {
            String[] keyAndValue = line.split("=");
            if (keyAndValue.length != 2) continue;
            this.deviceParameters.put(keyAndValue[0], keyAndValue[1]);
        }
        LOGGER.debug(Basic.generateIndentedMultiLineLog((String)("Getting parameters [" + group + "] took " + (System.currentTimeMillis() - time) / 1000L + " sec for " + this.device)));
    }

    private String readDeviceParametersFromDevice(String group) throws SeeTecException {
        NetworkParameter axisNetworkParameter;
        try {
            axisNetworkParameter = this.device.getAxisNetworkParameter();
        }
        catch (ConfigurationException ex) {
            LOGGER.error("Could not read parameters from device" + this.device);
            throw new SeeTecException(-20000, ex.getMessage());
        }
        String result = "";
        try {
            result = this.device.getHttpHandler().readGetRequest("/axis-cgi/param.cgi?action=list&group=" + group);
        }
        catch (SeeTecException ex) {
            if (ex.getNetworkStatus() == HTTPStatusCode.HTTP_NOT_FOUND) {
                try {
                    result = this.device.getHttpHandler().readGetRequest("/axis-cgi/admin/param.cgi?action=list&group=" + group);
                }
                catch (Exception exception) {
                    LOGGER.warn("Unable to get device parameters for " + this.device + "[" + exception.getMessage() + "]");
                }
            }
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to get device parameters for " + this.device + "[" + ex.getMessage() + "]");
        }
        HTTPStatusCode httpStatusCode = NetworkHelper.getStatusCode((NetworkParameter)axisNetworkParameter, (String)result);
        if (httpStatusCode == HTTPStatusCode.HTTP_FOUND || httpStatusCode == HTTPStatusCode.HTTP_MOVED_PERMANENTLY) {
            LOGGER.error("Check if the device has activated https only. HTTP is not working for " + this.device);
            throw new SeeTecException(-20000, "Could not read parameters from device " + this.device);
        }
        return result;
    }

    public boolean isDewarpEnabled() throws SeeTecException {
        return ENABLED.equals(this.getDeviceParameterValue("root.Properties.Image.Dewarp"));
    }

    public String getSourceForView(int viewNumber) throws SeeTecException {
        return this.getDeviceParameterValue("root.Image.I" + viewNumber + ".Source");
    }

    public boolean canSourceImageRotation(int viewNumber) throws SeeTecException {
        String imageRotation = this.getDeviceParameterValue("root.ImageSource.I" + viewNumber + ".SourceRotation");
        boolean result = false;
        if (imageRotation != null && !imageRotation.isEmpty()) {
            try {
                result = imageRotation.equalsIgnoreCase(ENABLED);
            }
            catch (NumberFormatException ex) {
                result = false;
            }
        }
        return result;
    }

    public boolean isViewEnabled(int viewNumber) throws SeeTecException {
        return ENABLED.equals(this.getDeviceParameterValue("root.Image.I" + viewNumber + ".Enabled"));
    }

    public boolean isPtzEnabled() throws SeeTecException {
        return ENABLED.equals(this.getDeviceParameterValue("root.Properties.PTZ.PTZ"));
    }

    public boolean canAbsolutePan(int viewNumber) throws SeeTecException {
        return Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".AbsolutePan"));
    }

    public boolean canAbsoluteTilt(int viewNumber) throws SeeTecException {
        return Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".AbsoluteTilt"));
    }

    public boolean canAbsoluteZoom(int viewNumber) throws SeeTecException {
        return Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".AbsoluteZoom"));
    }

    public boolean canContinuousPan(int viewNumber) throws SeeTecException {
        return Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".ContinuousPan"));
    }

    public boolean canContinuousTilt(int viewNumber) throws SeeTecException {
        return Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".ContinuousTilt"));
    }

    public boolean canContinuousZoom(int viewNumber) throws SeeTecException {
        return Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".ContinuousZoom"));
    }

    public boolean canContinuousFocus(int viewNumber) throws SeeTecException {
        return Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".ContinuousFocus"));
    }

    public boolean canRelativeFocus(int viewNumber) throws SeeTecException {
        return Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".RelativeFocus"));
    }

    public boolean canAutoFocus(int viewNumber) throws SeeTecException {
        return Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".AutoFocus"));
    }

    public boolean canContinuousIris(int viewNumber) throws SeeTecException {
        return Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".ContinuousIris"));
    }

    public boolean canRelativeIris(int viewNumber) throws SeeTecException {
        return Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".RelativeIris"));
    }

    public boolean canAutoIris(int viewNumber) throws SeeTecException {
        return Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".AutoIris"));
    }

    public boolean canIrCutFilter(int viewNumber) throws SeeTecException {
        return Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".IrCutFilter"));
    }

    public boolean canAutoIrCutFilter(int viewNumber) throws SeeTecException {
        return Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".AutoIrCutFilter"));
    }

    public boolean canServerPreset(int viewNumber) throws SeeTecException {
        return Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".ServerPreset")) || Boolean.parseBoolean(this.getDeviceParameterValue("root.PTZ.Support.S" + viewNumber + ".DevicePreset"));
    }

    public Integer getMaxZoom(int viewNumber) throws SeeTecException {
        String maxZoomParam = this.getDeviceParameterValue("root.PTZ.Limit.L" + viewNumber + ".MaxZoom");
        return maxZoomParam == null ? null : Integer.valueOf(Integer.parseInt(maxZoomParam));
    }
}

