/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.utils;

import de.seetec.v5.re.cm.device.video.axis.utils.AxisResolution;
import de.seetec.v5.re.shared.ConfigurationElement;
import de.seetec.v5.re.shared.ConfigurationManager;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AxisCaptureModeCnfMgr
extends ConfigurationManager {
    private static final String GROUP = "group";
    private static final String NAME = "name";
    private final Logger logger = LogManager.getLogger((String)((Object)((Object)this)).getClass().getName());
    private String tagFound = null;

    public int init(byte[] cnf) {
        if (cnf == null) {
            return -20000;
        }
        if (super.init(cnf) != 0) {
            this.logger.info("Could not use the given file: " + Arrays.toString(cnf));
            return -20000;
        }
        return 0;
    }

    public String getTagFound() {
        return this.tagFound;
    }

    public String getCaptureModeValue(int width, int height, String resolution, int captureModeFPSmillis) {
        ConfigurationElement child = this.getRootElement().getChild(GROUP);
        if (child != null && child.getElement().getAttributeValue(NAME).equalsIgnoreCase("root") && (child = child.getChild(GROUP)) != null && child.getElement().getAttributeValue(NAME).equalsIgnoreCase("ImageSource") && (child = child.getChild(GROUP)) != null && child.getElement().getAttributeValue(NAME).equalsIgnoreCase("I0") && (child = child.getChild(GROUP)) != null) {
            boolean validTagFound = false;
            if (child.getElement().getAttributeValue(NAME).equalsIgnoreCase("Sensor")) {
                validTagFound = true;
                this.tagFound = "Sensor";
            } else if (child.getElement().getAttributeValue(NAME).equalsIgnoreCase("Video")) {
                validTagFound = true;
                this.tagFound = "Video";
            }
            if (validTagFound && (child = child.getChild("parameter")) != null && child.getElement().getAttributeValue(NAME).equalsIgnoreCase("CaptureMode") && (child = child.getChild("type")) != null) {
                for (ConfigurationElement element : child.getChildren("enum", null)) {
                    boolean result;
                    String niceValue;
                    if (!element.getName().equals("entry") || (niceValue = element.getElement().getAttributeValue("niceValue")) == null || niceValue.isEmpty() || !(result = this.matchCaptureMode(niceValue, width, height, resolution, captureModeFPSmillis))) continue;
                    this.logger.debug(width + "x" + height + " " + (resolution != null ? resolution : "") + " @ " + String.valueOf(captureModeFPSmillis / 1000) + "fps fits to value '" + element.getElement().getAttributeValue("value") + "' for " + (Object)((Object)this));
                    return element.getElement().getAttributeValue("value");
                }
            }
        }
        return null;
    }

    protected boolean matchCaptureMode(String niceValue, int width, int height, String resolution, int captureModeFPSmillis) {
        String result;
        String res;
        boolean containsWidthAndHeight = false;
        boolean containsResolution = false;
        boolean containsFPS = false;
        boolean matchWidthAndHeight = false;
        boolean matchResolution = false;
        boolean matchFPS = false;
        String nice = niceValue.toLowerCase();
        if (nice.equals(res = resolution.toLowerCase())) {
            return true;
        }
        if (nice.contains("x")) {
            containsWidthAndHeight = true;
            if (nice.contains(width + "x" + height)) {
                matchWidthAndHeight = true;
            }
        }
        String[] parts = nice.split("@");
        if (nice.contains("hz") || nice.contains("fps") || parts.length > 1) {
            containsFPS = true;
            if (parts.length > 1 && parts[1].contains(String.valueOf(captureModeFPSmillis / 1000)) || nice.replace(" ", "").contains(String.valueOf(captureModeFPSmillis / 1000) + "fps") || nice.replace(" ", "").contains(String.valueOf(captureModeFPSmillis / 1000) + "hz")) {
                matchFPS = true;
            }
        }
        if (!res.isEmpty() && nice.contains(res)) {
            containsResolution = true;
            matchResolution = true;
        }
        if (!(parts.length < 1 || containsResolution || containsWidthAndHeight || (result = AxisResolution.getResolution(parts[0])).isEmpty())) {
            containsWidthAndHeight = true;
            if (result.contains(width + "x" + height)) {
                matchWidthAndHeight = true;
            }
        }
        return containsFPS ? matchFPS && (!containsResolution && !containsWidthAndHeight || containsResolution && matchResolution || containsWidthAndHeight && matchWidthAndHeight) : containsWidthAndHeight && matchWidthAndHeight || containsResolution && matchResolution;
    }
}

