/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.eventDom;

import de.seetec.v5.re.cm.device.video.axis.eventDom.SimpleItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;

public class Source {
    protected Logger logger = LogManager.getLogger((String)this.getClass().getName());
    public List<SimpleItem> simpleItems = new ArrayList<SimpleItem>();

    public Source(Node node) {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            try {
                this.simpleItems.add(new SimpleItem(node.getChildNodes().item(i)));
                continue;
            }
            catch (Exception e) {
                this.logger.debug("unable to build simpleItem Instance from Node: " + node + " " + e.getMessage());
            }
        }
    }

    public String getText(boolean linefeed) {
        StringBuilder builder = new StringBuilder();
        builder.append("<tt:Source>");
        if (linefeed) {
            builder.append("\n");
        }
        for (SimpleItem simpleItem : this.simpleItems) {
            builder.append(simpleItem.getText(linefeed));
        }
        builder.append("</tt:Source>");
        if (linefeed) {
            builder.append("\n");
        }
        return builder.toString();
    }

    public String getIdentifierString() {
        StringBuilder result = new StringBuilder("");
        for (SimpleItem simple : this.simpleItems) {
            result.append(simple.getIdentifierString());
        }
        return result.toString();
    }

    boolean hasNameValuePair(String name, String value) {
        for (SimpleItem simpleItem : this.simpleItems) {
            if (!simpleItem.getName().equals(name) || !simpleItem.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }
}

