/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.eventDom;

import de.seetec.v5.re.cm.device.video.axis.eventDom.Value;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;

public class SimpleItemInstance {
    protected Logger logger = null;
    private String name = null;
    private String niceName = null;
    private String type = null;
    private boolean isPropertyState;
    private ArrayList<Value> values = new ArrayList();

    public SimpleItemInstance(Node node) {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        if (node.getAttributes().getNamedItem("NiceName") != null) {
            this.niceName = node.getAttributes().getNamedItem("NiceName").getNodeValue();
        }
        if (node.getAttributes().getNamedItem("Name") != null) {
            this.name = node.getAttributes().getNamedItem("Name").getNodeValue();
        }
        if (this.name == null && this.niceName != null) {
            this.name = this.niceName;
        } else if (this.name == null && this.niceName == null) {
            throw new RuntimeException("Simple Instance is not named: " + node);
        }
        boolean bl = this.isPropertyState = node.getAttributes().getNamedItem("isPropertyState") != null && node.getAttributes().getNamedItem("isPropertyState").getNodeValue().equals("true");
        if (node.getAttributes().getNamedItem("Type") != null) {
            this.type = node.getAttributes().getNamedItem("Type").getNodeValue();
        }
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            try {
                this.values.add(new Value(node.getChildNodes().item(i)));
                continue;
            }
            catch (Exception e) {
                this.logger.debug("unable to add node as Value " + node.getChildNodes().item(i));
            }
        }
        if (node.getChildNodes().getLength() == 0 && this.type != null && this.type.equals("xsd:boolean")) {
            this.values.add(new Value(true));
            this.values.add(new Value(false));
        }
    }

    public boolean hasNiceName() {
        return this.niceName != null;
    }

    public String getNiceName() {
        return this.niceName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPropertyState() {
        return this.isPropertyState;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public String getText(boolean linefeed) {
        StringBuilder builder = new StringBuilder();
        builder.append("<SimpleItemInstance Name=\"").append(this.getName()).append("\"");
        if (this.hasNiceName()) {
            builder.append(" NiceName=\"").append(this.getNiceName()).append("\"");
        }
        if (this.type != null) {
            builder.append(" Type=\"").append(this.type).append("\"");
        }
        if (this.isPropertyState()) {
            builder.append(" isPropertyState=\"true\"");
        }
        builder.append(">");
        if (linefeed) {
            builder.append("\n");
        }
        for (Value value : this.values) {
            builder.append(value.getText(linefeed));
        }
        builder.append("</SimpleItemInstance>");
        if (linefeed) {
            builder.append("\n");
        }
        return builder.toString();
    }

    public List<String> getAllIdentifierString() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.values.isEmpty()) {
            list.add("");
            return list;
        }
        for (Value value : this.values) {
            list.add("|" + this.name + ":" + value.getValue());
        }
        return list;
    }
}

