/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.eventDom;

import de.seetec.v5.re.cm.device.video.axis.eventDom.DataInstance;
import de.seetec.v5.re.cm.device.video.axis.eventDom.SourceInstance;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.oasis_open.docs.wsn.t_1.TopicSetType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageInstance {
    protected String name;
    protected String nameNS;
    private boolean isProperty;
    private List<SourceInstance> sourceInstances = new ArrayList<SourceInstance>();
    private List<DataInstance> dataInstances = new ArrayList<DataInstance>();

    public boolean isStatefull() {
        return this.isProperty;
    }

    private boolean isProperty() {
        return this.isProperty;
    }

    public static List<String> getAllIdentifierFromContentString(String xml) {
        ArrayList<String> allIdentifier = new ArrayList<String>();
        List<MessageInstance> list = MessageInstance.getAllMessageInstanceFromContentString(xml);
        for (MessageInstance instance : list) {
            for (String identifier : instance.getAllIdentifierString()) {
                if (allIdentifier.contains(identifier)) continue;
                allIdentifier.add(identifier);
            }
        }
        return allIdentifier;
    }

    public static List<MessageInstance> getAllMessageInstanceFromTopicSet(TopicSetType ts) {
        ArrayList<MessageInstance> list = new ArrayList<MessageInstance>();
        for (Object test : ts.getAny()) {
            if (!(test instanceof Node)) continue;
            Node node = (Node)test;
            List<MessageInstance> templist = MessageInstance.getMessageFromAnyNodeTree(node, "", "");
            templist.stream().forEach(entry -> list.add((MessageInstance)entry));
        }
        return list;
    }

    public static List<MessageInstance> getAllMessageInstanceFromContentString(String xml) {
        Document doc;
        boolean dtdValidate = false;
        boolean xsdValidate = false;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(dtdValidate || xsdValidate);
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(stream);
        }
        catch (Exception e) {
            return new ArrayList<MessageInstance>();
        }
        return MessageInstance.getAllMessageInstanceFromAnyNodeTree(doc);
    }

    public static MessageInstance getMessageInstanceFromMessageInstanceXml(String xml) {
        Document doc;
        boolean dtdValidate = false;
        boolean xsdValidate = false;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(dtdValidate || xsdValidate);
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(stream);
        }
        catch (Exception e) {
            return null;
        }
        return new MessageInstance(doc.getChildNodes().item(0), "", "");
    }

    private static List<MessageInstance> getAllMessageInstanceFromAnyNodeTree(Node node) {
        if (node.getNodeName().equals("wstop:TopicSet")) {
            return MessageInstance.getAllMessageInstanceFromTopicSet(node);
        }
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            List<MessageInstance> m = MessageInstance.getAllMessageInstanceFromAnyNodeTree(node.getChildNodes().item(i));
            if (m == null) continue;
            return m;
        }
        return null;
    }

    private static List<MessageInstance> getAllMessageInstanceFromTopicSet(Node topicSet) {
        NodeList childs = topicSet.getChildNodes();
        ArrayList<MessageInstance> list = new ArrayList<MessageInstance>();
        for (int i = 0; i < childs.getLength(); ++i) {
            List<MessageInstance> templist = MessageInstance.getMessageFromAnyNodeTree(childs.item(i), "", "");
            for (MessageInstance entry : templist) {
                if (entry.name.startsWith("RuleEngine")) {
                    list.add(0, entry);
                    continue;
                }
                list.add(entry);
            }
        }
        return list;
    }

    public static List<MessageInstance> getMessageFromAnyNodeTree(Node item, String type, String typeNS) {
        ArrayList<MessageInstance> list = new ArrayList<MessageInstance>();
        String prefix = item.getPrefix();
        type = type + item.getLocalName();
        typeNS = typeNS + (prefix == null ? "" : prefix + ":") + item.getLocalName();
        NodeList childs = item.getChildNodes();
        if (item.getAttributes().getNamedItem("wstop:topic") != null || item.getAttributes().getNamedItem("topic") != null) {
            for (int i = 0; i < childs.getLength(); ++i) {
                list.add(new MessageInstance(childs.item(i), type, typeNS));
            }
        } else {
            for (int i = 0; i < childs.getLength(); ++i) {
                List<MessageInstance> templist = MessageInstance.getMessageFromAnyNodeTree(childs.item(i), type + "/", typeNS + "/");
                templist.stream().forEach(entry -> list.add((MessageInstance)entry));
            }
        }
        return list;
    }

    public MessageInstance(Node node, String eventName, String eventNameNS) {
        int i;
        this.name = eventName;
        this.nameNS = eventNameNS;
        this.isProperty = node.getAttributes().getNamedItem("aev:isProperty") != null && node.getAttributes().getNamedItem("aev:isProperty").getNodeValue().equals("true");
        NodeList childElements = node.getChildNodes();
        if (childElements.getLength() == 0) {
            return;
        }
        if (!childElements.item(0).getLocalName().equals("SourceInstance")) {
            for (i = 1; i < childElements.getLength() && !childElements.item(i).getLocalName().equals("SourceInstance"); ++i) {
            }
        }
        for (i = 0; i < childElements.getLength(); ++i) {
            if (childElements.item(i).getLocalName().equals("SourceInstance")) {
                this.sourceInstances.add(new SourceInstance(childElements.item(i)));
                continue;
            }
            this.dataInstances.add(new DataInstance(childElements.item(i)));
        }
    }

    public List<String> getAllIdentifierString() {
        return this.getAllIdentifierString(this.name);
    }

    public List<String> getAllIdentifierStringWithNS() {
        return this.getAllIdentifierString(this.nameNS);
    }

    private List<String> getAllIdentifierString(String eventType) {
        List<String> sourceStringList;
        ArrayList<String> listTemp;
        ArrayList<String> list = new ArrayList<String>();
        list.add(eventType);
        for (SourceInstance source : this.sourceInstances) {
            listTemp = new ArrayList<String>();
            for (String anfang : list) {
                sourceStringList = source.getAllIdentifierString();
                sourceStringList.stream().forEach(ende -> listTemp.add(anfang + ende));
            }
            list = listTemp;
        }
        for (DataInstance data : this.dataInstances) {
            listTemp = new ArrayList();
            for (String anfang : list) {
                sourceStringList = data.getAllIdentifierString();
                for (String ende2 : sourceStringList) {
                    listTemp.add(anfang + ende2);
                }
            }
            list = listTemp;
        }
        ArrayList<String> listTemp2 = new ArrayList<String>();
        for (String entry : list) {
            if (this.isProperty) {
                listTemp2.add(entry + "|isProperty:" + this.getPropertyAttributeName());
                continue;
            }
            listTemp2.add(entry + "|isProperty:false");
        }
        list = listTemp2;
        return list;
    }

    public String toString() {
        return this.getText(false);
    }

    public String getText(boolean linefeed) {
        StringBuilder builder = new StringBuilder();
        builder.append("<MessageInstance");
        if (this.isProperty()) {
            builder.append(" isProperty=\"true\"");
        }
        builder.append(">");
        if (linefeed) {
            builder.append("\n");
        }
        for (SourceInstance sourceInstance : this.sourceInstances) {
            builder.append(sourceInstance.getText(linefeed));
        }
        for (DataInstance dataInstance : this.dataInstances) {
            builder.append(dataInstance.getText(linefeed));
        }
        builder.append("</MessageInstance>");
        if (linefeed) {
            builder.append("\n");
        }
        return builder.toString();
    }

    private String getPropertyAttributeName() {
        for (DataInstance dataInstance : this.dataInstances) {
            String attributeName = dataInstance.getPropertyAttributeName();
            if (attributeName.equals("false")) continue;
            return attributeName;
        }
        return "false";
    }
}

