/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.eventDom;

import de.seetec.v5.re.cm.device.video.axis.eventDom.Data;
import de.seetec.v5.re.cm.device.video.axis.eventDom.Source;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Message {
    protected Logger logger = null;
    protected String name;
    private List<Source> sources = new ArrayList<Source>();
    private List<Data> datas = new ArrayList<Data>();

    public static Message getMessageFromXML(String xml) {
        try {
            boolean dtdValidate = false;
            boolean xsdValidate = false;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(dtdValidate || xsdValidate);
            ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(stream);
            return Message.getMessageFromAnyNodeTree(doc);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getTopicForMessageFromAnyNodeTree(Node node) {
        if (node.getNodeName().equals("wsnt:Topic")) {
            return node.getFirstChild().getNodeValue();
        }
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            String topic = Message.getTopicForMessageFromAnyNodeTree(node.getChildNodes().item(i));
            if (topic == null) continue;
            return topic;
        }
        return null;
    }

    public static Message getMessageFromAnyNodeTree(Node node) {
        String type = Message.getTopicForMessageFromAnyNodeTree(node);
        if (type == null) {
            return null;
        }
        return Message.getMessageFromAnyNodeTree(node, type);
    }

    private static Message getMessageFromAnyNodeTree(Node item, String type) {
        if (item.getNodeName().equals("tt:Message")) {
            return new Message(item, type);
        }
        for (int i = 0; i < item.getChildNodes().getLength(); ++i) {
            Message m = Message.getMessageFromAnyNodeTree(item.getChildNodes().item(i), type);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    public Message(Node node, String eventName) {
        int i;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        String[] eventTopicNames = eventName.split("/");
        for (i = 0; i < eventTopicNames.length; ++i) {
            String[] nameInstances = eventTopicNames[i].split(":");
            eventTopicNames[i] = nameInstances[nameInstances.length - 1];
        }
        this.name = eventTopicNames[0];
        for (i = 1; i < eventTopicNames.length; ++i) {
            this.name = this.name + "/" + eventTopicNames[i];
        }
        NodeList childElements = node.getChildNodes();
        if (!childElements.item(0).getLocalName().equals("Source")) {
            for (int i2 = 0; i2 < childElements.getLength() && !childElements.item(i2).getLocalName().equals("Source"); ++i2) {
            }
        }
        block11: for (int i3 = 0; i3 < childElements.getLength(); ++i3) {
            switch (childElements.item(i3).getLocalName()) {
                case "Source": {
                    this.sources.add(new Source(childElements.item(i3)));
                    continue block11;
                }
                case "Key": {
                    this.logger.debug("Key Found");
                    continue block11;
                }
                default: {
                    this.datas.add(new Data(childElements.item(i3)));
                }
            }
        }
    }

    public String getIdentifierString() {
        StringBuilder result = new StringBuilder(this.name);
        for (Source source1 : this.sources) {
            result.append(source1.getIdentifierString());
        }
        for (Data data : this.datas) {
            result.append(data.getIdentifierString());
        }
        return result.toString();
    }

    public String toString() {
        return this.getText(false);
    }

    public String getText(boolean linefeed) {
        StringBuilder builder = new StringBuilder();
        builder.append("<Message");
        builder.append(">");
        if (linefeed) {
            builder.append("\n");
        }
        for (Source source : this.sources) {
            builder.append(source.getText(linefeed));
        }
        for (Data data : this.datas) {
            builder.append(data.getText(linefeed));
        }
        builder.append("</Message>");
        if (linefeed) {
            builder.append("\n");
        }
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public boolean hasNameValuePair(String name, String value) {
        for (Source source : this.sources) {
            if (!source.hasNameValuePair(name, value)) continue;
            return true;
        }
        for (Data data : this.datas) {
            if (!data.hasNameValuePair(name, value)) continue;
            return true;
        }
        return false;
    }
}

