/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class AxisIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.axis.AxisIOHandler";
    private boolean useVapix3Api = false;
    private AxisDevice axisDevice = null;
    private int numberOfInputs = -1;

    @Override
    public int init(Core core, Device device, Entity[] srvEnities, boolean ignoreSomeParameter, boolean unconditionalStartOfThread) {
        int errorCode = super.init(core, device, srvEnities, ignoreSomeParameter, unconditionalStartOfThread);
        this.axisDevice = (AxisDevice)this.device;
        try {
            this.networkParameter = this.axisDevice.getAxisNetworkParameter();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Failed to get AxisDeviceNetworkParameter for " + this, (Throwable)ex);
            errorCode = -20000;
        }
        if (AxisDevice.isAxisNetworkIoModule(this.axisDevice.getDeviceType())) {
            String[] auth = new String[]{this.usr, this.pwd};
            this.networkParameter.setUserPWD(auth);
            this.networkParameter.setSoTimeout(5000);
            this.axisDevice.setAxisNetworkParameter(this.networkParameter);
            try {
                this.numberOfInputs = Integer.parseInt(this.axisDevice.getAxisDeviceParameters().getDeviceParameterValue("root.Input.NbrOfInputs"));
            }
            catch (SeeTecException ex) {
                this.logger.warn("Exception while trying to get number of inputs for " + this);
                return ex.getErrorCode();
            }
        }
        try {
            this.axisDevice.getAxisFirmwareVersion().checkFirmwareForGenericDriver();
            this.useVapix3Api = true;
        }
        catch (SeeTecException ex) {
            this.logger.debug("Using old VAPIX API because " + ex.getMessage() + " for " + this);
        }
        return errorCode;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean previousLoopWithError = false;
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                block21: {
                    try {
                        long duration;
                        long ts = System.currentTimeMillis();
                        this.readDigitalInputs();
                        if (previousLoopWithError) {
                            DigitalInputSrv[] iServices;
                            previousLoopWithError = false;
                            DigitalInputSrv[] digitalInputSrvArray = iServices = super.getDigitalInputSrv();
                            int n = digitalInputSrvArray.length;
                            for (int i = 0; i < n; ++i) {
                                DigitalInputSrv iService = digitalInputSrvArray[i];
                                if (!iService.getEntity().isEnabled().booleanValue()) continue;
                                iService.publishServiceStatus(iService.getInputStatus());
                            }
                            if (AxisDevice.isAxisNetworkIoModule(this.axisDevice.getDeviceType())) {
                                this.axisDevice.sendResolvedConnectionEvent(this.axisDevice.getDeviceID());
                            }
                        }
                        if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) break block21;
                        try {
                            Thread.sleep(200L - duration);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (Throwable ex) {
                        previousLoopWithError = true;
                        if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                            this.logger.warn("Network trouble for " + this);
                        } else if (ex.getMessage().contains("Address already in use")) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                        try {
                            DigitalInputSrv[] iServices = super.getDigitalInputSrv();
                            this.getCore().setEntityStatus(this.device.getDeviceEntity().getEntityID(), -20100);
                            for (DigitalInputSrv iService : iServices) {
                                if (!iService.getEntity().isEnabled().booleanValue()) continue;
                                iService.publishServiceStatus(-21603);
                            }
                            if (AxisDevice.isAxisNetworkIoModule(this.axisDevice.getDeviceType())) {
                                this.axisDevice.sendCannotEstablishConnectionLoggingEvent(-20100);
                            }
                        }
                        catch (Throwable t) {
                            this.logger.warn((Object)t, t);
                        }
                        long tsTimeout = System.currentTimeMillis() + 10000L;
                        while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
                this.getCore().setEntityStatus(this.device.getDeviceEntity().getEntityID(), 0);
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread finished of this " + this);
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private int readDigitalInputs() throws Exception {
        if (AxisDevice.isAxisNetworkIoModule(this.axisDevice.getDeviceType()) && this.numberOfInputs <= 0) {
            return 0;
        }
        String seeTecID = Long.toHexString(System.currentTimeMillis() & 0xFFFFFFFFL);
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        StringBuilder url = new StringBuilder(512);
        int counter = 0;
        url.append("/axis-cgi/io/input.cgi?check=");
        for (DigitalInputSrv iService : iServices) {
            if (iService.getServiceType() != 9801L && (iService.getServiceType() != 9804L || counter >= this.numberOfInputs)) continue;
            if (++counter > 1) {
                url.append(',');
            }
            url.append(iService.getInputNumber());
        }
        url.append("&sid=");
        url.append(seeTecID);
        String digitalInput = this.axisDevice.getHttpHandler().readGetRequest(url.toString());
        for (DigitalInputSrv iService : iServices) {
            int inputNumber = iService.getInputNumber();
            String key = "input" + inputNumber + "=";
            int index = digitalInput.indexOf(key);
            if (index < 0) continue;
            int value = Integer.parseInt(digitalInput.substring(index += key.length(), index + 1));
            iService.checkInput(value);
        }
        return 0;
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error("No digital output [" + outputNumber + "] service configured for " + this);
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Digital output value [" + value + "] is not valid for " + this);
            return -21601;
        }
        this.logger.info("Writing digital output value [" + value + "] to output [" + outputNumber + "] with HoldTime [" + holdTime + "] for " + this);
        String url = "/axis-cgi/io/output.cgi?action=" + outputNumber;
        try {
            if (this.useVapix3Api) {
                if (value > 0) {
                    url = url + ":/";
                    if (holdTime > 0L) {
                        url = url + holdTime + "\\";
                    }
                } else {
                    url = url + ":\\";
                }
            } else if (value > 0) {
                url = url + ":/";
                if (holdTime > 0L) {
                    url = url + holdTime + "\\\\";
                }
            } else {
                url = url + ":\\";
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.info(Basic.generateIndentedMultiLineLog((String)("Sending [" + url + "] for " + this)));
            }
            this.axisDevice.getHttpHandler().readGetRequest(url);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
            throw new RuntimeException("Cannot write value [" + value + "] to output [" + outputNumber + "] for " + this);
        }
        return 0;
    }
}

