/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis;

import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerCnf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.video.axis.AxisAlarmHandlerIntf;
import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.LteHostResolver;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.re.shared.VideoSourceParameter;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AxisEventReader
implements RTSPHandlerIntf {
    private RTSPHandlerSuper rtspHandler = null;
    private final Semaphore semaphore = new Semaphore(1);
    private NetworkParameter networkParameter = null;
    private final AxisDevice device;
    private final ReentrantReadWriteLock callbackLock = new ReentrantReadWriteLock();
    private final ArrayList<AxisAlarmHandlerIntf> callbacks = new ArrayList();
    private final List<GenericEventTriggerCnf> genericEventTriggerCnfs;
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private boolean isShutdown = false;

    public AxisEventReader(AxisDevice device, List<GenericEventTriggerCnf> genericEventTriggerCnfs) throws SeeTecException {
        this.device = device;
        if (this.device == null) {
            throw new SeeTecException(-20002, "Parameter null");
        }
        this.genericEventTriggerCnfs = genericEventTriggerCnfs;
        if (this.genericEventTriggerCnfs == null) {
            throw new SeeTecException(-20002, "Parameter null");
        }
        try {
            this.device.getAxisNetworkParameter().setHost(new LteHostResolver(this.device.getCore().getLTESupportConfiguration()).resolve(this.device.getAxisNetworkParameter().getHost()));
            this.networkParameter = NetworkParameterFactory.createNetworkParameter((NetworkParameter)this.device.getAxisNetworkParameter());
            this.networkParameter.setSoTimeout(10000);
            int errorCode = this.initAndStartRTSPHandler();
            if (errorCode != 0) {
                this.logger.error("Starting RTSP Handler failed [" + errorCode + "] for " + this);
                this.onNetworkError(errorCode);
            }
        }
        catch (ConfigurationException | SeeTecException ex) {
            this.logger.error(ex.getMessage() + " for " + this);
            this.onNetworkError(-21600);
        }
    }

    public void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        this.isShutdown = true;
        if (this.rtspHandler != null) {
            this.rtspHandler.shutdown();
            this.rtspHandler = null;
        }
    }

    @Override
    public void processData(byte[] data) {
        this.callbackLock.readLock().lock();
        try {
            this.callbacks.stream().forEach(callback -> callback.receiveAlarm(data));
        }
        finally {
            this.callbackLock.readLock().unlock();
        }
    }

    @Override
    public void onNetworkError(int errorCode) {
        this.callbackLock.readLock().lock();
        try {
            this.callbacks.stream().forEach(callback -> callback.onNetworkError(errorCode));
            if (this.semaphore.tryAcquire()) {
                this.reinitialize();
            }
        }
        finally {
            this.callbackLock.readLock().unlock();
        }
    }

    private boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public void sendStatusService(int statusCode) {
    }

    @Override
    public void sendDescribeResponse(RTSPResponse response) {
    }

    @Override
    public void setSSRCfromRTSP(String ssrc) {
    }

    private int initAndStartRTSPHandler() throws SeeTecException {
        try {
            Set<String> eventCnfSet = this.generateEventTopicFilter(this.genericEventTriggerCnfs);
            String rtspUrl = "rtsp://" + this.networkParameter.getHost() + "/axis-media/media.amp?video=0&audio=0&event=on&eventtopic=" + Tools.collectionJoin(eventCnfSet, "|");
            Entity[] entities = this.device.getSrvEntities();
            int rtspPort = 554;
            for (Entity entity : entities) {
                if (entity.getEntityType() != 212313L) continue;
                VideoSourceParameter videoSourceParameter = new VideoSourceParameter();
                videoSourceParameter.init(entity, null, "test", null);
                if (videoSourceParameter.getServerEntryNo() != 1) continue;
                rtspPort = videoSourceParameter.getRtspPort();
                break;
            }
            RTSPStreamSettings rtspStreamSettings = new RTSPStreamSettings();
            rtspStreamSettings.init(this, this.networkParameter, rtspPort, rtspUrl, false, TransmissionType.RTP_OVER_RTSP_OVER_TCP, this.networkParameter.getSoTimeout());
            rtspStreamSettings.setIsVideoEnabled(false);
            rtspStreamSettings.enableMetadata(this);
            rtspStreamSettings.setMetadataTimeout(0);
            rtspStreamSettings.setKeepAliveForTimeouts(this.device.keepAliveResponse);
            rtspStreamSettings.disableBasicAuthentication();
            this.rtspHandler = rtspStreamSettings.getRTSPHandler();
            return this.rtspHandler.start();
        }
        catch (SeeTecException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SeeTecException(-20000, e.getMessage());
        }
    }

    private void reinitialize() {
        new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (!AxisEventReader.this.isShutdown()) {
                        try {
                            int errorCode;
                            if (AxisEventReader.this.rtspHandler != null) {
                                AxisEventReader.this.rtspHandler.shutdown();
                            }
                            if ((errorCode = AxisEventReader.this.initAndStartRTSPHandler()) == 0) return;
                            AxisEventReader.this.logger.error("Reinitializing event stream for " + AxisEventReader.this.device + " failed [" + errorCode + "] Waiting " + AxisEventReader.this.networkParameter.getSoTimeout() / 1000 + " seconds");
                            Thread.sleep(AxisEventReader.this.networkParameter.getSoTimeout());
                        }
                        catch (Exception ex) {
                            AxisEventReader.this.logger.warn("Reinitializing event stream for " + AxisEventReader.this.device + " failed [" + ex.getMessage() + "]");
                            try {
                                Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
                            }
                            catch (Exception e) {
                                AxisEventReader.this.logger.debug("Error while sleeping.");
                            }
                        }
                    }
                    return;
                }
                finally {
                    AxisEventReader.this.semaphore.release();
                }
            }
        }, "AxisReInitializeTrigger " + this.device).start();
    }

    protected Set<String> generateEventTopicFilter(List<GenericEventTriggerCnf> genericEventTriggerCnfs) {
        int minimumTagLength = 3;
        String radarIdentifier = "RadarSource";
        String cameraApplicationPlatform = "CameraApplicationPlatform";
        String storageIdentifier = "Storage";
        String axisIdentifier = "axis:";
        String onvifIdentifier = "onvif:";
        String delimiter = "/";
        HashSet<String> eventCnfSet = new HashSet<String>();
        try {
            if (genericEventTriggerCnfs != null) {
                for (GenericEventTriggerCnf eventItem : genericEventTriggerCnfs) {
                    String eventType;
                    if (!eventItem.isEnabled() || (eventType = eventItem.getGenericEventTriggerType().split("\\|")[0]).length() <= 3) continue;
                    String[] eventTypeParts = eventType.split("/");
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < eventTypeParts.length; ++i) {
                        switch (i) {
                            case 0: {
                                sb.append(eventTypeParts[0].equals("Storage") || eventTypeParts[0].equals("RadarSource") || eventTypeParts[0].equals("CameraApplicationPlatform") ? "axis:" : "onvif:");
                                break;
                            }
                            case 1: {
                                sb.append("/");
                                if (eventTypeParts[0].equals("RadarSource")) break;
                                sb.append("axis:");
                                break;
                            }
                            default: {
                                sb.append("/");
                            }
                        }
                        sb.append(eventTypeParts[i]);
                    }
                    eventCnfSet.add(sb.toString());
                }
            }
        }
        catch (ConfigurationException e) {
            this.logger.error(e.getMessage() + " for " + this + " | " + this.device);
        }
        return eventCnfSet;
    }

    protected void deregister(AxisAlarmHandlerIntf callback) {
        this.callbackLock.writeLock().lock();
        try {
            this.callbacks.remove(callback);
        }
        finally {
            this.callbackLock.writeLock().unlock();
        }
    }

    protected void register(AxisAlarmHandlerIntf axisAlarmHandlerIntf) {
        this.callbackLock.writeLock().lock();
        try {
            this.callbacks.add(axisAlarmHandlerIntf);
        }
        finally {
            this.callbackLock.writeLock().unlock();
        }
    }
}

