/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis;

import de.seetec.v5.re.cm.configuration.definition.device.CameraResolutionType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceGroupMembershipsType;
import de.seetec.v5.re.cm.configuration.definition.device.ImageRotationCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.PtzCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedRotationAnglesType;
import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisDeviceParameters;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisResolution;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;

class AxisDeviceDefinitionHelper {
    private AxisDevice device;
    private Logger logger;
    private Map<Integer, Float> channelFramerateCache = new HashMap<Integer, Float>();

    AxisDeviceDefinitionHelper(AxisDevice device, Logger logger) {
        this.device = device;
        this.logger = logger;
    }

    List<CameraResolutionType> parseResolutionParam(String resolutionParam, float framerate) {
        String[] resolutions = resolutionParam.split(",");
        ArrayList<CameraResolutionType> resolutionTypeList = new ArrayList<CameraResolutionType>();
        String[] stringArray = resolutions;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String resolution;
            String newResolution = resolution = stringArray[i];
            if (!resolution.contains("x")) {
                newResolution = AxisResolution.getResolution(resolution);
            }
            String[] resolutionValues = newResolution.split("x");
            CameraResolutionType resolutionType = new CameraResolutionType();
            resolutionType.setDisplayResolution(newResolution);
            resolutionType.setWidth(Integer.parseInt(resolutionValues[0]));
            resolutionType.setHeight(Integer.parseInt(resolutionValues[1]));
            resolutionType.setMaxMilliFPS((int)(framerate * 1000.0f));
            resolutionType.setMinMilliFPS(1);
            resolutionType.setResolution(AxisResolution.getResolutionName(newResolution));
            resolutionType.setSupportedFrameRates(null);
            resolutionTypeList.add(resolutionType);
        }
        return resolutionTypeList;
    }

    float getFramerateForView(int viewNumber) {
        Float cachedFramerate = this.channelFramerateCache.get(viewNumber);
        if (cachedFramerate != null) {
            return cachedFramerate.floatValue();
        }
        float framerate = 60.0f;
        try {
            framerate = this.device.getMaxFramerate(viewNumber);
            this.logger.info("Max frame rate for current capture mode is " + framerate + "fps for " + this);
        }
        catch (ConfigurationException | SeeTecException ex) {
            this.logger.error("Error read max framerate [" + ex.getMessage() + "]. Stuck with default " + framerate + "fps for " + this);
        }
        this.channelFramerateCache.put(viewNumber, Float.valueOf(framerate));
        return framerate;
    }

    String getResolutionParamForView(int viewNumber) throws SeeTecException {
        AxisDeviceParameters deviceParams = this.device.getAxisDeviceParameters();
        String channelResolutionParam = deviceParams.getDeviceParameterValue("root.Properties.Image.I" + viewNumber + ".Resolution");
        if (channelResolutionParam == null) {
            String deviceResolutionParam = deviceParams.getDeviceParameterValue("root.Properties.Image.Resolution");
            if (deviceResolutionParam == null) {
                String errorMsg = "Could not retrieve resolutions parameter from device for " + this.device;
                this.logger.error(errorMsg);
                throw new SeeTecException(-20000, errorMsg);
            }
            channelResolutionParam = deviceResolutionParam;
        }
        return channelResolutionParam;
    }

    ImageRotationCapabilitiesType getImageRotationCapabilitiesForView(int viewNumber) throws SeeTecException {
        ImageRotationCapabilitiesType imageRotationCapabilities = new ImageRotationCapabilitiesType();
        String[] rotationAnglesArray = new String[]{"0"};
        String channelName = "I" + viewNumber;
        String channelRotationParam = this.device.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.Image." + channelName + ".Rotation");
        if (channelRotationParam != null) {
            rotationAnglesArray = channelRotationParam.split(",");
        } else {
            String deviceRotationParam = this.device.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.Image.Rotation");
            if (deviceRotationParam != null) {
                rotationAnglesArray = deviceRotationParam.split(",");
            }
        }
        SupportedRotationAnglesType supportedRotationAnglesType = new SupportedRotationAnglesType();
        for (String rotationAngle : rotationAnglesArray) {
            supportedRotationAnglesType.getInt().add(Integer.parseInt(rotationAngle.trim()) * 1000);
        }
        imageRotationCapabilities.setSupportedRotationAngles(supportedRotationAnglesType);
        boolean canRotate = rotationAnglesArray.length > 1;
        imageRotationCapabilities.setCanRotateJPEGImage(canRotate);
        imageRotationCapabilities.setCanRotateMPEGImage(canRotate);
        return imageRotationCapabilities;
    }

    DeviceGroupMembershipsType createDeviceGroupMembershipsTypeForView(int viewNumber) throws SeeTecException {
        String localStorageParameter;
        DeviceGroupMembershipsType deviceGroupMembershipsType = new DeviceGroupMembershipsType();
        deviceGroupMembershipsType.getDeviceGroups().add("GenericDriver");
        deviceGroupMembershipsType.getDeviceGroups().add("GenericEventTrigger");
        deviceGroupMembershipsType.getDeviceGroups().add("ShowSingleCaptureMode");
        deviceGroupMembershipsType.getDeviceGroups().add("PresetsImportable");
        deviceGroupMembershipsType.getDeviceGroups().add("ConfigurableVideoStreamNetworkTimeout");
        deviceGroupMembershipsType.getDeviceGroups().add("CameraAdministrationModifyPassword");
        deviceGroupMembershipsType.getDeviceGroups().add("CameraAdministrationUpgradeFirmware");
        String areaZoomParameter = this.device.getAxisDeviceParameters().getDeviceParameterValue("root.PTZ.Support.S" + (viewNumber + 1) + ".AreaZoom");
        if (areaZoomParameter != null && areaZoomParameter.equals("true")) {
            deviceGroupMembershipsType.getDeviceGroups().add("OpticalZoomAreaSupported");
        }
        if ((localStorageParameter = this.device.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.LocalStorage.LocalStorage")) != null && localStorageParameter.equals("yes")) {
            deviceGroupMembershipsType.getDeviceGroups().add("EdgeStorage");
            deviceGroupMembershipsType.getDeviceGroups().add("EdgeStorageVideoImport");
        }
        deviceGroupMembershipsType.getDeviceGroups().add("CheckDeviceInfos");
        return deviceGroupMembershipsType;
    }

    String getRtspCameraParam(int viewNumber) throws SeeTecException {
        String source;
        block3: {
            source = this.device.getAxisDeviceParameters().getSourceForView(viewNumber);
            if (source == null) {
                return null;
            }
            try {
                source = String.valueOf(Integer.parseInt(source) + 1);
            }
            catch (NumberFormatException e) {
                if ("quad".equals(source)) break block3;
                source = null;
            }
        }
        return source;
    }

    PtzCapabilitiesType createPtzCapabilitiesForView(int viewNumber) throws SeeTecException {
        int ptzChannelNumber = viewNumber + 1;
        AxisDeviceParameters deviceParam = this.device.getAxisDeviceParameters();
        if (!deviceParam.isPtzEnabled()) {
            String errorMsg = "Ptz is disabled for device " + this.device;
            this.logger.error(errorMsg);
            throw new SeeTecException(-20000, errorMsg);
        }
        PtzCapabilitiesType ptz = new PtzCapabilitiesType();
        ptz.setCanAbsolutePan(deviceParam.canAbsolutePan(ptzChannelNumber));
        ptz.setCanAbsoluteTilt(deviceParam.canAbsoluteTilt(ptzChannelNumber));
        ptz.setCanAbsoluteZoom(deviceParam.canAbsoluteZoom(ptzChannelNumber));
        ptz.setCanContinuousPan(deviceParam.canContinuousPan(ptzChannelNumber));
        ptz.setCanContinuousTilt(deviceParam.canContinuousTilt(ptzChannelNumber));
        ptz.setCanContinuousZoom(deviceParam.canContinuousZoom(ptzChannelNumber));
        ptz.setCanRelativePan(false);
        ptz.setCanRelativeTilt(false);
        ptz.setCanRelativeZoom(false);
        ptz.setCanCenterPT(true);
        ptz.setCanFocus(deviceParam.canContinuousFocus(ptzChannelNumber) || deviceParam.canRelativeFocus(ptzChannelNumber));
        ptz.setCanAutoFocus(deviceParam.canAutoFocus(ptzChannelNumber));
        ptz.setCanIris(deviceParam.canContinuousIris(ptzChannelNumber) || deviceParam.canRelativeIris(ptzChannelNumber));
        ptz.setCanAutoIris(deviceParam.canAutoIris(ptzChannelNumber));
        ptz.setCanNullLux(deviceParam.canIrCutFilter(ptzChannelNumber));
        ptz.setCanAutoNullLux(deviceParam.canAutoIrCutFilter(ptzChannelNumber));
        if (!ptz.isCanNullLux()) {
            boolean canImageSourceZeroLux = this.device.isSupportingImageSourceZeroLux(ptzChannelNumber);
            ptz.setCanNullLux(canImageSourceZeroLux);
            ptz.setCanAutoNullLux(canImageSourceZeroLux);
        }
        ptz.setCanPreset(deviceParam.canServerPreset(ptzChannelNumber));
        ptz.setMinPan(-180000);
        ptz.setMaxPan(180000);
        ptz.setMinTilt(0);
        ptz.setMaxTilt(90000);
        ptz.setMinZoom(0);
        ptz.setMaxZoom(100000);
        ptz.setMinAbsoluteZoom(0);
        Integer maxAbsoluteZoom = deviceParam.getMaxZoom(ptzChannelNumber);
        ptz.setMaxAbsoluteZoom(maxAbsoluteZoom == null ? 0 : maxAbsoluteZoom);
        ptz.setMinSpeed(0);
        ptz.setMaxSpeed(100000);
        ptz.setPTZMinContinuousLevel(10000);
        ptz.setPTZMaxContinuousLevel(100000);
        ptz.setPTZContinuousSpeedFactor(1000);
        return ptz;
    }
}

