/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis;

import de.seetec.v5.re.cm.configuration.definition.camera.FeaturesType;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecsType;
import de.seetec.v5.re.cm.configuration.definition.device.AvailableIOsType;
import de.seetec.v5.re.cm.configuration.definition.device.BitrateSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.CameraResolutionType;
import de.seetec.v5.re.cm.configuration.definition.device.CaptureModeDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.CodecType;
import de.seetec.v5.re.cm.configuration.definition.device.CommentsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceNetworkDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.EdgeStoragePlaybackSpeedType;
import de.seetec.v5.re.cm.configuration.definition.device.GenericEventDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.MiscVideoServerCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MultiStreamingDefinitionsType;
import de.seetec.v5.re.cm.configuration.definition.device.RtspSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.StreamDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedApiVersionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCameraResolutionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCaptureModesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedEdgeStoragePlaybackSpeedsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedMPEGProfileIDs;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedTransmissionTypeIDsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedVideoSourceEntityTypesType;
import de.seetec.v5.re.cm.configuration.definition.device.VideoSourceType;
import de.seetec.v5.re.cm.configuration.definition.device.VideoSourcesDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.VirtualCameraDefinitionType;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministration;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerCnf;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerDummy;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerHTTP;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.net.rtsp.SDPContent;
import de.seetec.v5.re.cm.device.shared.net.rtsp.request.DescribeRequest;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.video.axis.AxisCameraAdministration;
import de.seetec.v5.re.cm.device.video.axis.AxisDeviceDefinitionHelper;
import de.seetec.v5.re.cm.device.video.axis.AxisEventReader;
import de.seetec.v5.re.cm.device.video.axis.AxisIOHandler;
import de.seetec.v5.re.cm.device.video.axis.eventDom.MessageInstance;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisAPIVersion;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisCaptureModeCnfMgr;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisDeviceParameters;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisDisk;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisDisksPropertiesCnfMgr;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisFirmwareVersion;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisQuery;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisResolution;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisStorageQuery;
import de.seetec.v5.re.cm.device.video.axis.utils.Query;
import de.seetec.v5.re.cm.device.video.axis.utils.ResolutionComparator;
import de.seetec.v5.re.cm.device.video.axis.videosource.AxisPlaybackVideoSourceClient;
import de.seetec.v5.re.cm.shared.timerange.TimeRange;
import de.seetec.v5.re.shared.CameraOrientation;
import de.seetec.v5.re.shared.CnfDeviceCaptureMode;
import de.seetec.v5.re.shared.CnfDeviceVirtualCameras;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaID;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkHelperAdapter;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import de.seetec.v5.shared.net.SeetecHttpClient;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class AxisDevice
extends VideoServer {
    private static final String REQUEST_CAPTURE_MODES = "/axis-cgi/param.cgi?action=listdefinitions&listformat=xmlschema&group=ImageSource.I0.*.CaptureMode";
    private static final String MARKER = "%%";
    private static final String API_VERSION = "VAPIX Version 3";
    private static final int DEFAULT_VIEW = 0;
    private static volatile CameraAdministration CAMERA_ADMINISTRATION = null;
    public boolean enableSeiTrigger = true;
    public boolean useNewHttp = true;
    public boolean keepAliveResponse = false;
    protected AxisAPIVersion apiVersion = null;
    private AxisFirmwareVersion fwVersion = null;
    private final Object snycObj = new Object();
    private boolean isRTSPPortSet = false;
    private boolean isCameraOrientationSet = false;
    private boolean isInitDoneOnce = false;
    private final AxisDeviceDefinitionHelper axisDeviceDefinitionHelper = new AxisDeviceDefinitionHelper(this, this.logger);
    private NetworkParameter networkParameter = null;
    private AxisDeviceParameters deviceParameters = null;
    private AxisEventReader axisEventReader;
    private final Semaphore semaphore = new Semaphore(1);
    private SeetecHttpClient httpClient = new NetworkHelperAdapter();
    private HttpHandlerImpl httpHandler;

    @Override
    public int shutdown() {
        if (this.axisEventReader != null) {
            this.axisEventReader.shutdown();
        }
        return super.shutdown();
    }

    public static boolean isGenericDriver(long type) {
        return type == 212313L || type == 202334L;
    }

    public static boolean isFisheyeCamera(long type) {
        return type == 202325L || type == 202364L || type == 202375L;
    }

    public static boolean isAxisNetworkIoModule(long type) {
        return type / 100L == 2204L;
    }

    public static final int checkDeviceInfos(long type, String host, int port, boolean useAuthorization, String user, String pass, int timeout) {
        String[] stringArray;
        if (useAuthorization) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = user;
            stringArray = stringArray2;
            stringArray2[1] = pass;
        } else {
            stringArray = null;
        }
        NetworkParameter networkParameter = NetworkParameterFactory.createNetworkParameter((String)host, (int)port, (boolean)false, (int)-1, (int)timeout, stringArray);
        String cameraResponse = "";
        try {
            String url = "/axis-cgi/view/param.cgi?action=list&group=root.Brand.Brand";
            cameraResponse = new HttpHandlerImpl(networkParameter).readGetRequest("/axis-cgi/view/param.cgi?action=list&group=root.Brand.Brand");
        }
        catch (SeeTecException se) {
            return se.getNetworkStatus() == HTTPStatusCode.HTTP_UNAUTHORIZED ? -21701 : -21697;
        }
        catch (Exception ex) {
            return -21697;
        }
        return cameraResponse.contains("root.Brand.Brand=AXIS") ? 0 : -21697;
    }

    @Override
    public int initializeDevice(long srvType) {
        int errorCode = 0;
        this.logger.info(Basic.generateIndentedMultiLineLog((String[])new String[]{this.toString(), "Enable SEI trigger on camera (manual reboot required) = " + this.enableSeiTrigger, "Use new RTSP_HTTP implementation = " + this.useNewHttp, "Wait for KeepAlive response = " + this.keepAliveResponse}));
        if (!this.isInitDoneOnce) {
            this.isInitDoneOnce = true;
            try {
                this.getAxisNetworkParameter();
                this.getAxisDeviceParameters();
                this.getAxisAPIVersion();
                this.getAxisFirmwareVersion();
            }
            catch (SeeTecException ex) {
                this.logger.error("Error retrieving device parameters [" + ex.getErrorCode() + "|" + ex.getMessage() + "] for " + this);
            }
            catch (ConfigurationException ex) {
                this.logger.error("Error retrieving device parameters [" + ex.getMessage() + "] for " + this);
            }
            this.setSeiTriggerDataOnDevice(this.enableSeiTrigger);
        }
        super.initializeDevice(srvType);
        if (srvType >= 210000L && srvType <= 210099L || srvType >= 212300L && srvType <= 212399L || srvType >= 202300L && srvType <= 202399L || srvType == 210500L || srvType == 210501L || srvType == 210600L || srvType == 210700L || srvType == 210800L || srvType == 219900L || srvType == 219901L) {
            if (!AxisDevice.isGenericDriver(srvType) && (errorCode = this.initCaptureMode()) != 0) {
                return errorCode;
            }
            errorCode = this.initViewAreas();
        }
        return errorCode;
    }

    public int[] getMaxResolutionOfCaptureMode(String resolutionsFromCamera) throws SeeTecException, IllegalArgumentException {
        if (resolutionsFromCamera == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<int[]> allResolutions = new ArrayList<int[]>();
        for (String resolution : resolutionsFromCamera.split(",")) {
            if (!resolution.contains("x")) {
                resolution = AxisResolution.getResolution(resolution);
            }
            String[] widthAndHeight = resolution.split("x");
            try {
                allResolutions.add(new int[]{Integer.parseInt(widthAndHeight[0]), Integer.parseInt(widthAndHeight[1])});
            }
            catch (IndexOutOfBoundsException iob) {
                this.logger.error("Can't split resolution [" + resolution + "] for " + this);
            }
            catch (NumberFormatException nfe) {
                this.logger.error("Can't convert resolution [" + resolution + "] for " + this);
            }
        }
        if (allResolutions.isEmpty()) {
            throw new SeeTecException(-20000, "No resolution extracted for " + this);
        }
        Collections.sort(allResolutions, new ResolutionComparator());
        return (int[])allResolutions.get(allResolutions.size() - 1);
    }

    @Override
    public String getFirmwareVersion() {
        try {
            return this.getAxisFirmwareVersion().getFirmwareVersion();
        }
        catch (SeeTecException ex) {
            return "<unknown>";
        }
    }

    public NetworkParameter getAxisNetworkParameter() throws ConfigurationException {
        if (this.networkParameter == null) {
            this.networkParameter = this.getDeviceCnf().getNetworkParameter();
        }
        return this.networkParameter;
    }

    public static CameraAdministration getCameraAdministration() throws SeeTecException {
        if (CAMERA_ADMINISTRATION == null) {
            CAMERA_ADMINISTRATION = new AxisCameraAdministration((SeetecHttpClient)new NetworkHelperAdapter());
        }
        return CAMERA_ADMINISTRATION;
    }

    public AxisDeviceParameters getAxisDeviceParameters() throws SeeTecException {
        if (this.deviceParameters == null) {
            this.deviceParameters = new AxisDeviceParameters(this);
            this.deviceParameters.getDeviceParameters(true);
        }
        return this.deviceParameters;
    }

    public AxisAPIVersion getAxisAPIVersion() {
        if (this.apiVersion == null) {
            try {
                String apiVersionValue = this.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.API.HTTP.Version");
                this.apiVersion = AxisAPIVersion.valueOf(Integer.parseInt(apiVersionValue));
            }
            catch (SeeTecException e) {
                this.logger.error("Problems while determing API version for " + this);
                this.apiVersion = AxisAPIVersion.VERSION_2;
            }
            catch (NumberFormatException e) {
                this.apiVersion = AxisAPIVersion.VERSION_3;
            }
        }
        return this.apiVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setRTSPPort(int rtspPort) {
        if (this.isRTSPPortSet) return 0;
        this.isRTSPPortSet = true;
        if (rtspPort == 554 || rtspPort >= 1024 && rtspPort <= 65535) {
            this.logger.debug("Using RTSP port: " + rtspPort + " for " + this);
            StringBuilder url = this.getAxisAPIVersion() == AxisAPIVersion.VERSION_2 ? new StringBuilder("/axis-cgi/admin/param.cgi?action=update&root.Network.RTSP.Port=") : new StringBuilder("/axis-cgi/param.cgi?action=update&root.Network.RTSP.Port=");
            url.append(rtspPort);
            url.append("&root.Network.RTSP.Timeout=60");
            try {
                if (this.getHttpHandler().readGetRequest(url.toString()) != null) return 0;
                this.logger.error("Error while setting rtsp port for " + this);
                return -20000;
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception [" + ex.getErrorCode() + "|" + ex.getMessage() + "] while setting rtsp port for " + this);
                return ex.getErrorCode();
            }
            catch (Exception ex) {
                this.logger.error("Exception [" + ex.getMessage() + "] while setting rtsp port for " + this);
                return 0;
            }
        } else {
            this.logger.error("Invalid RTSP port: " + rtspPort + ". Valid values are [554,1024..65535] for " + this);
            return -21601;
        }
    }

    protected boolean hasCaptureModeChanged(String currentlySetCaptureMode, String foundDisplayResolutionInDefinition) {
        boolean result = false;
        if (currentlySetCaptureMode == null) {
            if (foundDisplayResolutionInDefinition != null && !foundDisplayResolutionInDefinition.contains("Default")) {
                return true;
            }
        } else if (foundDisplayResolutionInDefinition != null && !foundDisplayResolutionInDefinition.isEmpty() && !currentlySetCaptureMode.contains(foundDisplayResolutionInDefinition)) {
            this.logger.info(Basic.generateIndentedMultiLineLog((String)String.format("Capture mode on camera has changed from '%s' to '%s' for %s", foundDisplayResolutionInDefinition, currentlySetCaptureMode, this)));
            return true;
        }
        return result;
    }

    protected float getMaxFramerate(int viewNumber) throws SeeTecException, ConfigurationException {
        String BASE_URL = "/axis-media/media.amp";
        Query.Builder builder = new Query.Builder().setTarget("rtsp://" + this.getAxisNetworkParameter().getHost() + "/axis-media/media.amp").addParam("videocodec", "h264");
        String source = this.axisDeviceDefinitionHelper.getRtspCameraParam(viewNumber);
        if (source != null) {
            builder.addParam("camera", source);
        }
        String rtspUrl = builder.build().toString();
        RTSPStreamSettings rtspSettings = new RTSPStreamSettings();
        int errorCode = rtspSettings.init(new RTSPHandlerDummy(), this.getAxisNetworkParameter(), this.getAxisNetworkParameter().getHTTPport(), rtspUrl, false, TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST);
        if (errorCode != 0) {
            throw new SeeTecException(errorCode, "Initialization of RTSPSettings failed [" + errorCode + "] for " + this);
        }
        RTSPHandlerSuper rtspHandler = rtspSettings.getRTSPHandler();
        try {
            if (((RTSPHandlerHTTP)rtspHandler).setupEnvironment(true) == 0) {
                DescribeRequest describeReq = new DescribeRequest();
                describeReq.init(rtspUrl, rtspSettings);
                RTSPResponse response = ((RTSPHandlerHTTP)rtspHandler).sendRTSPRequest(describeReq);
                String responseContent = response.getData();
                SDPContent sdpContent = new SDPContent(responseContent);
                List<String> result = sdpContent.getAttributes("framerate");
                if (result.isEmpty()) {
                    throw new SeeTecException(-20000, "No information about max framerate in SDP for " + this);
                }
                try {
                    float f = Float.parseFloat(result.get(0));
                    return f;
                }
                catch (NumberFormatException nfe) {
                    throw new SeeTecException(-20000, "Error while converting '" + result.get(0) + "' to number for " + this);
                }
            }
            throw new SeeTecException(-20000, "Could not ask for max framerate for " + this);
        }
        finally {
            rtspHandler.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int setCameraOrientation(VideoProfileHandler listener) {
        Object object = this.snycObj;
        synchronized (object) {
            int errorCode = 0;
            if (!this.isCameraOrientationSet) {
                this.isCameraOrientationSet = true;
                try {
                    CameraOrientation orientation = listener.getVideoSourceParameter().getDewarpingOrientation();
                    String url = "/axis-cgi/param.cgi?action=update&group=ImageSource.I0.CameraTiltOrientation=";
                    if (orientation == null) {
                        url = url + "0";
                    } else {
                        switch (orientation) {
                            case CEILING: {
                                url = url + "-90";
                                break;
                            }
                            case TABLE: {
                                url = url + "90";
                                break;
                            }
                            default: {
                                url = url + "0";
                            }
                        }
                    }
                    this.getHttpHandler().readGetRequest(url);
                }
                catch (SeeTecException ex) {
                    this.logger.info("Exception [" + ex.getErrorCode() + "|" + ex.getMessage() + "] while setting camera orientation for " + this);
                    errorCode = ex.getErrorCode();
                }
                catch (ConfigurationException ex) {
                    this.logger.info("Configuration exception [" + ex.getMessage() + "] while setting camera orientation for " + this);
                    errorCode = -20001;
                }
                catch (Exception ex) {
                    this.logger.info("Exception [" + ex.getMessage() + "] while setting camera orientation for " + this);
                    errorCode = -20001;
                }
            }
            return errorCode;
        }
    }

    @Override
    protected IOHandler createIOHandler() {
        return new AxisIOHandler();
    }

    protected AxisFirmwareVersion getAxisFirmwareVersion() throws SeeTecException {
        if (this.fwVersion == null) {
            this.fwVersion = new AxisFirmwareVersion(this);
        }
        return this.fwVersion;
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        try {
            String currentSignature = this.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.Firmware.Version");
            String currentManufacturer = "Axis Smart Driver (H.26x Generation)";
            String currentName = this.getAxisDeviceParameters().getDeviceParameterValue("root.Brand.ProdShortName");
            String currentComments = "RE_APP_VERSION::7.1.1_23";
            String currentlySetCaptureMode = this.getCurrentlySetCaptureMode(0);
            String foundDisplayResolutionInDefinition = this.getCurrentCaptureModeFromDefinition();
            boolean hasCaptureModeChanged = this.hasCaptureModeChanged(currentlySetCaptureMode, foundDisplayResolutionInDefinition);
            if (!(signature != null && signature.equals(currentSignature) && manufacturer != null && manufacturer.equals("Axis Smart Driver (H.26x Generation)") && name != null && name.equals(currentName) && comments != null && comments.equals("RE_APP_VERSION::7.1.1_23") && !hasCaptureModeChanged)) {
                this.getAxisFirmwareVersion().checkFirmwareForGenericDriver();
                DeviceDefinition deviceDefinition = new DeviceDefinition();
                deviceDefinition.setCountFirstChannelOnly(true);
                deviceDefinition.setSignature(currentSignature);
                deviceDefinition.setManufacturer("Axis Smart Driver (H.26x Generation)");
                deviceDefinition.setComments(this.createCommentsType("RE_APP_VERSION::7.1.1_23"));
                deviceDefinition.setDefaultMediaID(MediaID.VIDEO_SERVER_DIGITAL.getType());
                deviceDefinition.setSupportedApiVersions(this.createSupportedApiVersionsType());
                deviceDefinition.setDefaultApiVersion(API_VERSION);
                deviceDefinition.setNoOfCams(this.determineNumberOfCams());
                deviceDefinition.setSupportedVideoSourceEntityTypes(this.createSupportedVideoSourceEntityTypes());
                deviceDefinition.setVirtualCameraDefinition(this.createVirtualCameraDefinitionType());
                deviceDefinition.setDeviceNetworkDefinition(this.createDeviceNetworkDefinitionType());
                deviceDefinition.setSupportedCaptureModes(this.createSupportedCaptureModesType());
                deviceDefinition.setDefaultCaptureModeIndex(0);
                deviceDefinition.setImageRotationCapabilities(this.axisDeviceDefinitionHelper.getImageRotationCapabilitiesForView(0));
                deviceDefinition.setAudioCapabilities(this.createAudioCapabilitiesType());
                deviceDefinition.setAvailableIOs(this.createAvailableIOsType());
                deviceDefinition.setMiscVideoServerCapabilities(this.createMiscVideoServerCapabilitiesType());
                deviceDefinition.setDeviceGroupMemberships(this.axisDeviceDefinitionHelper.createDeviceGroupMembershipsTypeForView(0));
                deviceDefinition.setSupportedGenericEvents(this.getGenericEventTrigger());
                deviceDefinition.setSupportedEdgeStoragePlaybackSpeeds(this.createSupportedEdgeStoragePlaybackSpeedsType());
                deviceDefinition.setEntityType(202334L);
                deviceDefinition.setName(currentName);
                return deviceDefinition;
            }
        }
        catch (Throwable t) {
            this.logger.warn("Error while reading capabalities [" + t.getMessage() + "] from " + this, t);
            throw new SeeTecException(-21600, t.getMessage());
        }
        return null;
    }

    private CommentsType createCommentsType(String currentComments) {
        CommentsType commentsType = new CommentsType();
        commentsType.getString().add(currentComments);
        return commentsType;
    }

    private SupportedApiVersionsType createSupportedApiVersionsType() {
        SupportedApiVersionsType supportedApiVersionsType = new SupportedApiVersionsType();
        supportedApiVersionsType.getString().add(API_VERSION);
        return supportedApiVersionsType;
    }

    private int determineNumberOfCams() throws NumberFormatException, SeeTecException {
        int numberOfCams;
        String nbrOfViewsParameter = this.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.Image.NbrOfViews");
        String nbrOfConfigsParameter = this.getAxisDeviceParameters().getDeviceParameterValue("root.Image.NbrOfConfigs");
        String nbrOfImageSources = this.getAxisDeviceParameters().getDeviceParameterValue("root.ImageSource.NbrOfSources");
        if (this.getAxisDeviceParameters().isDewarpEnabled() && nbrOfViewsParameter != null) {
            numberOfCams = Integer.parseInt(nbrOfViewsParameter);
        } else if (nbrOfConfigsParameter != null && nbrOfConfigsParameter.equals("5") && nbrOfViewsParameter != null && nbrOfViewsParameter.equals("4")) {
            numberOfCams = 5;
        } else if (nbrOfImageSources != null) {
            numberOfCams = Integer.parseInt(nbrOfImageSources);
        } else {
            this.logger.warn(Basic.generateIndentedMultiLineLog((String)("Could not read necessary parameters to for setNoOfCams. Using default value [1] for " + this)));
            numberOfCams = 1;
        }
        return numberOfCams;
    }

    private SupportedEdgeStoragePlaybackSpeedsType createSupportedEdgeStoragePlaybackSpeedsType() {
        SupportedEdgeStoragePlaybackSpeedsType supportedEdgeStoragePlaybackSpeedsType = new SupportedEdgeStoragePlaybackSpeedsType();
        EdgeStoragePlaybackSpeedType singleSpeed = new EdgeStoragePlaybackSpeedType();
        singleSpeed.setSpeedValue(1);
        singleSpeed.setSpeedName("1x");
        supportedEdgeStoragePlaybackSpeedsType.getEdgeStoragePlaybackSpeed().add(singleSpeed);
        EdgeStoragePlaybackSpeedType maxSpeed = new EdgeStoragePlaybackSpeedType();
        maxSpeed.setSpeedValue(2);
        maxSpeed.setSpeedName("max");
        supportedEdgeStoragePlaybackSpeedsType.getEdgeStoragePlaybackSpeed().add(0, maxSpeed);
        return supportedEdgeStoragePlaybackSpeedsType;
    }

    private SupportedVideoSourceEntityTypesType createSupportedVideoSourceEntityTypes() {
        SupportedVideoSourceEntityTypesType supportedVideoSourceEntityTypesType = new SupportedVideoSourceEntityTypesType();
        supportedVideoSourceEntityTypesType.getLong().add(212313L);
        return supportedVideoSourceEntityTypesType;
    }

    private VirtualCameraDefinitionType createVirtualCameraDefinitionType() throws NumberFormatException, SeeTecException {
        String nbrOfViewsParameter = this.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.Image.NbrOfViews");
        String currentName = this.getAxisDeviceParameters().getDeviceParameterValue("root.Brand.ProdShortName");
        VirtualCameraDefinitionType virtualCameraDefinitionType = new VirtualCameraDefinitionType();
        String noOfVirtualCameras = "0";
        if (nbrOfViewsParameter != null) {
            noOfVirtualCameras = nbrOfViewsParameter;
        }
        if (currentName.contains("Q6000")) {
            virtualCameraDefinitionType.setCanVirtualCamera(false);
            virtualCameraDefinitionType.setCanVirtualCameraCropping(false);
            virtualCameraDefinitionType.setNoOfVirtualCameras(5);
            this.logger.info("Exception for Axis Q6000 virtual cameras settings - use only 1 license  for " + this);
        } else if (Integer.parseInt(noOfVirtualCameras) > 1) {
            if (this.getAxisDeviceParameters().isDewarpEnabled()) {
                virtualCameraDefinitionType.setCanVirtualCamera(false);
                virtualCameraDefinitionType.setCanVirtualCameraCropping(false);
                virtualCameraDefinitionType.setNoOfVirtualCameras(Integer.parseInt(noOfVirtualCameras));
            } else {
                virtualCameraDefinitionType.setCanVirtualCamera(true);
                virtualCameraDefinitionType.setCanVirtualCameraCropping(true);
                virtualCameraDefinitionType.setNoOfVirtualCameras(Integer.parseInt(noOfVirtualCameras));
            }
        } else {
            virtualCameraDefinitionType.setCanVirtualCamera(false);
            virtualCameraDefinitionType.setCanVirtualCameraCropping(false);
            virtualCameraDefinitionType.setNoOfVirtualCameras(0);
        }
        return virtualCameraDefinitionType;
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Mentioned hard-coded password is just Axis default pass which is a proper default setting in this case.")
    private DeviceNetworkDefinitionType createDeviceNetworkDefinitionType() throws SeeTecException {
        DeviceNetworkDefinitionType deviceNetworkDefinitionType = new DeviceNetworkDefinitionType();
        deviceNetworkDefinitionType.setCanChangeHttpPort(true);
        deviceNetworkDefinitionType.setCanChangeHttpsPort(true);
        String httpsParameter = this.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.HTTPS.HTTPS");
        if (httpsParameter != null && httpsParameter.equals("yes")) {
            deviceNetworkDefinitionType.setCanHttps(true);
        } else {
            deviceNetworkDefinitionType.setCanHttps(false);
        }
        deviceNetworkDefinitionType.setDefaultHttpPort(80);
        deviceNetworkDefinitionType.setDefaultHttpsPort(443);
        deviceNetworkDefinitionType.setDefaultPassword("pass");
        deviceNetworkDefinitionType.setDefaultUserName("root");
        deviceNetworkDefinitionType.setUseAuthentication(true);
        deviceNetworkDefinitionType.setMinVideoStreamNetworkTimeout(5000L);
        deviceNetworkDefinitionType.setMaxVideoStreamNetworkTimeout(20000L);
        deviceNetworkDefinitionType.setDefaultVideoStreamNetworkTimeout(10000L);
        return deviceNetworkDefinitionType;
    }

    private SupportedCaptureModesType createSupportedCaptureModesType() throws SeeTecException {
        SupportedCaptureModesType supportedCaptureModesType = new SupportedCaptureModesType();
        supportedCaptureModesType.getCaptureModeDefinition().add(this.getSupportedCaptureMode(0));
        return supportedCaptureModesType;
    }

    private MiscVideoServerCapabilitiesType createMiscVideoServerCapabilitiesType() throws SeeTecException {
        MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = new MiscVideoServerCapabilitiesType();
        miscVideoServerCapabilitiesType.setCanTimeDate(true);
        miscVideoServerCapabilitiesType.setCanTitle(true);
        miscVideoServerCapabilitiesType.setCanDetectTampering(false);
        miscVideoServerCapabilitiesType.setCanDetectVideoloss(false);
        miscVideoServerCapabilitiesType.setNoOfRS232S(0);
        miscVideoServerCapabilitiesType.setCanTimeshift(false);
        miscVideoServerCapabilitiesType.setPTZSpeedMultiplier(100);
        String ptzParameter = this.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.PTZ.PTZ");
        if (ptzParameter != null && ptzParameter.equals("yes")) {
            miscVideoServerCapabilitiesType.setCanPTZ(true);
        } else {
            miscVideoServerCapabilitiesType.setCanPTZ(false);
        }
        return miscVideoServerCapabilitiesType;
    }

    private AvailableIOsType createAvailableIOsType() throws NumberFormatException, SeeTecException {
        AvailableIOsType availableIOsType = new AvailableIOsType();
        String nbrOfInputsParameter = this.getAxisDeviceParameters().getDeviceParameterValue("root.Input.NbrOfInputs");
        int numberOfInputs = nbrOfInputsParameter != null && !nbrOfInputsParameter.isEmpty() ? Integer.parseInt(nbrOfInputsParameter) : 0;
        for (int i = 0; i < numberOfInputs; ++i) {
            availableIOsType.getInputOutputCapabilities().add(0);
        }
        String nbrOfOutputsParameter = this.getAxisDeviceParameters().getDeviceParameterValue("root.Output.NbrOfOutputs");
        int numberOfOutputs = nbrOfOutputsParameter != null && !nbrOfOutputsParameter.isEmpty() ? Integer.parseInt(nbrOfOutputsParameter) : 0;
        for (int i = 0; i < numberOfOutputs; ++i) {
            availableIOsType.getInputOutputCapabilities().add(1);
        }
        return availableIOsType;
    }

    /*
     * Enabled aggressive block sorting
     */
    private AudioCapabilitiesType createAudioCapabilitiesType() throws SeeTecException, NumberFormatException {
        AudioCapabilitiesType audioCapabilitiesType = new AudioCapabilitiesType();
        String audioParameter = this.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.Audio.Audio");
        if (audioParameter != null && audioParameter.equals("yes")) {
            audioCapabilitiesType.setCanAudio(true);
        } else {
            audioCapabilitiesType.setCanAudio(false);
        }
        String nbrOfAudioSourcesParameter = this.getAxisDeviceParameters().getDeviceParameterValue("root.AudioSource.NbrOfSources");
        if (nbrOfAudioSourcesParameter != null) {
            audioCapabilitiesType.setNumberOfPossibleAudioStreams(Integer.parseInt(nbrOfAudioSourcesParameter));
        } else {
            audioCapabilitiesType.setNumberOfPossibleAudioStreams(0);
        }
        audioCapabilitiesType.setDefaultAudioCodecIndex(0);
        if (!audioCapabilitiesType.isCanAudio()) {
            audioCapabilitiesType.setAudioCodecs(null);
            return audioCapabilitiesType;
        }
        AudioCodecsType audioCodecsType = new AudioCodecsType();
        String audioFormatParameter = this.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.Audio.Format");
        if (audioFormatParameter == null) {
            this.logger.warn(Basic.generateIndentedMultiLineLog((String)("Could not read audio format (audio codecs) parameter from device for " + this)));
        } else {
            String[] audioCodecs;
            block10: for (String audioCodec : audioCodecs = audioFormatParameter.split(",")) {
                AudioCodecDefinitionType audioCodecDefinitionType = new AudioCodecDefinitionType();
                CodecType codecType = new CodecType();
                switch (audioCodec) {
                    case "g711": {
                        codecType.setValue(Codec.G711U.getType());
                        break;
                    }
                    case "g726": {
                        codecType.setValue(Codec.G726.getType());
                        break;
                    }
                    case "aac": {
                        continue block10;
                    }
                }
                audioCodecDefinitionType.setAudioCodec(codecType);
                audioCodecDefinitionType.setBitrate(64000);
                audioCodecsType.getAudioCodecDefinition().add(audioCodecDefinitionType);
            }
        }
        audioCapabilitiesType.setAudioCodecs(audioCodecsType);
        String availableDuplexModes = this.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.Audio.DuplexMode");
        if (availableDuplexModes == null) return audioCapabilitiesType;
        if (!availableDuplexModes.contains("full") && !availableDuplexModes.contains("half")) {
            if (!availableDuplexModes.contains("post")) return audioCapabilitiesType;
        }
        audioCapabilitiesType.setCanAudioOut(true);
        return audioCapabilitiesType;
    }

    @Override
    protected VideoSourcesDefinitionType getVideoSourcesDefinitionFromDevice(int totalSources) throws SeeTecException {
        VideoSourcesDefinitionType videoSourcesDefinitionType = new VideoSourcesDefinitionType();
        AxisDeviceParameters axisDeviceParameters = this.getAxisDeviceParameters();
        try {
            List<VideoSourceType> sourceDefinitionList = videoSourcesDefinitionType.getVideoSource();
            for (int i = 0; i < totalSources; ++i) {
                VideoSourceType videoSource = new VideoSourceType();
                videoSource.setVideoSourceEnabled(!axisDeviceParameters.isDewarpEnabled() || axisDeviceParameters.isViewEnabled(i));
                if (axisDeviceParameters.isPtzEnabled()) {
                    videoSource.setPtzCapabilities(this.axisDeviceDefinitionHelper.createPtzCapabilitiesForView(i));
                }
                videoSource.setAudioCapabilities(this.createAudioCapabilitiesType());
                videoSource.setImageRotation(this.axisDeviceDefinitionHelper.getImageRotationCapabilitiesForView(i));
                videoSource.setMiscVideoServerCapabilities(this.createMiscVideoServerCapabilitiesType());
                videoSource.setDeviceGroupMemberships(this.axisDeviceDefinitionHelper.createDeviceGroupMembershipsTypeForView(i));
                videoSource.setSupportedEdgeStoragePlaybackSpeeds(this.createSupportedEdgeStoragePlaybackSpeedsType());
                videoSource.setCaptureMode(this.getSupportedCaptureMode(i));
                sourceDefinitionList.add(videoSource);
            }
        }
        catch (Exception ex) {
            this.logger.warn("Couldn't read view capabilities for " + this);
            throw new SeeTecException(-21600, ex.getMessage());
        }
        return videoSourcesDefinitionType;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        try {
            AxisDeviceParameters deviceParam = this.getAxisDeviceParameters();
            VideoCameraDefinition videoCameraDefinition = new VideoCameraDefinition();
            videoCameraDefinition.setManufacturer("Generic Axis Driver");
            videoCameraDefinition.setComment("");
            videoCameraDefinition.setDefaultMediaID(deviceParam.isPtzEnabled() ? MediaID.VIDEO_SOURCE_PTZ.getType() : MediaID.VIDEO_SOURCE_DIGITAL.getType());
            videoCameraDefinition.setName(deviceParam.getDeviceParameterValue("root.Brand.ProdShortName"));
            videoCameraDefinition.setEntityType(212313L);
            videoCameraDefinition.setPreferAbsolutePTZ(false);
            FeaturesType featuresType = new FeaturesType();
            if (deviceParam.isPtzEnabled()) {
                int channel = 1;
                featuresType.setCanAbsolutePan(deviceParam.canAbsolutePan(channel));
                featuresType.setCanAbsoluteTilt(deviceParam.canAbsoluteTilt(channel));
                featuresType.setCanAbsoluteZoom(deviceParam.canAbsoluteZoom(channel));
                featuresType.setCanContinuousPan(deviceParam.canContinuousPan(channel));
                featuresType.setCanContinuousTilt(deviceParam.canContinuousTilt(channel));
                featuresType.setCanContinuousZoom(deviceParam.canContinuousZoom(channel));
                featuresType.setCanRelativePan(false);
                featuresType.setCanRelativeTilt(false);
                featuresType.setCanRelativeZoom(false);
                featuresType.setCanCenterPT(true);
                featuresType.setCanFocus(deviceParam.canContinuousFocus(channel) || deviceParam.canRelativeFocus(channel));
                featuresType.setCanAutoFocus(deviceParam.canAutoFocus(channel));
                featuresType.setCanIris(deviceParam.canContinuousIris(channel) || deviceParam.canRelativeIris(channel));
                featuresType.setCanAutoIris(deviceParam.canAutoIris(channel));
                featuresType.setCanNullLux(deviceParam.canIrCutFilter(channel));
                featuresType.setCanAutoNullLux(deviceParam.canAutoIrCutFilter(channel));
                if (!featuresType.isCanNullLux()) {
                    boolean canImageSourceZeroLux = this.isSupportingImageSourceZeroLux(channel);
                    featuresType.setCanNullLux(canImageSourceZeroLux);
                    featuresType.setCanAutoNullLux(canImageSourceZeroLux);
                }
                featuresType.setCanPreset(deviceParam.canServerPreset(channel));
                featuresType.setMinPan(-180000);
                featuresType.setMaxPan(180000);
                featuresType.setMinTilt(0);
                featuresType.setMaxTilt(90000);
                featuresType.setMinZoom(0);
                featuresType.setMaxZoom(100000);
                featuresType.setMinAbsoluteZoom(0);
                Integer maxAbsoluteZoom = deviceParam.getMaxZoom(channel);
                featuresType.setMaxAbsoluteZoom(maxAbsoluteZoom == null ? 0 : maxAbsoluteZoom);
                featuresType.setMinSpeed(0);
                featuresType.setMaxSpeed(100000);
                featuresType.setPTZMinContinuousLevel(10000);
                featuresType.setPTZMaxContinuousLevel(100000);
                featuresType.setPTZContinuousSpeedFactor(1000);
            }
            videoCameraDefinition.setFeatures(featuresType);
            return videoCameraDefinition;
        }
        catch (SeeTecException ex) {
            this.logger.warn("Error [" + ex.getErrorCode() + "|" + ex.getMessage() + "] while reading capabilities from " + this);
            throw new SeeTecException(-21600, ex.getMessage());
        }
    }

    protected boolean isSupportingImageSourceZeroLux(int channel) {
        try {
            String key = "root.ImageSource.I" + (channel - 1) + ".DayNight.IrCutFilter";
            String irCutFilterValue = this.getHttpHandler().readGetRequest("/axis-cgi/param.cgi?action=list&group=" + key);
            return irCutFilterValue.contains(key + "=");
        }
        catch (Exception ex) {
            this.logger.warn("Exception while getting Zero Lux capabilities for " + this + " : " + ex.getMessage());
            return false;
        }
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() throws SeeTecException, ConfigurationException {
        SupportedGenericEventsType supportedGenericEventsType = new SupportedGenericEventsType();
        try {
            String triggerDataEnabledParameter = this.getAxisDeviceParameters().getDeviceParameterValue("root.Image.TriggerDataEnabled");
            String nbrOfImageSources = this.getAxisDeviceParameters().getDeviceParameterValue("root.ImageSource.NbrOfSources");
            if (triggerDataEnabledParameter != null && triggerDataEnabledParameter.equals("yes")) {
                if (nbrOfImageSources != null) {
                    GenericEventDefinitionType genericEventDefinitionType;
                    String parameter;
                    String path;
                    int numberOfImageSources = Integer.parseInt(nbrOfImageSources);
                    for (int i = 0; i < numberOfImageSources; ++i) {
                        path = "root.Image.I" + i + ".TriggerData.AudioEnabled";
                        parameter = this.getAxisDeviceParameters().getDeviceParameterValue(path);
                        if (parameter != null && parameter.equals("yes")) {
                            this.logger.debug("Found trigger AudioDetection " + i + " for " + this);
                            genericEventDefinitionType = new GenericEventDefinitionType();
                            genericEventDefinitionType.setEventType("A" + i);
                            genericEventDefinitionType.setSourceNumber(i + 1);
                            supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
                        }
                        path = "root.Image.I" + i + ".TriggerData.TamperingEnabled";
                        parameter = this.getAxisDeviceParameters().getDeviceParameterValue(path);
                        if (parameter != null && parameter.equals("yes")) {
                            this.logger.debug("Found trigger Tampering " + i + " for " + this);
                            genericEventDefinitionType = new GenericEventDefinitionType();
                            genericEventDefinitionType.setEventType("T" + i);
                            genericEventDefinitionType.setSourceNumber(i + 1);
                            supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
                        }
                        path = "root.Image.I" + i + ".TriggerData.VideoLossEnabled";
                        parameter = this.getAxisDeviceParameters().getDeviceParameterValue(path);
                        if (parameter == null || !parameter.equals("yes")) continue;
                        this.logger.debug("Found trigger Videoloss " + i + " for " + this);
                        genericEventDefinitionType = new GenericEventDefinitionType();
                        genericEventDefinitionType.setEventType("V" + i);
                        genericEventDefinitionType.setSourceNumber(i + 1);
                        supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
                    }
                    path = "root.Properties.Motion.Motion";
                    parameter = this.getAxisDeviceParameters().getDeviceParameterValue(path);
                    String maxNbrOfWindowsParameter = this.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.Motion.MaxNbrOfWindows");
                    if (parameter != null && parameter.equals("yes") && maxNbrOfWindowsParameter != null) {
                        int maxNbrOfMotionWindows = Integer.parseInt(maxNbrOfWindowsParameter);
                        for (int j = 0; j < maxNbrOfMotionWindows; ++j) {
                            this.logger.debug("Found trigger MotionDetection " + j + " for " + this);
                            genericEventDefinitionType = new GenericEventDefinitionType();
                            genericEventDefinitionType.setEventType("M" + j);
                            genericEventDefinitionType.setSourceNumber(0);
                            supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
                        }
                    }
                } else {
                    this.logger.warn("Not able to read EventTrigger because NbrOfSources is null for " + this);
                }
            } else {
                this.logger.warn("Not able to read EventTrigger because TriggerDataEnabled = false and could not set them to true for " + this);
            }
        }
        catch (Exception e) {
            this.logger.warn("Exception occured (" + e.getMessage() + ") for " + this);
        }
        try {
            if (this.getAxisFirmwareVersion().isEventDataStreamSupported()) {
                String url = "/vapix/services";
                StringBuilder body = new StringBuilder();
                body.append("<s:Envelope xmlns:s=\"http://www.w3.org/2003/05/soap-envelope\">");
                body.append("  <s:Body xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
                body.append("    <GetEventInstances xmlns=\"http://www.axis.com/vapix/ws/event1\"/>");
                body.append("  </s:Body>");
                body.append("</s:Envelope>");
                String contentType = "application/soap+xml;action=\"http://www.axis.com/vapix/ws/event1/GetEventInstances\";charset=utf-8;";
                String response = this.getHttpHandler().readPostRequest(url, body.toString(), false, contentType);
                List<String> allIdentifier = MessageInstance.getAllIdentifierFromContentString(response);
                for (String identifier : allIdentifier) {
                    GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
                    genericEventDefinitionType.setEventType(identifier);
                    genericEventDefinitionType.setSourceNumber(0);
                    supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Exception while reading generic event triggers (" + e.getMessage() + ") for " + this);
        }
        return supportedGenericEventsType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getCurrentlySetCaptureMode(int sourceNumber) {
        String currentlySetCaptureMode = null;
        try {
            List<String> captureModes = this.getAvailableCaptureModes();
            if (captureModes == null) {
                return currentlySetCaptureMode;
            }
            String captureNumber = this.getAxisDeviceParameters().getDeviceParameterValue("root.ImageSource.I" + sourceNumber + ".Sensor.CaptureMode");
            if (captureNumber == null) {
                captureNumber = this.getAxisDeviceParameters().getDeviceParameterValue("root.ImageSource.I" + sourceNumber + ".Video.CaptureMode");
            }
            if (captureNumber == null && sourceNumber != 0) {
                return null;
            }
            try {
                currentlySetCaptureMode = captureModes.get(Integer.parseInt(captureNumber) - 1);
            }
            catch (NumberFormatException numberFormatException) {
                for (String captureMode : captureModes) {
                    if (!captureMode.startsWith(captureNumber)) continue;
                    currentlySetCaptureMode = captureMode;
                    break;
                }
            }
            if (currentlySetCaptureMode == null) return currentlySetCaptureMode;
            int indexOfMarker = currentlySetCaptureMode.indexOf(MARKER);
            if (indexOfMarker < 0) return currentlySetCaptureMode;
            return currentlySetCaptureMode.substring(indexOfMarker + MARKER.length());
        }
        catch (Exception e) {
            this.logger.debug("Could not find out currently set capture mode [" + e.getMessage() + "] for " + this);
            return null;
        }
    }

    protected String getCurrentCaptureModeFromDefinition() {
        String foundDisplayResolutionInDefinition = null;
        try {
            List<CaptureModeDefinitionType> list = this.getDeviceDefinitionFromConfiguration().getSupportedCaptureModes().getCaptureModeDefinition();
            if (!list.isEmpty()) {
                foundDisplayResolutionInDefinition = list.get(0).getResolution().getDisplayResolution();
            }
        }
        catch (Exception e) {
            this.logger.debug("Could not find out current capture mode in definition [" + e.getMessage() + "] for " + this);
        }
        return foundDisplayResolutionInDefinition;
    }

    private CaptureModeDefinitionType getSupportedCaptureMode(int viewNumber) throws SeeTecException {
        String[] codecs;
        int maxTotalNumberOfStreams = 6;
        int maxNumberOfStreams = 3;
        CaptureModeDefinitionType captureModeDefinitionType = new CaptureModeDefinitionType();
        captureModeDefinitionType.setRebootRequired(false);
        captureModeDefinitionType.setModeSuffix("");
        captureModeDefinitionType.setMaxTotalNumberOfStreams(6);
        captureModeDefinitionType.setDefaultStreamDefinitionIndex(0);
        String resolutionParameter = this.axisDeviceDefinitionHelper.getResolutionParamForView(viewNumber);
        int[] maxResolution = this.getMaxResolutionOfCaptureMode(resolutionParameter);
        int width = maxResolution[0];
        int height = maxResolution[1];
        if (width == 0 || height == 0) {
            String errorMsg = "Parsed resolution for this capture mode is " + width + "x" + height + " .Something went wrong";
            this.logger.error(errorMsg);
            throw new SeeTecException(-20000, errorMsg);
        }
        this.logger.info(String.format("%sx%s read out as max resolution for %s", width, height, this));
        float framerate = this.axisDeviceDefinitionHelper.getFramerateForView(viewNumber);
        String currentlySetCaptureMode = this.getCurrentlySetCaptureMode(viewNumber);
        if (currentlySetCaptureMode == null) {
            currentlySetCaptureMode = "Default " + width + "x" + height + " " + (int)framerate + "fps";
        }
        this.logger.info("Processing capture mode " + currentlySetCaptureMode + " for " + this);
        CameraResolutionType captureModeCameraResolutionType = new CameraResolutionType();
        captureModeCameraResolutionType.setDisplayResolution(currentlySetCaptureMode);
        captureModeCameraResolutionType.setWidth(width);
        captureModeCameraResolutionType.setHeight(height);
        captureModeCameraResolutionType.setMaxMilliFPS((int)(framerate * 1000.0f));
        captureModeCameraResolutionType.setMinMilliFPS(1);
        captureModeCameraResolutionType.setResolution(AxisResolution.getResolutionName(width + "x" + height));
        captureModeCameraResolutionType.setSupportedFrameRates(null);
        captureModeDefinitionType.setResolution(captureModeCameraResolutionType);
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = new MultiStreamingDefinitionsType();
        String codecsParameter = this.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.Image.Format");
        if (codecsParameter == null) {
            this.logger.error("Could not retrieve codecs paramter from device for " + this);
            throw new SeeTecException(-20000, "Could not retrieve codecs parameter from device for " + this);
        }
        block10: for (String codec : codecs = codecsParameter.split(",")) {
            CodecType codecType = new CodecType();
            SupportedMPEGProfileIDs supportedMPEGProfileIds = new SupportedMPEGProfileIDs();
            StreamDefinitionType streamDefinitionType = new StreamDefinitionType();
            switch (codec) {
                case "h264": {
                    codecType.setValue(Codec.H264.getType());
                    String h264ProfilesParameter = this.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.Image.H264.Profiles");
                    if (h264ProfilesParameter != null) {
                        String[] mpegProfiles;
                        for (String mpegProfile : mpegProfiles = h264ProfilesParameter.split(",")) {
                            if (mpegProfile.equals("Baseline")) {
                                supportedMPEGProfileIds.getInt().add(MpegProfile.BASELINE.getType());
                                continue;
                            }
                            if (mpegProfile.equals("Main")) {
                                supportedMPEGProfileIds.getInt().add(MpegProfile.MAIN.getType());
                                continue;
                            }
                            if (!mpegProfile.equals("High")) continue;
                            supportedMPEGProfileIds.getInt().add(MpegProfile.HIGH.getType());
                        }
                    }
                    SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST.getType());
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_MULTICAST.getType());
                    streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                    BitrateSettingsType bitrateSettingsType = new BitrateSettingsType();
                    bitrateSettingsType.setCanVBR(true);
                    bitrateSettingsType.setCanVBRQuality(true);
                    bitrateSettingsType.setCanCBR(true);
                    bitrateSettingsType.setCanCBRQuality(true);
                    bitrateSettingsType.setMaxBandwidth(51200000);
                    bitrateSettingsType.setMinBandwidth(1024);
                    bitrateSettingsType.setSupportedBitrates(null);
                    streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                    break;
                }
                case "h265": {
                    codecType.setValue(Codec.H265.getType());
                    SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST.getType());
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_MULTICAST.getType());
                    streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                    BitrateSettingsType bitrateSettingsType = new BitrateSettingsType();
                    bitrateSettingsType.setCanVBR(true);
                    bitrateSettingsType.setCanVBRQuality(true);
                    bitrateSettingsType.setCanCBR(true);
                    bitrateSettingsType.setCanCBRQuality(false);
                    bitrateSettingsType.setMaxBandwidth(51200000);
                    bitrateSettingsType.setMinBandwidth(1024);
                    bitrateSettingsType.setSupportedBitrates(null);
                    streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                    break;
                }
                case "mjpeg": {
                    codecType.setValue(Codec.MJPEG.getType());
                    SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.HTTP_SERVERPUSH.getType());
                    streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                    BitrateSettingsType bitrateSettingsType = new BitrateSettingsType();
                    bitrateSettingsType.setCanVBR(false);
                    bitrateSettingsType.setCanVBRQuality(true);
                    bitrateSettingsType.setCanCBR(false);
                    bitrateSettingsType.setCanCBRQuality(true);
                    bitrateSettingsType.setMaxBandwidth(51200000);
                    bitrateSettingsType.setMinBandwidth(1024);
                    bitrateSettingsType.setSupportedBitrates(null);
                    streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                    break;
                }
                default: {
                    continue block10;
                }
            }
            streamDefinitionType.setNoOfHWMDInputs(0);
            streamDefinitionType.setMaxNumberOfStreams(3);
            streamDefinitionType.setDefaultMilliFPS(5000);
            streamDefinitionType.setHideFPSField(false);
            streamDefinitionType.setHideIFrameField(false);
            streamDefinitionType.setMinIFrameDistance(1);
            streamDefinitionType.setMaxIFrameDistance(Integer.MAX_VALUE);
            streamDefinitionType.setHideKompressionField(false);
            streamDefinitionType.setHideBandwithField(false);
            streamDefinitionType.setEncodingIntervalMin(0);
            streamDefinitionType.setEncodingIntervalMax(0);
            streamDefinitionType.setStreamingMode(codecType);
            RtspSettingsType rtspSettingsType = new RtspSettingsType();
            rtspSettingsType.setDefaultRtspPort(554);
            rtspSettingsType.setCanChangeRtspPort(true);
            rtspSettingsType.setCanMultipleRtspPorts(false);
            streamDefinitionType.setRtspSettings(rtspSettingsType);
            streamDefinitionType.setName(codec.toUpperCase());
            SupportedCameraResolutionsType supportedCameraResolutionsType = new SupportedCameraResolutionsType();
            float framerateForView = this.axisDeviceDefinitionHelper.getFramerateForView(viewNumber);
            supportedCameraResolutionsType.getCameraResolution().addAll(this.axisDeviceDefinitionHelper.parseResolutionParam(resolutionParameter, framerateForView));
            streamDefinitionType.setSupportedCameraResolutions(supportedCameraResolutionsType);
            streamDefinitionType.setSupportedMPEGProfileIDs(supportedMPEGProfileIds);
            streamDefinitionType.setDefaultCameraResolutionIndex(0);
            streamDefinitionType.setDefaultTransmissionTypeIndex(0);
            multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionType);
        }
        captureModeDefinitionType.setMultiStreamingDefinitions(multiStreamingDefinitionsType);
        return captureModeDefinitionType;
    }

    private void waitForCaputreModeChange(String token, String mode) {
        long time = System.currentTimeMillis();
        this.logger.debug("Wating for [" + token + "] [" + mode + "]");
        try {
            while (!this.getAxisDeviceParameters().getDeviceParameterValue(token, true).equals(mode)) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - time <= 60000L) continue;
                this.logger.warn("Capture mode change could not be detected in 60 sec, go on without for " + this);
                break;
            }
        }
        catch (SeeTecException ex) {
            this.logger.warn("Error querying the camera [" + ex.getErrorCode() + "|" + ex.getMessage() + "] for " + this);
        }
        catch (Throwable t) {
            this.logger.warn("Error querying the camera [" + t.getMessage() + "] for " + this);
        }
    }

    private int initCaptureMode() {
        block25: {
            try {
                CnfDeviceCaptureMode cnfDeviceCaptureMode = this.getDeviceCnf().getCaptureMode();
                if (cnfDeviceCaptureMode.isEnabled()) {
                    AxisCaptureModeCnfMgr captureModeCnfMgr = new AxisCaptureModeCnfMgr();
                    byte[] result = this.getHttpHandler().readGetRequestAsByteArray(REQUEST_CAPTURE_MODES);
                    if (captureModeCnfMgr.init(result) != 0) {
                        this.logger.error("Error while processing capture modes (XML) for " + this);
                        return -20001;
                    }
                    String captureModeValue = captureModeCnfMgr.getCaptureModeValue(cnfDeviceCaptureMode.getWidth(), cnfDeviceCaptureMode.getHeight(), cnfDeviceCaptureMode.getResolution(), this.getDeviceCnf().getCaptureMode().getMaxFramerate());
                    if (captureModeValue == null) {
                        this.logger.warn("Could not find a matching capture mode for " + cnfDeviceCaptureMode.getWidth() + "x" + cnfDeviceCaptureMode.getHeight() + " for " + this);
                        this.logger.warn("I will use '1' as biggest possible capture mode for " + this);
                        String firmware = this.getFirmwareVersion();
                        if (this.getDeviceType() == 202375L && AxisFirmwareVersion.isFirmwareGreater(firmware, "7.15.2.2")) {
                            if (cnfDeviceCaptureMode.getDisplayResolution().equals("Fisheye")) {
                                captureModeValue = "1";
                            } else if (cnfDeviceCaptureMode.getDisplayResolution().equals("Dewarp 4:3")) {
                                captureModeValue = "2";
                            } else if (cnfDeviceCaptureMode.getDisplayResolution().equals("Dewarp 16:9")) {
                                captureModeValue = "3";
                            } else if (cnfDeviceCaptureMode.getDisplayResolution().equals("Dewarp 16:9 (HDMI)")) {
                                captureModeValue = "4";
                            } else if (cnfDeviceCaptureMode.getDisplayResolution().equals("Dewarp 16:9 25/30 fps")) {
                                captureModeValue = "5";
                            }
                        } else {
                            captureModeValue = "1";
                        }
                    }
                    if (captureModeCnfMgr.getTagFound() != null) {
                        this.logger.debug("Use CaptureMode group [" + captureModeCnfMgr.getTagFound() + "] for " + this);
                        StringBuilder url = new StringBuilder();
                        url.append("/axis-cgi/param.cgi?action=list&group=root.ImageSource.I0.");
                        url.append(captureModeCnfMgr.getTagFound());
                        url.append(".CaptureMode");
                        String currentCaptureMode = this.getHttpHandler().readGetRequest(url.toString());
                        try {
                            currentCaptureMode = currentCaptureMode.substring(currentCaptureMode.indexOf("root.ImageSource.I0."));
                            currentCaptureMode = currentCaptureMode.split("=")[1].trim();
                        }
                        catch (Exception e) {
                            this.logger.warn("Not able to parse out current CaptureMode for " + this);
                            currentCaptureMode = null;
                        }
                        this.logger.debug("Current CaptureMode is [" + currentCaptureMode + "] for " + this);
                        if (currentCaptureMode != null && currentCaptureMode.equals(captureModeValue)) {
                            this.logger.info("Requested CaptureMode [" + captureModeValue + "] already set for " + this);
                        } else {
                            this.logger.info("Requested CaptureMode [" + captureModeValue + "] NOT set yet for " + this);
                            url = new StringBuilder();
                            url.append("/axis-cgi/param.cgi?action=update&ImageSource.I0.");
                            url.append(captureModeCnfMgr.getTagFound());
                            url.append(".CaptureMode=");
                            url.append(captureModeValue);
                            this.getHttpHandler().readGetRequest(url.toString());
                            this.waitForCaputreModeChange("root.ImageSource.I0." + captureModeCnfMgr.getTagFound() + ".CaptureMode", captureModeValue);
                        }
                        break block25;
                    }
                    this.logger.error("Can't find out parameter group for CaptureMode for " + this);
                    break block25;
                }
                this.logger.debug("Capture mode settings disabled for " + this);
            }
            catch (SeeTecException ex) {
                if (this.checkForObsoleteInstance()) {
                    return 0;
                }
                this.logger.error("Exception [" + ex.getErrorCode() + "|" + ex.getMessage() + "] while setting capture mode for " + this, (Throwable)ex);
                if (ex.getErrorCode() == -20001) {
                    return -21656;
                }
                if (ex.getMessage().toLowerCase().contains("unauthorized")) {
                    this.logger.error("Unauthorized access for " + this);
                    return -21657;
                }
                this.logger.error("Init capture mode exception for " + this, (Throwable)ex);
                return -20001;
            }
            catch (Exception e) {
                this.logger.error("Exception [" + e.getMessage() + "] while setting capture mode for " + this, (Throwable)e);
                return -20001;
            }
        }
        return 0;
    }

    private int initViewAreas() {
        try {
            CnfDeviceVirtualCameras cnfDeviceVirtualCameras = this.getDeviceCnf().getVirtualCameras();
            if (cnfDeviceVirtualCameras.isEnabled()) {
                this.logger.debug("Virtual cameras enabled for " + this);
                this.getHttpHandler().readGetRequest("/axis-cgi/param.cgi?action=update&root.PTZ.ImageSource.I0.PTZEnabled=true");
            } else {
                String RequestCapabilityViewAreas = "/axis-cgi/param.cgi?action=list&group=Properties.API.HTTP.Version,Properties.PTZ.PTZ,Properties.PTZ.DigitalPTZ,Properties.Image.NbrOfViews";
                String reply = this.getHttpHandler().readGetRequest(RequestCapabilityViewAreas);
                int indexPtzYes = reply.indexOf("Properties.PTZ.PTZ=yes");
                int indexDigitalPtzYes = reply.indexOf("Properties.PTZ.DigitalPTZ=yes");
                int indexNbrOfViews = reply.indexOf("Properties.Image.NbrOfViews=1");
                if (indexPtzYes != -1 && indexDigitalPtzYes != -1 && indexNbrOfViews == -1) {
                    this.logger.debug("Camera has view area support but right now disabled for " + this);
                    String DisableViewArea = "/axis-cgi/param.cgi?action=update&root.PTZ.ImageSource.I0.PTZEnabled=false";
                    this.getHttpHandler().readGetRequest(DisableViewArea);
                } else {
                    this.logger.debug("Camera doesn't support view areas. " + this);
                }
            }
        }
        catch (SeeTecException ex) {
            if (this.checkForObsoleteInstance()) {
                return 0;
            }
            if (ex.getNetworkStatus() != HTTPStatusCode.HTTP_NOT_FOUND) {
                this.logger.error("Exception [" + ex.getErrorCode() + "|" + ex.getMessage() + "] while setting view area configuration for " + this);
                if (ex.getErrorCode() == -20001) {
                    return -21656;
                }
                if (ex.getNetworkStatus() == HTTPStatusCode.HTTP_UNAUTHORIZED) {
                    this.logger.error("Unauthorized access for " + this);
                    return -21657;
                }
                this.logger.error("Init view areas failed for " + this, (Throwable)ex);
                return -20001;
            }
        }
        catch (Exception e) {
            this.logger.error("Exception [" + e.getMessage() + "] while setting view area configuration for " + this, (Throwable)e);
            return -20001;
        }
        return 0;
    }

    private List<String> getAvailableCaptureModes() throws SeeTecException {
        String result;
        try {
            result = this.getHttpHandler().readGetRequest(REQUEST_CAPTURE_MODES);
        }
        catch (Exception exception) {
            this.logger.warn("Could not read networkparameters for " + this);
            throw new SeeTecException(-21600, exception.getMessage());
        }
        int indexOfHeaderEnd = result.indexOf("\r\n\r\n");
        result = result.substring(indexOfHeaderEnd + 4);
        if (indexOfHeaderEnd == -1 || result.contains("Error: Error -1")) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(result.getBytes());
            Document deviceConf = new SAXBuilder().build((InputStream)bais);
            Element root = deviceConf.getRootElement();
            List list = root.getChild("group", root.getNamespace()).getChild("group", root.getNamespace()).getChild("group", root.getNamespace()).getChild("group", root.getNamespace()).getChild("parameter", root.getNamespace()).getChild("type", root.getNamespace()).getChild("enum", root.getNamespace()).getChildren();
            ArrayList<String> captureModes = new ArrayList<String>();
            for (Element element : list) {
                if (element.getAttributes().size() > 1) {
                    captureModes.add(element.getAttributeValue("value") + MARKER + element.getAttributeValue("niceValue"));
                    continue;
                }
                captureModes.add(element.getAttributeValue("value"));
            }
            return captureModes;
        }
        catch (JDOMException exception) {
            this.logger.info("No valid XML -> no capture modes available for " + this);
            return null;
        }
    }

    private void setSeiTriggerDataOnDevice(boolean enable) {
        String value = enable ? "yes" : "no";
        try {
            StringBuilder completeUrl = new StringBuilder();
            completeUrl.append("/axis-cgi/param.cgi?action=update");
            completeUrl.append("&Image.I0.MPEG.UserDataEnabled=").append(value);
            completeUrl.append("&Image.TriggerDataEnabled=").append(value);
            completeUrl.append("&Image.I0.TriggerData.TamperingEnabled=").append(value);
            completeUrl.append("&Image.I0.TriggerData.MotionDetectionEnabled=").append(value);
            completeUrl.append("&Image.I0.TriggerData.VideoLossEnabled=").append(value);
            this.logger.info(Basic.generateIndentedMultiLineLog((String)completeUrl.toString()));
            this.getHttpHandler().readGetRequest(completeUrl.toString());
        }
        catch (Exception e) {
            this.logger.warn("Exception [" + e.getMessage() + "] while enabling SEI stuff on the device for " + this);
        }
    }

    private boolean checkForObsoleteInstance() {
        this.logger.debug("Check " + this + " for obsolete instance");
        for (Device device : this.core.getDeviceLifeCycleInformation().getDeviceList()) {
            if (!device.getDeviceID().equals(this.getDeviceID())) continue;
            if (device.hashCode() == this.hashCode()) break;
            this.logger.debug("Instance " + this + " is obsolete, so we ignore errors from delayed HTTP response");
            return true;
        }
        return false;
    }

    @Override
    public List<TimeRange> getRecordingInfosFromDevice(long startTimestamp, long endTimestamp, int videoSourceNr) {
        ArrayList<TimeRange> timeRanges = new ArrayList<TimeRange>();
        try {
            Element recordings;
            List recording;
            Document xmlDoc;
            Element root;
            String url = "/axis-cgi/record/list.cgi?recordingid=all&sortorder=ascending";
            int timeout = this.networkParameter.getSoTimeout();
            this.networkParameter.setSoTimeout((int)TimeUnit.MINUTES.toMillis(1L));
            String xmlString = this.getHttpHandler(true).readGetRequest(url);
            this.networkParameter.setSoTimeout(timeout);
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Response from device " + this + " : " + xmlString);
            }
            if ((root = (xmlDoc = new SAXBuilder().build((InputStream)bais)).getRootElement()) != null && (recording = (recordings = root.getChild("recordings")).getChildren("recording")) != null) {
                for (Object listElement : recording) {
                    long stop;
                    if (!(listElement instanceof Element)) continue;
                    Element rec = (Element)listElement;
                    String recordingName = rec.getAttributeValue("recordingid");
                    String startTime = rec.getAttributeValue("starttimelocal");
                    String stopTime = rec.getAttributeValue("stoptimelocal");
                    String source = rec.getAttributeValue("source");
                    long start = AxisPlaybackVideoSourceClient.convertAxisRecordingDateToTimestamp(startTime);
                    if (start == (stop = AxisPlaybackVideoSourceClient.convertAxisRecordingDateToTimestamp(stopTime))) {
                        this.logger.warn("Start time and stop time are equal : " + new Date(start) + " for " + this);
                        continue;
                    }
                    Long timeDifference = this.getTimeDifferenceFromDevice();
                    TimeRange timeRange = new TimeRange(start - timeDifference, stop - timeDifference, recordingName);
                    boolean videoSourceCorrect = this.isVideoSourceCorrect(source, videoSourceNr);
                    if (!videoSourceCorrect) continue;
                    timeRanges.add(timeRange);
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Error while getting recording infos from device for " + this, t);
        }
        return timeRanges;
    }

    public Long getTimeDifferenceFromDevice() throws SeeTecException, JDOMException, Exception {
        long timeStamp = 0L;
        try {
            String url = "/axis-cgi/time.cgi";
            String jsonBody = "{\"apiVersion\":\"1.0\",\"method\":\"getAll\"}";
            String response = this.getHttpHandler().readPostRequest(url, jsonBody, false, "application/json");
            timeStamp = this.parseDateTimeStringToTimestamp(response);
        }
        catch (Exception ex) {
            this.logger.info("New command for getting time from device does not work. Trying old API command for " + this);
            String response = this.getHttpHandler().readGetRequest("/axis-cgi/date.cgi?action=get");
            String dateTime = response.replace("\r", "").replace("\n", "").trim();
            timeStamp = AxisPlaybackVideoSourceClient.convertAxisDateToTimestamp(dateTime);
        }
        if (timeStamp != 0L) {
            long localTime = System.currentTimeMillis();
            long diff = timeStamp - localTime;
            this.logger.info(String.format("Time difference for %s: %d ms", this, diff));
            return diff;
        }
        throw new SeeTecException(-21600, "Error while calculating time difference between device and server");
    }

    public boolean isVideoSourceCorrect(String source, int videoSourceNr) {
        boolean isVideoSourceCorrect = false;
        try {
            if (source.equalsIgnoreCase("quad") && videoSourceNr == 5) {
                isVideoSourceCorrect = true;
            } else if (videoSourceNr == Integer.parseInt(source)) {
                isVideoSourceCorrect = true;
            }
        }
        catch (NumberFormatException e) {
            this.logger.error("Video source:" + source + " could not be mapped to the Camera, Recording not added.");
        }
        return isVideoSourceCorrect;
    }

    protected String checkEdgeStorageReady(int channelNumber) {
        List<TimeRange> lastRecordings = this.getRecordingInfosFromDevice(System.currentTimeMillis() - 60000L, System.currentTimeMillis(), channelNumber);
        ArrayList<String> multiLineLog = new ArrayList<String>();
        multiLineLog.add("Edge Storage Information for " + this);
        multiLineLog.add("Channel: " + channelNumber);
        if (lastRecordings.isEmpty()) {
            multiLineLog.add("Edge Storage is not ready, because there are no recordings available from the last 60 seconds");
        } else {
            multiLineLog.add("Edge Storage is ready on the camera.");
            try {
                AxisStorageQuery query = AxisQuery.controlStorage().diskIdAll();
                byte[] storageInfo = this.getHttpHandler(true).readGetRequestAsByteArray(query.toString());
                AxisDisksPropertiesCnfMgr disksProps = new AxisDisksPropertiesCnfMgr();
                int errorCode = disksProps.init(storageInfo);
                if (errorCode != 0) {
                    throw new SeeTecException(-20002, "Wrong XML response format to be used in AxisDisk class.");
                }
                multiLineLog.add("");
                multiLineLog.add("Additional Information from camera:");
                multiLineLog.add("");
                for (int i = 0; i < disksProps.getNumberOfDisks(); ++i) {
                    AxisDisk disk = disksProps.getDisk(i);
                    multiLineLog.add(disk.toString());
                }
            }
            catch (Exception ex) {
                multiLineLog.add("Could not gather additional edge storage information from camera");
            }
        }
        String edgeStorageStatus = Basic.generateIndentedMultiLineLog(multiLineLog);
        this.logger.info(edgeStorageStatus);
        return edgeStorageStatus;
    }

    protected AxisEventReader createEventReader(List<GenericEventTriggerCnf> genericEventTriggerCnfs) {
        try {
            this.semaphore.acquire();
            if (this.axisEventReader == null && this.getAxisFirmwareVersion().isEventDataStreamSupported()) {
                this.axisEventReader = new AxisEventReader(this, genericEventTriggerCnfs);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("AxisEventReader won't be started for " + this + ". Reason: " + ex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error("Exception while starting event reader: " + ex.getMessage() + " for " + this);
        }
        finally {
            this.semaphore.release();
        }
        return this.axisEventReader;
    }

    protected AxisEventReader getEventReader() {
        try {
            this.semaphore.acquire();
            AxisEventReader axisEventReader = this.axisEventReader;
            return axisEventReader;
        }
        catch (InterruptedException interruptedException) {
            this.logger.error("AxisEventReader can't be delivered. Reason: " + interruptedException.getMessage());
        }
        finally {
            this.semaphore.release();
        }
        return null;
    }

    public HttpHandlerImpl getHttpHandler() throws Exception {
        return this.getHttpHandler(false);
    }

    public HttpHandlerImpl getHttpHandler(boolean forceNewInstance) throws Exception {
        if (this.httpHandler == null || forceNewInstance) {
            this.httpHandler = new HttpHandlerImpl(this.networkParameter);
        }
        return this.httpHandler;
    }

    void setAxisNetworkParameter(NetworkParameter networkParameter) {
        this.networkParameter = networkParameter;
    }

    public String getVideoSourceSpecifier(AxisDeviceParameters axisDeviceParameters, int videoSourceNr) throws SeeTecException {
        if (axisDeviceParameters.getSourceForView(videoSourceNr - 1).equalsIgnoreCase("quad")) {
            return "quad";
        }
        return "" + videoSourceNr;
    }

    protected long parseDateTimeStringToTimestamp(String response) {
        String[] responseLines;
        long timestamp = 0L;
        for (String responseLine : responseLines = response.split("\n")) {
            if (!responseLine.contains("\"dateTime\":")) continue;
            String dateTime = responseLine.replace("\"", "").replace("dateTime:", "").replace(",", "").trim();
            ZonedDateTime cameraTime = ZonedDateTime.parse(dateTime);
            timestamp = cameraTime.toInstant().toEpochMilli();
            break;
        }
        return timestamp;
    }
}

