/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperH264;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.shared.videostatus.AnalogVideoStatus;
import de.seetec.v5.re.cm.device.shared.videostatus.AnalogVideoStatusReader;
import de.seetec.v5.re.cm.device.video.axis.AxisAudioOutServer;
import de.seetec.v5.re.cm.device.video.axis.AxisCameraControl;
import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.re.cm.device.video.axis.AxisEventTriggerHandler;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisSEIUserDataReader;
import de.seetec.v5.re.cm.device.video.axis.videosource.AxisAudioSourceClient;
import de.seetec.v5.re.cm.device.video.axis.videosource.AxisH264VideoSourceClient;
import de.seetec.v5.re.cm.device.video.axis.videosource.AxisJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.axis.videosource.AxisMPEGVideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.EdgeStorageParameter;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.OPCLowerNodeIDType;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Vector;

public class AxisCameraSrv
extends LiveCameraSrv {
    private long videoLossSince = Long.MIN_VALUE;
    private boolean videoLossAlarmTriggered = false;
    private boolean tamperingAlarmTriggered = false;
    private AxisDevice axisDevice = null;

    @Override
    public int init(Vector<PresetCnf> presetList) throws ConfigurationException {
        this.axisDevice = (AxisDevice)this.getDevice();
        EdgeStorageParameter edgeStorageParameter = this.getVideoSourceCnf().getEdgeStorageParameter();
        if (edgeStorageParameter != null && edgeStorageParameter.isEnabled()) {
            this.axisDevice.checkEdgeStorageReady(this.getVideoSourceCnf().getServerEntryNo());
        }
        return super.init(presetList);
    }

    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new AxisCameraControl();
    }

    public void setChannelParameters(boolean useTitle, String title, boolean useDateTime, int rotationAngle) throws ConfigurationException, SeeTecException, Exception {
        String url = "/axis-cgi/param.cgi?action=update";
        int channelNr = this.getVideoSourceCnf().getServerEntryNo() - 1;
        url = useTitle ? url + "&Image.I" + channelNr + ".Text.String=" + title + "&Image.I" + channelNr + ".Text.TextEnabled=yes" : url + "&Image.I" + channelNr + ".Text.TextEnabled=no";
        url = useDateTime ? url + "&Image.I" + channelNr + ".Text.DateEnabled=yes&Image.I" + channelNr + ".Text.ClockEnabled=yes" : url + "&Image.I" + channelNr + ".Text.DateEnabled=no&Image.I" + channelNr + ".Text.ClockEnabled=no";
        if (this.axisDevice.getAxisDeviceParameters().canSourceImageRotation(channelNr)) {
            url = url + "&ImageSource.I" + channelNr + ".Rotation=" + rotationAngle;
        }
        this.axisDevice.getHttpHandler().readGetRequest(url);
    }

    @Override
    protected AxisAudioOutServer createAudioOutServer() {
        NetworkParameter networkParameter = null;
        try {
            networkParameter = this.axisDevice.getAxisNetworkParameter();
        }
        catch (ConfigurationException configurationException) {
            this.logger.error("Could not read Network parameter [" + configurationException.getMessage() + "] for " + this);
        }
        AxisAudioOutServer axisAudioOutServer = new AxisAudioOutServer(networkParameter);
        axisAudioOutServer.init();
        return axisAudioOutServer;
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        VideoSourceClient videoSourceClient = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Creating new [VideoSourceClient] with VideoProfileHandler [" + listener + "] for " + this);
        }
        try {
            int errorCode;
            Codec streamingMode = listener.getVideoSourceParameter().getMediaCodec();
            if (listener.getVideoSourceParameter().getEntity().getEntityType() == 210069L) {
                videoSourceClient = new AxisAudioSourceClient();
                errorCode = videoSourceClient.init(core, this, listener);
            } else {
                if (null == streamingMode) {
                    videoSourceClient = new AxisJPEGVideoSourceClient();
                } else {
                    switch (streamingMode) {
                        case MPEG4: {
                            videoSourceClient = new AxisMPEGVideoSourceClient();
                            break;
                        }
                        case H264: 
                        case H265: {
                            videoSourceClient = new AxisH264VideoSourceClient();
                            break;
                        }
                        default: {
                            videoSourceClient = new AxisJPEGVideoSourceClient();
                        }
                    }
                }
                try {
                    if (AxisDevice.isFisheyeCamera(this.axisDevice.getDeviceType()) && (errorCode = this.axisDevice.setCameraOrientation(listener)) != 0) {
                        this.logger.error("Could not set camera orientation for " + this);
                    }
                }
                catch (Exception ex) {
                    this.logger.error("Error while setting camera orientation for " + this, (Throwable)ex);
                }
                errorCode = videoSourceClient.init(core, this, listener);
            }
            this.videoLossSince = Long.MIN_VALUE;
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] failed with error [" + errorCode + "]  for " + this);
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] failed with error [" + errorCode + "]  for " + this);
            }
        }
        catch (SeeTecException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error("Creating [VideoSourceClient] failed [" + ex.getMessage() + "] for " + this, ex);
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] failed [" + ex.getMessage() + "] for " + this);
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] resolution) throws SeeTecException {
        try {
            StringBuilder url = new StringBuilder("/axis-cgi/jpg/image.cgi?camera=1");
            if (resolution != null && resolution.length == 2 && resolution[0] > 0 && resolution[1] > 0) {
                url.append("&resolution=").append(resolution[0]).append("x").append(resolution[1]);
            }
            url.append("&compression=50&overview=1");
            byte[] result = this.axisDevice.getHttpHandler().readGetRequestAsByteArray(url.toString());
            if (result != null) {
                return new ContentFrame(0, result);
            }
            this.logger.error("Error while requesting snapshot for " + this);
            throw new SeeTecException(-20001, "Unknown exception while requesting snapshot for " + this);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception [" + ex.getErrorCode() + "|" + ex.getMessage() + "] while requesting snapshot for " + this, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            this.logger.error("Exception [" + ex.getMessage() + "] while requesting snapshot for " + this, (Throwable)ex);
            throw new SeeTecException(-20001, "Exception [" + ex.getMessage() + "] while requesting snapshot for " + this);
        }
    }

    public int setViewAreas(VideoProfileHandler listener) throws Exception {
        long time = System.currentTimeMillis();
        if (listener != null && listener.getVideoSourceParameter().getCropping().isEnabled() && this.getDevice().getDeviceCnf().getVirtualCameras().isEnabled()) {
            int captureModeHeight;
            int captureModeWidth;
            int croppingX = listener.getVideoSourceParameter().getCropping().getRectangle()[0];
            int croppingY = listener.getVideoSourceParameter().getCropping().getRectangle()[1];
            int croppingWidth = listener.getVideoSourceParameter().getCropping().getRectangle()[2];
            int croppingHeight = listener.getVideoSourceParameter().getCropping().getRectangle()[3];
            if (this.getDevice().getDeviceType() == 202334L) {
                captureModeWidth = this.getDevice().getDeviceDefinitionFromConfiguration().getSupportedCaptureModes().getCaptureModeDefinition().get(0).getResolution().getWidth();
                captureModeHeight = this.getDevice().getDeviceDefinitionFromConfiguration().getSupportedCaptureModes().getCaptureModeDefinition().get(0).getResolution().getHeight();
            } else {
                captureModeWidth = this.getDevice().getDeviceCnf().getCaptureMode().getWidth();
                captureModeHeight = this.getDevice().getDeviceCnf().getCaptureMode().getHeight();
            }
            boolean use16to9 = listener.getVideoSourceParameter().getCropping().isUsing16to9();
            boolean use4to3 = listener.getVideoSourceParameter().getCropping().isUsing4to3();
            int videoSourceNr = listener.getVideoSourceParameter().getServerEntryNo();
            int MAX_ZOO_MFACTOR = 10000;
            int MIN_SIZE = 160;
            float a = 10000.0f / (float)(-captureModeWidth + 160);
            float b = 10000.0f - 1600000.0f / (float)(-captureModeWidth + 160);
            int zoomFactor = (int)(a * (float)croppingWidth + b);
            float directionMaxPan = croppingX + croppingWidth / 2 < (captureModeWidth /= 2) ? -180.0f : 180.0f;
            float directionMaxTilt = croppingY + croppingHeight / 2 > (captureModeHeight /= 2) ? -180.0f : 180.0f;
            float panFactor = (float)Math.abs(captureModeWidth - (croppingX + croppingWidth / 2)) * directionMaxPan / (float)captureModeWidth;
            float tiltFactor = (float)Math.abs(captureModeHeight - (croppingY + croppingHeight / 2)) * directionMaxTilt / (float)captureModeHeight;
            panFactor = (float)((double)((int)(panFactor * 10.0f)) / 10.0);
            tiltFactor = (float)((double)((int)(tiltFactor * 10.0f)) / 10.0);
            this.logger.info(Basic.generateIndentedMultiLineLog((String[])new String[]{this.toString(), "cropping[X,Y,Width,Height]: " + croppingX + "," + croppingY + "," + croppingWidth + "," + croppingHeight, "captureMode[Width,Height]: " + captureModeWidth * 2 + "," + captureModeHeight * 2, "pan/tilt/zoomFactor: " + panFactor + "/" + tiltFactor + "/" + zoomFactor}));
            StringBuilder url = new StringBuilder("/axis-cgi/param.cgi?action=update&Image.I");
            url.append(videoSourceNr - 1).append(".Enabled=yes&Image.I");
            url.append(videoSourceNr - 1).append(".Name=SeeTec");
            url.append(videoSourceNr).append("&Image.I").append(videoSourceNr - 1);
            if (use16to9 && !use4to3) {
                url.append(".Appearance.Resolution=160x90");
            } else {
                url.append(".Appearance.Resolution=160x120");
            }
            url.append("&PTZ.Various.V");
            url.append(videoSourceNr);
            url.append(".Locked=false");
            this.axisDevice.getHttpHandler().readGetRequest(url.toString());
            url = new StringBuilder("/axis-cgi/com/ptz.cgi?camera=").append(videoSourceNr).append("&zoom=").append(zoomFactor).append("&pan=").append(panFactor).append("&tilt=").append(tiltFactor);
            this.axisDevice.getHttpHandler().readGetRequest(url.toString());
            if (this.getCore().getCoreExtension().contains("DEPRECATED_VIEWAREA_PRESETS")) {
                url = new StringBuilder("/axis-cgi/com/ptzconfig.cgi?camera=" + videoSourceNr + "&setserverpresetname=Home&home=yes");
                this.axisDevice.getHttpHandler().readGetRequest(url.toString());
            }
            url = new StringBuilder("/axis-cgi/param.cgi?action=update&PTZ.Various.V" + videoSourceNr + ".Locked=true");
            this.axisDevice.getHttpHandler().readGetRequest(url.toString());
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Time for seeting view areas: " + (System.currentTimeMillis() - time));
            }
            return 0;
        }
        this.logger.debug("No view areas used for " + this);
        return 0;
    }

    public String getNearestResolution(int videoSourceNr, int width, int height) throws SeeTecException, ConfigurationException, Exception {
        String[] resolutions;
        this.logger.debug("Trying to get resolution nearest to " + width + "x" + height + " for " + this);
        String result = this.axisDevice.getHttpHandler().readGetRequest("/axis-cgi/param.cgi?action=list&group=Properties.Image.I" + (videoSourceNr - 1) + ".Resolution");
        String[] resolutionLines = result.split("Resolution=");
        if (resolutionLines.length == 2 && (resolutions = resolutionLines[1].replace("\n", "").replace("\r", "").split(",")).length > 0) {
            Integer[][] cameraResolutions = new Integer[resolutions.length][2];
            for (int i = 0; i < resolutions.length; ++i) {
                String[] singleResolution = resolutions[i].split("x");
                if (singleResolution.length != 2) continue;
                cameraResolutions[i][0] = Integer.parseInt(singleResolution[0]);
                cameraResolutions[i][1] = Integer.parseInt(singleResolution[1]);
            }
            for (Integer[] cameraResolution : cameraResolutions) {
                if (cameraResolution[0] == width && cameraResolution[1] == height) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Found resolution " + width + "x" + height + " for " + this);
                    }
                    return width + "x" + height;
                }
                if (cameraResolution[0] == width && cameraResolution[1] < height) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Found resolution " + cameraResolution[0] + "x" + cameraResolution[1] + " for " + this);
                    }
                    return cameraResolution[0] + "x" + cameraResolution[1];
                }
                if (cameraResolution[0] >= width) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Found resolution " + cameraResolution[0] + "x" + cameraResolution[1] + " for " + this);
                }
                return cameraResolution[0] + "x" + cameraResolution[1];
            }
            return cameraResolutions[cameraResolutions.length - 1][0] + "x" + cameraResolutions[cameraResolutions.length - 1][1];
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("No nearest Resolution found. Using " + width + "x" + height + " for " + this);
        }
        return width + "x" + height;
    }

    @Override
    protected GenericEventTriggerHandler createNewGenericEventTriggerHandler() {
        return new AxisEventTriggerHandler(this);
    }

    public void checkForSEIUserData(VideoProfileHandler listener, byte[] data, boolean isH264Data) {
        if ((data[12] & 6) == 6) {
            byte[] pattern = new byte[16];
            for (int i = 0; i < 16; ++i) {
                pattern[i] = -86;
            }
            int indexAfterAAs = Basic.indexOfByteArray((byte[])data, (byte[])pattern, (int)12, (int)(data.length - 12));
            if (indexAfterAAs == -1) {
                return;
            }
            if (isH264Data) {
                data = StreamingHelperH264.demaskH264Data(data, 12);
            }
            try {
                int lengthOfUserData;
                for (int i = indexAfterAAs; i < data.length - 1 && (lengthOfUserData = Basic.byteArrayToInt4((byte[])new byte[]{data[i], data[i + 1]})) >= 0; i += lengthOfUserData + 2) {
                    byte[] userData = new byte[lengthOfUserData];
                    if (lengthOfUserData > data.length - (i + 2)) {
                        this.logger.debug("Given length [" + lengthOfUserData + "] is longer then rest of bytes.");
                        this.logger.debug(Basic.byteArrayToHexString((byte[])data, (int)0, (int)data.length));
                        break;
                    }
                    System.arraycopy(data, i + 2, userData, 0, lengthOfUserData);
                    if (userData[0] != 10 || userData[1] != 3) continue;
                    String userDataAsString = new String(userData);
                    userDataAsString = userDataAsString.substring(2);
                    AxisSEIUserDataReader seiUserData = new AxisSEIUserDataReader(this, userDataAsString);
                    this.evaluateSEIUserData(listener, seiUserData);
                }
            }
            catch (Exception ex) {
                this.logger.error("Unexpected SEI data (without RTP header): " + Basic.byteArrayToHexString((byte[])data, (int)12, (int)(data.length - 12)) + " for " + this, (Throwable)ex);
            }
        }
    }

    public void evaluateSEIUserData(VideoProfileHandler listener, AnalogVideoStatusReader seiUserData) throws Exception {
        boolean isGenericTampering = false;
        boolean isGenericAxisDevice = AxisDevice.isGenericDriver(this.getEntityType());
        if (isGenericAxisDevice && this.getGenericEventHandler() != null && this.getGenericEventHandler() instanceof AxisEventTriggerHandler) {
            AxisEventTriggerHandler triggerHandler = (AxisEventTriggerHandler)this.getGenericEventHandler();
            triggerHandler.forwardTrigger((AxisSEIUserDataReader)seiUserData);
            if (triggerHandler.isTriggerEnabled("T0") || triggerHandler.isTriggerContainingEnabled("tampering")) {
                isGenericTampering = true;
            }
        }
        if (listener != null) {
            int videoSourceNr = listener.getVideoSourceParameter().getServerEntryNo();
            if (seiUserData.getVideoSignalState(videoSourceNr) == AnalogVideoStatus.VIDEOLOSS) {
                if (listener.getVideoSourceParameter().isEnableVideoloss() || isGenericAxisDevice) {
                    if (this.videoLossSince == Long.MIN_VALUE) {
                        this.videoLossSince = System.currentTimeMillis();
                        this.videoLossAlarmTriggered = false;
                    }
                    if (this.videoLossSince != Long.MIN_VALUE && System.currentTimeMillis() > this.videoLossSince + 5000L && !this.videoLossAlarmTriggered) {
                        this.videoLossAlarmTriggered = true;
                        this.logger.debug("Videoloss for longer than 5sec. Trigger alarm! for " + this);
                        listener.sendStatusService(-21663);
                        if (listener.hasHardwareMotionDetection()) {
                            this.evaluateVideoLoss();
                            if (System.currentTimeMillis() > listener.getVideoSourceClient().getLastVideoLossEventSent() + 5000L) {
                                listener.getVideoSourceClient().setLastVideoLossEventSent(System.currentTimeMillis());
                                this.getCore().sendVideoLossEvent(this);
                            }
                        }
                    }
                }
            } else if (seiUserData.getVideoSignalState(videoSourceNr) == AnalogVideoStatus.VIDEOGAIN && this.videoLossSince != Long.MIN_VALUE) {
                listener.sendStatusService(0);
                this.videoLossSince = Long.MIN_VALUE;
                this.getCore().sendOPCEvent("false", OPCLowerNodeIDType.CAMERA_VIDEOLOSS_STATUS, this.getEntityID());
            }
            if (seiUserData.getTamperingState(videoSourceNr) == AnalogVideoStatus.TAMPERING) {
                if ((listener.getVideoSourceParameter().isEnableTampering() || isGenericTampering) && !this.tamperingAlarmTriggered) {
                    this.tamperingAlarmTriggered = true;
                    this.logger.debug("Tampering detected for: " + this);
                    if (listener.hasHardwareMotionDetection()) {
                        this.evaluateTampering();
                        if (System.currentTimeMillis() > listener.getVideoSourceClient().getLastTamperingEventSent() + 10000L) {
                            listener.getVideoSourceClient().setLastTamperingEventSent(System.currentTimeMillis());
                            this.getCore().sendTamperingEvent(this);
                        }
                    }
                }
            } else if (seiUserData.getTamperingState(videoSourceNr) == AnalogVideoStatus.NOTAMPERING && this.tamperingAlarmTriggered) {
                this.tamperingAlarmTriggered = false;
            }
        }
    }
}

