/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis;

import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministration;
import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministrationBase;
import de.seetec.v5.shared.net.HttpHandler;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.SeetecHttpClient;
import de.seetec.v5.shared.util.SeeTecException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.http.ContentType;

public class AxisCameraAdministration
extends CameraAdministrationBase
implements CameraAdministration {
    public AxisCameraAdministration(SeetecHttpClient httpClient) throws SeeTecException {
        super(httpClient);
    }

    public HttpHandler getHttpHandler(NetworkParameter networkParameter) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        return new HttpHandlerImpl(networkParameter);
    }

    @Override
    protected void modifyPasswordOnDevice(String passwordToSet, NetworkParameter networkParameter) throws SeeTecException {
        try {
            String userName = networkParameter.getUserPWD()[0];
            HttpHandlerImpl httpHandler = new HttpHandlerImpl(networkParameter);
            String response = httpHandler.readGetRequest("/axis-cgi/pwdgrp.cgi?action=update&user=" + userName + "&pwd=" + passwordToSet);
            this.checkResponseBodyForError(response);
        }
        catch (SeeTecException seeTecException) {
            throw new SeeTecException(seeTecException.getErrorCode(), "Error while setting password. Status: " + seeTecException.getNetworkStatus() + ". Message: " + seeTecException.getMessage());
        }
        catch (Exception ex) {
            throw new SeeTecException(-21600, "Error while setting password. Message: " + ex.getMessage());
        }
    }

    @Override
    protected void upgradeFirmwareOnDevice(byte[] firmwareData, NetworkParameter networkParameter) throws SeeTecException {
        networkParameter.setSoTimeout((int)TimeUnit.MINUTES.toMillis(15L));
        try {
            HttpHandler httpHandler = this.getHttpHandler(networkParameter);
            String responseBody = httpHandler.readPostRequestMultipart("/axis-cgi/firmwareupgrade.cgi", "firmware.bin", firmwareData, ContentType.APPLICATION_OCTET_STREAM, "firmware.bin");
            this.checkResponseBodyForError(responseBody);
            this.checkResponseBodyForAlreadyInProgress(responseBody);
            this.checkResponseBodyForUpgradeSuccessful(responseBody);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException exception) {
            throw new SeeTecException(-20001, "Error while upgrading firmware on device. Message: " + exception.getMessage());
        }
        catch (SeeTecException seeTecException) {
            throw new SeeTecException(seeTecException.getErrorCode(), "Error while upgrading firmware on device. Status: " + seeTecException.getNetworkStatus() + ". Message: " + seeTecException.getMessage());
        }
    }

    private void checkResponseBodyForError(String responseBody) throws SeeTecException {
        if (responseBody.contains("Error")) {
            throw new SeeTecException(-20002, responseBody);
        }
    }

    private void checkResponseBodyForAlreadyInProgress(String responseBody) throws SeeTecException {
        if (responseBody.contains("Already in Progress")) {
            throw new SeeTecException(-20002, responseBody);
        }
    }

    private void checkResponseBodyForUpgradeSuccessful(String responseBody) throws SeeTecException {
        if (!responseBody.contains("upgrade completed successfully")) {
            throw new SeeTecException(-20002, responseBody);
        }
    }
}

