/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.avigilon;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.avigilon.AvigilonDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.onvif.ver10.media.wsdl.Media;
import org.onvif.ver10.schema.AudioEncoderConfiguration;
import org.onvif.ver10.schema.AudioEncoding;
import org.onvif.ver10.schema.H264Configuration;
import org.onvif.ver10.schema.IntRange;
import org.onvif.ver10.schema.Mpeg4Configuration;
import org.onvif.ver10.schema.Profile;
import org.onvif.ver10.schema.StreamType;
import org.onvif.ver10.schema.TransportProtocol;
import org.onvif.ver10.schema.VideoEncoderConfiguration;
import org.onvif.ver10.schema.VideoEncoderConfigurationOptions;
import org.onvif.ver10.schema.VideoEncoding;
import org.onvif.ver10.schema.VideoRateControl;
import org.onvif.ver10.schema.VideoResolution;

public final class AvigilonVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.avigilon.AvigilonVideoSourceClient";

    @Override
    public int init() {
        String rtspHost = "";
        int rtspPort = 554;
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        try {
            int videoSourceNumber = this.listener.getVideoSourceParameter().getServerEntryNo() - 1;
            boolean audioStreamNumber = false;
            AvigilonDevice avigilonDevice = (AvigilonDevice)this.getVideoSrv().getDevice();
            OnvifCore onvifCore = avigilonDevice.getOnvifCore();
            avigilonDevice.getEventTypesMap();
            Media mediaService = onvifCore.getMediaService().getOnvifMediaService();
            Profile profile = onvifCore.getMediaService().getOnvifMediaService().getProfile("defaultPrimary" + videoSourceNumber);
            String selectedStreamName = "camEncCfg" + videoSourceNumber;
            VideoEncoderConfiguration videoEncoderConfiguration = mediaService.getVideoEncoderConfiguration(selectedStreamName);
            VideoEncoderConfigurationOptions videoEncoderConfigurationOptions = mediaService.getVideoEncoderConfigurationOptions(selectedStreamName, profile.getToken());
            IntRange qualityRange = videoEncoderConfigurationOptions.getQualityRange();
            VideoEncoding videoEncoding = null;
            if (this.videoCodec == Codec.MJPEG) {
                videoEncoding = VideoEncoding.JPEG;
                videoEncoderConfiguration.setMPEG4(null);
                videoEncoderConfiguration.setH264(null);
            } else if (this.videoCodec == Codec.H264) {
                videoEncoding = VideoEncoding.H_264;
                H264Configuration h264Configuration = videoEncoderConfiguration.getH264();
                IntRange govLengthRange = videoEncoderConfigurationOptions.getH264().getGovLengthRange();
                h264Configuration.setGovLength(Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, govLengthRange.getMin(), govLengthRange.getMax()));
                videoEncoderConfiguration.setH264(h264Configuration);
                videoEncoderConfiguration.setMPEG4(null);
            } else if (this.videoCodec == Codec.MPEG4) {
                videoEncoding = VideoEncoding.MPEG_4;
                Mpeg4Configuration mpeg4Configuration = videoEncoderConfiguration.getMPEG4();
                IntRange govLengthRange = videoEncoderConfigurationOptions.getMPEG4().getGovLengthRange();
                mpeg4Configuration.setGovLength(Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, govLengthRange.getMin(), govLengthRange.getMax()));
                videoEncoderConfiguration.setMPEG4(mpeg4Configuration);
                videoEncoderConfiguration.setH264(null);
            }
            videoEncoderConfiguration.setEncoding(videoEncoding);
            this.quality /= 1000;
            int calculatedQuality = this.quality * (qualityRange.getMax() - qualityRange.getMin()) / 100 + qualityRange.getMin();
            videoEncoderConfiguration.setQuality((float)calculatedQuality);
            VideoResolution videoResolution = new VideoResolution();
            videoResolution.setWidth(this.width);
            videoResolution.setHeight(this.height);
            videoEncoderConfiguration.setResolution(videoResolution);
            VideoRateControl videoRateControl = new VideoRateControl();
            videoRateControl.setBitrateLimit(this.bandwidth / 1024);
            videoRateControl.setEncodingInterval(1);
            videoRateControl.setFrameRateLimit((int)(this.fps / 1000L));
            videoEncoderConfiguration.setRateControl(videoRateControl);
            mediaService.setVideoEncoderConfiguration(videoEncoderConfiguration, true);
            if (profile.getVideoEncoderConfiguration() == null || profile.getVideoEncoderConfiguration() != null && !profile.getVideoEncoderConfiguration().getToken().equals(videoEncoderConfiguration.getToken())) {
                mediaService.addVideoEncoderConfiguration(profile.getToken(), videoEncoderConfiguration.getToken());
            }
            if (this.isAudioEnabled) {
                AudioEncoderConfiguration audioEncoderConfiguration = (AudioEncoderConfiguration)mediaService.getAudioEncoderConfigurations().get(0);
                AudioEncoding audioEncoding = null;
                if (this.audioCodec == Codec.G711U || this.audioCodec == Codec.G711A) {
                    audioEncoding = AudioEncoding.G_711;
                } else if (this.audioCodec == Codec.G726) {
                    audioEncoding = AudioEncoding.G_726;
                } else if (this.audioCodec == Codec.AAC) {
                    audioEncoding = AudioEncoding.AAC;
                }
                audioEncoderConfiguration.setEncoding(audioEncoding);
                audioEncoderConfiguration.setBitrate(64000);
                audioEncoderConfiguration.setSampleRate(8000);
                mediaService.setAudioEncoderConfiguration(audioEncoderConfiguration, true);
                if (profile.getAudioEncoderConfiguration() == null || profile.getAudioEncoderConfiguration() != null && !profile.getAudioEncoderConfiguration().getToken().equals(audioEncoderConfiguration.getToken())) {
                    mediaService.addAudioEncoderConfiguration(profile.getToken(), audioEncoderConfiguration.getToken());
                }
            }
            TransportProtocol transportProtocol = null;
            if (this.transmissionID == TransmissionType.RTP_OVER_UDP_UNICAST) {
                transportProtocol = TransportProtocol.UDP;
            } else if (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_TCP) {
                transportProtocol = TransportProtocol.TCP;
            }
            this.rtspUrl = onvifCore.getMediaService().getStreamUri(profile.getToken(), StreamType.RTP_UNICAST, transportProtocol);
            this.logger.info("Use following ONVIF Profile: " + profile.getToken() + "and following RTSP URL: " + this.rtspUrl + " for " + this);
            try {
                String regex = "rtsp://([a-zA-Z0-9.-]+)[:]?([\\p{Digit}]*)/";
                String result1 = "";
                String result2 = "";
                Matcher matcher = Pattern.compile("rtsp://([a-zA-Z0-9.-]+)[:]?([\\p{Digit}]*)/").matcher(this.rtspUrl);
                if (matcher.find()) {
                    result1 = matcher.group(1);
                    result2 = matcher.group(2);
                }
                rtspHost = result1 != null && !result1.equals("") ? result1 : this.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter().getHost();
                rtspPort = result2 != null && !result2.equals("") ? Integer.parseInt(result2) : this.listener.getVideoSourceParameter().getRtspPort();
                this.logger.info("Use following RTSP host: " + rtspHost + " for " + this);
                this.logger.info("Use following RTSP port: " + rtspPort + " for " + this);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.warn("RTSP port could not be read from given URL, so we use the default port (" + rtspPort + ")");
            }
        }
        catch (Throwable throwable) {
            this.logger.error("There are problems while setting parameters via ONVIF on the device", throwable);
            return -21662;
        }
        try {
            this.networkParameter.setSoTimeout(5000);
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, rtspPort, this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 3, this.rtspUrl);
            if (this.errorCode != 0) {
                this.logger.error("Error while setting RTSP parameters for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspSettings.setHost(rtspHost);
            this.rtspSettings.setUdpBuffer(65535);
            this.rtspSettings.setUserAgent("Java");
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP stream for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (SeeTecException exception) {
            this.logger.error("Error while first RTSP request. errorCode: " + exception.getErrorCode() + " for " + this.getVideoSrv(), (Throwable)exception);
            return exception.getErrorCode();
        }
        catch (Exception exception) {
            this.logger.error("Error while first RTSP request. errorCode: " + this.errorCode + " for " + this.getVideoSrv(), (Throwable)exception);
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }
}

