/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.avigilon;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.onvif.EventMessage;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.video.avigilon.AvigilonIoHandler;
import de.seetec.v5.shared.Basic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AvigilonEventHandler
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.avigilon.AvigilonEventHandler";
    private Logger logger = null;
    private Thread thread = null;
    private OnvifCore onvifCore = null;
    private final Collection<HardwareMotionDetection<? extends MotionDetectionHandler>> hardwareMotionDetections = Collections.synchronizedList(new ArrayList());
    private AvigilonIoHandler avigilonIoHandler = null;

    public AvigilonEventHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    public int init(OnvifCore onvifCore) {
        this.onvifCore = onvifCore;
        this.thread = new Thread((Runnable)this, CLASS_NAME);
        this.thread.start();
        return 0;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        int tryCounter = 0;
        while (!this.isShutdown(CLASS_NAME)) {
            try {
                List<EventMessage> eventMessages;
                if (tryCounter == 10) {
                    Thread.sleep(59500L);
                    tryCounter = 0;
                } else {
                    Thread.sleep(50L);
                }
                try {
                    eventMessages = this.onvifCore.getEventService().pullMessages(OnvifHelper.intToDuration(5), 30);
                    tryCounter = 0;
                }
                catch (Exception e) {
                    ++tryCounter;
                    this.logger.warn("Error while evaluating Onvif event for " + this, (Throwable)e);
                    continue;
                }
                HashMap<Integer, Boolean> inputs = new HashMap<Integer, Boolean>();
                for (EventMessage eventMessage : eventMessages) {
                    DigitalInputSrv[] iServices;
                    if (this.hardwareMotionDetections != null) {
                        for (HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection : this.hardwareMotionDetections) {
                            HardwareMotionDetectionCnf[] hardwareMotionDetectionCnfs = hardwareMotionDetection.getHardwareMotionDetectionCnf();
                            if (hardwareMotionDetectionCnfs == null || hardwareMotionDetectionCnfs.length <= 0) continue;
                            String onvifEventType = "RuleEngine/MotionDetection";
                            String topic = this.removeNamespace(eventMessage.getTopic());
                            if (!topic.contains("RuleEngine/MotionDetection")) continue;
                            int window = 0;
                            if (!eventMessage.getDataName().equals("MotionActive") || !eventMessage.getDataValue().equals("1")) continue;
                            int camno = hardwareMotionDetection.getVideoSrv().getVideoSourceCnf().getServerEntryNo() - 1;
                            if (!eventMessage.getSourceValue().equals("camCfg" + camno + "ana" + camno + "MotionDetector")) continue;
                            hardwareMotionDetection.evaluateWindow(window);
                        }
                    }
                    if (this.avigilonIoHandler == null || (iServices = this.avigilonIoHandler.getDigitalInputSrv()) == null) continue;
                    for (int i = 0; i < iServices.length; i += 2) {
                        if (!iServices[i + 1].getDigitalInputSrvCnf().isEnabled()) continue;
                        String onvifEventType = "Device/DigitalInput";
                        String topic = this.removeNamespace(eventMessage.getTopic());
                        if (!topic.contains("Device/DigitalInput") || !eventMessage.getDataName().equals("Active")) continue;
                        int input = Integer.parseInt(eventMessage.getSourceValue().substring(3));
                        if (iServices[i + 1].getInputNumber() - 1 != input) continue;
                        boolean inputDetected = eventMessage.getDataValue().equals("1");
                        if (inputs.get(input) != null && ((Boolean)inputs.get(input)).booleanValue()) continue;
                        inputs.put(input, inputDetected);
                    }
                }
                for (Map.Entry entry : inputs.entrySet()) {
                    this.avigilonIoHandler.receiveAlarm((Integer)entry.getKey(), (Boolean)entry.getValue() != false ? 1 : 0);
                }
            }
            catch (Exception exception) {
                this.logger.warn("Error while evaluating Onvif event for " + this, (Throwable)exception);
            }
        }
        super.setRunFinished(CLASS_NAME, true);
    }

    public int shutdown() {
        this.startShutdown(CLASS_NAME);
        return 0;
    }

    public void activateMotionDetection(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        if (!this.hardwareMotionDetections.contains(hardwareMotionDetection) && hardwareMotionDetection != null) {
            this.hardwareMotionDetections.add(hardwareMotionDetection);
        }
    }

    public void deactivateMotionDetection(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        if (this.hardwareMotionDetections.contains(hardwareMotionDetection)) {
            this.hardwareMotionDetections.remove(hardwareMotionDetection);
        }
    }

    public void activateInputAlarms(AvigilonIoHandler avigilonIoHandler) {
        this.avigilonIoHandler = avigilonIoHandler;
    }

    public void deactivateInputAlarms() {
        this.avigilonIoHandler = null;
    }

    protected String removeNamespace(String inputString) {
        if (inputString == null) {
            return null;
        }
        String[] stringWithoutSlashes = inputString.split("/");
        if (stringWithoutSlashes.length < 2) {
            return inputString;
        }
        for (int i = 0; i < stringWithoutSlashes.length; ++i) {
            String[] stringWithoutColon;
            String stringBetweenSlashes = stringWithoutSlashes[i];
            if (!stringBetweenSlashes.contains(":") || (stringWithoutColon = stringBetweenSlashes.split(":")).length != 2) continue;
            stringWithoutSlashes[i] = stringWithoutColon[1];
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < stringWithoutSlashes.length; ++i) {
            result.append(stringWithoutSlashes[i]);
            if (i >= stringWithoutSlashes.length - 1) continue;
            result.append("/");
        }
        return result.toString();
    }
}

