/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.arh;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class ARHVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.arh.ARHVideoSourceClient_Serverpush";
    private HttpServerPushHandler httpServerPushHandler;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        int errorCode = 0;
        errorCode = super.init(false);
        if (errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
            return errorCode;
        }
        this.highestFramerate = 60000L;
        this.quality /= 1000;
        String url = "/scapture?ajaxcall=1&multipart=1&jpegquality=" + this.quality;
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting quality paramter for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return errorCode;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        int errorCode = 0;
        this.logger.info("Start grabbing images for " + this);
        try {
            this.networkParameter = super.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while retrieveing network parameters for " + this + ": " + ex.getMessage());
        }
        this.networkParameter.setSoTimeout(5000);
        this.networkParameter.setHttpPort(9901);
        boolean asynchronous = false;
        this.httpServerPushHandler = new HttpServerPushHandler();
        errorCode = this.httpServerPushHandler.init(this, this.networkParameter, "/", 2048);
        if (errorCode != 0) {
            this.logger.error("Error [" + errorCode + "]with " + this.httpServerPushHandler);
        } else {
            errorCode = this.httpServerPushHandler.startServerPush(asynchronous);
            if (errorCode != 0) {
                this.logger.warn("ServerPush of " + this.httpServerPushHandler + " terminated with error [" + errorCode + "]");
            }
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        this.logger.info("End grabbing images for " + this);
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public synchronized int shutdown() {
        try {
            if (this.startShutdown(CLASS_NAME)) {
                return 0;
            }
            super.shutdown();
            if (this.httpServerPushHandler != null) {
                this.httpServerPushHandler.shutdown();
                this.httpServerPushHandler = null;
            }
            this.logger.info("shutdown done for " + this.getVideoSrv());
            return 0;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while shutdown for " + this, t);
            return -20000;
        }
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.shutdown();
    }
}

