/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.arh;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class ARHIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.arh.ARHIOHandler";

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean previousLoopWithError = false;
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs();
                    if (previousLoopWithError) {
                        DigitalInputSrv[] iServices;
                        previousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this);
                        DigitalInputSrv[] digitalInputSrvArray = iServices = super.getDigitalInputSrv();
                        int n = digitalInputSrvArray.length;
                        for (int i = 0; i < n; ++i) {
                            DigitalInputSrv iService = digitalInputSrvArray[i];
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(iService.getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    previousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)ex, ex);
                        if (ex.getMessage().indexOf("Address already in use") >= 0) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        DigitalInputSrv[] iServices;
                        for (DigitalInputSrv iService : iServices = super.getDigitalInputSrv()) {
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private int readDigitalInputs() throws Exception {
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        StringBuilder url = new StringBuilder("/trigger/gpiotrigger?getinput&ajaxcall=1");
        String sDigitalInput = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)false, (String)"input="));
        if (sDigitalInput.contains("Unable to recognize")) {
            url = new StringBuilder("/trigger/gpiotrigger?getgpin&wfilter=1");
            sDigitalInput = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)false, (String)"gpin"));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("DigitalInput [" + sDigitalInput + "] for " + this);
        }
        String[] inputValues = sDigitalInput.split("\r\n");
        int inputValue = 0;
        for (String inputValue1 : inputValues) {
            if (!inputValue1.contains("input") && !inputValue1.contains("gpin")) continue;
            String[] inputLine = inputValue1.split("=");
            if (inputLine.length == 2) {
                inputValue = Integer.parseInt(inputLine[1]);
            }
            iServices[0].checkInput(inputValue);
            iServices[1].checkInput(inputValue);
            return 0;
        }
        return 0;
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        IOHandler.HoldTimer holdTimer;
        int errorCode;
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + outputNumber + "] :-(");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this + " :-(");
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + outputNumber + "] with HoldTime [" + holdTime + "] for " + this);
        }
        try {
            String url = "/trigger/gpiotrigger?setoutput=" + value;
            this.logger.info("Sending [" + url + "] for " + this + " ...");
            String result = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE));
            if (result.contains("Unable to recognize:")) {
                url = "/trigger/gpiotrigger?gpout=" + value + "&wfilter=1";
                this.logger.info("Sending [" + url + "] for " + this + " ...");
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
            throw new RuntimeException("Cannot write value [" + value + "] to output [" + outputNumber + "] :-(");
        }
        if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
            holdTimer.shutdown();
            this.logger.warn("Creating " + holdTimer + " failed with error [ " + errorCode + " ] :-( ");
        }
        return 0;
    }
}

