/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.arecont.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.arecont.ArecontCameraSrv;
import de.seetec.v5.re.cm.device.video.arecont.ArecontDevice;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class ArecontH264VideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.arecont.mpeg.ArecontH264VideoSourceClient";
    private StringBuilder url = null;

    @Override
    public int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.iFrameDist = this.fps * (long)this.iFrameDistMS / 1000000L;
        this.quality /= 1000;
        this.quality /= 2;
        this.quality -= 50;
        this.quality = this.quality > 0 ? this.quality : this.quality * -1;
        this.quality = this.quality < 4 ? 4 : this.quality;
        this.quality = this.quality > 51 ? 51 : this.quality;
        this.fps /= 1000L;
        this.bandwidth = this.isConstantBitrateUsed ? (this.bandwidth /= 1024) : 65535;
        this.url = new StringBuilder("rtsp://");
        this.url.append(this.getHost());
        this.url.append("/h264.sdp");
        if (((ArecontCameraSrv)this.getVideoSrv()).isPanoramicModel()) {
            this.url.append(this.getVideoSourceNr());
        }
        this.url.append("?res=");
        try {
            if (((ArecontCameraSrv)this.getVideoSrv()).isScalingResolution(this)) {
                String setScaling = ((ArecontDevice)this.getVideoSrv().getDevice()).sendSetCommand("scaling", "on");
                if (!this.checkSetParameter("scaling", setScaling, "on")) {
                    throw new SeeTecException(-21710, "Could not activate scaling on camera for " + this);
                }
                String setScaleSize = ((ArecontDevice)this.getVideoSrv().getDevice()).sendSetCommand("scaling_size", this.width + "," + this.height);
                if (!this.checkSetParameter("scaling_size", setScaleSize, this.width + "," + this.height)) {
                    throw new SeeTecException(-21710, "Could not set scaling size on camera for " + this);
                }
                this.url.append("full");
                this.url.append("&channel=scaled");
            } else {
                this.url.append((CharSequence)((ArecontCameraSrv)this.getVideoSrv()).getCroppingString(this.resolutionTag, this.width, this.height, this));
            }
        }
        catch (Throwable t) {
            this.logger.info((Object)t, t);
            return -20000;
        }
        this.url.append("&ssn=");
        int ssn = 1;
        if (this.getVideoSrv() != null) {
            ssn = ((ArecontDevice)this.getVideoSrv().getDevice()).getSSN();
        }
        this.url.append(ssn);
        this.url.append("&doublescan=0");
        if (this.isConstantBitrateUsed) {
            try {
                String setRateLimitMode = ((ArecontDevice)this.getVideoSrv().getDevice()).sendSetCommand("ratelimit_mode", "on");
                String setRateLimit = ((ArecontDevice)this.getVideoSrv().getDevice()).sendSetCommand("ratelimit", String.valueOf(this.bandwidth));
                this.checkSetParameter("ratelimit_mode", setRateLimitMode, "on");
                this.checkSetParameter("ratelimit", setRateLimit, String.valueOf(this.bandwidth));
            }
            catch (Throwable t) {
                this.logger.info((Object)t, t);
                return -20000;
            }
        }
        try {
            ((ArecontDevice)this.getVideoSrv().getDevice()).sendSetCommand("bitrate", String.valueOf(0));
            ((ArecontDevice)this.getVideoSrv().getDevice()).sendSetCommand("ratelimit_mode", "off");
        }
        catch (Throwable t) {
            this.logger.info((Object)t, t);
            return -20000;
        }
        this.url.append("&qp=");
        this.url.append(this.quality);
        this.url.append("&fps=");
        this.url.append(this.fps);
        try {
            String setIFrame = "/setreg?page=3&";
            setIFrame = ((ArecontCameraSrv)this.getVideoSrv()).isPanoramicModel() ? setIFrame + "reg=100&val=" : setIFrame + "reg=21&val=";
            setIFrame = setIFrame + this.iFrameDist;
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)setIFrame, (int)Integer.MAX_VALUE);
        }
        catch (Exception e) {
            this.logger.error("Error while setting iFrame distance " + this.getVideoSrv());
            return -21601;
        }
        this.errorCode = ((ArecontCameraSrv)this.getVideoSrv()).rotateImage(this, this.networkParameter);
        if (this.errorCode != 0) {
            return this.errorCode;
        }
        try {
            this.transmissionID = this.getListener().getVideoSourceParameter().getTransmissionID();
        }
        catch (ConfigurationException exception) {
            this.logger.error("Exception while getting streaming configuration for " + this + ": " + exception.getMessage());
        }
        if (this.isAudioEnabled) {
            this.url.append("&mic=on");
        }
        this.logger.info(this.url.toString());
        this.rtspSettings = new RTSPStreamSettings();
        this.networkParameter.setSoTimeout(Math.max(10000, this.iFrameDistMS * 3));
        try {
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.url.toString(), this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 1);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this, (Throwable)ex);
        }
        this.rtspSettings.setKeepAliveInterval(3000);
        this.rtspSettings.setTcpChannel(0);
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while initializing RTSP Handler for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        this.errorCode = this.rtspHandler.start();
        if (this.errorCode != 0) {
            this.logger.error("Start of RTSP Handler failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.getListener().sendStatusService(error);
        this.shutdown();
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }

    private boolean checkSetParameter(String parameter, String result, String expectedResult) {
        if (((ArecontDevice)this.getVideoSrv().getDevice()).isFeatureAvailable(result) && result.contains(expectedResult)) {
            return true;
        }
        this.logger.warn(parameter + " could not be set for " + this);
        return false;
    }
}

