/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.arecont.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.arecont.ArecontCameraSrv;
import de.seetec.v5.re.cm.device.video.arecont.ArecontDevice;
import de.seetec.v5.shared.util.SeeTecException;

public class ArecontJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.arecont.jpeg.ArecontJPEGVideoSourceClient";
    private StringBuilder croppingString = null;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        try {
            this.logger.info("init started for" + this.getVideoSrv());
            int errorCode = super.init(false);
            if (errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
                return errorCode;
            }
            try {
                this.croppingString = ((ArecontCameraSrv)this.getVideoSrv()).getCroppingString(this.resolutionTag, this.width, this.height, this);
            }
            catch (SeeTecException e) {
                this.logger.error("Error while building cropping string for " + this);
                return e.getErrorCode();
            }
            errorCode = ((ArecontCameraSrv)this.getVideoSrv()).rotateImage(this, this.networkParameter);
            if (errorCode != 0) {
                return errorCode;
            }
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return errorCode;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            StringBuilder sb = new StringBuilder();
            long setFps = (this.highestFramerate + 999L) / 1000L;
            int setQuality = (int)((float)this.quality / 4700.0f);
            if (setQuality < 1) {
                setQuality = 1;
            } else if (setQuality > 21) {
                setQuality = 21;
            }
            sb.append("/mjpeg");
            if (((ArecontCameraSrv)this.getVideoSrv()).isPanoramicModel()) {
                sb.append(this.getVideoSourceNr());
            }
            sb.append("?res=");
            if (!((ArecontCameraSrv)this.getVideoSrv()).isScalingResolution(this)) {
                sb.append((CharSequence)this.croppingString);
            } else {
                sb.append("full");
            }
            sb.append("&fps=");
            sb.append(setFps);
            sb.append("&quality=");
            sb.append(setQuality);
            if (((ArecontCameraSrv)this.getVideoSrv()).isScalingResolution(this)) {
                sb.append("&channel=scaled");
                String setScaling = ((ArecontDevice)this.getVideoSrv().getDevice()).sendSetCommand("scaling", "on");
                if (!setScaling.contains("on")) {
                    throw new SeeTecException(-21710, "Could not activate scaling on camera for " + this);
                }
                String setScaleSize = ((ArecontDevice)this.getVideoSrv().getDevice()).sendSetCommand("scaling_size", this.width + "," + this.height);
                if (!setScaleSize.contains(String.valueOf(this.width)) && !setScaleSize.contains(String.valueOf(this.height))) {
                    throw new SeeTecException(-21710, "Could not set scaling size on camera for " + this);
                }
            }
            try {
                this.networkParameter.setSoTimeout(5000);
                boolean asynchronous = false;
                this.logger.info(sb.toString());
                HttpServerPushHandler httpServerPushHandler = new HttpServerPushHandler();
                int errorCode = httpServerPushHandler.init(this, this.networkParameter, sb.toString());
                if (errorCode != 0) {
                    this.logger.error("Error [" + errorCode + "]with " + httpServerPushHandler);
                } else {
                    errorCode = httpServerPushHandler.startServerPush(asynchronous);
                    if (errorCode != 0) {
                        this.logger.warn("ServerPush of " + httpServerPushHandler + " terminated with error [" + errorCode + "]");
                    }
                }
                httpServerPushHandler.shutdown();
            }
            catch (Throwable ex) {
                this.logger.error((Object)ex, ex);
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        super.getListener().sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        super.getListener().notifyForNetworkProblems();
        this.shutdown();
    }
}

