/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.arecont;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class ArecontIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.arecont.ArecontIOHandler";

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.readDigitalInputs();
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private int readDigitalInputs() {
        DigitalInputSrv[] iServices;
        String url = "/get?auxin";
        for (DigitalInputSrv iService : iServices = super.getDigitalInputSrv()) {
            try {
                byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
                if (result != null) {
                    String s = new String(result);
                    if (s.contains("auxin=on")) {
                        iService.checkInput(1);
                        continue;
                    }
                    if (s.contains("auxin=off")) {
                        iService.checkInput(0);
                        continue;
                    }
                    this.logger.warn("Could not read auxiliary input value");
                    continue;
                }
                this.logger.warn("Could not read auxiliary input");
                return -21679;
            }
            catch (SeeTecException ex) {
                this.logger.error("Could not read auxiliary input");
                return -21679;
            }
        }
        return 0;
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        int errorCode = 0;
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this);
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + outputNumber + "] with HoldTime [" + holdTime + "] for " + this);
        }
        try {
            IOHandler.HoldTimer holdTimer;
            String url = "/set?auxout=" + (value > 0 ? "on" : "off");
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] :-(");
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Problems setting output [" + outputNumber + "] of " + this + " :-(", ex);
        }
        return errorCode;
    }
}

