/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.arecont;

import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.video.arecont.ArecontCameraSrv;
import de.seetec.v5.re.cm.device.video.arecont.ArecontMotionDetectionHandler;
import org.apache.logging.log4j.LogManager;

public class ArecontHardwareMotionDetection
extends HardwareMotionDetection<ArecontMotionDetectionHandler> {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.arecont.ArecontMotionDetectionHandler";

    public ArecontHardwareMotionDetection() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public ArecontMotionDetectionHandler getMotionDetectionHandlerInstance() {
        return new ArecontMotionDetectionHandler();
    }

    @Override
    public int init(VideoSrv videoSrv, HardwareMotionDetectionCnf[] hardwareMotionDetectionCnf) {
        String url;
        int errorCode = super.init(videoSrv, hardwareMotionDetectionCnf, false);
        if (errorCode != 0) {
            return errorCode;
        }
        if (((ArecontCameraSrv)this.getVideoSrv()).isPanoramicModel()) {
            try {
                this.logger.info("Panoramic model. Use special MD url. Source ID is: " + videoSrv.getVideoSourceCnf().getPtzAddress());
                url = "/get" + videoSrv.getVideoSourceCnf().getPtzAddress() + "?mdresult";
            }
            catch (Exception e) {
                this.logger.error("Can't get videoSourceID for " + videoSrv);
                return -20000;
            }
        } else {
            url = "/get?mdresult";
        }
        this.generalHandler = new ArecontMotionDetectionHandler();
        errorCode = ((ArecontMotionDetectionHandler)this.generalHandler).init(this, url);
        if (errorCode != 0) {
            this.logger.error("Error while initializing handler for " + videoSrv + ". errorCode: " + errorCode);
            return errorCode;
        }
        return 0;
    }

    @Override
    public void notifyForNetworkProblems() {
    }

    @Override
    protected boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }
}

