/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.arecont;

import de.seetec.v5.re.cm.configuration.definition.camera.FeaturesType;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecsType;
import de.seetec.v5.re.cm.configuration.definition.device.AvailableIOsType;
import de.seetec.v5.re.cm.configuration.definition.device.BitrateSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.CameraResolutionType;
import de.seetec.v5.re.cm.configuration.definition.device.CaptureModeDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.CodecType;
import de.seetec.v5.re.cm.configuration.definition.device.CommentsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceGroupMembershipsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceNetworkDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.GenericEventDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.ImageRotationCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MiscVideoServerCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MultiStreamingDefinitionsType;
import de.seetec.v5.re.cm.configuration.definition.device.RtspSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.StreamDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedApiVersionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCameraResolutionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCaptureModesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedMPEGProfileIDs;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedRotationAnglesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedTransmissionTypeIDsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedVideoSourceEntityTypesType;
import de.seetec.v5.re.cm.configuration.definition.device.VirtualCameraDefinitionType;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.arecont.ArecontIOHandler;
import de.seetec.v5.re.shared.CnfDeviceCaptureMode;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaID;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.util.ArrayList;

public class ArecontDevice
extends VideoServer {
    private int ssn = 0;

    public synchronized int getSSN() {
        this.ssn = this.ssn == 65535 ? 0 : this.ssn;
        return ++this.ssn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int initializeDevice(long srvType) {
        super.initializeDevice(srvType);
        String HD_MODE = "1080p_mode=";
        if (srvType == 211051L) {
            try {
                String reply;
                CnfDeviceCaptureMode cnfDeviceCaptureMode = this.getDeviceCnf().getCaptureMode();
                if (!cnfDeviceCaptureMode.isEnabled() || !(reply = new String(NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)"/get?1080p_mode", (int)Integer.MAX_VALUE))).contains("1080p_mode=")) return 0;
                this.logger.info("Capture mode supported for " + this);
                String[] parts = reply.split("1080p_mode=");
                if (parts.length <= 1) return 0;
                String captureModeAsString = parts[1].trim();
                if ((!cnfDeviceCaptureMode.getDisplayResolution().contains("1080p") || !captureModeAsString.contains("off")) && (cnfDeviceCaptureMode.getDisplayResolution().contains("1080p") || !captureModeAsString.contains("on"))) return 0;
                String newValue = captureModeAsString.equals("on") ? "off" : "on";
                this.logger.info("-----------------------------------------------");
                this.logger.info("New capture mode is: 1080p_mode=" + newValue);
                this.logger.info("Capture mode has to be set for " + this);
                this.logger.info("-----------------------------------------------");
                NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)("/set?1080p_mode=" + newValue), (int)Integer.MAX_VALUE);
                return 0;
            }
            catch (Throwable t) {
                this.logger.error("Error while evaluating/setting capture mode settings for " + this);
                return -20001;
            }
        }
        if (srvType < 211000L || srvType > 211099L) return 0;
        try {
            String reply;
            CnfDeviceCaptureMode cnfDeviceCaptureMode = this.getDeviceCnf().getCaptureMode();
            if (cnfDeviceCaptureMode == null || !cnfDeviceCaptureMode.isEnabled() || !(reply = new String(NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)"/get?1080p_mode", (int)Integer.MAX_VALUE))).contains("1080p_mode=")) return 0;
            this.logger.info("Capture mode supported for " + this);
            String[] parts = reply.split("1080p_mode=");
            if (parts.length > 1) {
                String captureModeAsString = parts[1].trim();
                int alreadySetupValue = 3648;
                if (!captureModeAsString.equalsIgnoreCase("off") && captureModeAsString.equalsIgnoreCase("on")) {
                    alreadySetupValue = 1920;
                }
                if (alreadySetupValue == cnfDeviceCaptureMode.getWidth()) return 0;
                String newValue = "off";
                if (cnfDeviceCaptureMode.getWidth() != 3648 && cnfDeviceCaptureMode.getWidth() == 1920) {
                    newValue = "on";
                }
                this.logger.info("-----------------------------------------------");
                this.logger.info("New capture mode is: 1080p_mode=" + newValue);
                this.logger.info("Capture mode has to be set for " + this);
                this.logger.info("-----------------------------------------------");
                NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)("/set?1080p_mode=" + newValue), (int)Integer.MAX_VALUE);
                return 0;
            }
            this.logger.error("Error while extracting capture mode from reply: " + reply + " for " + this);
            return -20001;
        }
        catch (SeeTecException se) {
            this.logger.error("Exception while evaluating/setting capture mode settings for " + this);
            return se.getErrorCode();
        }
        catch (Exception e) {
            this.logger.error("Error while evaluating/setting capture mode settings for " + this);
            return -20001;
        }
    }

    @Override
    protected IOHandler createIOHandler() {
        return new ArecontIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    @Override
    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Mentionned hard-coded password is just an empty one which is a proper default setting in this case.")
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        block44: {
            try {
                String outputs;
                String maxHeight;
                String maxWidth;
                int maxNumberOfStreams;
                int maxTotalNumberOfStreams;
                boolean isPanoramic;
                String currentSignature = this.sendGetCommand("fwversion");
                String currentManufacturer = "Arecont Vision Smart Driver";
                String currentName = this.sendGetCommand("", "model", "releasename");
                String currentComments = "RE_APP_VERSION::7.1.1_23";
                if (signature != null && signature.equals(currentSignature) && manufacturer != null && manufacturer.equals("Arecont Vision Smart Driver") && name != null && name.equals(currentName) && comments != null && comments.equals("RE_APP_VERSION::7.1.1_23")) break block44;
                DeviceDefinition deviceDefinition = new DeviceDefinition();
                deviceDefinition.setCountFirstChannelOnly(true);
                deviceDefinition.setSignature(currentSignature);
                deviceDefinition.setManufacturer("Arecont Vision Smart Driver");
                CommentsType commentsType = new CommentsType();
                commentsType.getString().add("RE_APP_VERSION::7.1.1_23");
                deviceDefinition.setComments(commentsType);
                deviceDefinition.setDefaultMediaID(MediaID.VIDEO_SERVER_DIGITAL.getType());
                SupportedApiVersionsType supportedApiVersionsType = new SupportedApiVersionsType();
                supportedApiVersionsType.getString().add("1.0");
                deviceDefinition.setSupportedApiVersions(supportedApiVersionsType);
                deviceDefinition.setDefaultApiVersion("1.0");
                try {
                    isPanoramic = this.isFeatureAvailable(this.sendGetCommand("channelenable"));
                }
                catch (Exception ex) {
                    isPanoramic = false;
                }
                if (isPanoramic) {
                    deviceDefinition.setNoOfCams(4);
                } else {
                    deviceDefinition.setNoOfCams(1);
                }
                if (isPanoramic) {
                    maxTotalNumberOfStreams = 2;
                    maxNumberOfStreams = 2;
                } else {
                    maxTotalNumberOfStreams = 8;
                    maxNumberOfStreams = 8;
                }
                SupportedVideoSourceEntityTypesType supportedVideoSourceEntityTypesType = new SupportedVideoSourceEntityTypesType();
                supportedVideoSourceEntityTypesType.getLong().add(211051L);
                deviceDefinition.setSupportedVideoSourceEntityTypes(supportedVideoSourceEntityTypesType);
                VirtualCameraDefinitionType virtualCameraDefinitionType = new VirtualCameraDefinitionType();
                virtualCameraDefinitionType.setCanVirtualCamera(true);
                virtualCameraDefinitionType.setCanVirtualCameraCropping(true);
                virtualCameraDefinitionType.setNoOfVirtualCameras(8);
                deviceDefinition.setVirtualCameraDefinition(virtualCameraDefinitionType);
                String hd_mode = this.sendSetCommand("1080p_mode", "off");
                try {
                    maxWidth = this.sendGetCommand("maxsensorwidth");
                    maxHeight = this.sendGetCommand("maxsensorheight");
                    if (!this.isFeatureAvailable(maxWidth) || !this.isFeatureAvailable(maxWidth)) {
                        maxWidth = "2048";
                        maxHeight = "1536";
                    }
                }
                catch (SeeTecException se) {
                    this.logger.warn("Camera does not support maxsensorwidth/maxsensorheight API parameter, use default 2048x1536, maybe check for firmware update: " + this);
                    maxWidth = "2048";
                    maxHeight = "1536";
                }
                String maxFPS = "100";
                try {
                    String response = this.sendSetCommand("fps", maxFPS);
                    maxFPS = !this.isFeatureAvailable(response) ? "60" : response;
                    if (maxFPS.matches("0")) {
                        maxFPS = "60";
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Camera does not support fps API parameter, use default 60 fps, maybe check for firmware update: " + this);
                    maxFPS = "60";
                }
                SupportedCaptureModesType supportedCaptureModesType = new SupportedCaptureModesType();
                ArrayList<String> captureModes = new ArrayList<String>();
                if (!this.isFeatureAvailable(hd_mode)) {
                    captureModes.clear();
                    captureModes.add("-1%%Default " + maxWidth + "x" + maxHeight + " " + maxFPS + "fps");
                } else {
                    captureModes.add("1080p");
                    captureModes.add("Full Resolution");
                }
                this.logger.debug("Processing " + captureModes.size() + " capture modes for (" + this + ")");
                for (String captureMode : captureModes) {
                    BigInteger featuresInteger;
                    this.logger.info("Processing capture mode " + captureMode + " for (" + this + ")");
                    if (captureMode.contains("1080p")) {
                        this.sendSetCommand("1080p_mode", "on");
                    } else {
                        this.sendSetCommand("1080p_mode", "off");
                    }
                    maxWidth = this.sendGetCommand("maxsensorwidth");
                    maxHeight = this.sendGetCommand("maxsensorheight");
                    if (!this.isFeatureAvailable(maxWidth) || !this.isFeatureAvailable(maxWidth)) {
                        maxWidth = "2048";
                        maxHeight = "1536";
                    }
                    ArrayList<String> resolutions = new ArrayList<String>();
                    ArrayList<String> allResolutions = new ArrayList<String>();
                    ArrayList<String> fullDownScaleResolutions = new ArrayList<String>();
                    resolutions.add(maxWidth + "x" + maxHeight);
                    resolutions.add(Integer.parseInt(maxWidth) / 2 + "x" + Integer.parseInt(maxHeight) / 2);
                    String features = this.sendGetCommand("features");
                    if (this.isFeatureAvailable(features) && (featuresInteger = BigInteger.valueOf(Long.parseLong(features))).testBit(15)) {
                        Scaling[] allLowerResolutions;
                        for (Scaling resolution : allLowerResolutions = Scaling.allLowerResolutions(Integer.parseInt(maxWidth) * Integer.parseInt(maxHeight))) {
                            fullDownScaleResolutions.add(resolution.getWidth() + "x" + resolution.getHeight());
                        }
                    }
                    CaptureModeDefinitionType captureModeDefinitionType = new CaptureModeDefinitionType();
                    captureModeDefinitionType.setRebootRequired(false);
                    captureModeDefinitionType.setModeSuffix("");
                    captureModeDefinitionType.setMaxTotalNumberOfStreams(maxTotalNumberOfStreams);
                    captureModeDefinitionType.setDefaultStreamDefinitionIndex(0);
                    CameraResolutionType captureModeCameraResolutionType = new CameraResolutionType();
                    captureModeCameraResolutionType.setDisplayResolution(captureMode);
                    captureModeCameraResolutionType.setWidth(Integer.parseInt(maxWidth));
                    captureModeCameraResolutionType.setHeight(Integer.parseInt(maxHeight));
                    captureModeCameraResolutionType.setMaxMilliFPS(Integer.parseInt(maxFPS) * 1000);
                    captureModeCameraResolutionType.setMinMilliFPS(1);
                    captureModeCameraResolutionType.setResolution(maxWidth + "x" + maxHeight);
                    captureModeCameraResolutionType.setSupportedFrameRates(null);
                    captureModeDefinitionType.setResolution(captureModeCameraResolutionType);
                    MultiStreamingDefinitionsType multiStreamingDefinitionsType = new MultiStreamingDefinitionsType();
                    ArrayList<String> codecs = new ArrayList<String>();
                    int currentNameLength = currentName.length();
                    int generation = currentNameLength > 5 ? currentName.charAt(4) : (currentNameLength > 0 ? (int)currentName.charAt(currentNameLength - 1) : 48);
                    if (generation != 48) {
                        codecs.add("h264");
                        codecs.add("mjpeg");
                    } else {
                        codecs.add("mjpeg");
                    }
                    for (String codec : codecs) {
                        BitrateSettingsType bitrateSettingsType;
                        SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType;
                        CodecType codecType = new CodecType();
                        SupportedMPEGProfileIDs supportedMPEGProfileIds = new SupportedMPEGProfileIDs();
                        StreamDefinitionType streamDefinitionType = new StreamDefinitionType();
                        if (codec.contains("h264")) {
                            codecType.setValue(Codec.H264.getType());
                            supportedMPEGProfileIds.getInt().add(MpegProfile.BASELINE.getType());
                            supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                            supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                            supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                            supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_MULTICAST.getType());
                            streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                            bitrateSettingsType = new BitrateSettingsType();
                            bitrateSettingsType.setCanVBR(true);
                            bitrateSettingsType.setCanVBRQuality(true);
                            bitrateSettingsType.setCanCBR(true);
                            bitrateSettingsType.setCanCBRQuality(false);
                            bitrateSettingsType.setMaxBandwidth(67107840);
                            bitrateSettingsType.setMinBandwidth(1024);
                            bitrateSettingsType.setSupportedBitrates(null);
                            streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                        } else {
                            if (!codec.contains("mjpeg")) continue;
                            codecType.setValue(Codec.MJPEG.getType());
                            supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                            supportedTransmissionTypeIDsType.getInt().add(TransmissionType.HTTP_SERVERPUSH.getType());
                            streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                            bitrateSettingsType = new BitrateSettingsType();
                            bitrateSettingsType.setCanVBR(false);
                            bitrateSettingsType.setCanVBRQuality(true);
                            bitrateSettingsType.setCanCBR(false);
                            bitrateSettingsType.setCanCBRQuality(true);
                            bitrateSettingsType.setMaxBandwidth(67107840);
                            bitrateSettingsType.setMinBandwidth(1024);
                            bitrateSettingsType.setSupportedBitrates(null);
                            streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                        }
                        streamDefinitionType.setNoOfHWMDInputs(0);
                        streamDefinitionType.setMaxNumberOfStreams(maxNumberOfStreams);
                        streamDefinitionType.setDefaultMilliFPS(5000);
                        streamDefinitionType.setHideFPSField(false);
                        streamDefinitionType.setHideIFrameField(false);
                        streamDefinitionType.setMinIFrameDistance(1);
                        streamDefinitionType.setMaxIFrameDistance(65535);
                        streamDefinitionType.setHideKompressionField(false);
                        streamDefinitionType.setHideBandwithField(false);
                        streamDefinitionType.setEncodingIntervalMin(0);
                        streamDefinitionType.setEncodingIntervalMax(0);
                        streamDefinitionType.setStreamingMode(codecType);
                        RtspSettingsType rtspSettingsType = new RtspSettingsType();
                        rtspSettingsType.setDefaultRtspPort(554);
                        rtspSettingsType.setCanChangeRtspPort(true);
                        rtspSettingsType.setCanMultipleRtspPorts(false);
                        streamDefinitionType.setRtspSettings(rtspSettingsType);
                        streamDefinitionType.setName(codec.toUpperCase());
                        SupportedCameraResolutionsType supportedCameraResolutionsType = new SupportedCameraResolutionsType();
                        allResolutions.clear();
                        allResolutions.addAll(resolutions);
                        if (codec.contains("h264")) {
                            allResolutions.addAll(fullDownScaleResolutions);
                        }
                        for (int i = 0; i < allResolutions.size(); ++i) {
                            String[] resolutionValues = ((String)allResolutions.get(i)).split("x");
                            CameraResolutionType cameraResolutionType = new CameraResolutionType();
                            if (i == 0) {
                                cameraResolutionType.setDisplayResolution("Full");
                            } else if (i == 1) {
                                cameraResolutionType.setDisplayResolution("Half");
                            } else {
                                cameraResolutionType.setDisplayResolution((String)allResolutions.get(i));
                            }
                            cameraResolutionType.setWidth(Integer.parseInt(resolutionValues[0]));
                            cameraResolutionType.setHeight(Integer.parseInt(resolutionValues[1]));
                            cameraResolutionType.setMaxMilliFPS(Integer.parseInt(maxFPS) * 1000);
                            cameraResolutionType.setMinMilliFPS(1000);
                            cameraResolutionType.setResolution((String)allResolutions.get(i));
                            cameraResolutionType.setSupportedFrameRates(null);
                            supportedCameraResolutionsType.getCameraResolution().add(cameraResolutionType);
                        }
                        streamDefinitionType.setSupportedCameraResolutions(supportedCameraResolutionsType);
                        streamDefinitionType.setSupportedMPEGProfileIDs(supportedMPEGProfileIds);
                        streamDefinitionType.setDefaultCameraResolutionIndex(0);
                        streamDefinitionType.setDefaultTransmissionTypeIndex(0);
                        multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionType);
                    }
                    captureModeDefinitionType.setMultiStreamingDefinitions(multiStreamingDefinitionsType);
                    supportedCaptureModesType.getCaptureModeDefinition().add(captureModeDefinitionType);
                }
                deviceDefinition.setSupportedCaptureModes(supportedCaptureModesType);
                deviceDefinition.setDefaultCaptureModeIndex(0);
                DeviceNetworkDefinitionType deviceNetworkDefinitionType = new DeviceNetworkDefinitionType();
                deviceNetworkDefinitionType.setCanChangeHttpPort(true);
                deviceNetworkDefinitionType.setCanChangeHttpsPort(false);
                deviceNetworkDefinitionType.setCanHttps(false);
                deviceNetworkDefinitionType.setDefaultHttpPort(80);
                deviceNetworkDefinitionType.setDefaultHttpsPort(443);
                deviceNetworkDefinitionType.setDefaultPassword("");
                deviceNetworkDefinitionType.setDefaultUserName("");
                deviceNetworkDefinitionType.setUseAuthentication(false);
                deviceDefinition.setDeviceNetworkDefinition(deviceNetworkDefinitionType);
                ImageRotationCapabilitiesType imageRotationCapabilitiesType = new ImageRotationCapabilitiesType();
                SupportedRotationAnglesType supportedRotationAnglesType = new SupportedRotationAnglesType();
                ArrayList<String> rotationAngles = new ArrayList<String>();
                rotationAngles.add("0");
                rotationAngles.add("180");
                try {
                    BigInteger featuresInteger;
                    String features = this.sendGetCommand("features");
                    if (this.isFeatureAvailable(features) && (featuresInteger = BigInteger.valueOf(Long.parseLong(features))).testBit(16)) {
                        rotationAngles.add("90");
                        rotationAngles.add("270");
                    }
                }
                catch (Exception features) {
                    // empty catch block
                }
                for (String rotationAngle : rotationAngles) {
                    supportedRotationAnglesType.getInt().add(Integer.parseInt(rotationAngle) * 1000);
                }
                imageRotationCapabilitiesType.setSupportedRotationAngles(supportedRotationAnglesType);
                imageRotationCapabilitiesType.setCanRotateJPEGImage(true);
                imageRotationCapabilitiesType.setCanRotateMPEGImage(true);
                deviceDefinition.setImageRotationCapabilities(imageRotationCapabilitiesType);
                AvailableIOsType availableIOsType = new AvailableIOsType();
                String inputs = this.sendGetCommand("auxin");
                if (this.isFeatureAvailable(inputs)) {
                    availableIOsType.getInputOutputCapabilities().add(0);
                }
                if (this.isFeatureAvailable(outputs = this.sendGetCommand("auxout"))) {
                    availableIOsType.getInputOutputCapabilities().add(1);
                }
                deviceDefinition.setAvailableIOs(availableIOsType);
                MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = new MiscVideoServerCapabilitiesType();
                miscVideoServerCapabilitiesType.setCanTimeDate(false);
                miscVideoServerCapabilitiesType.setCanTitle(false);
                miscVideoServerCapabilitiesType.setCanDetectTampering(false);
                miscVideoServerCapabilitiesType.setCanDetectVideoloss(false);
                miscVideoServerCapabilitiesType.setNoOfRS232S(0);
                miscVideoServerCapabilitiesType.setCanTimeshift(false);
                miscVideoServerCapabilitiesType.setPTZSpeedMultiplier(100);
                miscVideoServerCapabilitiesType.setCanPTZ(false);
                deviceDefinition.setMiscVideoServerCapabilities(miscVideoServerCapabilitiesType);
                AudioCapabilitiesType audioCapabilitiesType = new AudioCapabilitiesType();
                String features = this.sendGetCommand("features");
                if (this.isFeatureAvailable(features)) {
                    BigInteger featuresInteger = BigInteger.valueOf(Long.parseLong(features));
                    if (featuresInteger.testBit(11)) {
                        audioCapabilitiesType.setCanAudio(true);
                    } else {
                        audioCapabilitiesType.setCanAudio(false);
                    }
                }
                audioCapabilitiesType.setDefaultAudioCodecIndex(0);
                if (audioCapabilitiesType.isCanAudio()) {
                    audioCapabilitiesType.setNumberOfPossibleAudioStreams(1);
                    AudioCodecsType audioCodecsType = new AudioCodecsType();
                    AudioCodecDefinitionType audioCodecDefinitionType = new AudioCodecDefinitionType();
                    CodecType codecType = new CodecType();
                    codecType.setValue(Codec.G711U.getType());
                    audioCodecDefinitionType.setAudioCodec(codecType);
                    audioCodecDefinitionType.setBitrate(64000);
                    audioCodecsType.getAudioCodecDefinition().add(audioCodecDefinitionType);
                    audioCapabilitiesType.setAudioCodecs(audioCodecsType);
                } else {
                    audioCapabilitiesType.setNumberOfPossibleAudioStreams(0);
                    audioCapabilitiesType.setAudioCodecs(null);
                }
                deviceDefinition.setAudioCapabilities(audioCapabilitiesType);
                DeviceGroupMembershipsType deviceGroupMembershipsType = new DeviceGroupMembershipsType();
                deviceGroupMembershipsType.getDeviceGroups().add("GenericDriver");
                deviceGroupMembershipsType.getDeviceGroups().add("CheckDeviceInfos");
                deviceGroupMembershipsType.getDeviceGroups().add("GenericEventTrigger");
                deviceDefinition.setDeviceGroupMemberships(deviceGroupMembershipsType);
                deviceDefinition.setSupportedGenericEvents(this.getGenericEventTrigger());
                deviceDefinition.setEntityType(200951L);
                deviceDefinition.setName(currentName);
                return deviceDefinition;
            }
            catch (Throwable t) {
                this.logger.warn("Error while reading information from " + this, t);
                throw new SeeTecException(-21600, t.getMessage());
            }
        }
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        try {
            boolean ptzAvailable = false;
            VideoCameraDefinition videoCameraDefinition = new VideoCameraDefinition();
            videoCameraDefinition.setManufacturer("Generic Arecont Driver");
            videoCameraDefinition.setComment("");
            videoCameraDefinition.setDefaultMediaID(ptzAvailable ? MediaID.VIDEO_SOURCE_PTZ.getType() : MediaID.VIDEO_SOURCE_DIGITAL.getType());
            String modelName = this.sendGetCommand("", "model", "releasename");
            videoCameraDefinition.setName(modelName);
            videoCameraDefinition.setEntityType(211051L);
            videoCameraDefinition.setPreferAbsolutePTZ(false);
            FeaturesType featuresType = new FeaturesType();
            if (ptzAvailable) {
                featuresType.setCanAbsolutePan(false);
                featuresType.setCanAbsoluteTilt(false);
                featuresType.setCanAbsoluteZoom(false);
                featuresType.setCanContinuousPan(false);
                featuresType.setCanContinuousTilt(false);
                featuresType.setCanContinuousZoom(false);
                featuresType.setCanRelativePan(false);
                featuresType.setCanRelativeTilt(false);
                featuresType.setCanRelativeZoom(false);
                featuresType.setCanCenterPT(false);
                featuresType.setCanFocus(false);
                featuresType.setCanAutoFocus(false);
                featuresType.setCanIris(false);
                featuresType.setCanAutoIris(false);
                featuresType.setCanNullLux(false);
                featuresType.setCanAutoNullLux(false);
                featuresType.setCanPreset(false);
                featuresType.setMinPan(-180000);
                featuresType.setMaxPan(180000);
                featuresType.setMinTilt(0);
                featuresType.setMaxTilt(90000);
                featuresType.setMinZoom(0);
                featuresType.setMaxZoom(100000);
                featuresType.setMinSpeed(0);
                featuresType.setMaxSpeed(100000);
                featuresType.setPTZMinContinuousLevel(10000);
                featuresType.setPTZMaxContinuousLevel(100000);
                featuresType.setPTZContinuousSpeedFactor(1000);
            }
            videoCameraDefinition.setFeatures(featuresType);
            return videoCameraDefinition;
        }
        catch (Exception exception) {
            this.logger.warn("Error while reading information from " + this);
            throw new SeeTecException(-21600, exception.getMessage());
        }
    }

    public static final int checkDeviceInfos(long type, String host, int port, boolean useAuthorization, String user, String pass, int timeout) {
        String cameraResponse;
        block6: {
            String[] stringArray;
            if (useAuthorization) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = user;
                stringArray = stringArray2;
                stringArray2[1] = pass;
            } else {
                stringArray = null;
            }
            NetworkParameter networkParameter = NetworkParameterFactory.createNetworkParameter((String)host, (int)port, (boolean)false, (int)-1, (int)timeout, stringArray);
            cameraResponse = "";
            try {
                String url = "/get?make";
                cameraResponse = new String(NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)"/get?make", (int)Integer.MAX_VALUE, (boolean)true));
            }
            catch (SeeTecException se) {
                if (se.getNetworkStatus() != HTTPStatusCode.HTTP_UNAUTHORIZED) {
                    return -21697;
                }
                if (se.getNetworkStatus() != HTTPStatusCode.HTTP_UNAUTHORIZED) break block6;
                return -21701;
            }
        }
        if (cameraResponse.contains("make=AV")) {
            return 0;
        }
        return -21697;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() throws SeeTecException, ConfigurationException {
        SupportedGenericEventsType supportedGenericEventsType = new SupportedGenericEventsType();
        ArrayList<String> eventList = new ArrayList<String>();
        eventList.add("mdresult");
        for (String event : eventList) {
            GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
            genericEventDefinitionType.setEventType(event);
            genericEventDefinitionType.setSourceNumber(0);
            supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
        }
        return supportedGenericEventsType;
    }

    public String sendGetCommand(String key) throws SeeTecException {
        return this.sendGetCommand("", key);
    }

    public String sendSetCommand(String key, String value) throws SeeTecException {
        return this.sendSetCommand("", key, value);
    }

    public String sendGetCommand(String channel, String key) throws SeeTecException {
        if (key == null || key.isEmpty()) {
            throw new SeeTecException(-21601, "Key argument is null or empty " + this);
        }
        if (channel == null || channel.isEmpty()) {
            return this.sendApiCommand("get", key, null);
        }
        return this.sendApiCommand("get" + channel, key, null);
    }

    public String sendSetCommand(String channel, String key, String value) throws SeeTecException {
        if (value == null || value.isEmpty() || key == null || key.isEmpty()) {
            throw new SeeTecException(-21601, "Arguments null or empty for " + this);
        }
        if (channel == null || channel.isEmpty()) {
            return this.sendApiCommand("set", key, value);
        }
        return this.sendApiCommand("set" + channel, key, value);
    }

    public String sendGetCommand(String channel, String key, String value) throws SeeTecException {
        if (value == null || value.isEmpty() || key == null || key.isEmpty()) {
            throw new SeeTecException(-21601, "Arguments null or empty for " + this);
        }
        if (channel == null || channel.isEmpty()) {
            return this.sendApiCommand("get", key, value);
        }
        return this.sendApiCommand("get" + channel, key, value);
    }

    private String sendApiCommand(String type, String key, String value) throws SeeTecException {
        try {
            HTTPResponse response;
            String url = "/" + type + "?" + key + (value != null ? "=" + value : "");
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Print whole API command: " + url);
            }
            if ((response = new HTTPResponse(NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)url, (int)Integer.MAX_VALUE))).getHttpHeader() != null && response.getHttpHeader().getStatusCode() == HTTPStatusCode.HTTP_OK.getStatusCode()) {
                return response.getHttpBody().getData().replace(key + "=", "").replace("\r", "").replace("\n", "");
            }
            if (response.getHttpHeader() != null && response.getHttpHeader().getStatusCode() == HTTPStatusCode.HTTP_NOT_MODIFIED.getStatusCode()) {
                return "off";
            }
            this.logger.error(response.getHttpHeader().getData());
            throw new SeeTecException(-21654, "Error reading parameter for " + this);
        }
        catch (ConfigurationException ex) {
            throw new SeeTecException(-21602, "Reading DeviceCnf failed for " + this);
        }
        catch (Exception e) {
            throw new SeeTecException(-21602, "Exception for " + this);
        }
    }

    public boolean isFeatureAvailable(String feature) {
        return feature != null && !feature.contains("Error: Unknown parameter or value missing") && !feature.toLowerCase().contains("command not supported");
    }

    public static enum Scaling {
        RES_720P("720p", 1280, 720, 921600),
        RES_XVGA("XVGA", 1024, 768, 786432),
        RES_DVGA_16_9("DVGA (16:9)", 1136, 640, 727040),
        RES_DVGA_3_2("DVGA (3:2)", 960, 640, 614400),
        RES_SVGA("SVGA", 800, 600, 480000),
        RES_D1_PAL("D1 (PAL)", 720, 576, 414720),
        RES_4CIF_PAL("4CIF (PAL)", 704, 576, 405504),
        RES_D1_NTSC("D1 (NTSC)", 720, 480, 345600),
        RES_4CIF_NTSC("4CIF (NTSC)", 704, 480, 337920),
        RES_VGA("VGA", 640, 480, 307200),
        RES_2CIF_PAL("2CIF (PAL)", 704, 288, 202752),
        RES_HVGA_4_3("HVGA (4:3)", 480, 360, 172800),
        RES_2CIF_NTSC("2CIF (NTSC)", 704, 240, 168960),
        RES_HVGA_8_3("HVGA (8:3)", 640, 240, 153600),
        RES_HVGA_3_2("HVGA (3:2)", 480, 320, 153600),
        RES_HVGA_16_9("HVGA (16:9)", 480, 272, 130560),
        RES_CIF_PAL("CIF (PAL)", 352, 288, 101376),
        RES_CIF_NTSC("CIF (NTSC)", 352, 240, 84480),
        RES_QVGA_SIF("QVGA (SIF)", 320, 240, 76800),
        RES_QCIF_PAL("QCIF (PAL)", 176, 144, 25344),
        RES_QCIF_NTSC("QCIF (NTSC)", 176, 120, 21120),
        RES_SQCIF("SQCIF", 128, 96, 12288);

        private final String name;
        private final int width;
        private final int height;
        private final int pixelCount;

        private Scaling(String name, int width, int height, int pixelCount) {
            this.name = name;
            this.width = width;
            this.height = height;
            this.pixelCount = pixelCount;
        }

        public String getName() {
            return this.name;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getPixelCount() {
            return this.pixelCount;
        }

        public static Scaling[] allLowerResolutions(int pixelCount) {
            ArrayList<Scaling> returnValues = new ArrayList<Scaling>();
            for (Scaling t : Scaling.values()) {
                if (t.getPixelCount() > pixelCount) continue;
                returnValues.add(t);
            }
            return returnValues.toArray(new Scaling[returnValues.size()]);
        }
    }
}

