/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.arecont;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.DoNothingCameraControl;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.arecont.ArecontDevice;
import de.seetec.v5.re.cm.device.video.arecont.ArecontTriggerHandler;
import de.seetec.v5.re.cm.device.video.arecont.jpeg.ArecontJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.arecont.mpeg.ArecontH264VideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class ArecontCameraSrv
extends LiveCameraSrv {
    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new DoNothingCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        VideoSourceClient videoSourceClient = null;
        this.logger.info("Creating new [VideoSourceClient] with VideoProfileHandler=" + listener + " ...");
        try {
            Codec streamingMode = listener.getVideoSourceParameter().getMediaCodec();
            videoSourceClient = streamingMode == Codec.H264 ? new ArecontH264VideoSourceClient() : new ArecontJPEGVideoSourceClient();
            int errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(", ex);
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        byte[] doubleLine = new byte[]{13, 10, 13, 10};
        try {
            if (this.getDevice().getDeviceCnf().getVirtualCameras().isEnabled()) {
                int captureModeHeight;
                int captureModeWidth;
                if (this.getDevice().getDeviceType() == 200951L) {
                    captureModeWidth = this.getDevice().getDeviceDefinitionFromConfiguration().getSupportedCaptureModes().getCaptureModeDefinition().get(0).getResolution().getWidth();
                    captureModeHeight = this.getDevice().getDeviceDefinitionFromConfiguration().getSupportedCaptureModes().getCaptureModeDefinition().get(0).getResolution().getHeight();
                } else {
                    captureModeWidth = this.getDevice().getDeviceCnf().getCaptureMode().getWidth();
                    captureModeHeight = this.getDevice().getDeviceCnf().getCaptureMode().getHeight();
                }
                String url = "/image";
                if (this.isPanoramicModel()) {
                    url = url + "" + this.getVideoSourceCnf().getServerEntryNo();
                }
                url = url + "?res=half&x0=0&y0=0&x1=" + captureModeWidth + "&y1=" + captureModeHeight + "&quality=12&doublescan=0";
                byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)url, (int)Integer.MAX_VALUE);
                int firstDoubleLineDelimiter = Basic.indexOfByteArray((byte[])result, (byte[])doubleLine, (int)0);
                byte[] frame = new byte[result.length - firstDoubleLineDelimiter];
                System.arraycopy(result, firstDoubleLineDelimiter, frame, 0, frame.length);
                return new ContentFrame(0, frame);
            }
            this.logger.error("Error while reading out capture mode resolution.");
            throw new SeeTecException(-20001, "Error while reading out capture mode resolution.");
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while requesting snapshot for " + this.getDevice(), (Throwable)e);
            throw e;
        }
        catch (Exception ex) {
            this.logger.error("Exception while requesting snapshot for " + this.getDevice(), (Throwable)ex);
            throw new SeeTecException(-20001, "Unknown exception while requesting snapshot");
        }
    }

    @Override
    public int checkReachability(VideoProfileHandler listener) {
        int result = super.checkReachability(listener);
        if (result == 0) {
            try {
                String motionDetect = ((ArecontDevice)this.getDevice()).sendGetCommand("motiondetect");
                if (motionDetect.equals("off")) {
                    ((ArecontDevice)this.getDevice()).sendSetCommand("motiondetect", "on");
                }
            }
            catch (Throwable t) {
                this.logger.error("Can't activate Motion Detection on Camera for " + this);
            }
        }
        return result;
    }

    public final int rotateImage(VideoSourceClient videoSourceClient, NetworkParameter networkParameter) {
        if (videoSourceClient == null || videoSourceClient.getListener() == null || videoSourceClient.getVideoSourceNr() < 0 || videoSourceClient.getRotationAngle() < 0 || networkParameter == null) {
            return -20002;
        }
        try {
            if (this.getDevice().getDeviceCnf().getVirtualCameras().isEnabled()) {
                if (videoSourceClient.getListener().getVideoSourceParameter() != null && videoSourceClient.getListener().getVideoSourceParameter().getVCamOriginalEntityID() == videoSourceClient.getListener().getVideoSourceParameter().getEntity().getEntityID().longValue()) {
                    String rotationURL = "/set";
                    if (this.isPanoramicModel()) {
                        rotationURL = rotationURL + "" + videoSourceClient.getVideoSourceNr();
                    }
                    rotationURL = rotationURL + "?rotate=" + videoSourceClient.getRotationAngle();
                    try {
                        NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)rotationURL, (int)Integer.MAX_VALUE);
                    }
                    catch (Exception e) {
                        this.logger.error("Exception while rotating image for " + this);
                        return -21601;
                    }
                    return 0;
                }
                this.logger.info("Don't rotate cause this is a VCAM: " + this);
                return 0;
            }
            if (videoSourceClient.getListener().getVideoSourceParameter() != null) {
                if (this.getEntityType() == 211005L || this.getEntityType() == 211006L) {
                    return 0;
                }
                String rotationURL = "/set";
                if (this.isPanoramicModel()) {
                    rotationURL = rotationURL + "" + videoSourceClient.getVideoSourceNr();
                }
                rotationURL = rotationURL + "?rotate=" + videoSourceClient.getRotationAngle();
                try {
                    NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)rotationURL, (int)Integer.MAX_VALUE);
                }
                catch (Exception e) {
                    this.logger.error("Exception while rotating image for " + this);
                    return -21601;
                }
                return 0;
            }
            this.logger.info("Don't rotate cause this is a VCAM: " + this);
            return 0;
        }
        catch (Exception e) {
            this.logger.error("Exception while evaluatiing rotation needs for " + this);
            return -21601;
        }
    }

    public final boolean isPanoramicModel() {
        if (this.getEntityType() == 211051L) {
            return this.getDevice().getDeviceDefinitionFromConfiguration().getNoOfCams() > 1;
        }
        return this.getEntityType() == 211005L || this.getEntityType() == 211006L || this.getEntityType() == 211015L || this.getEntityType() == 211016L || this.getEntityType() == 211037L || this.getEntityType() == 211038L;
    }

    public final StringBuilder getCroppingString(String resolutionTag, int width, int height, VideoSourceClient videoSourceClient) throws SeeTecException {
        int maxWidth = Integer.MIN_VALUE;
        int maxHeight = Integer.MIN_VALUE;
        StringBuilder url = new StringBuilder();
        try {
            int[] maxResolution = this.getMaxResolution();
            maxWidth = maxResolution[0];
            maxHeight = maxResolution[1];
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while getting maxResolution for " + this);
            throw e;
        }
        if (this.getEntityType() == 211051L) {
            try {
                if (this.isFull(videoSourceClient)) {
                    url.append("full");
                } else {
                    url.append("half");
                }
            }
            catch (ConfigurationException ex) {
                throw new SeeTecException(-21601, "Error while reading resolution parameters for " + this);
            }
            try {
                if (videoSourceClient != null && videoSourceClient.getListener() != null && videoSourceClient.getListener().getVideoSourceParameter().getCropping() != null && videoSourceClient.getListener().getVideoSourceParameter().getCropping().isEnabled()) {
                    int croppingX = videoSourceClient.getListener().getVideoSourceParameter().getCropping().getRectangle()[0];
                    int croppingY = videoSourceClient.getListener().getVideoSourceParameter().getCropping().getRectangle()[1];
                    int croppingWidth = videoSourceClient.getListener().getVideoSourceParameter().getCropping().getRectangle()[2];
                    int croppingHeight = videoSourceClient.getListener().getVideoSourceParameter().getCropping().getRectangle()[3];
                    String flexibleCropping = ((ArecontDevice)this.getDevice()).sendSetCommand("cropping", "off");
                    if (!flexibleCropping.equals("on")) {
                        int divideHeight;
                        int divideWidth;
                        if (videoSourceClient.getListener().getVideoSourceParameter().getMediaCodec().equals((Object)Codec.MJPEG)) {
                            divideWidth = 32;
                            divideHeight = 16;
                        } else {
                            divideWidth = 64;
                            divideHeight = 32;
                        }
                        int widthValue = croppingWidth % divideWidth;
                        int heightValue = croppingHeight % divideHeight;
                        if (widthValue > 0) {
                            croppingWidth += divideWidth - widthValue;
                        }
                        if (heightValue > 0) {
                            croppingHeight += divideHeight - heightValue;
                        }
                    }
                    url.append("&x0=");
                    url.append(croppingX);
                    url.append("&y0=");
                    url.append(croppingY);
                    url.append("&x1=");
                    url.append(croppingX + croppingWidth);
                    url.append("&y1=");
                    url.append(croppingY + croppingHeight);
                }
                url.append("&x0=0");
                url.append("&y0=0");
                url.append("&x1=");
                url.append(maxWidth);
                url.append("&y1=");
                url.append(maxHeight);
            }
            catch (Exception e) {
                throw new SeeTecException(-21601, "Error while reading vcam parameters for " + this);
            }
        } else if (resolutionTag != null && resolutionTag.length() > 0) {
            url.append(resolutionTag);
            try {
                if (videoSourceClient != null && videoSourceClient.getListener() != null && videoSourceClient.getListener().getVideoSourceParameter().getCropping().isEnabled()) {
                    int croppingX = videoSourceClient.getListener().getVideoSourceParameter().getCropping().getRectangle()[0];
                    int croppingY = videoSourceClient.getListener().getVideoSourceParameter().getCropping().getRectangle()[1];
                    int croppingWidth = videoSourceClient.getListener().getVideoSourceParameter().getCropping().getRectangle()[2];
                    int croppingHeight = videoSourceClient.getListener().getVideoSourceParameter().getCropping().getRectangle()[3];
                    url.append("&x0=");
                    url.append(croppingX);
                    url.append("&y0=");
                    url.append(croppingY);
                    url.append("&x1=");
                    url.append(croppingX + croppingWidth);
                    url.append("&y1=");
                    url.append(croppingY + croppingHeight);
                }
                url.append("&x0=0");
                url.append("&y0=0");
                url.append("&x1=");
                url.append(maxWidth);
                url.append("&y1=");
                url.append(maxHeight);
            }
            catch (Exception e) {
                throw new SeeTecException(-21601, "Error while reading vcam parameters for " + this);
            }
        } else {
            url.append("full");
            url.append("&x0=");
            int x0 = maxWidth - width >> 1;
            int y0 = maxHeight - height >> 1;
            int x1 = maxWidth + width >> 1;
            int y1 = maxHeight + height >> 1;
            url.append(x0);
            url.append("&y0=");
            url.append(y0);
            url.append("&x1=");
            url.append(x1);
            url.append("&y1=");
            url.append(y1);
        }
        return url;
    }

    private int[] getMaxResolution() throws SeeTecException {
        int[] maxResolution = new int[2];
        long cameraType = this.getEntityType();
        if (cameraType == 211000L || cameraType == 211008L || cameraType == 211017L || cameraType == 211022L || cameraType == 211023L || cameraType == 211011L || cameraType == 211028L || cameraType == 211033L) {
            maxResolution[0] = 1280;
            maxResolution[1] = 1024;
        } else if (cameraType == 211001L || cameraType == 211009L || cameraType == 211018L || cameraType == 211012L) {
            maxResolution[0] = 1600;
            maxResolution[1] = 1200;
        } else if (cameraType == 211024L || cameraType == 211025L || cameraType == 211026L || cameraType == 211029L || cameraType == 211034L) {
            maxResolution[0] = 1920;
            maxResolution[1] = 1080;
        } else if (cameraType == 211002L || cameraType == 211007L || cameraType == 211019L || cameraType == 211035L || cameraType == 211003L || cameraType == 211013L || cameraType == 211031L || cameraType == 211027L) {
            maxResolution[0] = 2048;
            maxResolution[1] = 1536;
        } else if (cameraType == 211004L || cameraType == 211010L || cameraType == 211020L || cameraType == 211014L || cameraType == 211032L || cameraType == 211036L) {
            maxResolution[0] = 2592;
            maxResolution[1] = 1944;
        } else if (cameraType == 211005L || cameraType == 211006L || cameraType == 211015L || cameraType == 211016L) {
            maxResolution[0] = 1600;
            maxResolution[1] = 1200;
        } else if (cameraType == 211021L || cameraType == 211030L) {
            maxResolution[0] = 3648;
            maxResolution[1] = 2752;
        } else if (cameraType == 211037L || cameraType == 211038L) {
            maxResolution[0] = 10240;
            maxResolution[1] = 1920;
        } else if (cameraType == 211051L) {
            try {
                maxResolution[0] = Integer.parseInt(((ArecontDevice)this.getDevice()).sendGetCommand("maxsensorwidth"));
                maxResolution[1] = Integer.parseInt(((ArecontDevice)this.getDevice()).sendGetCommand("maxsensorheight"));
            }
            catch (Exception e) {
                this.logger.warn("Setting default values for resolution for " + this);
                maxResolution[0] = 2048;
                maxResolution[1] = 1536;
            }
        } else {
            this.logger.fatal("Resolution of this type not suported right now. type: " + this.getEntityType());
            throw new SeeTecException(-20009, "Type not supported right now.");
        }
        return maxResolution;
    }

    public boolean isFull(VideoSourceClient videoSourceClient) throws ConfigurationException {
        String name = videoSourceClient.getListener().getVideoSourceParameter().getDisplayResolution();
        return name.toLowerCase().contains("full");
    }

    public boolean isScalingResolution(VideoSourceClient videoSourceClient) throws ConfigurationException {
        String name = videoSourceClient.getListener().getVideoSourceParameter().getDisplayResolution();
        return !name.toLowerCase().contains("full") && !name.toLowerCase().contains("half") && !name.toLowerCase().contains("default");
    }

    @Override
    protected GenericEventTriggerHandler createNewGenericEventTriggerHandler() {
        return new ArecontTriggerHandler(this, this);
    }
}

