/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.aper;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpWriterUnicast;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.aper.AperDevice;
import de.seetec.v5.re.cm.device.video.aper.AperHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.aper.AperMotionDetectionHandler;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.Reader;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.onvif.ver10.media.wsdl.Media;
import org.onvif.ver10.schema.AudioEncoderConfiguration;
import org.onvif.ver10.schema.H264Configuration;
import org.onvif.ver10.schema.H264Profile;
import org.onvif.ver10.schema.IntRange;
import org.onvif.ver10.schema.Profile;
import org.onvif.ver10.schema.StreamType;
import org.onvif.ver10.schema.TransportProtocol;
import org.onvif.ver10.schema.VideoEncoderConfiguration;
import org.onvif.ver10.schema.VideoEncoderConfigurationOptions;
import org.onvif.ver10.schema.VideoEncoding;
import org.onvif.ver10.schema.VideoRateControl;
import org.onvif.ver10.schema.VideoResolution;

public class AperOnvifVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.aper.AperOnvifVideoSourceClient";
    private MetadataSourceClient metadataSourceClient = null;
    private String profileToken = null;
    private String additionalStreamProfileToken = null;

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }

    @Override
    public int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        try {
            VideoEncoderConfiguration videoEncoderConfiguration;
            if (this.profileToken == null) {
                this.logger.error("No ONVIF profile selected");
                return -21600;
            }
            AperDevice aperDevice = (AperDevice)this.getVideoSrv().getDevice();
            OnvifCore onvifCore = aperDevice.getOnvifCore();
            Media mediaService = onvifCore.getMediaService().getOnvifMediaService();
            String encoderToken = "";
            if (this.profileToken.equals("MAIN_PROFILE")) {
                encoderToken = "main_vencoder";
            } else if (this.profileToken.equals("SECOND_PROFILE")) {
                encoderToken = "second_vencoder";
            }
            if (this.additionalStreamProfileToken != null) {
                Profile profile1 = mediaService.getProfile("MAIN_PROFILE");
                profile1.setVideoSourceConfiguration(mediaService.getVideoSourceConfiguration("general_vsource"));
                profile1.setVideoEncoderConfiguration(mediaService.getVideoEncoderConfiguration("main_vencoder"));
                videoEncoderConfiguration = profile1.getVideoEncoderConfiguration();
                videoEncoderConfiguration.setEncoding(VideoEncoding.H_264);
                VideoResolution videoResolution = videoEncoderConfiguration.getResolution();
                videoResolution.setWidth(this.width);
                videoResolution.setHeight(this.height);
                videoEncoderConfiguration.setResolution(videoResolution);
                videoEncoderConfiguration.setQuality(50.0f);
                this.fps = this.fps < 1000L ? 1000L : this.fps;
                this.fps /= 1000L;
                VideoRateControl videoRateControl = videoEncoderConfiguration.getRateControl();
                videoRateControl.setFrameRateLimit((int)this.fps);
                videoRateControl.setEncodingInterval(1);
                videoRateControl.setBitrateLimit(2048);
                videoEncoderConfiguration.setRateControl(videoRateControl);
                VideoEncoderConfigurationOptions videoEncoderConfigurationOptions = mediaService.getVideoEncoderConfigurationOptions(videoEncoderConfiguration.getToken(), profile1.getToken());
                IntRange govRange = videoEncoderConfigurationOptions.getH264().getGovLengthRange();
                H264Configuration h264Configuration = new H264Configuration();
                this.fps *= 1000L;
                this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, govRange.getMin(), govRange.getMax());
                this.fps /= 1000L;
                h264Configuration.setGovLength((int)this.iFrameDist);
                h264Configuration.setH264Profile(H264Profile.MAIN);
                videoEncoderConfiguration.setH264(h264Configuration);
                try {
                    mediaService.setVideoEncoderConfiguration(videoEncoderConfiguration, true);
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    this.logger.warn("Configuration of the 1st could not be set");
                    if (exception.getCause().getMessage().contains("401: Unauthorized")) {
                        this.logger.warn("=> Authorization failed");
                        return -21657;
                    }
                    if (exception.getCause().getMessage().contains("Invalid QName in mapping: ter:InvalidArgVal")) {
                        this.logger.warn("=> Invalid arguments");
                        return -21601;
                    }
                    return -21600;
                }
            }
            Profile profile = onvifCore.getMediaService().getOnvifMediaService().getProfile(this.profileToken);
            profile.setVideoSourceConfiguration(mediaService.getVideoSourceConfiguration("general_vsource"));
            profile.setVideoEncoderConfiguration(mediaService.getVideoEncoderConfiguration(encoderToken));
            videoEncoderConfiguration = profile.getVideoEncoderConfiguration();
            VideoEncoderConfigurationOptions videoEncoderConfigurationOptions = mediaService.getVideoEncoderConfigurationOptions(videoEncoderConfiguration.getToken(), this.profileToken);
            IntRange bitrateRange = new IntRange();
            bitrateRange.setMin(512);
            bitrateRange.setMax(8000);
            if (this.additionalStreamProfileToken == null) {
                long l = this.fps = this.fps < 1000L ? 1000L : this.fps;
            }
            if (this.videoCodec == Codec.H264) {
                IntRange govRange = videoEncoderConfigurationOptions.getH264().getGovLengthRange();
                this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, govRange.getMin(), govRange.getMax());
            }
            this.quality /= 1000;
            if (this.additionalStreamProfileToken == null) {
                this.fps /= 1000L;
            }
            int bitrate = this.bandwidth / 1024;
            if ((videoEncoderConfiguration.getEncoding() != VideoEncoding.H_264 || this.videoCodec != Codec.H264) && (videoEncoderConfiguration.getEncoding() != VideoEncoding.JPEG || this.videoCodec != Codec.MJPEG) || videoEncoderConfiguration.getResolution().getWidth() != this.width || videoEncoderConfiguration.getResolution().getHeight() != this.height || videoEncoderConfiguration.getQuality() != (float)this.quality || videoEncoderConfiguration.getRateControl().getBitrateLimit() != bitrate || (long)videoEncoderConfiguration.getRateControl().getFrameRateLimit() != this.fps || videoEncoderConfiguration.getEncoding() == VideoEncoding.H_264 && (long)videoEncoderConfiguration.getH264().getGovLength() != this.iFrameDist) {
                VideoEncoderConfiguration currentVideoEncoderConfiguration = videoEncoderConfiguration;
                currentVideoEncoderConfiguration.setResolution(videoEncoderConfiguration.getResolution());
                if (this.videoCodec == Codec.H264) {
                    videoEncoderConfiguration.setEncoding(VideoEncoding.H_264);
                } else {
                    videoEncoderConfiguration.setEncoding(VideoEncoding.JPEG);
                }
                VideoResolution videoResolution = videoEncoderConfiguration.getResolution();
                videoResolution.setWidth(this.width);
                videoResolution.setHeight(this.height);
                videoEncoderConfiguration.setResolution(videoResolution);
                videoEncoderConfiguration.setQuality((float)this.quality);
                VideoRateControl videoRateControl = videoEncoderConfiguration.getRateControl();
                videoRateControl.setFrameRateLimit((int)this.fps);
                videoRateControl.setEncodingInterval(1);
                if (bitrate <= bitrateRange.getMin()) {
                    bitrate = bitrateRange.getMin();
                } else if (bitrate >= bitrateRange.getMax()) {
                    bitrate = bitrateRange.getMax();
                }
                if (this.videoCodec == Codec.MJPEG) {
                    bitrate = 0;
                }
                videoRateControl.setBitrateLimit(bitrate);
                if (this.videoCodec == Codec.H264) {
                    H264Configuration h264Configuration = new H264Configuration();
                    h264Configuration.setGovLength((int)this.iFrameDist);
                    h264Configuration.setH264Profile(H264Profile.MAIN);
                    videoEncoderConfiguration.setH264(h264Configuration);
                } else if (this.videoCodec == Codec.MJPEG) {
                    videoEncoderConfiguration.setH264(null);
                }
                videoEncoderConfiguration.setRateControl(videoRateControl);
                try {
                    mediaService.setVideoEncoderConfiguration(videoEncoderConfiguration, true);
                }
                catch (Exception exception) {
                    this.logger.warn("Configuration could not be set");
                    if (exception.getCause().getMessage().contains("401: Unauthorized")) {
                        this.logger.warn("=> Authorization failed");
                        return -21657;
                    }
                    if (exception.getCause().getMessage().contains("Invalid QName in mapping: ter:InvalidArgVal")) {
                        this.logger.warn("=> Invalid arguments");
                        return -21601;
                    }
                    return -21600;
                }
            }
            try {
                if (this.isAudioEnabled) {
                    if (profile.getAudioSourceConfiguration() == null) {
                        mediaService.addAudioSourceConfiguration(this.profileToken, "general_asource");
                    }
                    if (profile.getAudioEncoderConfiguration() == null) {
                        mediaService.addAudioEncoderConfiguration(this.profileToken, "main_aencoder");
                    }
                    AudioEncoderConfiguration audioEncoderConfiguration = profile.getAudioEncoderConfiguration();
                    audioEncoderConfiguration.setEncoding(null);
                    mediaService.setAudioEncoderConfiguration(audioEncoderConfiguration, true);
                } else {
                    if (profile.getAudioSourceConfiguration() != null) {
                        mediaService.removeAudioSourceConfiguration(this.profileToken);
                    }
                    if (profile.getAudioEncoderConfiguration() != null) {
                        mediaService.removeAudioEncoderConfiguration(this.profileToken);
                    }
                }
            }
            catch (Exception exception) {
                this.logger.warn("Audio configuration could not be set");
                this.logger.info((Object)exception);
                this.isAudioEnabled = false;
            }
            try {
                String streamUri;
                this.rtspUrl = streamUri = onvifCore.getMediaService().getStreamUri(this.profileToken, StreamType.RTP_UNICAST, TransportProtocol.UDP);
            }
            catch (Exception exception) {
                this.logger.warn("GetStreamURI is not available");
                if (exception.getCause().getMessage().contains("401: Unauthorized")) {
                    this.logger.warn("=> Authorization failed");
                    return -21657;
                }
                if (exception.getCause().getMessage().contains("Invalid QName in mapping: ter:InvalidArgVal")) {
                    this.logger.warn("=> Invalid arguments");
                    return -21601;
                }
                return -21600;
            }
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            this.logger.info(exception.getMessage() + this);
            return -21600;
        }
        this.rtspSettings = new RTSPStreamSettings();
        try {
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        this.rtspSettings.setUserAgent("Java");
        if (this.listener instanceof BasicVideoProfileHandler) {
            this.logger.info("MD enabled for " + this.getVideoSrv());
            this.metadataSourceClient = new MetadataSourceClient(this);
            this.rtspSettings.enableMetadata(this.metadataSourceClient);
            this.rtspSettings.setMetadataTimeout(this.networkParameter.getSoTimeout());
        }
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while starting RTSP Handling for " + this.getVideoSrv() + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        this.errorCode = this.rtspHandler.start();
        if (this.errorCode != 0) {
            this.logger.error("RTSPHandler.start failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public final void setProfile(String profileToken) {
        this.profileToken = profileToken;
    }

    public final void setStream(String profileToken) {
        this.additionalStreamProfileToken = profileToken;
    }

    protected class MetadataSourceClient
    implements RTSPHandlerIntf {
        private RTSPHandlerIntf listener = null;
        private byte[] receiverReportMetadata = new byte[32];

        public MetadataSourceClient(RTSPHandlerIntf listener) {
            this.listener = listener;
            this.receiverReportMetadata[0] = -127;
            this.receiverReportMetadata[1] = -55;
            this.receiverReportMetadata[2] = 0;
            this.receiverReportMetadata[3] = 7;
        }

        public int init(UdpWriterUnicast udpRTCPWriterMetadata) {
            return 0;
        }

        @Override
        public void onNetworkError(int error) {
            if (this.listener != null) {
                this.listener.onNetworkError(error);
            }
        }

        @Override
        public void processData(byte[] data) {
            if (data[1] == -56) {
                System.arraycopy(data, 4, this.receiverReportMetadata, 8, 4);
                System.arraycopy(data, 10, this.receiverReportMetadata, 24, 4);
                AperOnvifVideoSourceClient.this.rtspHandler.sendReceiverReportMetadata(this.receiverReportMetadata);
            } else {
                System.arraycopy(data, 2, this.receiverReportMetadata, 18, 2);
                AperOnvifVideoSourceClient.this.rtspHandler.storeReceiverReportMetadata(this.receiverReportMetadata);
                if (AperOnvifVideoSourceClient.this.getVideoSrv().getHardwareMotionDetection() != null) {
                    String content = new String(data, 12, data.length - 12);
                    try {
                        AperHardwareMotionDetection aperOnvifHardwareMotionDetection;
                        boolean motionValue;
                        SAXBuilder parser = new SAXBuilder();
                        Document document = parser.build((Reader)new StringReader(content.trim()));
                        Element rootElement = document.getRootElement();
                        Namespace namespaceTT = Namespace.getNamespace((String)"tt", (String)"http://www.onvif.org/ver10/schema");
                        Namespace namespaceWSNT = Namespace.getNamespace((String)"wsnt", (String)"http://docs.oasis-open.org/wsn/b-2");
                        Element messageElement = rootElement.getChild("Event", namespaceTT).getChild("NotificationMessage", namespaceWSNT).getChild("Message", namespaceWSNT).getChild("Message", namespaceTT);
                        if (messageElement.getChild("Source", namespaceTT).getChild("SimpleItem", namespaceTT).getAttribute("Name").getValue().equals("VideoSourceToken") && messageElement.getChild("Data", namespaceTT).getChild("SimpleItem", namespaceTT).getAttribute("Name").getValue().equals("State") && (motionValue = messageElement.getChild("Data", namespaceTT).getChild("SimpleItem", namespaceTT).getAttribute("Value").getBooleanValue()) && (aperOnvifHardwareMotionDetection = (AperHardwareMotionDetection)AperOnvifVideoSourceClient.this.getVideoSrv().getHardwareMotionDetection()) != null && aperOnvifHardwareMotionDetection.getMotionDetectionHandler() != null) {
                            ((AperMotionDetectionHandler)((Object)aperOnvifHardwareMotionDetection.getMotionDetectionHandler())).processMotionDetection(0);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public void shutdown() {
            this.listener = null;
            this.receiverReportMetadata = null;
        }

        @Override
        public void sendStatusService(int errorCode) {
        }

        @Override
        public void sendDescribeResponse(RTSPResponse response) {
        }

        @Override
        public void setSSRCfromRTSP(String ssrc) {
        }
    }
}

