/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.aper;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.aper.AperDevice;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.List;
import org.onvif.ver10.deviceio.wsdl.DeviceIOPort;
import org.onvif.ver10.schema.RelayLogicalState;
import org.onvif.ver10.schema.RelayOutput;

public class AperIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.aper.AperIOHandler";
    private int errorCode;
    private DeviceIOPort deviceIOservice = null;
    private boolean alarm = false;

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean previousLoopWithError = false;
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs();
                    if (previousLoopWithError) {
                        DigitalInputSrv[] iServices;
                        previousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this + " ...");
                        DigitalInputSrv[] digitalInputSrvArray = iServices = super.getDigitalInputSrv();
                        int n = digitalInputSrvArray.length;
                        for (int i = 0; i < n; ++i) {
                            DigitalInputSrv iService = digitalInputSrvArray[i];
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(iService.getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    previousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)ex, ex);
                        if (ex.getMessage().contains("Address already in use")) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        DigitalInputSrv[] iServices;
                        for (DigitalInputSrv iService : iServices = super.getDigitalInputSrv()) {
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private int readDigitalInputs() throws Exception {
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        AperDevice aperDevice = (AperDevice)this.device;
        if (aperDevice.isOnvifDevice()) {
            if (this.alarm) {
                iServices[0].checkInput(1);
                iServices[1].checkInput(1);
            } else {
                iServices[0].checkInput(0);
                iServices[1].checkInput(0);
            }
        }
        return 0;
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        AperDevice aperDevice;
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + outputNumber + "]");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this);
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + outputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
        }
        if ((aperDevice = (AperDevice)this.device).isOnvifDevice()) {
            try {
                IOHandler.HoldTimer holdTimer;
                if (this.deviceIOservice == null) {
                    this.deviceIOservice = aperDevice.getOnvifCore().getDeviceIoService().getOnvifDeviceIoService();
                }
                this.logger.info("holdTime: " + holdTime);
                this.logger.info("value: " + value);
                List relayOutputs = this.deviceIOservice.getRelayOutputs();
                RelayOutput relayOutput = (RelayOutput)relayOutputs.get(outputNumber - 1);
                RelayLogicalState relayLogicalState = value > 0 ? RelayLogicalState.ACTIVE : RelayLogicalState.INACTIVE;
                this.deviceIOservice.setRelayOutputState(relayOutput.getToken(), relayLogicalState);
                if (holdTime > 0L && (this.errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                    holdTimer.shutdown();
                    this.logger.warn("Creating " + holdTimer + " failed with error [" + this.errorCode + "]");
                }
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)throwable, throwable);
                this.logger.warn("Problems setting output [" + outputNumber + "] of " + this);
            }
        }
        return 0;
    }
}

