/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.americandynamics;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public final class AmericanDynamicsIoHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsIoHandler";

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean previousLoopWithError = false;
            DigitalInputSrv[] iServices = super.getDigitalInputSrv();
            for (int i = 0; i < iServices.length; ++i) {
                String url = "/cgi-bin/admin/param.cgi?action=update&GPIO.In" + i + ".Enable=1";
                byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
                this.logger.info(new String(result));
            }
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs();
                    if (previousLoopWithError) {
                        previousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this + " ...");
                        DigitalInputSrv[] result = iServices;
                        int n = result.length;
                        for (int i = 0; i < n; ++i) {
                            DigitalInputSrv iService = result[i];
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(iService.getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    previousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)ex, ex);
                        if (ex.getMessage().contains("Address already in use")) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        for (DigitalInputSrv iService : iServices) {
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private int readDigitalInputs() throws Exception {
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        for (int i = 0; i < iServices.length / 2; ++i) {
            String url = "/cgi-bin/admin/param.cgi?action=list&group=GPIO.In" + i + ".Status";
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
            String responseString = new String(result);
            if (responseString.contains("GPIO.In" + i + ".Status=Active")) {
                iServices[2 * i].checkInput(1);
                iServices[2 * i + 1].checkInput(1);
                continue;
            }
            iServices[2 * i].checkInput(0);
            iServices[2 * i + 1].checkInput(0);
        }
        return 0;
    }

    @Override
    public int writeDigitalOutput(int number, int value, long holdTime) {
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Writing value [" + value + "] to output [" + number + "] with HoldTime [" + holdTime + "] for " + this + " ...");
            }
            String command = "/cgi-bin/admin/param.cgi?action=update&GPIO.Out" + (number - 1) + ".Enable=1";
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)command, (int)Integer.MAX_VALUE);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("/cgi-bin/admin/param.cgi?action=update");
            stringBuilder.append("&GPIO.Out").append(number - 1).append(".ActiveType=").append(value == 1 ? 0 : 1);
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)stringBuilder.toString(), (int)Integer.MAX_VALUE);
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(number - 1, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "]");
            }
            return 0;
        }
        catch (SeeTecException seeTecException) {
            this.logger.error((Object)seeTecException, (Throwable)seeTecException);
            return seeTecException.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    protected int discard() {
        return 0;
    }
}

