/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.americandynamics;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsIoHandler;
import de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsIoHandler400;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;

public final class AmericanDynamicsDevice
extends VideoServer {
    private int rtspPort = Integer.MIN_VALUE;

    @Override
    public int initializeDevice(long srvType) {
        super.initializeDevice(srvType);
        if ((this.getDeviceType() == 204500L || this.getDeviceType() == 204502L || this.getDeviceType() == 204503L || this.getDeviceType() == 204504L) && this.rtspPort == Integer.MIN_VALUE) {
            try {
                int port;
                String rtspPortCommand = "";
                rtspPortCommand = this.getDeviceType() == 204504L ? "RTSP.PrimaryStreamVPort" : "RTSP.PrimaryStreamAVPort";
                byte[] request = NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)("/cgi-bin/admin/param.cgi?action=list&group=" + rtspPortCommand), (int)Integer.MAX_VALUE);
                String response = new String(request);
                this.rtspPort = port = Integer.parseInt(response.substring(response.lastIndexOf(rtspPortCommand) + rtspPortCommand.length() + 1, response.lastIndexOf("\n")));
            }
            catch (Throwable throwable) {
                this.logger.info(throwable.getMessage());
                if (throwable.getMessage().contains("Unauthorized access")) {
                    return -21657;
                }
                return -21670;
            }
        }
        return 0;
    }

    @Override
    protected IOHandler createIOHandler() {
        if (this.getDeviceType() == 204500L || this.getDeviceType() == 204502L || this.getDeviceType() == 204503L || this.getDeviceType() == 204504L) {
            return new AmericanDynamicsIoHandler();
        }
        if (this.getDeviceType() == 204501L) {
            return new AmericanDynamicsIoHandler400();
        }
        return null;
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    public int getRtspPort() {
        return this.rtspPort;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() {
        return null;
    }
}

